module SearchCmds;

{*****************************************}
{
{        Pepper:  Spice Interim Editor
{        Search and Replace Commands
{        Richard Cohn
{        April 1, 1981
{
{*****************************************}


exports

procedure GetString;
procedure FindString (SearchForward:  boolean);
procedure Find;
procedure ReplaceString (SearchForward:  boolean);
procedure Replace;


{************************} private {**************************}

imports RegionEditor from RegionEdit;
imports ScreenUtilities from EdScreen;
imports TextUtilities from EdText;
imports ReplayUtilities from EdReplay;
imports Screen from Screen;

var AcceptGather:  boolean;


{****************************************************************}

procedure GatherLine (BufLine:  BufRange); 
    
   var C: integer;
       EolCount: integer;
       OldWin:  pTextWindow;
       L:  LineIndex;
       GatherC, LastGather:  ColumnIndex;


{********************************}
   
    procedure EchoChar (Ch:  char);

    var Done:  Boolean;
        Quote: Boolean; 

    begin { EchoChar }
    Quote := false;
    with CurWin^ do 
     begin
     if Ch = chr (LOR (PrefixBit, QuoteChar)) then
{Quote}
        begin
        Quote := true;
        OnPointer;
        repeat LookForCommand (CanvDflt)
        until NewEvent.Cmd <> NullCmd;
        SendTrnByte (NewEvent.Ch);
        OffPointer;
        if LAND (ord (NewEvent.Ch), #200) <> 0 then
            { convert to Ascii control character }
            Cursor2.Ch := chr (LAND (ord (NewEvent.Ch), #037))
        else
            Cursor2.Ch := NewEvent.Ch;
        Ch := Cursor2.Ch
        end;
     if (not Quote and (Ch = CR)) or (Ch = LF) then
{CR or LF}
      begin
       if Ch = LF then
        if NE(PFirst,Cursor2.Pos) then
         begin Sub1C(Cursor2);
          if Cursor2.Ch = CR then
           begin C := C - 1;
            MovePencil(L,C);
            EraseChar;
            MovePencil(L,C);
            Ch := CR
           end
          else Add1C(Cursor2)
         end;
       Add1C(Cursor2);
       if Ch = CR then
        begin Cursor2.Ch := LF;
         if EQ(Cursor2.Pos,EmptyLast) then CreateEmptyPage;
         Add1C(Cursor2);
         Write(EolMarker);
         C := C + 1;
         EolCount := EolCount + 1
        end
       else
        begin WriteChar(LF); C := C + 1 end
      end
     else
      if not Quote and (Ch in [chr (LOR (PrefixBit, DelBChar)),
           chr (LOR (PrefixBit, BSChar)), BS]) then
{BS}
       begin
        if NE(PFirst,Cursor2.Pos) then
         begin Sub1C(Cursor2);
          C := C - 1;
          if Cursor2.Ch = LF then
           begin Sub1C(Cursor2);
            if Cursor2.Ch = CR then EolCount := EolCount - 1
            else Add1C(Cursor2)
           end;
          if C >= GatherC then
           begin MovePencil(L,C);
            EraseChar;
            MovePencil(L,C)
           end
         end
       end
     else if not Quote and (Ch = chr (LOR (PrefixBit, DelBWord))) then
{BW}
        begin Done := False;
         repeat
          if EQ(PFirst,Cursor2.Pos) then Done := True
          else
           begin Sub1C(Cursor2);
            if Cursor2.Ch <> ' ' then 
             if (Cursor2.Ch = LF) and (EolCount > 0) then
              begin Sub1C(Cursor2);
               if Cursor2.Ch = CR then EolCount := EolCount - 1
               else
                begin Add1C(Cursor2); Done := True end
              end
             else
              begin Add1C(Cursor2); Done := True end
            end;
          if not Done then C := C - 1
         until Done;
         if NE(PFirst,Cursor2.Pos) then
          begin Sub1C(Cursor2);
           C := C - 1;
           if NE(PFirst,Cursor2.Pos) and (Cursor2.Ch in WordChars) then
            begin
             repeat Sub1C(Cursor2);
              C := C - 1
             until EQ(PFirst,Cursor2.Pos) or not (Cursor2.Ch in WordChars);
             if NE(PFirst,Cursor2.Pos) then
              begin Add1C(Cursor2); C := C + 1 end
            end
          end;
         if C < GatherC then 
             ClearLine(L,GatherC, LastGather) 
         else 
             ClearLine(L,C, LastGather)
        end
       else
        if not Quote and ((Ch = chr (LOR (PrefixBit, DelBLine))) or
            ((Ch = chr (DelBLine)) and (DelBLine < ord (' ')))) then
{BL}     begin
          if EolCount = 0 then
           begin ReAttach(Cursor2,PFirst);
            C := GatherC
           end
          else
           begin EolCount := EolCount - 1;
            repeat
             repeat Sub1C(Cursor2);
              C := C - 1
             until Cursor2.Ch = LF;
             Sub1C(Cursor2);
             if Cursor2.Ch <> CR then Add1C(Cursor2)
            until Cursor2.Ch = CR;
           end;
          if C < GatherC then 
              ClearLine(L,GatherC, LastGather) 
          else 
              ClearLine(L,C, LastGather)
         end
       else
{text}
          begin
          if LAND (ord (Cursor2.Ch), #200) <> 0 then
              { convert to Ascii control character }
              begin
              Cursor2.Ch := chr (LAND (ord (Cursor2.Ch), #037));
              Ch := Cursor2.Ch
              end;
          Add1C(Cursor2);
           WriteChar(Ch);
           C := C + 1
          end;
     if C > LastGather then
      begin DeleteChar(L,GatherC);
       Add1C(Cursor1);
       C := C - 1;
       MovePencil(L,C)
      end
     else
      if NE(PFirst,Cursor1.Pos) and (C < LastGather) then
       begin
        repeat Sub1C(Cursor1);
         Ch := Cursor1.Ch;
         InsertChar(L,GatherC);
         WriteChar(Ch);
         C := C + 1
        until EQ(PFirst,Cursor1.Pos) or (C = LastGather);
        MovePencil(L,C)
       end
     end { with }
    end { EchoChar };
   

{********************************}
   
procedure InsertSelection;

{ Insert the current selection, if any, into the search or replace buffer.  }

var Done:  boolean;
    OK:    boolean;
    w:     integer;
    Ch:    integer;
    Page:  integer;

begin { InsertSelection }
if Replay = NotReplaying then
    if SelectWindow = nil then
        SendTrnWord (0)
    else
        begin
        SendTrnWord (SelectWindow^.WinNum);
        with Bufary [SelectB] do
            begin
            SendTrnWord (First.Chunk^.OrderP);
            SendTrnWord (First.Chunk^.OrderC + First.Offset);
            SendTrnWord (Last.Chunk^.OrderP);
            SendTrnWord (Last.Chunk^.OrderC + Last.Offset)
            end
        end
else { replaying--so get selection }
    begin
    if SelectWindow <> nil then
        begin
        ChangeTextWindow (SelectWindow);
        UnderLine (Bufary [SelectB].First, Bufary [SelectB].Last, Erase);
        ChangeTextWindow (PromptWindow)
        end;
    w := GetTrnWord;
    if w = 0 then
        begin
        SelectWindow := nil;
        Bufary [SelectB].First := NilPosition;
        Bufary [SelectB].Last := NilPosition
        end
    else
        begin
        SelectWindow := Winary [w];
        ChangeTextWindow (SelectWindow);
        Page := GetTrnWord;
        Ch := GetTrnWord;
        Bufary [SelectB].First := FindPos (Page, Ch);
        Page := GetTrnWord;
        Ch := GetTrnWord;
        Bufary [SelectB].Last := FindPos (Page, Ch);
        UnderLine (Bufary[SelectB].First, Bufary [SelectB].Last, ThinBlack);
        ChangeTextWindow (PromptWindow)
        end;
    DrawLn (SelectB)
    end; { else }
if SelectWindow = nil then
    Warn ('Can''t insert:  No text selected')
else
    begin
    Attach (DrawCursor, Bufary [SelectB].First, ReadCursor);
    repeat
        OK := true;
        if (DrawCursor.Ch = LF) and
            (DrawCursor.Pos <> Bufary [SelectB].First) then
            begin
            Sub1C (DrawCursor);
            OK := DrawCursor.Ch <> CR;
            Add1C (DrawCursor)
            end;
        if OK then
            begin
            Cursor2.Ch := DrawCursor.Ch;
            if EQ(Cursor2.Pos,EmptyLast) then
                CreateEmptyPage;
            if PromptSize <> NoPrompt then
            EchoChar (DrawCursor.Ch)
            end;
        Done := DrawCursor.Pos = Bufary [SelectB].Last;
        if not Done then
            Add1C (DrawCursor)
    until Done;
    Detach (DrawCursor)
    end { else }
end { InsertSelection };
    

{********************************************}
  
   begin { GatherLine }
    if Automatic then
        begin
        AcceptGather := true;
        SendTrnByte (chr (Accept))
        end
    else
        begin
        OffPointer;
        CountChanges := false; 
        repeat LookForCommand (CanvDflt)
        until NewEvent.Cmd <> NullCmd;
        if NewEvent.Cmd in ExitStrCmds then
            begin
            ReturnKey (inputQueue, newEvent);
            NewEvent.Cmd := Accept;
            NewEvent.Ch := chr (Accept)
            end;
        SendTrnByte (NewEvent.Ch);
        AcceptGather := NewEvent.Cmd = Accept;
        if not (NewEvent.Cmd in [Accept, Reject]) then
          with Bufary [BufLine] do
            begin
            OldWin := CurWin;
            ChangeTextWindow (PromptWindow);
            if BufLine = SearchB then
                L := GatherL1
            else
                L := GatherL1 + 1;
            GatherC := GatherOffset;
            LastGather := GatherC + CurWin^.LastColumn div 2 - GatherOffset;
            MovePencil(L,GatherC);
            Attach(Cursor1,EmptyFirst,ReadCursor);
            Attach(Cursor2,EmptyFirst,WriteCursor);
            PFirst := Cursor1.Pos;
            EolCount := 0;
            C := GatherC;
            if PromptSize <> NoPrompt then
                ClearLine(L,GatherC,LastGather);
            repeat
                if NewEvent.Ch = chr (LOR (PrefixBit, InsSelection)) then
                    InsertSelection
                else
                    begin
                    Cursor2.Ch := NewEvent.Ch;
                    if EQ(Cursor2.Pos,EmptyLast) then CreateEmptyPage;
                    if PromptSize <> NoPrompt then
                        EchoChar (NewEvent.Ch);
                    end;
                MoveTextPointer (L, C);
                OnPointer;
                repeat LookForCommand (CanvDflt)
                until NewEvent.Cmd <> NullCmd;
                OffPointer;
                if NewEvent.Cmd in ExitStrCmds then
                    begin
                    ReturnKey (inputQueue, newEvent);
                    NewEvent.Cmd := Accept;
                    NewEvent.Ch := chr (Accept)
                    end;
                SendTrnByte (NewEvent.Ch)
            until NewEvent.Cmd in [Accept, Reject];
            ChangeTextWindow (OldWin);
            AcceptGather := NewEvent.Cmd = Accept;
             if AcceptGather then
              begin Collect(First,Last);
              if EQ(PFirst,Cursor2.Pos) then
               begin First := NilPosition; Last := NilPosition end
              else
               begin First := PFirst;
                Last := Add (Cursor2.Pos,-1);
                EmptyFirst := Cursor2.Pos;
                Split(EmptyFirst)
               end
             end;
            Detach(Cursor1);
            Detach(Cursor2);
            DrawLn(BufLine)
            end;                                         
        MoveTextPointer (CurWin^.CurLine, CurWin^.CurCol);
        CountChanges := true
        end
  end { GatherLine };

   
{********************************************************************}

  function GoodPattern: boolean;
  begin { GoodPattern }
   GoodPattern := false;
   if EQ(Bufary [SearchB].First, NilPosition) then 
       Warn('No pattern in Search buffer')
   else
    if Subtract(Bufary [SearchB].Last,Bufary [SearchB].First) < 0 then
        Warn('Pattern too long')
    else GoodPattern := true
  end { GoodPattern };

   
{******************************************************************}

   procedure FindFSetUp;
   const FirstChar = 0;
         LastChar = #377;
   var I: integer;
       C: char;
       Done: boolean;
   begin { FindFSetUp }
   with Bufary [SearchB] do
    begin
    PatLength := Subtract(Last,First) + 1;
    for C := Chr(FirstChar) to Chr(LastChar) do Jump[C] := PatLength;
    Attach(Cursor1,First,ReadCursor);
    I := PatLength;
    repeat I := I - 1;
     Jump[Cursor1.Ch] := I;
     if Cursor1.Ch in UCLetters then
         Jump[chr (ord (Cursor1.Ch) - ord ('A') + ord ('a'))] := I
     else if Cursor1.Ch in LCLetters then
         Jump[chr (ord (Cursor1.Ch) - ord ('a') + ord ('A'))] := I;
     Done := EQ(Cursor1.Pos,Last);
     Add1C(Cursor1)
    until Done;
    Detach(Cursor1)
    end
   end { FindFSetUp };
  
  
   procedure FindRSetUp;
   const FirstChar = 0;
         LastChar = #377;
   var I: integer;
       C: char;
       Done: boolean;
   begin { FindRSetUp }
   with Bufary [SearchB] do
    begin
    PatLength := Subtract(Last,First) + 1;
    for C := Chr(FirstChar) to Chr(LastChar) do Jump[C] := -PatLength;
    Attach(Cursor1,Last,ReadCursor);
    I := -PatLength;
    repeat I := I + 1;
     Jump[Cursor1.Ch] := I;
     if Cursor1.Ch in UCLetters then
         Jump[chr (ord (Cursor1.Ch) - ord ('A') + ord ('a'))] := I
     else if Cursor1.Ch in LCLetters then
         Jump[chr (ord (Cursor1.Ch) - ord ('a') + ord ('A'))] := I;
     Done := EQ(Cursor1.Pos,First);
     Sub1C(Cursor1)
    until Done;
    Detach(Cursor1)
    end
   end { FindRSetUp };
   
{******************************************************************}

   procedure FindForward;

   var Distance: integer;
       SourcePos: Position;
       State: (Searching, Matching, Found, NotFound);
       FindFirst, FindLast:  Position;

   { If a match is found, it is pointed at by (PFirst, PLast).  Otherwise
   { PFirst and PLast are set to NilPosition.  }

   begin { FindForward }
    FindFirst := Bufary [SearchB].First;
    FindLast := Bufary [SearchB].Last;
    SourcePos := Add(SourceFirst,PatLength - 1);
    State := Searching;
    Attach (Cursor1,FindLast,ReadCursor);
    Attach (Cursor2,SourcePos,ReadCursor);
    repeat ReAttach(Cursor2,SourcePos);
     if GT(SourcePos,SourceLast) then State := NotFound
     else
      begin Distance := Jump[Cursor2.Ch];
       if Distance > 0 then 
           SourcePos := Add(SourcePos,Distance)
       else
        begin ReAttach(Cursor1,FindLast);
         State := Matching;
         repeat
          if EQ(Cursor1.Pos,FindFirst) then State := Found
          else
           begin Sub1C(Cursor1);
            Sub1C(Cursor2);
            if Cursor1.Ch <> Cursor2.Ch then
                if Cursor1.Ch in UCLetters then
                    begin
                    if Cursor2.Ch <> 
                        chr (ord (Cursor1.Ch) - ord ('A') + ord ('a')) then
                            State := Searching
                    end
                else if Cursor1.Ch in LCLetters then
                    begin
                    if Cursor2.Ch <> 
                        chr (ord (Cursor1.Ch) - ord ('a') + ord ('A')) then
                            State := Searching
                    end
                else
                    State := Searching
           end
         until State <> Matching;
         if State = Searching then
          begin
           Distance := Jump[Cursor2.Ch] - 
               Subtract(FindLast,Cursor1.Pos);
           if Distance > 1 then 
               SourcePos := Add(SourcePos,Distance)
           else Add1(SourcePos)
          end
        end
      end
    until State <> Searching;
    if State = Found then
     begin PFirst := Cursor2.Pos;
      PLast := SourcePos
     end
    else
     begin PFirst := NilPosition;
      PLast := NilPosition
     end;
    Detach(Cursor1);
    Detach(Cursor2)
   end { FindForward };

   
{******************************************************************}

   procedure FindReverse;

   var Distance: integer;
       SourcePos: Position;
       State: (Searching, Matching, Found, NotFound);
       FindFirst, FindLast:  Position;

   begin { FindReverse }
    FindFirst := Bufary [SearchB].First;
    FindLast := Bufary [SearchB].Last;
    SourcePos := Add(SourceLast,1 - PatLength);
    State := Searching;
    Attach(Cursor1,FindFirst,ReadCursor);
    Attach(Cursor2,SourcePos,ReadCursor);
    repeat ReAttach(Cursor2,SourcePos);
     if LT(SourcePos,SourceFirst) then State := NotFound
     else
      begin Distance := Jump[Cursor2.Ch];
       if Distance < 0 then 
           SourcePos := Add (SourcePos,Distance)
       else
        begin ReAttach(Cursor1,FindFirst);
         State := Matching;
         repeat
          if EQ(Cursor1.Pos,FindLast) then State := Found
          else
           begin Add1C(Cursor1);
            Add1C(Cursor2);
            if Cursor1.Ch <> Cursor2.Ch then
                if Cursor1.Ch in UCLetters then
                    begin
                    if Cursor2.Ch <> 
                        chr (ord (Cursor1.Ch) - ord ('A') + ord ('a')) then
                            State := Searching
                    end
                else if Cursor1.Ch in LCLetters then
                    begin
                    if Cursor2.Ch <> 
                        chr (ord (Cursor1.Ch) - ord ('a') + ord ('A')) then
                            State := Searching
                    end
                else
                    State := Searching
           end
         until State <> Matching;
         if State = Searching then
          begin
           Distance := Jump[Cursor2.Ch] + 
               Subtract(Cursor1.Pos,FindFirst);
           if Distance < -1 then 
               SourcePos := Add (SourcePos,Distance)
           else Sub1(SourcePos)
          end
        end
      end
    until State <> Searching;
    if State = Found then
     begin PFirst := SourcePos;
      PLast := Cursor2.Pos
     end
    else
     begin PFirst := NilPosition;
      PLast := NilPosition
     end;
    Detach(Cursor1);
    Detach(Cursor2)
   end { FindReverse };

   
{******************************************************************}

procedure PromptOccurrences (S:  String; n:  integer); 

var X, Y:  integer;
    OldWin:  pTextWindow;

begin
if PromptSize <> NoPrompt then
    begin
    OldWin := CurWin;
    SReadCursor (X,Y);
    ChangeTextWindow (PromptWindow);
    ClearLine (0,0,0);
    if n = 1 then
        write (S, 'one occurrence')
    else
        write (S, n:1, ' occurrences');
    ChangeTextWindow (OldWin);
    SSetCursor (X,Y)
    end
end; { PromptOccurrences }

   
{******************************************************************}

procedure GetString;

begin
if NewEvent.Cmd = InSearchString then
    begin
    Prompt('Enter target search string (INS accepts, DEL aborts):');
    GatherLine (SearchB)
    end
else { Cmd = InReplaceString }
    begin
    Prompt('Enter replace string (INS accepts, DEL aborts):');
    GatherLine (ReplaceB)
    end;
ImmedPrompt := true;
NeedPrompt := true;
if not AcceptGather then
    Prompt ('Command aborted');
OnPointer;
end { GetString };

   
{******************************************************************}

procedure FindString (SearchForward:  boolean);

var SFirst, SLast: Position;
    NotDone: boolean;
    Count:  integer;

begin
    if GoodPattern then
        with CurWin^ do
            begin
            SourceFirst := GetPosition (CurLine, CurCol);
            if SearchForward then 
                begin
                Add1 (SourceFirst);
                SourceLast := Add (FilledLast,-1);
                FindFSetUp
                end
            else
                begin
                SourceLast := Add(SourceFirst,-1);
                SourceFirst := Add(FilledFirst,2);
                FindRSetUp
                end;
            Count := RepeatCount;
            NotDone := RepeatCount > 0; 
            while NotDone do
                begin
                OffPointer;
                Prompt('Searching'); 
                if SearchForward then
                    FindForward
                else
                    FindReverse;
                if EQ(PFirst, NilPosition) then 
                    NotDone := false
                else
                    begin
                    if SearchForward then
                        SourceFirst := Add(PFirst,1)
                    else 
                        SourceLast := Add(PLast,-1);
                    Show (PFirst, 0, LastLine);
                    RepeatCount := RepeatCount - 1;
                    NotDone := RepeatCount > 0
                    end;
                OnPointer
                end; { while }
            if Count <= RepeatCount then
                Warn ('Pattern not found')
            else
                PromptOccurrences ('Found ', Count - RepeatCount)
            end; { with }
ImmedPrompt := false;
NeedPrompt := true
end; { FindString }

   
{******************************************************************}

procedure Find;

var SearchForward:  boolean; 

begin { Find }
SearchForward := NewEvent.Cmd = ForSearch;
if SearchForward then
    Prompt('Forward search:  enter target string (INS accepts, DEL aborts)')
else
    Prompt('Reverse search:  enter target string (INS accepts, DEL aborts)');
GatherLine (SearchB);
if AcceptGather then
    FindString (SearchForward)
else
    Prompt ('Search aborted');
OnPointer
end { Find };


{******************************************************************}

procedure ReplaceString (SearchForward:  boolean);

  var Good: boolean;
      NotDone, EmptyReplacement: boolean;
      RealVerify:  boolean;
      L: LineIndex;
      C: ColumnIndex;
      Count:  integer;

begin { Replace }
RealVerify := Verify;
if GoodPattern then
    with CurWin^ do
        begin
        EmptyReplacement := EQ(Bufary [ReplaceB].First, NilPosition);
        Tmp := GetPosition (CurLine, CurCol);
        if SearchForward then 
            begin
            SourceFirst := Add (Tmp, 1);
            SourceLast := Add(FilledLast,-1);
            FindFSetUp
            end
        else
            begin
            SourceLast := Add(Tmp,-1);
            SourceFirst := Add(FilledFirst,2);
            FindRSetUp
            end;
        Count := 0;
        NotDone := true;
        if not RealVerify then
            Prompt('Replacing');
        while NotDone do
            begin
            OffPointer;
            if RealVerify then Prompt('Searching');
            if SearchForward then
                FindForward
            else
                FindReverse;
            OnPointer;
            if EQ(PFirst, NilPosition) then
                NotDone := false
            else
                begin
                Show(PFirst,0,LastLine);
                if RealVerify then
                    begin
                    Prompt
                      ('Replace:  INS does, '' '' doesn''t, TAB does then quits, ''!'' does all, DEL aborts');
                    if Replay = NotReplaying then
                        begin
                        repeat LookForCommand (CanvDflt)
                        until NewEvent.Cmd <> NullCmd;
                        NewEvent.Cmd := LAND (#177, ord (NewEvent.Ch));
                        while not (NewEvent.Cmd in
                            [Accept, Reject, SkipRepl, DoStop, DoAll]) do
                            begin
                            Write(Bel);
                            repeat LookForCommand (CanvDflt)
                            until NewEvent.Cmd <> NullCmd;
                            NewEvent.Cmd := LAND (#177, ord (NewEvent.Ch))
                            end;
                        SendTrnByte (chr (NewEvent.Cmd))
                        end
                    else
                        begin
                        NewEvent.Ch := GetTrnByte;
                        NewEvent.Cmd := ord (NewEvent.Ch);
                        CheckReplay (ReplaySingleStep)
                        end;
                    RealVerify := RealVerify and (NewEvent.Cmd <> DoAll);
                    NotDone := not (NewEvent.Cmd in [DoStop, Reject])
                    end;
                if not RealVerify then
                    Prompt('Replacing');
                if not RealVerify or (NewEvent.Cmd in [DoStop, Accept]) then
                    begin
                    if SelectWindow = CurWin then
                        if LT (Bufary [SelectB].First, PFirst) then
                            begin
                            if GE (Bufary [SelectB].Last, PFirst) then
                                UnSelect
                            end
                        else
                            if LE (Bufary [SelectB].First, PLast) then
                                UnSelect;
                    LeftPart := Add(PFirst,-1);
                    RightPart := Add(PLast,1);
                    GetLC (PFirst,L,C);
                    Split(PFirst);
                    Split(RightPart);
                    Collect(PFirst,PLast);
                    if not SearchForward then { a real hack--couldn't fix it }
                        NotDone := NotDone and LE (SourceFirst, LeftPart);
                    if EmptyReplacement then
                        begin
                        Tmp := RightPart;
                        Join(LeftPart,RightPart)
                        end
                    else
                        with Bufary [ReplaceB] do
                            begin 
                            Tmp := First;
                            Copy(First,Last);
                            Join(LeftPart,First);
                            Join(Last,RightPart);
                            First := PFirst;
                            Last := PLast
                            end;
                    JoinScreen(Tmp,L,C);
                    if SearchForward then
                        SourceFirst := RightPart
                    else
                        SourceLast := LeftPart;
                    Count := Count + 1
                    end
                else { RealVerify and not NewEvent... }
                    if SearchForward then
                        SourceFirst := Add(PFirst,1)
                    else
                        SourceLast := Add(PLast,-1);
                NotDone := NotDone and LE (SourceFirst, SourceLast)
                end { else not EQ (PFirst, NilPosition) }
            end; { while NotDone }
        if Count > 0 then
            PromptOccurrences ('Replaced ', Count)
        else if NewEvent.Cmd = Reject then
            Prompt ('Replace aborted')
        else
            Warn('Pattern not found')
        end; { with }
ImmedPrompt := false;
NeedPrompt := true
end; { ReplaceString }


{******************************************************************}

procedure Replace;

  var SearchForward:  boolean;
      Good, Success:  boolean;

begin { Replace }
SearchForward := NewEvent.Cmd = ForReplace;
if SearchForward then
    Prompt ('Forward replace:  enter target string (INS accepts, DEL aborts)')
else
    Prompt ('Reverse replace:  enter target string (INS accepts, DEL aborts)');
GatherLine(SearchB);
Good := false;
Success := AcceptGather;
if Success then
    if GoodPattern then
        begin
        if SearchForward then
           Prompt('Forward replace:  enter replacement string (INS accepts, DEL aborts)')
        else
           Prompt('Reverse replace:  enter replacement string (INS accepts, DEL aborts)');
        GatherLine(ReplaceB);
        Good := AcceptGather 
        end;
if Good then
    ReplaceString (SearchForward)
else
    Prompt ('Replace aborted');
OnPointer;
end. { Replace }
