module EditSetUp;

{*****************************************}
{
{        Pepper:  Spice Interim Editor
{        Editor Initialization
{        Richard Cohn
{        April 1, 1981
{
{*****************************************}


exports

imports RegionEditor from RegionEdit;

function EditInit

    (TextDoc     : EditDoc;
     EditW       : pWindow;
     PromptW     : pWindow;
     DoScroll    : boolean;
     DoThumb     : boolean;
     DoBox       : boolean;
     AutoSave    : boolean;
     DoReplay    : boolean;
     TitleStr    : string):      boolean;
     


{*****************************} private {*******************************}


imports BufferUtilities from EdBuffer;
imports ScreenUtilities from EdScreen;
imports TextUtilities from EdText;
imports ReplayUtilities from EdReplay;
imports Canvas from EdCanvas;
imports Memory from Memory;
imports FileSystem from FileSystem;
imports IO_Others from IO_Others;
imports CmdParse from CmdParse;
imports Perq_String from Perq_String;
imports System from System;


{*************************************************************************}

function EditInit

  (  TextDoc     : EditDoc;
     EditW       : pWindow;
     PromptW     : pWindow;
     DoScroll    : boolean;
     DoThumb     : boolean;
     DoBox       : boolean;
     AutoSave    : boolean;
     DoReplay    : boolean;
     TitleStr    : string  ):     boolean;

var 
    b:  BufRange;
    i:  integer;


{*****************************}

procedure InitEmpty;

var BufferSegment:  integer;
    i:  integer;
    P:  pChunk;

begin { InitEmpty }
if DEBUG [2] then Status ('Enter InitEmpty');
SwapOn := false;
CreateSegment (BufferSegment, MaxMemPage + 1, 1, MaxMemPage + 1);
SetMobility (BufferSegment, UnSwappable);
EmptyFirst.Chunk := nil;
for i := MinFile to MaxFile do
    with IdFile [i] do
        begin
        Index   := 0;
        MinPage := MaxDiskPage;
        MaxPage := MaxDiskPage
        end;
IdFile [SwapFile].MinPage := MinSwapPage;
IdFile [SwapFile].MaxPage := MaxDiskPage - 1;
FilePages := 0;
Files := 0;
Pages := IdFile [SwapFile].MinPage + MaxMemPage + 1;
for i := MaxMemPage downto 0 do with Txt[i] do
    begin 
    New(BufferSegment,256,Buffer);
     TPage := MinSwapPage + i;
     RealDirty := false;
     Dirty := false;
     Used := false;
     NewChunk (P);
     with P^ do
      begin CPage := TPage;
       First := 0;
       Length := MaxLength;
       OrderP := 0;
       OrderC := 0;
       Next := EmptyFirst.Chunk;
       if EmptyFirst.Chunk <> nil then EmptyFirst.Chunk^.Prev := P
       else EmptyLast.Chunk := P;
       EmptyFirst.Chunk := P
      end
    end;
LastMemPage := MaxMemPage;
EmptyFirst.Chunk^.Prev := nil;
EmptyFirst.Offset := 0;
EmptyLast.Offset := MaxOffset;
NilPosition := EmptyFirst;
Add1 (EmptyFirst);
NewChunk (EmptyFirst.Chunk);
with EmptyFirst, Chunk^ do
    begin
    Chunk^ := NilPosition.Chunk^;
    NilPosition.Chunk^.Next := nil;
    Next^.Prev := Chunk;
    First := 1;
    Length := Length - 1;
    Offset := 0
    end;
if DEBUG [2] then Status('exit InitEmpty')
end { InitEmpty };


{****************************}

procedure InitSets;

begin { InitSets }
MouseCmds := [SelChar, SelWord, SelLine, ExtendSel];
UpMouseCmds := [UpSelChar, UpSelWord, UpSelLine, UpExtend];
LeaveTSCmds := [FindMark, ForSearch, RevSearch, ForReplace, RevReplace, 
    InSearchString, InReplaceString, SearchDown, SearchUp, ReplaceDown, 
    ReplaceUp, ExitCmd, QuitCmd, PrefixKey, BeginFile, EndFile, 
    QHelp, HelpCmd, TopWindow, BottomWindow, PosToSelect, SelAll, DelSelection,
    MakeWindow, KillWindow, GrowWindow, ShrinkWindow, ord ('1')..ord ('9'),
    NextWindow, PrevWindow, OneWindow,
    ReplWindow, PopKill, BackFile, SaveFile, WritFile, ExitCmd, QuitCmd,
    SaveModFiles, DiffFiles, ChangePath, PrintDir,
    RefrScreen, DebugCmd, NewParm];
RepeatableCmds := [ForChar, BackChar, ForWord, BackWord, BeginLine, EndLine,
    UpLine, DownLine, UpPage, DownPage, 
    InsTab, TabCmd, MakeNewLine, IndentNewLine, InsSpace,
    OpenSpace, OpenIndent, CRCmd, LFCmd,
    DelFChar, BSChar, DelBChar, DelFWord, DelBWord, DelELine, DelBLine,
    DelTWhite, 
    InsSelection, Yank, PopKill,
    ForSearch, RevSearch, ForReplace, RevReplace, InSearchString, 
    InReplaceString, SearchDown, SearchUp, ReplaceDown, ReplaceUp,
    IncrNum, DecrNum, ParaFill, SelFill, LineCenter, SelCenter, DoMacro,
    GrowWindow, ShrinkWindow, NextWindow, PrevWindow, DiffFiles, blockIndent,
    blockUndent];
ChangeCmds := [DelFChar, DelBChar, DelFWord, DelBWord, DelELine, DelBLine,
    InsSelection, DelSelection, Yank, ForReplace, RevReplace, InsChar,
    QuoteChar, InsTab, TabCmd, MakeNewLine, IndentNewLine, InsSpace,OpenIndent,
    OpenSpace, DelTWhite, ReplaceUp, ReplaceDown, Twiddle, BSChar,
    IncrNum, DecrNum, ParaFill, SelFill, LineCenter, SelCenter,
    CRCmd, LFCmd, blockIndent, blockUndent];
InsCmds := [InsChar, QuoteChar, InsTab, TabCmd, MakeNewLine, CRCmd, LFCmd,
    IndentNewLine, InsSpace];
WordChars := ['0'..'9', 'A'..'Z', 'a'..'z'];
UCLetters := ['A'..'Z'];
LCLetters := ['a'..'z'];
Numbers := ['0'..'9'];
ValidParams := ['A', 'J', 'L', 'R', 'S', 'T', 'V', 'W'];
ReplayCmds := [QuoteChar, InsTab, TabCmd, MakeNewLine, IndentNewLine, InsSpace,
    CRCmd, LFCmd, 
    Twiddle, OpenSpace, OpenIndent, DelFChar, DelBChar, BSChar, DelFWord,
    DelBWord, DelELine, DelBLine, DelTWhite, InsSelection, DelSelection, Yank,
    PopKill, ForSearch, RevSearch, ForReplace, RevReplace, InSearchString,
    InReplaceString, SearchDown, SearchUp, ReplaceDown, ReplaceUp, Accept,
    Reject, MakeWindow, KillWindow, ReplWindow, GrowWindow, ShrinkWindow,
    IncrNum, DecrNum, ParaFill, SelFill, LineCenter, SelCenter,
    NextWindow, PrevWindow, OneWindow,
    ToggleInsert, NewParm, InsChar, CloseInsert,
    ord ('1')..ord ('9'), BackFile, WritFile, SaveFile, ExitCmd, QuitCmd,
    QHelp, HelpCmd, PrintDir, SaveModFiles, blockIndent, blockUndent];
PosCmds := [QuoteChar, InsTab, TabCmd, MakeNewLine, IndentNewLine, InsSpace,
    Twiddle, OpenSpace, OpenIndent, DelFChar, DelBChar, BSChar, DelFWord,
    DelBWord, DelELine, DelBLine, DelTWhite, InsSelection, Yank,
    IncrNum, DecrNum, ParaFill, LineCenter,
    ForSearch, RevSearch, ForReplace, RevReplace,
    SearchDown, SearchUp, ReplaceDown, ReplaceUp, InsChar, CRCmd, LFCmd];
SelCmds := [InsSelection, DelSelection, SelFill, SelCenter, blockIndent,
    blockUndent];
InSrchCmds := [ForSearch, RevSearch, ForReplace, RevReplace, InSearchString];
InReplCmds := [ForReplace, RevReplace, InReplaceString];
ExitStrCmds := [SearchDown, SearchUp, ReplaceDown, ReplaceUp,
    InSearchString, InReplaceString];
InsWhiteCmds := InsCmds + [OpenSpace, OpenIndent, DelFChar, DelBChar, BSChar,
    DelFWord, DelELine, InsSelection, Yank];
end; { InitSets }

  
{****************************}

procedure InitPointers;

var PointerSegment, i, j: integer;

begin { InitPointers }
CurrentPtr := ThumbPtr; { this forces MoveTextPointer to change cursor }
CreateSegment(PointerSegment,3,1,10);
New(PointerSegment,256, CursorPtr [TextPtr].Pattern);
New(PointerSegment,256, CursorPtr [ThumbPtr].Pattern);
New(PointerSegment,256, CursorPtr [ScrollPtr].Pattern);
New(PointerSegment,256, CursorPtr [BScrollPtr].Pattern);
for i := 0 to 63 do
    for j := 0 to 3 do
        CursorPtr [TextPtr].Pattern^[i,j] := 0;
CursorPtr [ScrollPtr].Pattern^ := CursorPtr [TextPtr].Pattern^;
CursorPtr [BScrollPtr].Pattern^ := CursorPtr [TextPtr].Pattern^;
CursorPtr [ThumbPtr].Pattern^ := CursorPtr [TextPtr].Pattern^;
with CursorPtr [TextPtr] do
    begin
    for i := 0 to LineHeight - 3 do
        Pattern^[i,0] := #140000;
    xOrigin := 1;
    yOrigin := 0
    end; { with }

with CursorPtr [ThumbPtr] do
    begin
    Pattern^[0,0] := #002000;
    Pattern^[1,0] := #007000;
    Pattern^[2,0] := #017400;
    Pattern^[3,0] := #037600;
    Pattern^[4,0] := #077700;
    Pattern^[5,0] := #177760;
    xOrigin := 5;
    yOrigin := 0
    end; { with }

with CursorPtr [ScrollPtr] do
    begin
    Pattern^[2,0] := #700; 
    Pattern^[3,0] := #3100;
    Pattern^[4,0] := #4200;
    Pattern^[5,0] := #10200;
    Pattern^[6,0] := #61777;
    Pattern^[7,0] := #121001;
    Pattern^[8,0] := #121776;
    Pattern^[9,0] := #121020;
    Pattern^[10,0] := #121740;
    Pattern^[11,0] := #121040;
    Pattern^[12,0] := #121700;
    Pattern^[13,0] := #61100;
    Pattern^[14,0] := #17600;
    xOrigin := 0;
    yOrigin := LineHeight div 2 - 7;
    if yOrigin < 0 then
        yOrigin := 0
    end; { with }

with CursorPtr [BScrollPtr] do
    begin
    Pattern^[2,0] := #700; 
    Pattern^[3,0] := #3700;
    Pattern^[4,0] := #7600;
    Pattern^[5,0] := #17600;
    Pattern^[6,0] := #77777;
    Pattern^[7,0] := #177777;
    Pattern^[8,0] := #177776;
    Pattern^[9,0] := #177760;
    Pattern^[10,0] := #177760;
    Pattern^[11,0] := #177740;
    Pattern^[12,0] := #177700;
    Pattern^[13,0] := #77700;
    Pattern^[14,0] := #17600;
    xOrigin := 0;
    yOrigin := LineHeight div 2 - 7;
    if yOrigin < 0 then
        yOrigin := 0
    end; { with }

end; { InitPointers }
 

{*****************************}
 
procedure InitPositions;

{ Set all positions to something valid so that Fixup doesn't bomb
{ before all positions are set to their real initial values.  }

var
    l:  LineIndex;
    b:  BufRange;

begin  { InitPositions } 
with CurWin^ do
    begin
    FilledFirst := NilPosition;
    FilledLast := NilPosition;
    ScreenFirst := NilPosition;
    ScreenLast := NilPosition;
    Mark := NilPosition;
    for L := 0 to LastLine do
        begin 
        Ln[L].Start := NilPosition;
        Ln[L].Finish := NilPosition;
        end; { for }
end; { with }
PrevKill := NilPosition;
NextKill := NilPosition;
SourceFirst := NilPosition;
SourceLast := NilPosition;
Display := NilPosition;
LeftPart := NilPosition;
RightPart := NilPosition;
PFirst := NilPosition;
PLast := NilPosition;
Tmp := NilPosition;
savedPos := nilPosition;
justP := NilPosition;
for b := minBuffer to maxBuffer do
    begin
    Bufary [b].First := NilPosition;
    Bufary [b].Last := NilPosition;
    end;
end;  { InitPositions } 

{*****************************}
 
begin { EditInit }

ExitEdit := true;
EditInit := false;

{ Currently, debug switches can't be set true in EditInit.  They've been }
{ left in just in case they're needed again.  }
for i := 1 to 9 do
    DEBUG [i] := false;
if DEBUG [2] then
    new (CurWin); { needed for Status to work }

EdTitle := TitleStr;
for i := Length (EdTitle) + 1 to LenEdTitle do
    AppendChar (EdTitle, ' ');
TimStr := '';

OffPointer;
xMove := 0;
yMove := 0;
InitPointers; 
InitSets;
remembering := false;
macroRunning := false;
InitQueue (macroQueue);

{ set parameters }
InsertMode := true;
InitKeyTranslation;
SelectKeyTranslation (InsertTable);
BlackScreen := false;
Verify := true;
TBarOn := true;
TabSpaces := DfltTabSpaces;
NormSaveAfter := DefaultSaveAfter;
dfltLeftMargin := iDfltLeftMargin;
dfltRightMargin := iDfltRightMargin;
MouseJump := 40;
wordWrap := false;
CountChanges := true;

{ set up transcript }
if not InitReplay (DoReplay) then
    exit (EditInit);

{ set up initial windows }
CreateSegment (WindowSeg, 2, 2, maxSegSize);
SetUpPromptWindow (PromptW);
CurWin := SetUpWindow (EditW, TextDoc.Name, false, DoScroll, DoThumb, DoBox, 
    AutoSave);
CurWin^.Prev := curWin;
CurWin^.Next := curWin;
CurWin^.WinNum := MinWindex;

{ set up chunk structure }
CreateSegment (ChunkSeg,2,2,10);
BufferSeg := -1; { will actually be initialized when a file is written }
CreateSegment (BufferSeg, MaxMemPage + 1, 1, MaxMemPage + 1);
FreeChunk := nil;
InitEmpty; 
DrawCursor.Attached := false;
Attach(DrawCursor,EmptyFirst,ReadCursor);
Detach(DrawCursor);
Cursor1.Attached := false;
Attach(Cursor1,EmptyFirst,ReadCursor);
Detach(Cursor1);
Cursor2.Attached := false;
Attach(Cursor2,EmptyFirst,ReadCursor);
Detach(Cursor2);
KillB := KillBMin;
SelectWindow := nil;
InitPositions;

{ read in initial file and draw screen }
RefreshPromptWindow;
if not InitFilled (TextDoc.IsFile) then
    exit (EditInit);
RefreshTextWindow;
if Replay = NotReplaying then
    IOSetModeTablet (RelTablet)
else
    Replay := ReplaySingleStep;
needPrompt := true;
immedPrompt := true;
ExitEdit := false;
EditInit := true;
if DEBUG [2] then Status ('Exit EditInit')
end { EditInit }.
