module Canvas;

{ temporary hack to handle Canvas routines }

exports

const
    LandScapeSupported = false; { set true for POS G2, false for prior vers. }
    KrizMapping = false; { set true for new button mapping, false for old }
                              
    CtrlCode    = #200;
    MinEvent    = 0;
    MaxEvent    = 255;
    NullCmd     = #001;
    NoopCmd     = #002;
    IllegalCmd  = #003;
    NullCh      = chr (NullCmd);
    HelpCmd     = #007;
    InsChar     = #004;
    ToShell     = #005;
    
{$IFC KrizMapping THEN}
    DnYellow    = chr (CtrlCode + ord ('<'));
    UpYellow    = chr (CtrlCode + ord ('>'));
    DnWhite     = chr (CtrlCode + ord ('['));
    UpWhite     = chr (CtrlCode + ord (']'));
    DnGreen     = chr (CtrlCode + ord ('('));
    UpGreen     = chr (CtrlCode + ord (')'));
    DnBlue      = chr (CtrlCode + ord ('{'));
    UpBlue      = chr (CtrlCode + ord ('}'));
{$ELSEC}
    DnYellow    = chr (CtrlCode + ord ('['));
    UpYellow    = chr (CtrlCode + ord (']'));
    DnWhite     = chr (CtrlCode + ord ('{'));
    UpWhite     = chr (CtrlCode + ord ('}'));
    DnGreen     = chr (CtrlCode + ord ('<'));
    UpGreen     = chr (CtrlCode + ord ('>'));
    DnBlue      = chr (CtrlCode + ord ('('));
    UpBlue      = chr (CtrlCode + ord (')'));
{$ENDC}

type
    KeyCommand = MinEvent..MaxEvent;
    KeyEvent = record
               Cmd:  KeyCommand;
               Ch:  char;
               x, y:  integer;
               returned:  boolean;
               end;
    Ink = (Black, White, Gray, Invert);
    CmdSet = set of KeyCommand;

{ really private but needed for transcript and macros }

    KeyQElement = ^KeyQRec;
    KeyQueue = record
               first, last:  KeyQElement;
               end;
    KeyQRec  = record
               Event:  KeyEvent;
               Next:  KeyQElement;
               end;
var
    InputQueue:  KeyQueue;

procedure InitKeyTranslation;
procedure PutRectangle (xOrigin, yOrigin, Width, Height, Thickness:
    integer; InkFn:  Ink);
procedure FillRectangle (InkFn:  Ink;  xOrigin, yOrigin, Width, Height:
    integer);
procedure PutChar (Ch:  char; xOrigin, yOrigin:  integer; InkFn:  Ink);
procedure SelectKeyTranslation (TableName:  string);
function CmdTranslate (Ch:  char):  KeyCommand;
function GetKey (var q: KeyQueue):  KeyEvent;

procedure InitQueue (var q: KeyQueue);
procedure ReturnKey (var q: KeyQueue; k: KeyEvent);
procedure EnQueueKey (var q: KeyQueue; k: KeyEvent);
function DeQueueKey (var q: KeyQueue):  KeyEvent;
procedure ReturnQueue (var changedQ: KeyQueue; returnedQ: KeyQueue);
function IsEmpty (q: KeyQueue):  boolean;
procedure FreeQueue (var q: KeyQueue);


{***************************} private {**********************************}


imports IO_Unit from IO_Unit;
imports IO_Others from IO_Others;
imports Screen from Screen;
imports System from System;

const
    CR  = chr (#015);
    LF  = chr (#012);
    DEL = chr (#177);
    ZeroOne  = #052525;


    
type 
    GrayLine     = array [1..48 + 4] of integer; {48 corresponds to the value
                                                  of SScreenW; before constant
                                                  ,now variable in module
                                                  screen }
                                                  

var
    SWordsP4: INTEGER;
    Table:  string;
    ShellChars:  set of Char; { Cmds that are sent to the shell as special }
    SpecialChars:  set of char;  { Chars that are always commands }
    xMouse, yMouse:  integer;
    SwYellow, SwWhite, SwGreen, SwBlue:  boolean;
    OldSwYellow, OldSwWhite, OldSwGreen, OldSwBlue:  boolean;
    GrayPtr:  ^GrayLine;

    freeQ:  KeyQueue;

{*********************************************************************}

procedure InitQueue (var q: KeyQueue);

{ Initialize q. }

begin { InitQueue }
q.first := nil;
q.last := nil;
end;  { InitQueue }


{*********************************************************************}

procedure InitKeyTranslation;

var i:  integer;

begin
new (0, 4, GrayPtr);
IF LandScapeSupported THEN
   SWordsP4 := LandScapeWordWidth + 4 { words/scan line + 4}
ELSE
   SwordsP4 := SScreenW + 4;
   
   for i := 1 to SWordsP4 do
    GrayPtr^[i] := ZeroOne;
InitQueue (InputQueue);
InitQueue (freeQ);
Table := '';
ShellChars := [CR, LF];
SpecialChars := [chr (#000)..chr (#037), DEL];
xMouse := 0;
yMouse := 0;
SwYellow := false;
SwWhite := false;
SwGreen := false;
SwBlue := false;
end; { InitKeyTranslation }

{**********************************************************************}

procedure PutRectangle (* xOrigin, yOrigin, Width, Height, Thickness:
    integer; InkFn:  Ink *);

var RFn:  0..7;

begin
case InkFn of
    Black:   RFn := RXNor;
    Gray:    RFn := RXNor; 
    White:   RFn := RXor;
    Invert:  RFn := RNot;
    end; { case }
RasterOp (RFn, Width, Thickness, xOrigin, yOrigin, SScreenW, SScreenP,
                                 xOrigin, yOrigin, SScreenW, SScreenP);
RasterOp (RFn, Thickness, Height, xOrigin, yOrigin, SScreenW, SScreenP,
                                  xOrigin, yOrigin, SScreenW, SScreenP);
RasterOp (RFn, Width, Thickness, xOrigin, yOrigin+Height-Thickness, 
    SScreenW, SScreenP, xOrigin, yOrigin+Height-Thickness, SScreenW, SScreenP);
RasterOp (RFn, Thickness, Height, xOrigin+Width-Thickness, yOrigin, 
    SScreenW, SScreenP, xOrigin+Width-Thickness, yOrigin, SScreenW, SScreenP)
end; { PutRectangle }


{****************************************************************************}

procedure FillRectangle (* InkFn:  Ink;  xOrigin, yOrigin, Width, Height:
    integer *);

var RFn:  0..7;
    y:  integer;

begin
if InkFn = Gray then
    for y := yOrigin to yOrigin + Height - 1 do
        RasterOp (RRpl, Width, 1, xOrigin, y, SScreenW, SScreenP,
            y mod 2, 0, SWordsP4, GrayPtr)
else
    begin
    case InkFn of
        Black:   RFn := RXNor;
        White:   RFn := RXor;
        Invert:  RFn := RNot;
        end; { case }
    RasterOp (RFn, Width, Height, xOrigin, yOrigin, SScreenW, SScreenP,
                                  xOrigin, yOrigin, SScreenW, SScreenP)
    end
end; { FillRectangle }


{****************************************************************************}

procedure PutChar (* Ch:  char; xOrigin, yOrigin:  integer; InkFn:  Ink *);

begin
case InkFn of
    White:  SChrFunc (RNot);
    Black:  SChrFunc (ROr);
    Gray:   SChrFunc (ROr);
    Invert: SChrFunc (RXor);
    end; { case }
SSetCursor (xOrigin, yOrigin);
SPutChr (Ch);
SChrFunc (RRpl)  { the normal chr func }
end; { PutChar }


{****************************************************************************}

procedure SelectKeyTranslation (TableName:  string);

begin
Table := TableName
end;


{****************************************************************************}

function CmdTranslate (Ch:  char):  KeyCommand;

begin
if ord (Ch) >= CtrlCode then
    CmdTranslate := ord (Ch) - CtrlCode
else if Table = 'Command' then
    CmdTranslate := ord (Ch)
else if Ch in ShellChars then
    if Table = 'Insert' then
        CmdTranslate := ord (Ch)
    else { Table = 'Shell' }
        CmdTranslate := ToShell
else if Ch in SpecialChars then
    CmdTranslate := ord (Ch)
else
    CmdTranslate := InsChar;
if Ch = NullCh then
    CmdTranslate := NullCmd
end; { CmdTranslate }

{****************************************************************************}

function GetKey (var q: KeyQueue):  KeyEvent;

{ Note:  in the real GetKey, queued events must be reinterpreted at then
{ moment they are plucked off the queue (in case Table has changed).   }


const IOEIOC = 1; { read completed successfully }

var
    xOldMouse, yOldMouse:  integer;
    NewKey:  KeyEvent;

begin
if not IsEmpty (q) then
    newKey := DeQueueKey (q)
else
    { get a new event }
    begin
    xOldMouse := xMouse;
    yOldMouse := yMouse;
    OldSwYellow := SwYellow;
    OldSwWhite := SwWhite;
    OldSwGreen := SwGreen;
    OldSwBlue := SwBlue;
    InLineByte ( #151 {IntOff} );
    xMouse := tabAbsX;
    yMouse := tabRelY;
    SwYellow := TabYellow;
    SwWhite := TabWhite;
    SwGreen := TabGreen;
    SwBlue := TabBlue;
    InLineByte ( #152 {IntOn} );
    with NewKey do
        begin
        x := xMouse - xOldMouse;
        y := yMouse - yOldMouse;
        if not OldSwYellow and SwYellow then
            Ch := DnYellow
        else if not OldSwWhite and SwWhite then 
            Ch := DnWhite
        else if not OldSwGreen and SwGreen then
            Ch := DnGreen
        else if not OldSwBlue and SwBlue then
            Ch := DnBlue
        else if OldSwYellow and not SwYellow then
            Ch := UpYellow
        else if OldSwWhite and not SwWhite then 
            Ch := UpWhite
        else if OldSwGreen and not SwGreen then
            Ch := UpGreen
        else if OldSwBlue and not SwBlue then
            Ch := UpBlue
        else { look for keystroke }
            if IOCRead (KeyBoard, Ch) <> IOEIOC then
                Ch := NullCh
            else
                begin
                CtrlCPending := false;
                CtrlSPending := false
                end;
        Cmd := CmdTranslate (Ch)
        end; { with }
    end; { else }
GetKey := NewKey
end; { GetKey }


{****************************************************************}

procedure EnQElement (var q: KeyQueue; k: KeyQElement);

{ Return k to the end of q. }

begin { EnQElement }
k^.Next := nil;
if q.first = nil then
    q.first := k;
if q.last <> nil then
    q.last^.next := k;
q.last := k;
end; { EnQElement }


{****************************************************************}

function DeQElement (var q: KeyQueue):  KeyQElement;

{ Return the next KeyQElement in q.  Returns nil if q is empty.  }

begin { DeQElement }
DeQElement := q.first;
if q.first <> nil then
    q.first := q.first^.Next;
if q.first = nil then
    q.last := nil;
end; { DeQElement }


{****************************************************************}

function GetQElement:  KeyQElement;

{ Get a new queue element.  }

var
    key:  KeyQElement;

begin { GetQElement }
key := DeQElement (freeQ);
if key = nil then
    new (key);
key^.event.returned := false;
GetQElement := key;
end; { GetQElement }


{****************************************************************}

procedure FreeQueue (var q: KeyQueue);

{ Return all queue elements to the free list.  }

var
    key, nKey:  KeyQElement;

begin { FreeQueue }
key := q.first;
while key <> nil do
    begin
    nKey := key^.next;
    EnQElement (freeQ, key);
    key := nKey;
    end;
q.first := nil;
q.last := nil;
end; { FreeQueue }


{****************************************************************************}

procedure ReturnKey (var q: KeyQueue; k: KeyEvent);

{ Return k to the beginning of q. }

var Key:  KeyQElement;

begin
key := GetQElement;
k.returned := true;
Key^.Event := k;
Key^.Next := q.first;
q.first := key;
if q.last = nil then
    q.last := key;
end; { ReturnKey }


{****************************************************************************}

procedure EnQueueKey (var q: KeyQueue; k: KeyEvent);

{ Return k to the end of q. }

var Key:  KeyQElement;

begin
key := GetQElement;
Key^.Event := k;
EnQElement (q, key);
end; { EnQueueKey }


{****************************************************************************}

function DeQueueKey (var q: KeyQueue):  KeyEvent;

{ Return the next event in q.  Raises exception if q is empty.  }

var
    key:  KeyQElement;

begin
key := DeQElement (q);
DeQueueKey := key^.Event;
EnQElement (freeQ, key);
end; { DeQueueKey }


{****************************************************************}

procedure ReturnQueue (var changedQ: KeyQueue; returnedQ: KeyQueue);

{ Insert a copy of q at the front of the InputQueue.  }

var
    newStart, oldKey, newKey:  KeyQElement;

begin
if returnedQ.first = nil then
    exit (ReturnQueue);
newKey := GetQElement;
oldKey := returnedQ.first;
newStart := newKey;
repeat
    newKey^.event := oldKey^.event;
    oldKey := oldKey^.next;
    if oldKey <> nil then
        begin
        newKey^.next := GetQElement;
        newKey := newKey^.next;
        end;
until oldKey = nil;
newKey^.Next := changedQ.first;
if changedQ.last = nil then
    changedQ.last := newKey;
changedQ.first := newStart
end; { ReturnQueue }


{****************************************************************}

function IsEmpty (q: KeyQueue):  boolean;

{ Return true if the queue is empty.  }

begin  { IsEmpty }
IsEmpty := q.first = nil;
end.  { IsEmpty }
