program LogIn;

{---------------------------------------------------------------------------
{
{ Abstract:
{    This is the login program.  It is called at both boot time and
{    anytime a LogIn command is executed.
{
{ Written by: Don Scelza
{
{ Copyright (C) Three Rivers Computer Corp.  1981.
{
{----------------------------------------------------------------------------}


{----------------------------------------------------------------------------
{ Change Log:
{
{ 21 Jan 82  V2.0 Brad Myers
{ Revamped switch and profile handling.
{ Added new parameter: PointAllowed.
{ Better help.
{ Prints system version number in title line.
{ }
{
{ 11 Jan 82  V1.17 Brad Myers
{ Fixed shell name to not be full path.
{ }
{
{ 6 Jan 82  V1.16 Brad Myers
{ SCurOn for Password.
{ Check path from profile.
{ }

{ 7 Dec 81  V1.15 WJHansen
{ allow switches when give name after prompt
{ Initialize TimeFID
{ for /Command, use  UseCmd and HoldCmd
{ install ShellOne and ShellTwo
{ install HoldPath, HoldCmd, HoldPFile
{ 30 Nov 81 V1.15 WJHansen
{ Don't display password
{ Default name is Guest
{ Default path is Sys:User>Guest>
{ Setup to use new general command file scheme
{ Accept /HELP
{ Accept /Commands=file   and   /Profile=file
{ Accept Login/Help and give explanation
{ Don't set Shell to LogIn when name or password is invalid; allow continue
{ Accept hours and minutes only for time.  (use old day)
{ If ResetError on >System.Users, login as 'no name'.
{ Don't use cmdfile from profile is one is given by /CommandFile.
{ }

{ 10-Aug-81 V1.14 Brad Myers
{ Added default time read from file
{ Set default path if not in profile
{ Deallocate old shell info
{ }

{ 30-Jun-81 V1.13 Brad Myers
{ Added new profile option for Default screen on and comp when shrink
{ Added default time read from file
{ }

{ 19-May-81 V1.12 Brad Myers
{ Added new profile option for cursor function (screen color)
{ Changed to use exceptions that come from FileUtils and Clock
{ Removed call to ChangeWindow(0) at top
{ }

{ 11-May-81 V1.11 Don Scelza
{ Added code to set shell name.
{ And ability to give a command file.
{ }

{ 11-May-81 V1.10 Don Scelza
{ Added a call to FixFileName in the profile code.
{ }

{ 8-May-81  V1.9  Don Scelza
{ First released version of the new LogIn
{ }

{ 29-Apr-81 V1.7  Don Scelza
{ Added code to set the name of the profile file.
{ }

{ 19-Mar-81 V1.4  Brad Myers
{ PERQ.String to PERQ_String.
{ }

{  5-Mar-81 V1.3  Don Scelza
{ Added calls to the UserPass module.
{ }

{  3-Mar-81 V1.2  Don Scelza
{ Added code to show boot character.  Added coe to ask for user
{ name and set ID fields.
{ }

{ 19-Feb-81 V1.1  John Strait
{ Incorporate system version number into the name of the Shell run file.
{ Make a constant for LogIn version number.
{ }

{ 16-Feb-81 V1.0  Don Scelza
{ Created LogIn program.
{ }
{----------------------------------------------------------------------------}


imports System      from System;
imports Screen      from Screen;
imports Clock       from Clock;
imports Perq_String from Perq_String;
imports Memory      from Memory;
imports UserPass    from UserPass;
imports CmdParse    from CmdParse;
imports Profile     from Profile;
imports FileSystem  from FileSystem;
imports FileUtils   from FileUtils;
imports IO_Unit     from IO_Unit;
imports IO_Others   from IO_Others;
imports IOErrors    from IOErrors;
imports Stream      from Stream;
imports ShellDefs   from ShellDefs;
imports AllocDisk   from AllocDisk;

const LogInVersion = '2.0';

label 1, 2;

var str: String;
    Valid, NeedCheck, ExplicitProfile: Boolean;
    Password, Name: String;
    UsrRec: UserRecord;
    CmdTable, ScrBotTable: CmdArray;
    HoldPFile, HoldShell, HoldPath, HoldCmd: String;
    ShellOne, ShellTwo: String;
    FID: FileID;
    Dum: Integer;
    switches: pSwitchRec;
    Words, OutWords: pArgRec;
    haveTime : boolean;
    

const Debug = false;
      
const PathIndex = 1;
      SetIndex = 2;
      ShellIndex = 3;
      CmdIndex = 4;
      CursIndex = 5;
      ScrIndex = 6;
      HelpIndex = 7;
      PointIndex = 8;
      ProfIndex = 9;
      NumCmds = 9;

      OnIndex = 1;
      OffIndex = 2;
      BlackIndex = 3;
      WhiteIndex = 4;
      ScrBotNumCmds = 4;

const MessFileName = '>motd';

var MessageFile: packed file of char;
    c: char;

procedure TrySetShell(NewName: string);
{-------------------------------------------------------
{ Abstract:
{    If HoldShell, the next shell, has not been set,
{    this procedure checks that NewName is a valid file and
{    sets HoldShell if it is.
{ Parameter:
{    NewName - Possible name for shell.
{------------------------------------------------------}
var 
    FID: FileID;
    TempName: PathName;
begin
if HoldShell = '' then begin
    tempName := NewName;
    FID := FSExtSearch(FSSysSearchList, ' .Run ', tempName, Dum, Dum);
    if FID <> 0 then
        HoldShell := NewName
    else
        writeln('** Could not find ', NewName, ' to be Shell.');
    end;
end;


Procedure AppendSwitches(var s1, s2: pSwitchRec);
{-----------------------------------------------------------
{
{ Abstract:
{    Append the switchRec s2 on the end of s1.  OK if either or both are NIL.
{
{-----------------------------------------------------------}
  var tempS: pSwitchRec;
  begin
  if s1 = NIL then s1 := s2
  else begin
       tempS := s1;
       while tempS^.next <> NIL do
         tempS := tempS^.next;
       tempS^.next := s2;
       end;
  end;

Procedure DoHelp;
  var i : integer;
  begin
  WriteLn;
  WriteLn('    Login allows a person to use the system.  Type your name and');
  WriteLn('    password.  Use the UserControl program to enter a new user.');
  WriteLn('    The null name (type a return) will usually login as "Guest".');
  WriteLn('    The switches to login, which can also appear in the user''s');
  WriteLn('    profile, are: ');
  for i := 1 to NumCmds do
    WriteLn('      ',CmdTable[i]);
  WriteLn;
  Exit(Login);
  end;


Procedure CheckSwitchesForHelpProfileAndShell(var switches: pSwitchRec;
             fromProfile: boolean);
{-----------------------------------------------------------
{
{ Abstract:
{    Go through the switch list.  If a help switch is found and not from
{    profile then do help and exit.  Remove the help switch.  If a
{    profile switch is found, if fromProfile then set CurPFile to the argument,
{    else set HoldPFile to that value.  Remove the profile switch.  If Shell
{    switch then if fromProfile then set ShellTwo else set ShellOne. Remove
{    the shell command.
{
{ Parameters:  Switches - the switch list to modify.  May change the value
{                         of switches if first item on list is profile or help.
{                         Changes all switches to uppercase.
{
{-----------------------------------------------------------}
   var tempS: pSwitchRec;
       lastS: pSwitchRec;
       removeIT: boolean;
   begin
   lastS := NIL;
   tempS := switches;
   while tempS <> NIL do
     begin
     ConvUpper(tempS^.switch);
     case UniqueCmdIndex(tempS^.switch, cmdTable, NumCmds) of
        HelpIndex : begin
                    if not fromProfile then DoHelp;
                    removeIt := True;
                    end;
        ProfIndex : begin
                    if fromProfile then CurPFile := tempS^.arg
                    else HoldPFile := tempS^.arg;
                    removeIt := true;
                    end;
        ShellIndex: begin
                    if fromProfile then ShellTwo := tempS^.arg
                    else ShellOne := tempS^.arg;
                    removeIt := true;
                    end;
        otherwise: removeIt := false;
        end;
     if removeIt then
        if lastS = NIL then switches := tempS^.next
        else lastS^.next := tempS^.next
     else lastS := tempS^.next;
     tempS := tempS^.next;
     end; {while}
   end;  {CheckSwitchesForHelpProfileAndShell}


procedure DoProfile;
{-------------------------------------------------------
{
{ Abstract:
{    Read the profile file.  Checks for errors.  If none, then
{    puts any switches found at the front of the global Switch list.
{
{------------------------------------------------------}
  label 3;
  var PLine: CString;
      sw, swlist : pSwitchRec;
      ins, outs: pArgRec;
      err: String;
      
  handler PNotFound(FName: string);
    begin
    writeln('** User profile file ', FName, ' not found.');
    if curPFile <> PFileConst then
       begin
       curPFile := PFileConst;
       goto 3;
       end
    else exit(DoProfile);
    end;

  begin
  swList := NIL;

3: PFileInit(CurPFile, 'Login');
   WriteLn('Reading profile file ',CurPFile);
   PLine := PFileEntry;
   while PLine <> '' do
     begin
     if not ParseStringArgs(PLine, ins, outs, sw, err) then
        begin
        write(err,' in profile.');
        WriteLn('** Profile ignored!!');
        exit(DoProfile);
        end;
     if (ins^.name <> '') or (outs^.name <> '') or (ins^.next <> NIL) or
        (outs^.next <> NIL) then 
          begin
          WriteLn('** Profile entry "',PLine,'" is malformed. Profile ignored.');
          exit(DoProfile);
          end;
     CheckSwitchesForHelpProfileAndShell(sw, true);
     AppendSwitches(swList, sw);
     PLine := PFileEntry;
     end;
   AppendSwitches(swList, switches);
   switches := swList;
   end;


Procedure HandleSwitches;
{-------------------------------------------------------
{
{ Abstract:
{    Handles the switches except Shell, Help, and Profile.  (Should have 
{    called CheckSwitchesForHelpProfileAndShell first.
{
{------------------------------------------------------}
  Procedure DoPush(name: PathName);
     handler SrchWarn(fileName: PathName);
       begin
       WriteLn('** Cannot fill search list with ',filename);
       exit(DoPush);
       end;
     handler SrchErr(fileName: PathName);
       begin
       WriteLn('** Cannot fill search list with ',filename);
       exit(DoPush);
       end;
     begin
     FSPushSearchItem(name, FSSysSearchList);
     end;
  Procedure DoPop;
     handler SrchWarn(fileName: PathName);
       begin
       WriteLn('** Cannot pop last item of list');
       exit(DoPop);
       end;
     handler SrchErr(fileName: PathName);
       begin
       WriteLn('** Cannot pop last item of list');
       exit(DoPop);
       end;
     begin
     FSPopSearchItem(FSSysSearchList);
     end;

  var i: integer;
  begin
  while switches <> NIL do
     begin
     case UniqueCmdIndex(switches^.switch, CmdTable, NumCmds) of
            PathIndex: begin
                       holdPath := switches^.arg;
                       end;
            SetIndex: if switches^.arg <> '' then
                         if switches^.arg = '-' then DoPop
                         else begin
                              if switches^.arg[length(switches^.arg)] <> '>'
                                 then AppendChar(switches^.arg, '>');
                              FixFileName(switches^.arg, false);
                              DoPush(switches^.arg);
                              end;
            CmdIndex: begin 
                      HoldCmd := switches^.arg;
                      end;
            CursIndex: begin
                       if Length(switches^.arg) <> 1 then 
                         WriteLn('** CursorFunction takes an integer argument')
                       else begin
                            i := Ord(switches^.arg[1])- Ord('0');
                            if (i < 0) or (i > 7) then 
                              WriteLn('** CursorFunction argument must be between 0 and 7.')
                            else DefCursFunction := i;
                            end;
                       end;
            ScrIndex: begin
                      ConvUpper(switches^.arg);
                      case UniqueCmdIndex(switches^.arg, ScrBotTable,
                              ScrBotNumCmds) of
                                OnIndex : DefScrOff := false;
                                OffIndex: DefScrOff := true;
                                BlackIndex: DefScrComp := true;
                                WhiteIndex: DefScrComp := false;
                                ScrBotNumCmds+1: StdError(ErSwParam, switches^.switch, false);
                                Otherwise: WriteLn('** Parameter ', switches^.arg, ' is not unique.');
                                end;
                      end;
            PointIndex: begin
                        ConvUpper(switches^.arg);
                        if switches^.arg <> '' then
                            begin
                            if switches^.arg[1]='F' then PointAllowed := false
                            else PointAllowed := true;
                            end;
                        end;
            NumCmds+1: StdError(ErBadSwitch,switches^.switch, false);
            NumCmds+2: StdError(ErSwNotUnique, switches^.switch, false);
            end {case};
    switches := switches^.next;
    end;
end;  {HandleSwitches}



procedure ReadPassWord(var PassWord: String);
{-----------------------------------------------------------
{ Abstract:
{    Reads password without displaying it.
{ Parameter:
{    PassWord - Set to the string read in.
{ Design:
{    Processes backspace, oops, ^H, ^U, and RETURN.
{-----------------------------------------------------------}
    label 2;
    handler HELPkey (var Replace: Sys9s); begin
       writeln;
       WriteLn;
       writeln('   Enter the secret password for user ''', Name, '''');
       Write('Password: ');
       goto 2;
    end;
       
    const
       CtlU = chr( ord('U') - ord('A') + 1);
       CtlH = chr( ord('H') - ord('A') + 1);
       ChCR = chr( ord('M') - ord('A') + 1);
    var 
       reading: Boolean;
       Ch: char;
    begin
 2:  SCurOn;
     PassWord := '';
     reading := true;
     while reading do begin
          while IOCRead(TransKey, Ch) <> IOEIOC do {nothing};
          case Ch of 
             '''': begin
                     while IOCRead(TransKey, Ch) <> IOEIOC do {nothing};
                     AppendChar(PassWord, Ch);
                   end;
             CtlU: PassWord := '';
             CtlH: if length(PassWord)>=1 then 
                     Adjust(PassWord, length(PassWord)-1);
             ChCR: reading := false;
             otherwise:
                   AppendChar(PassWord,Ch);
          end;
       end;
    WriteLn;
    SCurOff;
    end;



procedure HandleLine(S: String);
{-----------------------------------------------------------
{
{ Abstract:
{    Processes the input S as a line.  Sets Words, OutWords, and Switches
{    variables.  Appends switches found at END of global switches.  If help,
{    then do help immediately.  Do not use this for switches in profile.
{ Calls: CheckSwitchesForHelpProfileAndShell.
{
{-----------------------------------------------------------}
var Err: CString;
   sw: pSwitchRec;
   begin
    if not ParseStringLine(S, Words, OutWords, sw, Err) then
       begin
       writeln(Err);
       exit(Login);
       end
    else if (OutWords^.next <> NIL) or (Words^.next <> NIL) then
       begin
       writeln('** No '','' allowed');
       exit(LogIn);
       end
    else begin
         CheckSwitchesForHelpProfileAndShell(sw, false);
         AppendSwitches(switches, sw);
         end;
end; {HandleLine}


procedure CheckLogIn;
{-----------------------------------------------------------
{
{ Abstract:
{    This procedure is used to see if the user is valid.
{    Check the name and password.
{
{ Side Effects:
{    This procedure will change the current user ID, 
{    current group ID and Current user name.
{
{-----------------------------------------------------------}
    var
       isSwitch: Boolean;
       Word: CString;
       Break: char;
       FID: integer;
       Dum: integer;
       
       
    label 2;
    handler HELPkey (var Replace: Sys9s); begin
       writeln; 
       WriteLn;
       writeln('   Type in your login name or press the return key to log in as "Guest".');
       WriteLn;
       Name := '';
       goto 2;
    end;
    
    label 3;
    handler ResetError(filename: pathName); begin
       writeln;
       writeln('** Unable to find ', filename);
       NeedCheck := false;
       goto 3;
    end;
    
    
  begin  {CheckLogin}
    Break := NextId(Word, isSwitch); {remove cmd from line}
    HandleLine(UsrCmdLine);
    
             
    Name := Words^.name;
2:  if length(Name) = 0 then
        begin
        write('Please enter your name: ');
        readln(Name);
        HandleLine(Name);
        Name := Words^.Name;
        end;
    if length(Name) = 0 then 
        begin
        Password := '    ';
        Name := 'Guest';
        end
    else
        begin
        PassWord := '';
        if OutWords^.name <> '' then begin
            PassWord := OutWords^.name;
            Password := Concat(Password, '    ');
        end;
    if length(Password) = 0 then
            begin
            write('Password: ');
            ReadPassWord(PassWord);
            HandleLine(PassWord);
            PassWord := Words^.name;
            Password := Concat(Password, '    ');
            end;
        end;
    

   NeedCheck:=True; {May be set False by handler for ResetError from ValidUser}

3: if NeedCheck then
        begin
        if not ValidUser(Name, Password, UsrRec) then 
            begin
            writeln('** Invalid user or password.');
            goto 1;
            end;
    
        CurUserName := UsrRec.Name;
        CurUserID := UsrRec.UserId;
        CurGroupID := UsrRec.GroupID;
        if HoldPFile <> '' then
            CurPFile := HoldPFile
        else if length(UsrRec.Profile) <> 0 then
            CurPFile := UsrRec.Profile
        else
            CurPFile := PFileConst;
        end
    else
        begin
        CurUserName := 'Need to create System.Users';
        CurUserID := 0;
        CurGroupID := 0;
        CurPFile := PFileConst;
        end;
    end {CheckLogin};
    
    

procedure ClearUserState;
{---------------------------------------------------------------
{
{ Abstract:
{    This procedure is used to clear the system state that is
{    associated with a user.
{
{ Side Effects:
{    This procedure will clear some of the variables in system.
{
{--------------------------------------------------------------}
  Handler SrchWarn(name: PathName);
    begin
    Exit(ClearUserState);
    end;
  Handler SrchErr(name: PathName);
    begin
    Exit(ClearUserState);
    end;
  
  var s: PathName;
      Ctrl:  pCtrlRec;
      dev: integer;
            
  begin
  if ShellCtrl <> NIL then
      begin
      Ctrl := recast(ShellCtrl, pCtrlRec);
      DstryCmdFiles(Ctrl^.CmdFileList);
      ShellCtrl := NIL;
      DecRefCount(CmdSegment);
      CmdSegment := 0;
      end;

  DefCursFunction := ord(CTNormal);  {in case not specified}
  DefScrOff := False;
  DefScrComp := False;
  PointAllowed := True;
  PrintStatistics := False;

  LastFileName := '';

  dev := ord(not isFloppy);
  if DiskTable[dev].InUse then
    begin
    WriteLn('* Dismounting device ',dev:1);
    FSDismount(dev); {dismount other device than booted from}
    end;
    
  repeat
      FSPopSearchItem(FSSysSearchList);
  until false;
  
  {NOTE: exit is via FSPopSearchItem failure}

  end;
    

procedure GetTime;
{---------------------------------------------------------------
{
{ Abstract:
{    Gets the time from user and sets it.
{
{ Side Effects:
{    Sets the time.
{
{--------------------------------------------------------------}
var
    TimeIn: String;
    OldTime: string;

var
    Timebits: integer;
    blks: integer;
    buf: RECORD CASE boolean of
           true: (t: ^TimeStamp);
           false: (p: pDirBlk);
           END;

label 2;
Handler HELPkey (var Replace: Sys9s);
   begin
   WriteLn;
   WriteLn;
   WriteLn('      Type the date and time in military (24 hour) format.  Seconds are optional.');
   WriteLn('      Example:  21 Jan 82  15:32');
   WriteLn;
   goto 2;
   end;

Handler BadTime;
   begin
   goto 2;
   end;

 begin
    OldTime := '';
    if not isFloppy then begin
        TimeFID := FSInternalLookUp(TimeFileName, blks, Timebits);
        if (TimeFID = 0) or (blks<>1) or (Timebits<>TimeFBitSize) then
            begin
            TimeFID := FSEnter(TimeFileName);
            FSClose(TimeFID, 1, TimeFBitSize);
            end
        else begin
            NEW(buf.p);
            FSBlkRead(TimeFID, 0, buf.p);
            StampToString(buf.t^, OldTime);
            Adjust(OldTime, length(OldTime)-3); {remove seconds}
            end;
        end;

  2: if OldTime = '' then 
         write('Enter date and time as DD MMM YY HH:MM:SS :')
     else 
         write('Enter time as HH:MM or full date: [', OldTime, '] ');
     if not eoln then 
         read(TimeIn)
     else
         TimeIn := OldTime;
     Readln;

     if (length(TimeIn)<=8) and (PosC(TimeIn, ' ')=0) 
             and (PosC(TimeIn, ':')<>0) and (OldTime<>'') then
         Str := concat(substr(OldTime, 1, 10), TimeIn)
     else 
         Str := TimeIn;
     SetTString(Str);     {may raise BadTime and go back to 2}
     haveTime := true;
 end;
    

handler ResetError(FileName: PathName);

begin
  goto 2;
end;

{-----------------------------
{ LogIn    Main program
{----------------------------}   
var 
   IgnoreI: integer;
   
begin
Str := Concat('LogIn version ', LogInVersion);
Str := Concat(Str, '      ');
Str := Concat(Str, '    POS ');
Str := Concat(Str, MainVersion);
AppendChar(Str,'.');
Str := Concat(Str, StrVersion);
Str := Concat(Str, '  ');
AppendChar(Str, chr(SysBootChar));
Str := Concat(Str, '-boot     ');
ChangeTitle(Str);

    CmdTable[PathIndex] := 'PATH            set the default path to argument.';
    CmdTable[SetIndex] :=  'SETSEARCH       push (or pop with -) argument onto search list.';
    CmdTable[ShellIndex] :='SHELL           set the name of the shell program.';
    CmdTable[CmdIndex] :=  'COMMAND         set the first command to run.  Use @ to run a command file.';
    CmdTable[CursIndex] := 'CURSORFUNCTION  set the default cursor function.  Arg is 0..7.';
    CmdTable[ScrIndex] :=  'SCREENBOTTOM    set bottom of screen.  Args are ON, OFF, WHITE, BLACK.';
    CmdTable[HelpIndex] := 'HELP';
    CmdTable[PointIndex] :='POINTALLOWED    pointing device is used? (TRUE implies popUp menus allowed).';
    CmdTable[ProfIndex] := 'PROFILE         set the profile to use.';

    ScrBotTable[OnIndex] :=    'ON';
    ScrBotTable[OffIndex] :=   'OFF';
    ScrBotTable[BlackIndex] := 'BLACK';
    ScrBotTable[WhiteIndex] := 'WHITE';

HaveTime := false;

1: HoldPFile := '';
   HoldPath  := '';
   HoldCmd   := '';
   HoldShell := '';
   ShellOne := '';
   ShellTwo := '';
   switches := NIL;
   
if (not haveTime) and (UsrCmdLine = '') then GetTime;
    
CheckLogIn;     { Check for a valid user }
WriteLn('Initializing for user: ',curUserName);
ClearUserState; { Clear the user's state }
DoProfile;      { Get the profile file }
HandleSwitches; { Handle Switches set up by user and profile }

reset(MessageFile, MessFileName);
writeln;
while not EOF(MessageFile) do
  begin
    while not EOLN(MessageFile) do
      begin
        read(MessageFile, c);
        write(c)
      end;
    writeln;
    if not EOF(MessageFile)
      then readln(MessageFile)
  end;
close(MessageFile);

2: if HoldPath <> '' then
   begin
   if HoldPath[length(HoldPath)] <> '>' then AppendChar(HoldPath, '>');
   if FSInternalLookUp(HoldPath, dum, dum) = 0 then
      begin
      FixFileName(HoldPath, true);
      WriteLn('** New path ',HoldPath,' doesn''t exist.');
      HoldPath := '';
      end;
   end;

if HoldPath = '' then HoldPath := ':User>Guest>';

if FSInternalLookUp(HoldPath, dum, dum) = 0 then HoldPath := '>';
FSRemoveDots(HoldPath);

FSDirPrefix := HoldPath;
    
if ShellOne<>'' then TrySetShell(ShellOne);   {try shell from command line}
if ShellTwo<>'' then TrySetShell(ShellTwo);   {try shell from profile}
TrySetShell(concat(ShellConst, concat(StrVersion, '.Run')));
if HoldShell <> '' then
    ShellName := HoldShell
else begin
  writeln(' No Shell');
  goto 1; {no shell, loop running login}
end;

RFileName := ShellName;

if HoldCmd<>'' then begin
    if RemoveQuotes(HoldCmd) then;
    UsrCmdLine := HoldCmd;
    UseCmd := True;
    end
else UseCmd := False;

end.
