module Virtual;
{-----------------------------------------------------------------------------
{
{       Virtual - Perq virtual memory manager.
{       J. P. Strait        1 Jan 80.
{       Copyright (C) Three Rivers Computer Corporation, 1980.
{
{ Abstract:
{       Virtual is the Perq virtual memory manager.  It supervises the
{       segment tables and exports procedures for swapping memory segments.
{       Virtual is the portion of the Perq memory manager which must remain
{       memory resident at all times.
{       Perq physical memory is segmented into separately swappable items
{       (called segments) which may contain either code or data.
{
{ Design:
{       See the Q-Code reference manual.
{
{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------
{ Change Log:
{
{  13 Jan 82  V2.8  Brad Myers (found by JPS)
{    Handler for XStackOverflow in SwapIn and SwapOut

{ 10 Dec 81  V2.7  WJHansen
{    change to use long arithmetic for xxTime;  remove Arith

{ 25 Oct 81  V2.6  JPS
{ Changes to agree with V2.11 Memory.
{ }

{ 24 Sep 81 V2.5  WJH
{ When delete a segment, make it swappable.
{ }

{ 3 Jul 81  V2.4  JPS
{ Fix bug where MMFirst was getting trashed by SwapIn.
{ }

{ 28 May 81  V2.3  BAM
{ New light.
{ }

{ 26 May 81  V2.2  JPS
{ Show swapping with a "light".
{ }

{ 21 May 81  V2.1  JPS
{ Fix various serious bugs in SwapIn procedure.
{ Delete several unused variables in various procedures.
{ }

{ 12 May 81  V2.0  JPS
{ 1) Split Memory into two modules: Memory (user callable routines, swappable)
{    and Virtual (system callable routines, unswappable).
{ 2) Move FileIdToSegId and SegIdToFileId into Virtual.
{ 3) Use exceptions rather than MemoryError.
{ }

{ 24 Mar 81  V1.9  JPS
{ Begin adding stuff for virtual memory.
{ }

{ 23 Mar 81  V1.8  JPS
{ Convert to standard documentation form.
{ Delete DEBUG stuff.
{ Delete OutputF.
{ Add "MM" to the beginning of names which are exported but are not needed by
{ programs which import the memory manager.
{ Remove Concat call from MemoryError.
{ Remove import of Perq.String.
{ }

{ 24 Feb 81  V1.7  JPS
{ 1) Allow the ScreenSeg to change sizes.  To allow this, the memory
{    manager must prevent system segments (those with RefCount > 1) from
{    being moved into the area of memory which might be used for the
{    screen.  This is a hack which guarantees that the system can expand
{    the screen to its original size after returning from a user program.
{    This change was originally made by RFR, but had to be converted for
{    memory manager version 1.5 and greater.
{ 2) Remove PrintTable and PrintFreeList.
{ }

{ 23 Feb 81  V1.6  RFR
{ Added DK and CH to system boot record (they will be filled by the boot
{ microcode with the disk number and boot character used in booting).
{ }

{ 18 Feb 81  V1.5  JPS
{ Define fields in the SIT to remember names of boot loaded segments.
{ Remove most of InitMemory since it is done now by MakeBoot.  Make IOSeg
{ a constant.
{ }

{ 17 Feb 81  V1.4  DAS
{ Removed the include file SegNumbers.  Placed the segment number
{ definitions inline.
{ }

{ 16 Feb 81  V1.3  DAS
{ Changed to use Perq_String from Perq.String
{ }

{ 11 Feb 81        DCF
{ Changed calls to PString to conform to new PString.  This module is
{ compatable with the new System and Compiler.
{ }

{ 13 Jan 81  V1.2  JPS
{ 1) Allocate the IOSeg in memory manager initialization as a locked
{    segment at the high end of memory.  Use the last block in memory (the
{    Krnl no longer needs it).
{ 2) Move $R- to private part.
{ }

{ 10 Oct 80  V1.1  JPS
{ Add support for the diagnostic display (DDS).
{ }
{-----------------------------------------------------------------------------}

exports


const VirtualVersion = '2.8';


imports Memory from Memory;
imports IO_Unit from IO_Unit;
imports DiskIO from DiskIO;

          
 function  ReturnSegment: SegmentNumber;
 procedure ReleaseSegmentNumber( Seg: SegmentNumber );
 function  NewSegmentNumber: SegmentNumber;
 procedure MakeEdge( var E: MMEdge; S: SegmentNumber );
 procedure DeleteSegment( var S: SegmentNumber );
 procedure SwapOut( var E: MMEdge );
 procedure SwapIn( E: MMEdge; S: SegmentNumber; P: MMPosition );
 procedure Compact;
 procedure KeepSegments;
 procedure FindHole( Fsize: MMIntSize; ForUserSegment: Boolean );
 procedure IncIOCount( S: SegmentNumber );
 procedure DecIOCount( S: SegmentNumber );
 procedure SwapSegmentsIn( S1, S2, S3, S4: SegmentNumber );
 


var ScreenLast: Integer;
    Keep1, Keep2, Keep3, Keep4: SegmentNumber;
    Kludge: record case Integer of
             1: (A: DiskAddress);
             2: (D: Double)
             end;
    BlockHeader: IOHeadPtr;
    BlockAddress: Double;
    BlockSId: SegId;
    Status: IOStatPtr;
    BootSerialNum: Double;
    BootSegId: SegId;
    SwapSId: SegId;

 
 
private
