module Profile;

{----------------------------------------------------------------------
{
{ Abstract:
{    This module is used to get information from the user profile
{    file.
{
{ Written by: Don Scelza
{
{ Copyright (C) Three Rivers Computer Corperation,  1981
{
{-----------------------------------------------------------------------}


{ 28 Dec-81  V1.1  Brad Myers
{ Fixed so PFileEntry only returns a blank line when no more inputs.
{ Changed length of strings returned to be 255!!
{ }

{ 30-Apr-81  V1.0  Don Scelza
{ Created the module.
{ }


{********************} Exports {********************}

{---------------------------------------------------------------------
{
{    This module provides facilities that will allow a program to get
{ information from the user profile.
{
{    The profile file is a text file that has the form:
{
{        #<Subsystem name> <Line of text for that sub system>
{        <More text for that subsystem>
{        -
{        -
{        -
{        #<Next subsystem>---
{
{ The base unit of the file is a text line.  The function that provides
{ values from the profile file will return a line of text each time that it
{ is called.  All text line between the #<Subsystem name> and the next
{ #<Subsystem name> are assumed to be assoicated with the first subsystem.
{ Successive calles to PFileEntry will return the next line of text for the
{ current subsystem.
{
{----------------------------------------------------------------------}

Exception PNotFound(FileName: String);
{------------------------------------------------------------------------
  Abstract: Raised when profile file cannot be found
  Parameters: fileName is profile not found
------------------------------------------------------------------------}

Exception PNotInited;
{------------------------------------------------------------------------
  Abstract: Raised when a profile procedure is used but PFileInit not called
              first
------------------------------------------------------------------------}

Type ProfStr = String[255];

procedure PFileInit(PFileName, SubSystem: ProfStr);

function PFileEntry: ProfStr;

{*******************} Private {*********************}
