module Memory;
{-----------------------------------------------------------------------------
{
{       Memory - Perq memory manager.
{       J. P. Strait        1 Jan 80.
{       Copyright (C) Three Rivers Computer Corporation, 1980.
{
{ Abstract:
{       Memory is the Perq memory manager.  It supervises the segment tables
{       and exports procedures for manipulating memory segments.
{       Perq physical memory is segmented into separately addressable items
{       (called segments) which may contain either code or data.
{
{ Design:
{       See the Q-Code reference manual.
{
{-----------------------------------------------------------------------------}

{ 16 Nov 81  V2.13  DAS
{ Fixed to work with ten MBaud ethernet.
{ }

{ 25 Oct 81  V2.12  JPS 
{ Enlarge segment table to 512 entries when more than 1/4 MByte.
{ }

{ 25 Oct 81  V2.11  JPS 
{ Implement full hints in Memory.
{ 1) The two added words (for the UpdateTime) are overlayed on the two
{    words of Increment, Maximum, and FreeList which are not used for
{    Code segments.
{ 2) ChangeSize and NewP now check to be sure the segment is a Data segment.
{ 3) FindCodeSegment compares hints.
{ }

{  6 Oct 81  V2.10  JPS 
{ Fix bug in CreateSegment:  It cannot call ChangeSize to shorten a hole
{ because the new size may be larger than 256 blocks.  ChangeSize would
{ raise BadSize exception.
{ }

{  4 Oct 81  V2.9  JPS 
{ Change InitMemory to figure out how much physical memory the machine has.
{ }

{ 18 Sep 81  V2.8  WJH 
{ Set Mobility to Swappable in CreateSegment.
{ }

{ 26 Jul 81  V2.7  JPS
{ Fix bug in order of operations in CreateSegment.
{ }

{ 21 Jul 81  V2.6  JPS
{ Don't use MaxSegment anywhere.
{ }

{ 29 Jun 81  V2.5  JPS
{ Destroy swapping files when swapping is disabled.
{ }

{ 4 Jun 81  V2.4  JPS
{ Add Virgil headers for exceptions.
{ }

{ 26 May 81  V2.3  JPS
{ Add CurrentSegment function.
{ Prevent Memory from being swapped during FindHole calls.
{ }

{ 21 may 81  V2.2  JPS
{ Initialize BootSegId in EnableSwapping.
{ }

{ 14 May 81  V2.1  GGR
{ Add support for 3 MBaud EtherNet.
{ }

{ 12 May 81  V2.0  JPS
{ 1) Split Memory into two modules: Memory (user callable routines, swappable)
{    and Virtual (system callable routines, unswappable).
{ 2) Move FileIdToSegId and SegIdToFileId into Memory.
{ 3) Use exceptions and get rid of MemoryError.
{ }

{ 24 Mar 81  V1.9  JPS
{ Begin adding stuff for virtual memory.
{ }

{ 23 Mar 81  V1.8  JPS
{ Convert to standard documentation form.
{ Delete DEBUG stuff.
{ Delete OutputF.
{ Add "MM" to the beginning of names which are exported but are not needed by
{ programs which import the memory manager.
{ Remove Concat call from MemoryError.
{ Remove import of Perq.String.
{ }

{ 24 Feb 81  V1.7  JPS
{ 1) Allow the ScreenSeg to change sizes.  To allow this, the memory
{    manager must prevent system segments (those with RefCount > 1) from
{    being moved into the area of memory which might be used for the
{    screen.  This is a hack which guarantees that the system can expand
{    the screen to its original size after returning from a user program.
{    This change was originally made by RFR, but had to be converted for
{    memory manager version 1.5 and greater.
{ 2) Remove PrintTable and PrintFreeList.
{ }

{ 23 Feb 81  V1.6  RFR
{ Added DK and CH to system boot record (they will be filled by the boot
{ microcode with the disk number and boot character used in booting).
{ }

{ 18 Feb 81  V1.5  JPS
{ Define fields in the SIT to remember names of boot loaded segments.
{ Remove most of InitMemory since it is done now by MakeBoot.  Make IOSeg
{ a constant.
{ }

{ 17 Feb 81  V1.4  DAS
{ Removed the include file SegNumbers.  Placed the segment number
{ definitions inline.
{ }

{ 16 Feb 81  V1.3  DAS
{ Changed to use Perq_String from Perq.String
{ }

{ 11 Feb 81        DCF
{ Changed calls to PString to conform to new PString.  This module is
{ compatable with the new System and Compiler.
{ }

{ 13 Jan 81  V1.2  JPS
{ 1) Allocate the IOSeg in memory manager initialization as a locked
{    segment at the high end of memory.  Use the last block in memory (the
{    Krnl no longer needs it).
{ 2) Move $R- to private part.
{ }

{ 10 Oct 80  V1.1  JPS
{ Add support for the diagnostic display (DDS).
{ }

exports


const MemoryVersion = '2.13';


imports SystemDefs from SystemDefs;
imports Code from Code;


const SATSeg = 1;              { SAT segment }
      SITSeg = 2;              { SIT segement }
      FontSeg = 3;             { font segment }
      ScreenSeg = 4;           { screen segment }
      CursorSeg = 5;           { cursor segment }
      IOSeg = 6;               { IO segment }
      SysNameSeg = 7;          { system segment names }
      
      BootedMemoryInBlocks = #1000;    { memory in blocks at boot time }
      MaxSegment = #137;       { should be 2**16 - 1 }

      SetStkBase = #60;
      SetStkLimit = #120;

{$ifc Ether3MBaud then}
      IOSegSize = 6;           { number of blocks in the IOSeg }
{$elsec}
{$ifc Ether10MBaud then}
      IOSegSize = 3;           { number of blocks in the IOSeg }
{$elsec}
      IOSegSize = 3;           { number of blocks in the IOSeg }
{$endc}
{$endc}
      
      SysSegLength = 8;       { length of name of a boot-loaded segment }

      MMMaxBlocks = #400;      { maximum number of blocks in a segment }
      MMMaxCount = #377;
      MMMaxIntSize = MMMaxBlocks-1;
      MMMaxExtSize = MMMaxBlocks;
      


type MMBit4 = 0..#17;
     MMBit8 = 0..#377;
     MMBit12 = 0..#7777;
     MMIntSize = 0..MMMaxIntSize;
     MMExtSize = 1..MMMaxExtSize;
     MMAddress = integer;
     MMPosition = (MMLowPos, MMHighPos);

     SegmentNumber = integer;

     SegmentKind = (CodeSegment, DataSegment);
     
     SegmentMobility = (UnMovable, UnSwappable, LessSwappable, Swappable);

     MMFreeNode = record
      N: MMAddress;
      L: integer
      end;
      
     MMBlockArray = array[0..0] of array[0..127] of integer;
     
     pMMBlockArray = ^MMBlockArray;

     MMArray = record case Integer of
                1: (m: array[0..0] of MMFreeNode);
                2: (w: array[0..0] of Integer)
                end;

     pMMArray = ^MMArray;

     MMPointer = record case integer of
      1: (P: ^integer);
      2: (B: pMMBlockArray);
      3: (M: pMMArray);
      4: (Offset: MMAddress;
          Segmen: SegmentNumber)
      end;

     SATentry = packed record { Segment Address Table }
      { **** ENTRIES MUST BE TWO WORDS LONG **** }
      NotResident : boolean;            { 001 }
      Moving      : boolean;            { 002 }
      RecentlyUsed: boolean;            { 004 }
      Sharable    : boolean;            { 010 }
      Kind        : SegmentKind;        { 020 }
      Full        : boolean;            { 040 }
      InUse       : boolean;            { 100 }
      Lost        : boolean;  { *** }   { 200 }
      BaseLower   : MMBit8;
      BaseUpper   : MMBit4;
      Size        : MMBit12
      end;

     SITentry = packed record case integer of { Segment Information Table }
      { **** ENTRIES MUST BE EIGHT WORDS LONG **** }
      1: { real SIT entry }
         (NextSeg    : SegmentNumber;
          RefCount   : 0..MMMaxCount;
          IOCount    : 0..MMMaxCount;
          Mobility   : SegmentMobility;
          BootLoaded : Boolean;
          SwapInfo   : record case {BootLoaded:} Boolean of
                         True:  (BootLowerAddress: Integer;
                                 BootUpperAddress: Integer;
                                 BootLogBlock: Integer);
                         False: (DiskLowerAddress: Integer;
                                 DiskUpperAddress: Integer;
                                 DiskId: Integer)
                         end;
          case SegmentKind of
            DataSegment: (Increment  : MMIntSize;
                          Maximum    : MMIntSize;
                          Freelist   : MMAddress);
            CodeSegment: (Update     : TimeStamp)
         );
      2: { boot time information }
         (BootBlock: record
           CS: SegmentNumber;     { initial code segment }
           SS: SegmentNumber;     { initial stack segment }
           XX: Integer;           { unused }
           VN: Integer;           { system version number }
           FF: SegmentNumber;     { first free segment number }
           FC: SegmentNumber;     { first system code segment }
           DK: integer;           { disk system was booted from }
           CH: integer            { char used in booting }
           end)
      end;

     SATarray = array[0..0] of SATentry;

     SITarray = array[0..0] of SITentry;

     pSAT = ^SATarray;

     pSIT = ^SITarray;

     MMEdge = record
             H: SegmentNumber;  { Head }
             T: SegmentNumber   { Tail }
             end;

     SysSegName = packed array[1..SysSegLength] of Char;
     
     pSysNames = ^SysNameArray;
     
     SysNameArray = array[0..0] of SysSegName;
     
             
 procedure InitMemory;
 procedure DataSeg( var S: SegmentNumber );
 procedure CodeOrDataSeg( var S: SegmentNumber );
 procedure ChangeSize( S: SegmentNumber; Fsize: MMExtSize );
 procedure CreateSegment( var S: SegmentNumber;
                          Fsize, Fincrement, Fmaximum: MMExtSize );
 procedure IncRefCount( S: SegmentNumber );
 procedure SetMobility( S: SegmentNumber; M: SegmentMobility );
 procedure DecRefCount( S: SegmentNumber );
 procedure SetIncrement( S: SegmentNumber; V: MMExtSize );
 procedure SetMaximum( S: SegmentNumber; V: MMExtSize );
 procedure SetSharable( S: SegmentNumber; V: boolean );
 procedure SetKind( S: SegmentNumber; V: SegmentKind );
 procedure MarkMemory;
 procedure CleanUpMemory;
 procedure FindCodeSegment( var S: SegmentNumber; Hint: SegHint );
 procedure EnableSwapping( Where: Integer );
 procedure DisableSwapping;
 function  CurrentSegment: SegmentNumber;
 
 exception UnusedSegment( S: SegmentNumber );
{-----------------------------------------------------------------------------
{
{ Abstract:
{       UnusedSegment is raised when the memory manager encounters a segment
{       number which references a segment which is not in use.  This may mean
{       that a bad segment number was passed to some memory manager routine
{       or that a bad address was de-referenced.
{
{ Parameters:
{       S - Segment number of the unused segment.
{
{-----------------------------------------------------------------------------}


 exception NotDataSegment( S: SegmentNumber );
{-----------------------------------------------------------------------------
{
{ Abstract:
{       NotDataSegment is raised when the number of a code segment is passed
{       to some memory manager routine that requires the number of a data
{       segment.
{
{ Parameters:
{       S - Segment number of the code segment.
{
{-----------------------------------------------------------------------------}


 exception BadSize( S: SegmentNumber; Fsize: Integer );
{-----------------------------------------------------------------------------
{
{ Abstract:
{       BadSize is raised when a bad Size value is passed to some memory
{       manager routine.  This usually means that the size passed to
{       CreateSegment or ChangeSize is greater than the maximum size or
{       less than one.
{
{ Parameters:
{       Fsize - The bad Size value.
{
{-----------------------------------------------------------------------------}


 exception BadIncrement( S: SegmentNumber; Fincrement: Integer );
{-----------------------------------------------------------------------------
{
{ Abstract:
{       BadIncrement is raised when a bad Increment value is passed to some
{       memory manager routine.  This usually means that the increment passed
{       to CreateSegment is greater than 256 or less than one.
{
{ Parameters:
{       Fincrement - The bad Increment value.
{
{-----------------------------------------------------------------------------}


 exception BadMaximum( S: SegmentNumber; Fmaximum: Integer );
{-----------------------------------------------------------------------------
{
{ Abstract:
{       BadMaximum is raised when a bad Maximum value is passed to some memory
{       manager routine.  This usually means that the maximum passed to
{       CreateSegment is greater than 256 or less than one.
{
{ Parameters:
{       Fmaximum - The bad Maximum value.
{
{-----------------------------------------------------------------------------}


 exception FullMemory;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       FullMemory is raised when there is not enough physical memory to
{       satisfy some memory manager request.  This is raised only after
{       swapping segments out and compacting memory.
{
{-----------------------------------------------------------------------------}


 exception CantMoveSegment( S: SegmentNumber );
{-----------------------------------------------------------------------------
{
{ Abstract:
{       CantMoveSegment is raised when the memory manager attempts to move
{       a segment which is UnMovable or has a non-zero IO count.
{
{ Parameters:
{       S - The number of the segment which cannot be moved.
{
{-----------------------------------------------------------------------------}


 exception PartNotMounted;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       PartNotMounted is raised when
{               1) the memory manager attempts to swap a data segment out for
{                  the first time
{       and     2) the partition which is to be used for swapping is no longer
{                  mounted.
{
{-----------------------------------------------------------------------------}


 exception SwapInFailure( S: SegmentNumber );
{-----------------------------------------------------------------------------
{
{ Abstract:
{       SwapInFailure is raised when the swap file cannot be found for a
{       segment which is marked as swapped out.  This is an error which
{       should never happen in a debugged system.  It usually means that
{       there is a bug in the memory manager or that the segment tables
{       have been clobbered.
{
{ Parameters:
{       S - The number of the segment which could not be swapped in.
{
{-----------------------------------------------------------------------------}


 exception EdgeFailure;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       EdgeFailure is raised by MakeEdge when it discovers that the SIT
{       entries are not linked together into a circular list.  This is an
{       error which should never happen in a debugged system.  It usually
{       means that there is a bug in the memory manager or that the segment
{       tables have been clobbered.
{
{-----------------------------------------------------------------------------}


 exception NilPointer;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       NilPointer is raised when a Nil pointer is used or passed to Dispose.
{
{-----------------------------------------------------------------------------}


 exception BadPointer;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       BadPointer is raised when a bad pointer is passed to Dispose.
{
{ Parameters:
{
{-----------------------------------------------------------------------------}


 exception FullSegment;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       FullSegment is raised by New when it discovers that there is not
{       enough room to allocate and the segment cannot be enlarged (its
{       size has reached its maximum).
{
{-----------------------------------------------------------------------------}


 exception NoFreeSegments;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       NoFreeSegments is raised when the memory manager discovers that all
{       of the segment numbers are in use and it needs another one.  This
{       is equivalent to "Segment table full".
{
{-----------------------------------------------------------------------------}


 exception SwapError;
{-----------------------------------------------------------------------------
{
{ Abstract:
{       SwapError is raised if the one of the memory managers swapping
{       routines is called when swapping is disabled.  This is an error which
{       should never happen in a debugged system.  It usually means that
{       there is a bug in the memory manager.
{
{-----------------------------------------------------------------------------}


 

var SAT: pSAT;
    SIT: pSIT;
    MMFirst, MMFree, MMLast, MMHeap: SegmentNumber;
    MMHole: MMEdge;
    MMState: (MMScan1, MMScan2, MMScan3, MMScan4, MMScan5,
              MMScan6, MMScan7, MMScan8, MMScan9, MMScan10,
              MMScan11,
              MMNotFound, MMFound);
    StackSegment: SegmentNumber;
    FirstSystemSeg: SegmentNumber;
    BootFileId: Integer;
    SwappingAllowed: Boolean;
    SwapId: Integer;
    MemoryInBlocks: Integer;  { amount of memory on this machine }
 
 
private

