module GetTimeStamp;
{-----------------------------------------------------------------------------
{
{       GetTimeStamp - Perq get time routine.
{       J. P. Strait       1 Feb 81.
{       Copyright (C) Three Rivers Computer Corporation, 1981.
{
{ Abstract:
{       GetTimeStamp implements the read-time-as-TimeStamp function for the
{       Clock module.  See the Clock module for more details.
{
{ Design:
{       GetTimeStamp is a separate module so that it may be imported into the
{       resident system without importing all the other Clock routines.  Once
{       virtual memory is implemented, GetTimeStamp and Clock should be merged
{       into a single module.
{
{-----------------------------------------------------------------------------}

{ V1.4   1 Jun 81  Brad Myers.
{ Add comments.
{ }

{ V1.3  18 May 81  Brad Myers.
{ Change IO to IO_Others.
{ }

{ V1.2   2 Mar 81  John Strait.
{ Don't export IO.
{ }

{ V1.1   2 Mar 81  John Strait.
{ Add title, copyright, abstract.
{ Add version number.
{ Add change history retroactively.
{ }

{ V1.0   1 Feb 81  John Strait.
{ Start file.
{ }


{/////////////////////////} Exports {\\\\\\\\\\\\\\\\\\\\\\\\}

const GetTSVersion = '1.4';


type TimeStamp = packed record
       { the fields in this record are ordered this way to optimize bits }
       Hour:   0..23;
       Day:    1..31;
       Second: 0..59;
       Minute: 0..59;
       Month:  1..12;
       Year:   0..63;  { year since 1980 }
       end;

     TimeReference = record
                       Lower: Integer;
                       Upper: Integer
                       end;

procedure GetTStamp( var Stamp: TimeStamp );


var PastStamp: TimeStamp;
    Past: TimeReference;

{/////////////////////////} Private {\\\\\\\\\\\\\\\\\\\\\\\\}
