module FileSystem;
{--------------------------------------------------------------------
{
{ Abstract:
{
{
{ Spice Interim File System.

 Written by: Richard F. Rashid
 Date      : February 24, 1981
 Copyright (C) 1981 - Carnegie-Mellon University
--------------------------------------------------------------------}

{--------------------------------------------------------------------
 Change history

  4 Jan 82  BAM   V7.3    New exception for closing a directory.
  3 Dec 81  BAM   V7.2    New version of FlushFail.
 12 May 81  BAM   V7.1    Fixed to allow FlushFail on open.
 12 May 81  BAM   V7.0    Added Exceptions for FSLookUp and FSEnter.
                          Catch string too long from FixFileName
  9 Apr 81  BAM   V6.7    FSClose no longer sets any dates (set by open/enter).
  3 Apr 81  BAM   V6.6    Fixed bug in entering filename with .. in it.
 27 Mar 81  BAM   V6.5    Fixed Close to do Trucate.
 26 Mar 81  BAM   V6.4    Added comments.
 19 Mar 81  BAM   V6.3    import PERQ_String not PERQ.String.
 17 Mar 81  BAM   V6.2    Added new procedure FSIsFSDev.
 10 Mar 81  BAM   V6.1    Changed FixFileName to create a full file spec;
                           removed self-init from FixFileName
  9 Mar 81  BAM   V6.0    changed syntax of directories
  5 Mar 81  BAM   V5.0    Removed many procedures into FileUtils; removed
                           Import of DiskIO from export; changed size of
                           FileName strings; improved Scan;

  3 Mar 81  BR and JPS    Improve setting of dates in FSEnter/FSClose/FSLookUp.
                  V4.2    Set FileType in FSEnter.
                          Make Id a Var parameter ro FSScan as it should be.

  1 Mar 81  BR    V4.1    Set Dates in FSEnter/FSClose.

 26 Feb 81  DAS and JPS   Added FSRename.  Exported FixFileName.
                  V4.0
--------------------------------------------------------------------}

{********************} Exports {********************}

imports FileDefs from FileDefs;

const
  FSVersion     = '7.3';    { File system version number }
  BlksPerFile   =#077777;   { Max blocks in each file }
  FirstBlk      =0;         { Block number of the first data block }
                            { in a file }
  LastBlk       =#077776;   { Block number of the last data block }
                            { in a file. }
  FIBlk         =-1;        { Block number of the File Information Block }
  BootLength    = 60 + 128; { Size of the bootstrap area on disk--the }
                            { first n blocks on the disk.  the microcode }
                            { boot area is 60 blocks, the Pascal boot  }
                            { area is 128 blocks (32K). }
  StartBlk      =BootLength;{ The block number of the FIBlk of the first}
                            { user file. }
  SysFile       = -1;       { File ID of the system area on disk. }
  SEARCHSIZELIST = 5;       { Max number of directories on search list. }
                                 
type
  DirBlk= Record                      { Record for reading disk blocks }
           Case Integer Of 
           2: (
                Buffer:Array[0..255] Of Integer
              );
           3: (
                ByteBuffer: Packed Array [0..511] of FSBit8
              )
           End;

  PDirBlk= ^DirBlk;
       
  FileID        = integer;
  BlkNumbers    = integer;
      
  SearchList    = array[1..SEARCHSIZELIST] of PathName;
  ptrSearchList = ^SearchList;
                      
var 
  FSDirPrefix:PathName;  {current default directory including device and part}
  FSSysSearchList: SearchList;

function FSLookUp(FileName:PathName;Var BlkInFile,BitsInLBlk: Integer): FileID;
                       {uses current system search list}

function FSLocalLookUp(FileName:PathName; Var BlkInFile,BitsInLBlk: Integer):
            FileID;    {doesn't use any search lists}

function  FSSearch(var slist : SearchList; var FileName : PathName;
                   var BlkInFile, BitsInLBlk: integer) : FileID;
                       {uses specified search list instead of system one; is
                        var so no copying; changes FileName to be full filename
                        actually used}

function  FSEnter(FileName:PathName): FileID;
procedure FSClose(UserFile:FileID; Blks,Bits:Integer);
procedure FSBlkRead(UserFile:FileID; Block:BlkNumbers; Buff:PDirBlk);
procedure FSBlkWrite(UserFile:FileID; Block:BlkNumbers; Buff:PDirBlk);
procedure FSInit;
procedure FSMount(disk : integer);
procedure FSDismount(disk : integer);

procedure FSSetPrefix(prefixname : PathName);  {FSSetPrefix just assigns the
                                                vble; use FileUtils.FSSetPath
                                                to do processing on new path}

procedure FSGetPrefix(var prefixname : PathName);
function  FileIDtoSegID(id : FileID) : SegID;
function  SegIDtoFileID(id : SegID) : FileID;
procedure FSSetupSystem(bootchar: integer);
procedure FixFilename(var filename : PathName; nulliserror : boolean);
Function FSIsFSDev(name: PathName; var devName: String): integer;

Exception FSNotFnd(name: PathName);
{--------------------------------------------------------------------
  Abstract: Raised if file looked up is not found.  If this exception is not
            handled by client, the lookup or search will return zero
  Parameters: name is the name not found
--------------------------------------------------------------------}

Exception FSBadName(name: PathName);
{--------------------------------------------------------------------
  Abstract: Raised if file entered is illegal because:
              1) the device or partition specified is not valid
              2) a directory name specified does not exist
              3) the length of the simpleName is > 25 characters
            If this exception is not handled by the client, the Enter will
            return zero 
  Parameters: name is the name that is illegal
--------------------------------------------------------------------}

Function FSInternalLookUp(FileName:PathName; Var BlkInFile,BitsInLBlk:Integer):
                FileID;

Exception FSDirClose;
{--------------------------------------------------------------------
  Abstract: Raised if attempt to FSClose a directory file.  This is usually
            a bad idea since directories are spare files with an invalid
            length field. 
  RESUME: Allowed.  Will close the file as if nothing had happened.
--------------------------------------------------------------------}

const
  FSDebug = false;

{********************} Private {********************}
