module SesameDefs;
Exports
imports AccentType from AccentType;
imports TimeDefs from TimeDefs;
const
Path_Name_Size =255;
Entry_Name_Size =80;
type
APath_Name =string[Path_Name_Size];
Wild_APath_Name =string[Path_Name_Size];
Entry_Name =string[Entry_Name_Size];
const
NFlag_Deleted =#000001;
NFlag_NoNormal =#000002;
NFlag_RESERVED =#177774;
type
Name_Flags =0 ..#3;
const
NStat_Deleted =#000001;
NStat_High =#000002;
NStat_Low =#000004;
NStat_RESERVED =#177770;
type
Name_Status =0 ..#7;
const
Entry_All =0;
Entry_File =1;
Entry_Directory =2;
Entry_Port =3;
type
Entry_RESERVED =4 ..#377;
Entry_UserDefined =#400 ..#77777;
type
Entry_Type =0 ..#77777;
type
Entry_Data =record case Entry_Type of
Entry_File :();
Entry_Directory :();
Entry_Port :(EDPort :Port );
#400 :(EDBytes :packed array [0..255]of bit8 );
#401 :(EDWords :array [0..127]of integer );
#402 :(EDLongs :array [0..63]of long );
#403 :(EDString:string[255]);
end;
Entry_List_Record =record
EntryName :Entry_Name;
EntryVersion :long;
EntryType :Entry_Type;
NameStatus :Name_Status;
end;
Entry_List_Array =array [0..0]of Entry_List_Record;
Entry_List =^Entry_List_Array;
const
Valid_Name_Chars =
'$-.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz';
type
Group_ID =long;
type
File_Data =pointer;
const
Print_Name_Size =80;
type
Print_Name =string[Print_Name_Size];
const
DForm_Unspecified =0;
DForm_8_Bit =8;
DForm_16_Bit =16;
DForm_32_Bit =32;
DForm_36_Bit =36;
DForm_CRLF_Text =#413;
DForm_LF_Text =#410;
DForm_Press =#1000;
type
Data_Format =long;
type
File_Header =packed record
FileSize :long;
DataFormat :long;
PrintName :Print_Name;
Author :Group_ID;
CreationDate :Internal_Time;
AccessID :Group_ID;
AccessDate :Internal_Time;
FHdr_RESERVED :array [56..64]of integer;
end;
const
Sesame_Error_Base =1200;
NameNotFound =Sesame_Error_Base +1;
DirectoryNotFound =Sesame_Error_Base +2;
DirectoryNotEmpty =Sesame_Error_Base +3;
BadName =Sesame_Error_Base +4;
InvalidVersion =Sesame_Error_Base +5;
InvalidDirectoryVersion
=Sesame_Error_Base +6;
BadWildName =Sesame_Error_Base +7;
NotAFile =Sesame_Error_Base +8;
NoAccess =Sesame_Error_Base +9;
NotSamePartition =Sesame_Error_Base +10;
ImproperEntryType =Sesame_Error_Base +11;
NotADirectory =Sesame_Error_Base +12;
Private
 { Stub created by MakeStub at15-Feb-84  17:28:31 }
begin
end.
