module AccentType;
Exports
const
PAGEBYTESIZE =512;
PAGEWORDSIZE =PAGEBYTESIZE div 2;
DISKBUFSIZE =PAGEBYTESIZE div 2;
PAGEBITS =8;
type
Bit1 =0..1;
Bit2 =0..3;
Bit3 =0..7;
Bit4 =0..15;
Bit5 =0..31;
Bit6 =0..63;
Bit7 =0..127;
Bit8 =0..255;
Bit9 =0..511;
Bit10 =0..1023;
Bit11 =0..2047;
Bit12 =0..4095;
Bit13 =0..8191;
Bit14 =0..16383;
Bit15 =0..32767;
Bit16 =integer;
pBit32 =^Bit32;
Bit32 =packed record
case integer of
1:(DblWord :array [0..1]of integer);
3:(Bit32Ptr:pBit32);
4:(AnyPtr :pointer);
5:(Byte :packed array [0..3]of Bit8);
6:(PageOffset :Bit8;
LswPage :Bit8;
MswPage :Bit16
);
7:(Lng :Long);
8:(Blk :integer;
Index :Bit12;
Imag :Bit4
);
13:(Field4 :Bit8;
Field3 :Bit8;
Field2 :Bit8;
Field1 :Bit7;
Field0 :Bit1);
14:(Word0 :Bit16;
Word1 :Bit16);
15:(Byte0 :Bit8;
Byte1 :Bit8;
Byte2 :Bit8;
Byte3 :Bit8 );
end;
Bit64 =record
lsw :long;
msw :long;
end;
SegID =long;
SpiceSegKind =(Temporary,Permanent,Bad,SegPhysical,Imaginary,Shadow);
VirtualAddress =long;
PhysicalAddress =long;
MicroSeconds =long;
DiskAddr =packed record
case integer of
1:(lng :long);
2:(byte :packed array [0..3]of Bit8)
end;
TrapCodes =
(
TrapInit,
TrapReadFault,
TrapWriteFault,
TrapSend,
TrapReceive,
TrapSetPortsWaiting,
TrapPortsWithMessages,
TrapDebugWrite,
TrapException,
TrapNothing,
TrapRectDrawLine,
TrapRectRasterOp,
TrapCharRead,
TrapFull,
TrapFlush,
TrapMoveWords,
TrapRectPutString,
TrapError,
TrapClockEnable,
TrapGPRead,
TrapGPWrite,
TrapSoftEnable,
TrapGetIOSleepID,
TrapRectColor,
TrapRectScroll,
TrapLockPorts,
TrapMessagesWaiting
);
const AccErr =100;
Dummy =AccErr+0;
Success =AccErr+1;
TimeOut =AccErr+2;
PortFull =AccErr+3;
WillReply =AccErr+4;
TooManyReplies =AccErr+5;
MemFault =AccErr+6;
NotAPort =AccErr+7;
BadRights =AccErr+8;
NoMorePorts =AccErr+9;
IllegalBacklog =AccErr+10;
NetFail =AccErr+11;
Intr =AccErr+12;
Other =AccErr+13;
NotPortReceiver =AccErr+14;
UnrecognizedMsgType =AccErr+15;
NotEnoughRoom =AccErr+16;
NotAnIPCCall =AccErr+17;
BadMsgType =AccErr+18;
BadIPCName =AccErr+19;
MsgTooBig =AccErr+20;
NotYourChild =AccErr+21;
BadMsg =AccErr+22;
OutOfIPCSpace =AccErr+23;
Failure =AccErr+24;
MapFull =AccErr+25;
WriteFault =AccErr+26;
BadKernelMsg =AccErr+27;
NotCurrentProcess =AccErr+28;
CantFork =AccErr+29;
BadPriority =AccErr+30;
BadTrap =AccErr+31;
DiskErr =AccErr+32;
BadSegType =AccErr+33;
BadSegment =AccErr+34;
IsParent =AccErr+35;
IsChild =AccErr+36;
NoAvailablePages =AccErr+37;
FiveDeep =AccErr+38;
BadVPTable =AccErr+39;
VPExclusionFailure =AccErr+40;
MicroFailure =AccErr+41;
EStackTooDeep =AccErr+42;
MsgInterrupt =AccErr+43;
UncaughtException =AccErr+44;
BreakPointTrap =AccErr+45;
ASTInconsistency =AccErr+46;
InactiveSegment =AccErr+47;
SegmentAlreadyExists =AccErr+48;
OutOfImagSegments =AccErr+49;
NotASystemAddress =AccErr+50;
NotAUserAddress =AccErr+51;
BadCreateMask =AccErr+52;
BadRectangle =AccErr+53;
OutOfRectangleBounds =AccErr+54;
IllegalScanWidth =AccErr+55;
CoveredRectangle =AccErr+56;
BusyRectangle =AccErr+57;
NotAFont =AccErr+58;
PartitionFull =AccErr+59;
type GeneralReturn =integer;
const
BADMSGID =1;
WRONGARGS =2;
BADREPLY =3;
NOREPLY =4;
UNSPECEXCEPTION =5;
const
MAXPORTS =256;
DEFAULTBACKLOG =0;
MAXBACKLOG =63;
type
BackLogValue =0..MAXBACKLOG;
const
NORMALMSG =0;
EMERGENCYMSG =1;
NUMMSGTYPES =2;
const
WAIT =0;
DONTWAIT =1;
REPLY =2;
type
SendOption =WAIT..REPLY;
const
PREVIEW =0;
RECEIVEIT =1;
RECEIVEWAIT =2;
type
ReceiveOption =PREVIEW..RECEIVEWAIT;
const
DEFAULTPTS =0;
ALLPTS =1;
LOCALPT =2;
type
PortOption =DEFAULTPTS..LOCALPT;
const
NULLPORT =0;
KERNELPORT =1;
DATAPORT =2;
FIRSTNONRESERVEDPORT =3;
ALLPORTS =-1;
const
EXPLICITDEALLOC =0;
PROCESSDEATH =1;
NETWORKTROUBLE =2;
type
PortDeath =EXPLICITDEALLOC..NETWORKTROUBLE;
const
READONLY =0;
READWRITE =1;
type
MemProtection =READONLY..READWRITE;
const
TYPEUNSTRUCTURED =0;
TYPEBIT =0;
TYPEBOOLEAN =0;
TYPEINT16 =1;
TYPEINT32 =2;
TYPEPTOWNERSHIP =3;
TYPEPTRECEIVE =4;
TYPEPTALL =5;
TYPEPT =6;
TYPECHAR =8;
TYPEINT8 =9;
TYPEBYTE =9;
TYPEREAL =10;
TYPEPSTAT =11;
TYPESTRING =12;
TYPESEGID =13;
TYPEPAGE =14;
const
M_PORTDELETED =#100 +1;
M_MSGACCEPTED =#100 +2;
M_OWNERSHIPRIGHTS =#100 +3;
M_RECEIVERIGHTS =#100 +4;
M_GENERALKERNELREPLY =#100 +6;
M_KERNELMSGERROR =#100 +7;
M_PARENTFORKREPLY =#100 +#10;
M_CHILDFORKREPLY =#100 +#11;
M_DEBUGMSG =#100 +#12;
type
TypeType =packed record
case integer of
1:(TypeName :Bit8;
TypeSizeInBits :Bit8;
NumObjects :Bit12;
InLine :boolean;
LongForm :boolean;
Deallocate :boolean
);
2:(LongInteger :long)
end;
Port =long;
ptrPort =^Port;
ptrMsg =^Msg;
Msg =record
SimpleMsg :boolean;
MsgSize :long;
MsgType :long;
LocalPort :Port;
RemotePort :Port;
ID :long;
end;
ptrPortBitArray =^PortBitArray;
PortBitArray =packed array [0..MAXPORTS-1]of boolean;
ptrPortArray =^PortArray;
ptrAllPortArray =^PortArray;
PortArray =array [0..MAXPORTS-1]of Port;
ptrLPortArray =^LPortArray;
LPortArray =array [stretch(0)..stretch(#77777)]of Port;
GPBuffer =packed array [1..8]of Bit8;
ptrArguments =^Arguments;
Arguments =record
ReturnValue :GeneralReturn;
case integer of
1:(
Msg :ptrMsg;
MaxWait :long;
Option :integer;
PtOption :integer
);
2:(
Ports :ptrPortBitArray;
MsgType :long
);
3:(
SrcAddr :VirtualAddress;
DstAddr :VirtualAddress;
NumWords :long;
Delete :boolean;
Create :boolean;
Mask :long;
DontShare :boolean
);
4:(NumCmds :integer;
GPIBBuffer :GPBuffer
);
5:(NormalOrEmergency :boolean;
EnableOrDisable :boolean
);
6:
(SleepID :long
);
7:(
RectPort :Port;
X1 :integer;
Y1 :integer;
X2 :integer;
Y2 :integer;
Kind :integer
);
8:(
SrcRect :Port;
DstRect :Port;
Action :integer;
Height :integer;
Width :integer;
SrcX :integer;
SrcY :integer;
DstX :integer;
DstY :integer
);
9:(
Rect :Port;
FontRect :Port;
Funct :integer;
FirstX :integer;
FirstY :integer;
MaxX :integer;
FirstChar :integer;
MaxChar :integer;
StrPtr :Pointer;
Rslt :integer
);
10:(
LockDoLock :boolean;
LockPortPtr :ptrLPortArray;
LockPortCnt :long
);
11:(
MsgWType :long;
MsgWPortPtr :ptrLPortArray;
MsgWPortCnt :long
)
end;
const
MAXPROCS =63;
NUMPRIORITIES =16;
NUMSLEEPQS =32;
NUMQUEUES =NUMSLEEPQS +NUMPRIORITIES +5;
type
ProcState =(Supervisor,
Privileged,
BadSupervisor,
User);
ProcID =integer;
PriorID =0..NUMPRIORITIES-1;
QID =0..NUMQUEUES;
ptrInteger =^integer;
ptrBoolean =^boolean;
PStatus =record
State :ProcState;
Priority :PriorID;
MsgPending :boolean;
EMsgPending :boolean;
MsgEnable :boolean;
EMsgEnable :boolean;
LimitSet :boolean;
SVStkInCore :boolean;
QueueID :QID;
SleepID :ptrInteger;
RunTime :long;
LimitTime :long
end;
const
MAXPARTCHARS =8;
MAXDPCHARS =25;
MAXPARTITIONS =10;
MAXDEVICES =5;
type
PartString =string[MAXPARTCHARS];
DevPartString =string[MAXDPCHARS];
PartitionType =(Root,UnUsed,Segment,PLX );
PartInfo =record
PartHeadFree :DiskAddr;
PartTailFree :DiskAddr;
PartInfoBlk :DiskAddr;
PartRootDir :SegID;
PartNumOps :integer;
PartNumFree :long;
PartInUse :boolean;
PartMounted :boolean;
PartDevice :integer;
PartStart :DiskAddr;
PartEnd :DiskAddr;
PartKind :PartitionType;
PartName :PartString;
PartExUse :boolean;
Unused :long
end;
PartList =array[1..MAXPARTITIONS]of PartInfo;
ptrPartList =^PartList;
Private
 { Stub created by MakeStub at15-Feb-84  17:22:11 }
begin
end.
