module Arrows;

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This module implements the four raster images for arrows pointing
 *      Up, Down, Left and Right.  It is used in conjunction with the Pane
 *      Manager.  It must be initialized with a call to InitArrows before
 *      any of the other procedures are called.
 *
 *    -----------
 *    CHANGE LOG:
 *      Aug 13 1984     Lee Iverson     ** Created **
 *
 ***********************************************************************)

exports

imports SapphDefs from SapphDefs;
imports Panes from Panes;

Const
  (* Up arrow definition *)
  Up_Width  = 13;
  Up_Height = 11;
  
  (* Down arrow definition *)
  Down_Width  = 13;
  Down_Height = 11;
  
  (* Left arrow definition *)
  Left_Width  = 11;
  Left_Height = 13;
  
  (* Right arrow definition *)
  Right_Width  = 11;
  Right_Height = 13;

procedure
  InitArrows;

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      Initializes the Arrows module by creating the raster images for
 *      the four arrows.  This procedure must be called before any of
 *      the other procedures defined here are called.
 *
 ***********************************************************************)

procedure
  ArrowUp(
    pn: Pane;
    x: Integer;
    y: Integer;
    func: RopFunct
  );

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      Draws an arrow pointing up at the given location in the pane.
 *
 ***********************************************************************)

procedure
  ArrowDown(
    pn: Pane;
    x: Integer;
    y: Integer;
    func: RopFunct
  );

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      Draws an arrow pointing down at the given location in the pane.
 *
 ***********************************************************************)

procedure
  ArrowLeft(
    pn: Pane;
    x: Integer;
    y: Integer;
    func: RopFunct
  );

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      Draws an arrow pointing left at the given location in the pane.
 *
 ***********************************************************************)

procedure
  ArrowRight(
    pn: Pane;
    x: Integer;
    y: Integer;
    func: RopFunct
  );

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      Draws an arrow pointing right at the given location in the pane.
 *
 ***********************************************************************)

private

{$include Arrows.impl}.

