Program Pepper;

{****************************************************************
{
{ Pepper:  Spice Interim Editor
{ Richard Cohn
{ April 1, 1981
{
{ Copyright (C) Carnegie-Mellon University, 1981.
{ Copyright (C) Three Rivers Computer Corporation, 1980.
{
{
{ Modification history
{ ------------ -------
{
{ V0.1-0.9   3RCC       Original editor and improvements.
{
{ V1.0  1  Apr 81       First version of new editor.
{
{ V1.1  12 Jul 81       Bug fixes and some new commands.
{                       Runs on D systems only.
{
{ V1.2  15 Aug 81       Fixed copy between windows bug.
{                       Changed autosave parameters.
{                       Fixed bug in using up and down page with large
{                       repeat counts.
{                       Expanded some calls in FixUp for efficiency's sake
{                           (no noticeable improvement).
{                       Fixed bugs in SelectAll and UnSelect.
{                       Added prompt when copying text.
{                       Fixed bug in MoveBottomWindow.
{                       Fixed bug in CreateEmptyPage.
{                       Fixed insertion beyond end-of-file.
{                       Rearranged modules for more efficient swapping.
{                       Added open-space-and-indent command.
{                       Changed method of noticing modified buffer.
{                       Added insert-selection and quote-character to
{                           search/replace strings.  Display cursor when
{                           getting string.
{                       Added repeat count for delete-end-of-line.
{                       Removed exit prompt if buffer hasn't been modified.
{                       Fixed up case of two windows using same file and
{                           writing file though continuing to edit.
{                       Created free chunk list and added check on out of
{                           space for new chunks.
{                       Added time in window title.
{                       Fixed bug in replace at beginning of file.
{
{ V1.3  29 Aug 81       Turned off tablet when turning off pointer.
{                       Fixed bug in BufferModified.
{                       Made save-file write out filename itself.
{                       Fixed bug in drawing char's with high-order bit set.
{                       Fixed bug in ExpandWindow when no neighbors exist.
{
{ V1.4   6 Oct 81       Added transcripting.
{                       Prompt before reading help file.
{                       Added command-line debug switches.
{                       Allow abort of read file.
{                       Fixed bug in InsertWhiteSpace--wiping selection.
{
{ V1.5  14 Nov 81       Fixed bug in CompressWindow when only one window.
{                       Fixed transcript bug on repeat search.
{                       Moved flush to before read next command.
{                       Initialized Prev and Next in SetUpWindow.
{                       Added transcript commands to help file.
{                       ImmedQuit flushes transcript.
{                       Changes made to Draw microcode calls.
{                       New prompt on file modified.
{                       Ctrl-j and ctrl-m do the right thing in Emacs version.
{
{ V1.6  26 May 81       Changes made for D165 and megabyte memory:  new
{                           draw microcode, help exception, MaxMemPage
{                           changed to 127 from 15.
{                       Don't write out transcript on del-prev-char.
{
{ V1.7  11 Jan 83       Changed bindings for three-button mouse.
{                       Added '*' for modified files (DrawRegions).
{                       Fixed Unselect bug in DoDelete.
{                       Added new commands:  increment and decrement
{                           numbers, justify selection and paragraph,
{                           delete other windows, next and previous window,
{                           center line and selection.
{                       Permit abort of startup.
{                       Status ==> if DEBUG2 then Status.
{                       Added macros.
{                       Don't get rid of kill buffer when window deleted.
{                       Changed debug flags into an array.
{                       Up and down page do same number of lines.
{
{ V1.8  23 Feb 83       Small change to grow window.
{                       Fix in MergeWindow.  Repaired bug when next and
{                           prev win pts were made circular.
{                       Specified full path name to help.
{                       Up and down page keep cursor at same position.
{                       Merged edwindow into edscreen.
{                       Added default margins.
{                       Initialized all positions to prevent occasional
{                           nil pointer startup problem.
{                       Changed title to include current path.
{                       Specified help file as ">helpfile" to speed up search.
{                       Added setpath, diff, directory, and save modified
{                           files commands.
{                       Converted filename to FSExtSearch.
{                       Converted Muldiv to use longs.
{                       Changed Warn to Error during replay.
{
{ V2.0  25 Jan 83       DAS Fixed for F.2  Added ".Prose" as ext.
{
{ V2.1  27 Jan 83       DAS  Put in SetRealRelTablet(False);
{
{ V2.3  21 Mar 83       RSB Changed M in thumbbar to a vertical line
{                           Removed tablet off/on in Draw
{
{ V3.0  23 May 83       RSB Merged 3RCC's V2.3 into Cohn's V1.8
{                           Changed Directory to give one column.
{                           Made word-wrap use the right margin setting.
{                           JPS fixed quoted char bug in replay
{                           Changed Mark in thumbBar to vertical line.
{                           Added IndentBlock and UndentBlock
{
{ V3.1   6 Apr 83       RSB Made Keyboard Macro abort on warn or error
{
{****************************************************************}


imports RegionEditor from RegionEdit;
imports Canvas from EdCanvas;
imports EditSetUp from EdInit;
imports TextUtilities from EdText;
imports ScreenUtilities from EdScreen;
imports BufferUtilities from EdBuffer;
imports ReplayUtilities from EdReplay;
imports DirMod from EdDirect;
imports IO_Unit from IO_Unit;  { for CtrlSPending }
imports Perq_String from Perq_String;
imports FileUtils from FileUtils;
imports Screen from Screen;
imports CmdParse from CmdParse;
imports System from System;

const
    PepTitle = '    Pepper V3.1-3RCC    ';
    lenPepTitle = 24;  { Length (PepTitle); }
    maxPathLength = lenEdTitle - lenPepTitle;
    blank40 = '                                        ';

var 
    TextDoc:  EditDoc;
    EditW:  pWindow;
    PromptW:  pWindow;
    Message:  PString;
    Success:  boolean;
    Ignore:  string;
    xOrigin, yOrigin:  integer;
    Width, Height:  integer;
    HasTitle:  boolean;
    i:  integer;
    DoReplay:  boolean;
    Word:      string;
    D:  array [1..9] of boolean;


{*********************************************************************}

procedure GetHelp;

var
    OldWin:  pTextWindow;

{ Create a window to read in help file.  If current window is too small,
{ must enlarge it before creating a new one.  }

begin
OffPointer;
OldWin := CurWin;
ChangeTextWindow (PromptWindow);
Prompt ('Read help file? [Yes]');
repeat LookForCommand (CanvDflt)
until (NewEvent.Cmd <> NullCmd) and (NewEvent.Cmd <> HelpCmd);
if Replay = NotReplaying then
    SendKey (NewEvent);
ChangeTextWindow (OldWin);
OnPointer;
if NewEvent.Ch in ['n', 'N'] then
    begin
    Warn ('Help aborted');
    exit (GetHelp)
    end;
Prompt ('Reading help file...');
NeedPrompt := true;
ImmedPrompt := true;
if CurWin^.Bound^.yMax - CurWin^.Bound^.yMin <= 2 * MinWindowHeight then
    begin
    RepeatCount := 4;
    ExpandWindow
    end;
MakeNewWindow (HelpFile);
if Pos (CurWin^.FullName, HelpFile) = 0 then
    Warn ('Window too small to supply help--sorry!')
end;


{****************************************************************}

function ValidDirectory (var dir:  PathName):  boolean;

{ Return true if dir is a legal directory name.  If so, append the '>'
{ if it is needed.  }

var
    nBlocks, nBits:  integer;

begin { ValidDirectory }
FSRemoveDots (dir);
if RevPosC (dir, '>') <> Length (dir) then
    AppendChar (dir, '>');
ValidDirectory := FSLocalLookup (dir, nBlocks, nBits) <> 0;
end; { ValidDirectory }

{****************************************************************}

procedure SetNewPath (newPath: PathName);

{ If newPath is '' then prompt for a new pathname.  If the path is legal
{ then change to that path.  Change edTitle appropriately.  }

const
    maxPathLength = lenEdTitle - lenPepTitle;
    blank40 = '                                        ';

var
    ov:  integer;  { path length overflow }

begin  { SetNewPath }
if newPath = '' then
    newPath := GetAnswer ('New path:  ');
needPrompt := true;
immedPrompt := true;
if newPath = '' then
    exit (SetNewPath);

{ see if new path is legal }
if ValidDirectory (newPath) then
    FSSetPrefix (newPath)
else
    begin
    Warn ('No such directory');
    exit (SetNewPath);
    end;

{ change title }
ov := Length (newPath) - maxPathLength;
if ov > 0 then
    begin
    Delete (newPath, 1, ov + 3);
    newPath := Concat ('...', newPath);
    end
else if ov < 0 then
    begin
    newPath := Concat (newPath, blank40);
    Adjust (newPath, maxPathLength);
    end;
edTitle := Concat (newPath, pepTitle);
end;  { SetNewPath }


{****************************************************************}

procedure CompareFiles;

{ Compare the file in the current window with the file containing
{ the selection.  The source for the comparison is the selection
{ and the current file following the cursor.  If a difference in
{ files is found then the cursor and start selection are moved to
{ that difference.  If no difference is found, neither is changed.  }

var
    realCurWin:  pTextWindow;

begin  { CompareFiles }
if (selectWindow = curWin) or (selectWindow = nil) then
    begin
    Warn ('No selection exists in another window');
    exit (CompareFiles);
    end;

Prompt ('Comparing files ...');
realCurWin := curWin;
Attach (cursor1, GetPosition (curWin^.curLine, curWin^.curCol), readCursor);
Attach (cursor2, bufary [selectB].first, readCursor);
while (cursor1.ch = cursor2.ch)
    and LT (cursor2.pos, bufary [selectB].last)
    and not EOT (cursor1.pos) do
    begin
    Add1C (cursor1);
    Add1C (cursor2);
    end;

if (cursor1.ch = cursor2.ch) and EQ (cursor2.pos, bufary [selectB].last) then
    Warn ('No differences found!')
else
    begin
    Show (cursor1.pos, 0, curWin^.lastLine);
    ChangeTextWindow (selectWindow);
    if LT (bufary [selectB].first, cursor2.pos) then
        Underline (bufary [selectB].first, Add (cursor2.pos, -1), erase);
    bufary [selectB].first := cursor2.pos;
    DrawLn (selectB);
    Show (cursor2.pos, 0, curWin^.lastLine);
    ChangeTextWindow (realCurWin);
    Warn ('Difference found');
    end;

Detach (cursor1);
Detach (cursor2);
immedPrompt := false;
needPrompt := true;
end;  { CompareFiles }


{****************************************************************}

procedure PrintDirectory;

{ Run the directory program to get a file containing the directory
{ contents.  Read in the file as an ordinary file.  }

var
    dir:  PathName;

begin  { PrintDirectory }
if replay = notReplaying then
    dir := GetAnswer ('Print directory (<RETURN> aborts):  ');
if replay <> notReplaying then
    if GetTrnByte = INS then
        begin
        MakeNewWindow (dirFileName);
        curWin^.name := dirFileName;
        RefreshName;
        immedPrompt := true;
        end
    else
        Warn ('Could not print directory')
else if dir <> '' then
    begin
    FileRename (dirFileName);
    Prompt (Concat (Concat ('Listing files matching ', dir), ' ...'));
    if Direct (dir, dirFileName) then
        begin
        SendTrnByte (INS);
        MakeNewWindow (dirFileName);
        curWin^.name := dir;
        RefreshName;
        immedPrompt := true;
        end
    else
        begin
        Warn ('Could not print directory');
        SendTrnByte (DEL);
        end;
    end
else
    begin
    immedPrompt := true;
    SendTrnByte (DEL);
    end;
end;  { PrintDirectory }


{****************************************************************}

procedure SaveModifiedFiles;

{ Write out all files that have been modified.  }

var
    w:  Windex;
    oldWin:  pTextWindow;

begin  { SaveModifiedFiles }
oldWin := CurWin;
for w := MinWindex to MaxWindex do
    if Winary [w] <> nil then
        begin
        ChangeTextWindow (Winary[w]);
        if BufferModified then
            DoSaveFile;
        end; { if Winary [w] <> nil }
ChangeTextWindow (oldWin);
end;  { SaveModifiedFiles }


{*********************************************************************}

procedure EditQuit;

 var w:  integer;
     ExitWin:  boolean;
     
begin { EditQuit }
OffPointer;
ExitEdit := true;
for w := MinWindex to MaxWindex do
    if Winary [w] <> nil then
        begin
        ChangeTextWindow (Winary[w]);
        if DEBUG [2] then
            Status (Concat ('EditQuit:  FullName = ', CurWin^.FullName));
        QuitWindow (false, ExitWin);
        ExitEdit := ExitWin and ExitEdit;
        end; { if Winary [w] <> nil }
{*** Close(SwapFile,Purge) ***}
end; { EditQuit }


{*********************************************************************}

procedure QuitOtherWindows;

{ Exit all windows but the current one.  }

var w:  integer;
    ExitWin:  boolean;
    oldWin:  pTextWindow;
     
begin { QuitOtherWindows }
OffPointer;
oldWin := curWin;
for w := MinWindex to MaxWindex do
    if (Winary [w] <> oldWin) and (Winary [w] <> nil) then
        begin
        ChangeTextWindow (Winary[w]);
        if DEBUG [2] then
            Status(Concat('QuitOtherWindows:  FullName = ', CurWin^.FullName));
        QuitWindow (false, ExitWin);
        end; { if }
ChangeTextWindow (oldWin);
OnPointer;
ImmedPrompt := true;
NeedPrompt := true
end; { QuitOtherWindows }


{********************************************************************}

procedure ImmedQuit;

var Modified:   boolean;
    w:          integer;
    k:          KeyEvent;
    OldWin:     pTextWindow;

label 1;
    
begin
OffPointer;
ExitEdit := true;
Modified := false;
OldWin := CurWin;
for w := MinWindex to MaxWindex do
    if Winary [w] <> nil then
        begin
        ChangeTextWindow (Winary [w]);
        if BufferModified then
            begin
            Prompt
              ('File has been modified--are you sure you want to exit? [Yes]');
            repeat k := GetKey (inputQueue);
            until k.Cmd <> NullCmd;
            ExitEdit := k.Ch in ['y', 'Y', CR];
            goto 1;
            end;
        end;
1:
if ExitEdit then
    begin
    FlushTranscript;
    write (FF);
    exit (Pepper)
    end;
ChangeTextWindow (OldWin);
Prompt ('Exit aborted');
OnPointer;
ImmedPrompt := true;
NeedPrompt := true
end;  { ImmedQuit }


{*****************************************************************}

handler CtlCAbort;
begin
CtrlCPending := false
end;


{*****************************************************************}

handler CtlC;
begin
CtrlCPending := false
end;


{********************************************************************}

handler CtlShftC;
begin
CtrlCPending := false;
repeat LookForCommand (CanvKeybd);
until NewEvent.Cmd = NullCmd;
ImmedQuit
end;


{********************************************************************}

handler HelpKey (var retStr: Sys9s);
begin
{$R-}
retStr[0] := chr(1);
{$R=}
retStr[1] := HELP;
end;


{********************************************************************}

begin { main program }
IOSetRealRelTablet(false);
CtrlSPending := false;
write (FF);
EdWin := 0;
ChangeWindow (EdWin);
RefreshWindow (EdWin);
ChangeTitle (PepTitle);
GetWindowParms (EdWin, xOrigin, yOrigin, Width, Height, HasTitle);
with TextDoc do
    begin
    IsFile := true;
    FirstBuf := nil;
    RemDelimiters (UsrCmdLine, ' ', Ignore);
    GetSymbol (UsrCmdLine, Ignore, ' /', Ignore);
    RemDelimiters (UsrCmdLine, ' ', Ignore);
    GetSymbol (UsrCmdLine, Name, ' /', Ignore)
    end;
new (EditW);
with EditW^ do
    begin
    xMin := xOrigin;
    yMin := yOrigin + MaxPromptHeight;
    xMax := xOrigin + Width;
    yMax := yOrigin + Height
    end;
new (PromptW);
with PromptW^ do
    begin
    xMin := xOrigin;
    yMin := yOrigin;
    xMax := xOrigin + Width;
    yMax := yOrigin + MaxPromptHeight
    end;
DoReplay := false;
for i := 1 to 9 do
    D [i] := false;
RemDelimiters (UsrCmdLine, ' /', Ignore);
CnvUpper (UsrCmdLine);
while UsrCmdLine <> '' do
    begin
    GetSymbol (UsrCmdLine, Word, ' /', Ignore);
    RemDelimiters(UsrCmdLine,' /', Ignore);
    if (Length (Word) = 1) and (Word [1] in ['1'..'9']) then
        D [ord (Word [1]) - ord ('0')] := true
    else if Pos ('REPLAY', Word) = 1 then
        DoReplay := true
    else
        begin
        Write ('** Unknown parameter: ', Word, ', type return to continue');
        Readln
        end
    end;
if not EditInit (TextDoc, EditW, PromptW, true, true, true, false,
    DoReplay, PepTitle) then
    begin
    write (FF);
    exit (Pepper);
    end;

{ add path to title }
SetNewPath ('.');
for i := 1 to 9 do
    DEBUG [i] := D [i];
onPointer;
Winary [MinWindex] := CurWin;
Winary [MaxWindex + 1] := PromptWindow;
for i := MinWindex + 1 to MaxWindex do
    Winary [i] := nil;
while not ExitEdit do
    begin
    EditRegion;
    ExitEdit := false;
    NewEvent := GetKey (inputQueue);  { get the last returned event }
    case NewEvent.cmd of
      QHelp, HelpCmd:  GetHelp;
      MakeWindow:  MakeNewWindow ('');
      KillWindow:  DestroyWindow;
      ReplWindow:  ReplaceWindow ('');
      (MinWindex + ord('0'))..(MaxWindex + ord('0')):
        ChangeToWindow (NewEvent.Cmd - ord ('0'));
      NextWindow:  ChangeTextWindow (curWin^.next);
      PrevWindow:  ChangeTextWindow (curWin^.prev);
      GrowWindow:  ExpandWindow;
      ShrinkWindow:  CompressWindow;
      RefrScreen:  RefreshScreen (EdWin, EdTitle);
      SaveFile:    DoSaveFile;
      BackFile:
        begin
        if Replay = NotReplaying then
            begin
            CurWin^.nChanges := 0;
            WriteFile (Concat (CurWin^.FullName, '.Pepper'), Message);
            NeedPrompt := true;
            ImmedPrompt := false;
            if Message <> '' then
                Error (Message)
            end
        else
            Error ('Replaying--backup file not written')
        end; { BackFile }
      WritFile:    DoWriteFile;
      ExitCmd:     EditQuit;
      OneWindow:   QuitOtherWindows;
      QuitCmd:     ImmedQuit;
      DiffFiles:   CompareFiles;
      ChangePath:  SetNewPath ('');
      PrintDir:    PrintDirectory;
      SaveModFiles:  SaveModifiedFiles;
      otherwise:   Warn ('Illegal Command')
    end { case }
    end; { while }
write (FF)
end.
