!
!
!
!     This file contains the necessary instructions on how to update
!     an existing D.6 system to a D.61 system containing the micro-code
!     fix for real numbers and bring up the new network operating system.
!     This code will rebuild the current "a" boot with a new network 
!     operating system.
!     Be aware that if you have modified the
!     D.6 system, you will need to take special care when doing the
!     "makeboot" involved in this procedure.  (For more detail see
!     "How to Make a New System" in the PERQ Software Reference
!     Manual.
!      
!     Copyright (C) Three Rivers Computer Corporation,  1982
!
!---------------------------------------------------------------------------
!----------------------------------------------------------------------------
!
pause  Type <ctrl><shift>C to exit,  <return> to continue.


path Sys:Boot> 

!
! *** It is ok if this MakeDir gives an error.
!

makedir OldNet

!
! copy all files that we are going to change.  Just in case.
!

copy Ether10IO.Seg          OldNet>Ether10IO.Seg/NoAsk/NoCon
copy Ether10.Bin            OldNet>Ether10.Bin/NoAsk/NoCon
copy TestEther.Seg          OldNet>TestEther.Seg/NoAsk/NoCon
copy Load_Display.Seg       OldNet>Load_Display.Seg/NoAsk/NoCon
copy Etherhelp.seg          OldNet>EtherHelp.Seg/NoAsk/NoCon
copy FTP.Seg                OldNet>FTP.Seg/NoAsk/NoCon
Copy FTPUser.Seg            OldNet>FTPUser.Seg/NoAsk/NoCon
Copy FTPUtils.Seg           OldNet>FTPUtils.Seg/NoAsk/NoCon
Copy Ethernet.names         OldNet>Ethernet.Names/NoAsk/NoCon
Copy Perq.Bin               OldNet>Perq.Bin/NoAsk/NoCon
Copy Perq.Qcode.7           OldNet>Perq.Qcode.7/NoAsk/NoCon
!
! get the new files from the floppy.
!

floppy get FlpGetNet.Cmd
floppy @FlpGetNet.Cmd

!
!
!Prepare to make a new system:
!
!
!If you want to quit this command file because you have modified your
!system (as mentioned in the heading), type ^Shift-C
pause
link system ~ system.61 /system
link login ~ login.61
link shell ~ shell.61
link link ~ link.61
copy system.6.config ~ system.61.config
!
! Now write the boot file.
! We will overwrite the current "a" boot.
!
! **Note: The first question is:              Root file name
!         Respond with:                       system.61
!         The second question is:             Configuration file name [...]
!         Respond with:                       Carriage return for the default
!         The third question is:              Which character to boot from?
!         Respond with:                       a
!
! To the question:
! Use standard microcode:   respond with a carriage return UNLESS
!                           you have a MakeBoot before version D.6. If 
!                           you do it will not load Ether10.Bin. 
!                           If this is the case when MakeBoot asks
!                           for Microcode file type Ether10<cr>
!
! Respond to all remaining questions by typing a carriage return for the
! defaults.
!
!
pause

Scr 3

MakeBoot


!
! Change the name of this machine to be the name that you wish it to have.
! Replace the current line with the new name.
!
pause

Edi Ethernet.Names

!
! The new network operating system is now built on the disk.
! Please reboot.
!
!
! Boot the a-boot, path to the boot partition, and 
!        type "@linkall".
!
! Type "@NETLINK.CMD" to link
! TestEther
! FTP
! NetStatus
! NetReset
!

pause

!
!When successful, you may wish to delete the files in the OldNet
!directory and delete the OldNet directory itself.




Bye
