module Clock;
{-----------------------------------------------------------------------------
{
{       Clock - Perq clock routines.
{       J. P. Strait       1 Feb 81.
{       Copyright (C) Three Rivers Computer Corporation, 1981.
{
{ Abstract:
{       Clock implements the Perq human-time clock.  Times are represented
{       internally by a TimeStamp record which has numeric fields for Year,
{       Month, Day, Hour, Minute, and Second.  Times may also be expressed
{       by a string of the form YY MMM DD HH:MM:SS where MMM is a three (or
{       more) letter month name and HH:MM:SS is time of day on a 24 hour
{       clock.
{
{       The clock module exports routines for setting and reading the current
{       time as either a TimeStamp or a character string, and exports routines
{       for converting between TimeStamps and strings.
{       
{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------
{ Change Log:
{
{ V1.6  17 Dec 81 WJHansen
{    Set Past.Lower in SetTStamp
{
{ V1.5  12 May 81  Brad Myers.
{ If invalid time string then raise a signal.
{ }

{ V1.4  19 Mar 81  Brad Myers.
{ PERQ_String.
{ }

{ V1.3   2 Mar 81  John Strait.
{ Don't export IO from Clock and GetTimeStamp.
{ }

{ V1.2   2 Mar 81  John Strait.
{ Add title, copyright, and abstract.
{ Add version number.
{ Add retroactive change history.
{ }

{ V1.1  28 Feb 81  Brian Rosen.
{ Check for invalid month numbers in StampToString.
{ }

{ V1.0   1 Feb 81  John Strait.
{ Start file.
{ }
{-----------------------------------------------------------------------------}

exports


imports GetTimeStamp from GetTimeStamp;
     
     
const ClockVersion = '1.6';


type TimeString = String;


procedure SetTStamp( Stamp: TimeStamp );
procedure SetTString( String: TimeString);
procedure GetTString( var String: TimeString );
procedure StampToString( Stamp: TimeStamp; var String: TimeString );
procedure StringToStamp( String: TimeString; var Stamp: TimeStamp);

Exception BadTime;
{----------------------------------------------------
 Abstract: Raised when a string passed does not represent a valid time
----------------------------------------------------}

private
