using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace PERQDisk
{
    /// <summary>
    /// Represents a disk track, which contains one or more sectors.
    /// </summary>
    public class Track
    {
        public Track(int trackID, int sectors)
        {
            if (trackID < 0 || sectors < 1)
            {
                throw new ArgumentOutOfRangeException("Invalid Track specification");
            }

            _trackID = trackID;
            _sectors = sectors;

            _sectorList = new Sector[_sectors];

            CreateSectors();
        }

        public Sector GetSector(int sector)
        {
            if (sector < 0 || sector >= _sectors)
            {
                throw new ArgumentOutOfRangeException("sector");
            }

            return _sectorList[sector];
        }

        public void LoadSector(FileStream fs, int sector)
        {
            if (sector < 0 || sector >= _sectors)
            {
                throw new ArgumentOutOfRangeException("sector");
            }

            _sectorList[sector].Load(fs);
        }

        private void CreateSectors()
        {
            for (int i = 0; i < _sectors; i++)
            {
                _sectorList[i] = new Sector(i);
            }
        }

        private Sector[] _sectorList;
        private int _trackID;
        private int _sectors;
    }
}
