page
;----------------------------------------------------------------------
; Keyboard Tables
;----------------
; 	1) The following four tables are used by the keyboard routine
;	   to encode the scan codes into the correct values.
;	2) For most of the entries in this table the code generated by
;	   the key is shown. For those with the high-order bit (80H) set,
;	   the value represented in the lower 7 bits will be returned as
;	   a second character, following a null (00H) value.
;	3) Values marked with a plus-sign prior to a hex value represent
;	   shift and lock keys - these do not actually generate key codes,
;	   but rather are processed by the keyboard routine. In this case
;	   the value which follows the plus sign corresponds to the bit
;	   used by this key in the SHIFT_STATUS variable.
;	4) Some of the keys contain special values which are directly 
;	   converted into extended characters (this is done when the output 
;	   value must be greater than 7FH) - for these characters, the
;	   'EXT_FLAG' bit will be set in the 'KEY_TYPE' array.
;	5) Values with 'nul' represent invalid keyboard combinations.
;	   For these values, no keyboard code will be generated.
;

Key_Table equ this Byte
;----------------------
;	1) UnShifted Key Lookup Table
;
Public	Key_Table

	db	 nul  ;Keycode 0 not used			;Key Numbers
	db	 1Bh,  '1',  '2',  '3',  '4',  '5',  '6',  '7'	;1..8
	db	 '8',  '9',  '0',  '-',  '=',  08h,  09h,  'q'	;9..16
	db	 'w',  'e',  'r',  't',  'y',  'u',  'i',  'o'	;17..24
	db	 'p',  '[',  ']',  0Dh, +04h,  'a',  's',  'd'	;25..32
	db	 'f',  'g',  'h',  'j',  'k',  'l',  ';',  27h	;33..40
	db	 '`', +02h,  '\',  'z',  'x',  'c',  'v',  'b'	;41..48
	db	 'n',  'm',  ',',  '.',  '/', +01h,  '*', +08h	;49..56
	db	 ' ', +40h, 0BBh, 0BCh, 0BDh, 0BEh, 0BFh, 0C0h	;57..64
	db	0C1h, 0C2h, 0C3h, 0C4h, +20h, +10h, 0C7h, 0C8h	;65..72
	db	0C9h,  '-', 0CBh,  nul, 0CDh,  '+', 0CFh, 0D0h	;73..80
	db	0D1h, 080h, 0D3h,  0Dh				;81..84       
	page


Shift_Table equ this Byte
;------------------------
;	1) Shifted Key Lookup Table
;
Public	Shift_Table

	db	 nul						;Key Numbers  
	db	 1Bh,  '!',  '@',  '#',  '$',  '%',  '^',  '&'	;1..8         
	db	 '*',  '(',  ')',  '_',  '+',  08h,  8Fh,  'Q'  ;9..16        
	db	 'W',  'E',  'R',  'T',  'Y',  'U',  'I',  'O'  ;17..24       
	db	 'P',  '{',  '}',  0Dh, +04h,  'A',  'S',  'D'  ;25..32       
	db	 'F',  'G',  'H',  'J',  'K',  'L',  ':',  '"'  ;33..40       
	db	 '~', +02h,  '|',  'Z',  'X',  'C',  'V',  'B'  ;41..48       
	db	 'N',  'M',  '<',  '>',  '?', +01h, 0B7h, +08h  ;49..56       
	db	 ' ', +40h, 0D4h, 0D5h, 0D6h, 0D7h, 0D8h, 0D9h  ;57..64       
	db	0DAh, 0DBh, 0DCh, 0DDh, +20h, +10h,  '7',  '8'  ;65..72       
	db	 '9',  '-',  '4',  '5',  '6',  '+',  '1',  '2'  ;73..80       
	db	 '3',  '0',  '.',  0Dh                          ;81..84       
                                                                

Ctrl_Table equ this Byte
;-----------------------
;	1) Shifted Key Lookup Table
;
Public	Ctrl_Table

	db	 nul						;Key Numbers  
	db	 1Bh,  nul,  83h,  nul,  nul,  nul,  1Eh,  nul  ;1..8         
	db	 nul,  nul,  nul,  1Fh,  nul,  7Fh,  nul,  11h  ;9..16        
	db	 17h,  05h,  12h,  14h,  19h,  15h,  09h,  0Fh  ;17..24       
	db	 10h,  1Bh,  1Dh,  0Ah, +04h,  01h,  13h,  04h  ;25..32       
	db	 06h,  07h,  08h,  0Ah,  0Bh,  0Ch,  nul,  nul  ;33..40       
	db	 nul, +02h,  1Ch,  1Ah,  18h,  03h,  16h,  02h  ;41..48       
	db	 0Eh,  0Dh,  nul,  nul,  nul, +01h, 0F2h, +08h  ;49..56       
	db	 ' ',  nul, 0DEh, 0DFh, 0E0h, 0E1h, 0E2h, 0E3h  ;57..64       
	db	0E4h, 0E5h, 0E6h, 0E7h, +20h, 0C6h, 0F7h,  nul  ;65..72       
	db	 84h,  nul, 0F3h,  nul, 0F4h,  nul, 0F5h,  nul  ;73..80       
	db	0F6h,  nul,  nul,  0Ah                          ;81..84       


Alt_Table equ this Byte
;----------------------
;	1) Shifted Key Lookup Table
;
Public	Alt_Table

	db	 nul						;Key Numbers  
	db	 nul, 0F8h, 0F9h, 0FAh, 0FBh, 0FCh, 0FDh, 0FEh  ;1..8         
	db	0FFh,  80h,  81h,  82h,  83h,  7Fh,  nul,  90h  ;9..16        
	db	 91h,  92h,  93h,  94h,  95h,  96h,  97h,  98h  ;17..24       
	db	 99h,  nul,  nul,  0Ah, +04h,  9Eh,  9Fh, 0A0h  ;25..32       
	db	0A1h, 0A2h, 0A3h, 0A4h, 0A5h, 0A6h,  nul,  nul  ;33..40       
	db	 nul, +02h,  nul, 0ACh, 0ADh, 0AEh, 0AFh, 0B0h  ;41..48       
	db	0B1h, 0B2h,  nul,  nul,  nul, +01h,  nul, +08h  ;49..56       
	db	 ' ', +40h, 0E8h, 0E9h, 0EAh, 0EBh, 0ECh, 0EDh  ;57..64       
	db	0EEh, 0EFh, 0F0h, 0F1h, +20h, +10h,  07h,  08h  ;65..72       
	db	 09h,  nul,  04h,  05h,  06h,  nul,  01h,  02h  ;73..80       
	db	 03h, 0FFh,  nul,  nul                          ;81..84       

page
;----------------------------------------------------------------------
; Key Type Table
;---------------
;	The following table is used to determine how to process each
; key of the matrix.  Each entry represents a single key, and is bit-
; mapped as follows:
;
;	Bit 7: Extended ALT flag.  Key value in ALT table is
;	       contained in full 8 bits.
;	Bit 6: CTRL-override flag.  Used to flag special keys
;	       which change their usage in CTRL mode.
;	Bit 5: SHIFT-override flag.  Used to flag control keys
;	       which become 'normal' keys in shift mode.
;	Bit 4: PAD_TYPE.  Used to flag the keys in the
;	       numeric pad.
;	Bit 3: LOCK_TYPE.  Indicates that the key is a locking
;	       key, as in CAPS LOCK, NUM LOCK, INSERT etc.
;	Bit 2: CTRL_TYPE.  Indicates that a key is a 'control'
;	       key, as in SHIFT, CTRL, or ALT.
;	Bit 1: ALPHA_TYPE.  Set for letters (A-Z).
;	Bit 0: DIGIT_TYPE.  Used to flag digits.
;

Key_Type equ this Byte
;---------------------
;
Public	Key_Type

	db	 00h						;Key Numbers  
	db	 00h,  00h,  00h,  00h,  00h,  00h,  00h,  00h  ;1..8         
	db	 00h,  80h,  80h,  80h,  80h,  00h,  00h,  02h  ;9..16        
	db	 02h,  02h,  02h,  02h,  02h,  02h,  02h,  02h  ;17..24       
	db	 02h,  00h,  00h,  00h,  04h,  02h,  02h,  02h  ;25..32       
	db	 02h,  02h,  02h,  02h,  02h,  02h,  00h,  00h  ;33..40       
	db	 00h,  04h,  00h,  02h,  02h,  02h,  02h,  02h  ;41..48       
	db	 02h,  02h,  00h,  00h,  00h,  04h,  00h,  04h  ;49..56       
	db	 00h,  48h,  00h,  00h,  00h,  00h,  00h,  00h  ;57..64       
	db	 00h,  00h,  00h,  00h,  48h,  48h,  11h,  11h  ;65..72       
	db	 11h,  10h,  11h,  11h,  11h,  10h,  11h,  11h  ;73..80       
	db	 11h,  39h,  10h,  10h                          ;81..84       
