Page	60,132
Title	-Console Output Routines
;
;
;	Copyright (c) 1983
;	Zenith Data Systems
;	St. Joseph, Michigan
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 23_May_85
;
;
%Out	ConOut.asm
page
;----------------------------------------------------------------------
; Equates
;--------
;
MONITOR_SEGMENT SEGMENT WORD PUBLIC

	ASSUME	CS:MONITOR_SEGMENT, DS:ROM_DATA, ES:NOTHING

; Include Files
;--------------
;
;	ROM.LIT
;	INTR.LIT
;	SYS.EXT
;	VIDEO.LIT
;	VIDEO.EXT
;	KEYBOARD.LIT
;	KEYBOARD.EXT

	.xlist
	INCLUDE ../ROM/ROM.LIT
	INCLUDE ../ROM/INTR.LIT
	INCLUDE ../ROM/SYS.EXT
	INCLUDE ../VIDEO/VIDEO.LIT
	INCLUDE ../VIDEO/VIDEO.EXT
	INCLUDE ../IO/KEYBOARD.LIT
	INCLUDE ../IO/KEYBOARD.EXT
	.list

	extrn	VIDEO_IO_INTERRUPT:NEAR
	extrn	SCROLL_UP:NEAR
	extrn	GET_KEY_BUFF:NEAR
	extrn	GET_KEY_STATUS:NEAR
	extrn	GET_CURSOR_POSITION:Near

page
;**********************************************************************
; GET_CUR_POSN:
;
;	Get_Cur_Posn gets the cursor position for the currently
; active page.
;
; Output:
;	DX: Cursor position (DH:row, and DL:column)
;**********************************************************************
GET_CUR_POSN PROC NEAR
	PUBLIC	GET_CUR_POSN
	PUSHREG	<AX,BX,SI,DS>
	MOV	BH,DISPLAYED_PAGE	;Get the currently displayed page
	CALL	GET_CURSOR_POSITION	;Retrieve the Z-150 cursor position
	POPREG	<DS,SI,BX,AX>
	RET
GET_CUR_POSN ENDP


;**********************************************************************
; DISP_STRING: (STRING)
;
;	Disp_String displays a null (00H) terminated string on
; the console.
;
; Input:
;	SI: Pointer to string (assumed to be in the monitor segment).
;**********************************************************************
DISP_STRING PROC NEAR
	PUBLIC	DISP_STRING
	PUSHREG	<AX,SI>
DDS1:	MOV	AL,BYTE PTR CS: [SI]	;Get a character to be displayed
	INC	SI			;Point to the next character
	TEST	AL,AL			;Reached the end of the string?
	JZ	DDS2			;Yes - return
	CALL	CONSOLE_OUTPUT		;No, display this character
	JMP	SHORT DDS1		;Loop until whole string displayed
DDS2:	POPREG	<SI,AX>
	RET
DISP_STRING ENDP

;**********************************************************************
; SPACE: (COUNT)
;
;	Space is used to send an arbitrary number of spaces to the
; console.
;
; Input:
;	AH: Number of spaces to be displayed
;**********************************************************************
SPACE PROC NEAR
	PUBLIC	SPACE
	PUSHREG	<AX>
SP1:	MOV	AL,' '			;Get a space character
	CALL	CONSOLE_OUTPUT		;Display it on the console
	DEC	AH			;Displayed enough yet?
	JNZ	SP1			;No, display some more!
	POPREG	<AX>
	RET
SPACE ENDP



;**********************************************************************
; CONSOLE_OUTPUT: (CHAR)
;
;	Console_Output is called to output characters on the screen in
; the current video mode.  This routine differentiates itself from the
; Terminal_Display routines in that it detabs - ie, TABs which are
; displayed are converted to a sequence of spaces which will advance
; the cursor to the next 8-character tab stop.  The cursor is updated
; upon return to the next character location.
;	In addition to the above, the CONSOLE_OUTPUT routine ignores
; NULL characters.
;
; Input:
;	AL: Character to be displayed
;
; Note:	This routine is reentrant (via the SPACE routine), in the
;	event of a TAB.
;**********************************************************************
CONSOLE_OUTPUT PROC NEAR
	PUBLIC	CONSOLE_OUTPUT
	PUSHREG	<AX,BX,CX,DX>		;Save registers
	TEST	AL,AL			;Is the character a null?
	JZ	CO2			;Yes - ignore it
	CMP	AL,TAB			;Is this a horizontal tab?
	JNE	CO1			;No, display the character
	CALL	GET_CUR_POSN		;Read the current cursor position
	MOV	AH,DL			;Get the current column number
	AND	AH,TAB_MASK		;Find start of current tab
	ADD	AH,TAB_SIZE		;Find next tab stop
	SUB	AH,DL			;Find number of spaces to display
	CALL	SPACE			;Display them!
	JMP	SHORT CO2		;Return to caller
CO1:	MOV	AH,14			;Set terminal-display mode
	MOV	BL,03H			;Set color in case med-res graphics
	INT	VIDEO_IO_INTR		;Display the character on the screen
CO2:	POPREG	<DX,CX,BX,AX>		;Restore registers
	RET
CONSOLE_OUTPUT ENDP


MONITOR_SEGMENT ENDS

	END
