Page	60,132
Title	-Calculator Icon -- Main Module
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 1_Nov_85
;
;
%Out	CalcMain.asm
page
;--------------------------------------------------------------------
; Equates (16_May_85)
;--------------------
;
; Include Files
;--------------
;	Rom.lit
;	Intr.lit
;	Io.lit
;	Icon.lit
;	Calc.lit
;
	.xlist
	Include	..\Rom\Rom.lit
	Include ..\Rom\Intr.lit
	Include ..\Io\Io.lit
	Include Icon.lit
	Include	Calc.lit
	.list
;***********
; Non-Numlock Key Codes
;

d0	equ	51		;key code for digit 0
d1	equ	36		;key code for digit 1
d2	equ	37		;key code for digit 2
d3	equ	38		;key code for digit 3
d4	equ	22		;key code for digit 4
d5	equ	23		;key code for digit 5
d6	equ	24		;key code for digit 6
d7	equ	8		;key code for digit 7
d8	equ	9		;key code for digit 8
d9	equ	10		;key code for digit 9
dp	equ	52		;key code for decimal point
pl	equ	53		;key code for plus sign
mn	equ	39		;key code for minus sign
;***
tm	equ	25		;key code for times sign
dv	equ	11		;key code for divide sign
;***

;***********
; Numlock Key Codes
;

;**altd0	equ	82		;key code for digit 0
;**altd1	equ	79		;key code for digit 1
;**altd2	equ	80		;key code for digit 2
;**altd3	equ	81		;key code for digit 3
;**altd4	equ	75		;key code for digit 4
;**altd5	equ	76		;key code for digit 5
;**altd6	equ	77		;key code for digit 6
;**altd7	equ	71		;key code for digit 7
;**altd8	equ	72		;key code for digit 8
;**altd9	equ	73		;key code for digit 9
;**altdp	equ	83		;key code for decimal point
;**altpl	equ	78		;key code for plus sign
;**altmn	equ	74		;key code for minus sign
;***
;**alttm	equ	55		;key code for times sign
;**altdv	equ	53		;key code for divide sign
;***
;**
mp	equ	49		;key code for memory plus
mm	equ	35		;key code for memory minus
mc	equ	7		;key code for memory clear
mr	equ	21		;key code for memory recall
Clr_Cr	equ	20		;key code for clear
ce	equ	6		;key code for clear entry
csg	equ	12		;key code for change sign
eqs	equ	50		;key code for equal sign
csgn	equ	6		;change sign constant

;***************

page
;======================================================================
Rom_Data Segment At (40H)
;========================
;
	extrn	Shift_Status:Byte
Rom_Data EndS
;***************

;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:monitor_segment,ds:monitor_segment,es:monitor_segment

	;global variables
	extrn	Change_State:Near	;Change the Current Task's State
	extrn	Drw_Time:Near		;Draw the Time on the World Map
	extrn	Get_Time:Near		;Read the Time from the Rtc
	extrn	Get_Key_Status:Near	;Return Keyboard Status
	extrn	Get_Key_Buff:Near	;Return next key from Keyboard
;***
	extrn	DS_To_Rom_Data:Near	; Set Ds to Segment at 40:0h
;***

	extrn	Old_Video_Mode:Byte	;Current Video Mode
	extrn	Last_Task_Id:Byte	;Id of the Task that was interrupted
	extrn	Current_Task_Id:Byte	;Id of the Current Task
	extrn	DFlags:Byte		;Flag Byte for IconIo Screen I/O

	;calcmain variables
	extrn	dspim:byte		;display image
	extrn	winpos:byte		;window side left (will get toggled)
	extrn	mvlgh:byte		;memory value image length
	extrn	cst:word		;calculator state
	extrn	kop:byte		;constant operation
	extrn	top:byte		;temporary operation
	extrn	mflag:byte		;memory value displayed flag
	extrn	dpflag:byte		;dp entered
	extrn	nzflag:byte		;non-zero digit entered
	extrn	curpos:byte		;cursor position
	extrn	digctr:byte		;digit counter
	extrn	entflg:byte		;entry display flag
	extrn	mrg:byte		;memory register
	extrn	drg:byte		;display register
	extrn	trg:byte		;total register
	extrn	krg:byte		;constant register
	extrn	erg:byte		;temporary register
	extrn	rrg:byte		;round register

	;calcmath variables
	extrn	math:near		;math module
	extrn	setzer:near		;math module
	extrn	rg:byte			;working register

	extrn	dsperr:near		;CalcDsp Variables
	extrn	dspblk:near
	extrn	dspop:near
	extrn	dspmc:near
	extrn	wrwin:near
	extrn	scroll:near
	extrn	dspeln:near
	extrn	dspmln:near

	extrn	batro:near		;Putil Variables
	extrn	batrw:near
	extrn	calc_ram:word
	extrn	put_key_buff:near

page
;----------------------------------------------------------------------
; Fixed Data Area (29_Apr_85)
;----------------------------
;
opchar	db	"+","-","x","/"

; State A Jump Table
;-------------------
;
jmptba	dw	csaop			;plus, minus, times or divide
	dw	csaeq			;equal sign
	dw	csamop			;memory + or memory -
	dw	clear			;clear

; State B Jump Table
;-------------------
;
jmptbb	dw	cstb			;clear entry
	dw	csao1			;plus, minus, times or divide
	dw	csbeq			;equal sign
	dw	csbmop			;memory + or memory -
	dw	clear			;clear

; State C Jump Table
;-------------------
;
jmptbc	dw	csao0			;plus, minus, times or divide
	dw	csceq			;equal sign
	dw	csam2			;memory + or memory -
	dw	clear			;clear

keytb	db	d0
	db	d1
	db	d2
	db	d3
	db	d4
	db	d5
	db	d6
	db	d7
	db	d8
	db	d9
	db	dp
	db	pl
	db	mn
	db	tm
	db	dv
	db	eqs
	db	mp
	db	mm
	db	Clr_Cr
	db	13	; '=' key is =
	db	28	; ret is +
	db	57	; space is same as '0'
	db	mr
	db	csg
	db	ce

;**key2tb	db	altd0
;**	db	altd1
;**	db	altd2
;**	db	altd3
;**	db	altd4
;**	db	altd5
;**	db	altd6
;**	db	altd7
;**	db	altd8
;**	db	altd9
;**	db	altdp
;**	db	altpl
;**	db	altmn
;*****
;**	db	alttm
;**	db	altdv
;**	db	eqs
;**	db	mp
;**	db	mm
;**	db	Clr_Cr
;**	db	13	; '=' key is =
;**	db	28	; ret is +
;**	db	57	; space is same as '0'
;**	db	mr
;**	db	csg
;**	db	ce
;*****
;			key	ch	cl
;			---	--	--
xltbl	db	00	;d0	0	0
	db	01	;d1	0	1
	db	02	;d2	0	2
	db	03	;d3	0	3
	db	04	;d4	0	4
	db	05	;d5	0	5
	db	06	;d6	0	6
	db	07	;d7	0	7
	db	08	;d8	0	8
	db	09	;d9	0	9
	db	10	;dp	1	0
	db	60	;pl	6	0
	db	61	;mn	6	1
	db	62	;tm	6	2
	db	63	;dv	6	3
	db	70	;eqs	7	0
	db	80	;mp	8	0
	db	81	;mm	8	1
	db	90	;Clr_Cr	9	0
	db	70	;eqs	7	0
	db	60	;pl	6	0
	db	00	;d0	0	0
	db	20	;mr	2	0
	db	30	;csg	3	0
	db	50	;ce	5	0

keytbl	equ	(offset xltbl)-(offset keytb)
;**altln	equ	(offset xltbl)-(offset key2tb)

page
;----------------------------------------------------------------------
Calc_Init Proc Near; (29_Apr_85)
;-------------------------------
;	1) task-handler initialization routine for the calculator
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	calc_init

	push	ds
	push	cs
	pop	ds
	mov	winpos,0		;init winpos to left screen
	pop	ds
	ret				;Return

calc_init	EndP

page
;--------------------------------------------------------------------
Calc_Icon_L Proc Near; (30_Apr_85)
;---------------------------------
;	1) calculator entry routine -- Left Hand Side of Screen
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Calc_Icon_L

	cld				;init direction flag
	push	cs
	pop	ds			;DS:= Monitor_Segment

	mov	WinPos,0		;Window:= Left Side
	jmp	short CirSk2		; join common code

Calc_Icon_L	EndP

;--------------------------------------------------------------------
Calc_Icon_R Proc Near; (12_May_85)
;---------------------------------
;	1) calculator entry routine -- Right Hand Side of Screen
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Calc_Icon_R

	cld				;init direction flag
	push	cs
	pop	ds			;DS:= Monitor_Segment

	test	Old_Video_Mode,2	;If (40 Column Mode eq True)
	jnz	CirSk1

	mov	al,0			;	State:= 0
	mov	WinPos,al		;	(Window:= Left Side)
	mov	ah,Icon_Calc - 2	;	Task:= Calc
	call	Change_State		;	Change Back to Left Side
	jmp	Short CirSk2

CirSk1:	mov	WinPos,57		;Else	Window:= Right Side

;
; common icon entry code for left/right side
;
CirSk2:	call	wrmini			;do warm init
	call	Scrini
	call	wrwin			;display fixed window
	call	dspmv			;memory value to display register
	call	dspmln			; then display on screen
	jmp	word ptr cst		;continue calculator function

Calc_Icon_R	EndP

page
;--------------------------------------------------------------------
Alt_Calc_Function Proc Near; (17_May_85)
;---------------------------------------
;	1) Main Program Entry - to transfer Calculator Memory Value
;	   to keyboard buffer.
;
;	 hollerith	ascii(AL)	scan(AH)
;	---------------------------------------
;	 ','		27h		51
;	 '.'		2eh		52	
;	 '0'		30h		11
;	 '-'		2dh		12
;	 '1'-'9'	31h-39h		2-10
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Monitor_Segment
Public	Alt_Calc_Function

	pushf				;Save FLAGS
	PushReg	<bp,ds,es,di,si>	;Save Registers
	push	cs			;setup
	pop	ds			; data segment to Monitor_Segment
	cli				; disable interupts while in Calc_Alt

	cmp	Current_Task_Id,Icon_Calc-2 ;Alt_Calc uses CALC data areas
	je	exit			; SO ... If already Calc, EXIT 
	call	wrmini			;get current memory value
	jc	short exit		;memory BAD (now ZEROED), do no x-fer

	mov	entflg,0		;Entry_Display_Flag ... cleared
	call	dspmv			;memory value to display register
	std				;set direction reverse
	mov	si,offset dspim		;x-fer contents
	mov	cl,mvlgh		; into
	mov	ch,0			; the (note: CX is now <= 16) ...
	add	si,cx			; (string was reverse packed in dspim,
	dec	si			;  x-fer end to front)

memget:	lodsb				;Loop	AL:= Next Character

	;test for ',' '.' '0' '-'
	mov	ah,11			;	AH:= Scan Code for a Zero
	cmp	al,'0'			;	If (Character eq Zero)
	je	Short MemPut		;		Put Character in Buffer

	mov	ah,12			;	AH:= Scan Code for a Dash
	cmp	al,'-'			;	If (Character eq Dash)
	je	Short MemPut		;		Put Character in Buffer

	mov	ah,52			;	AH:= Scan Code for a Period
	cmp	al,'.'			;	If (Character eq Period)
	jne	Short MemSk1		;		If (Last Character)
	cmp	cx,1			;			Exit
	je	Exit			;		Else
	jmp	Short MemPut		;			Put Char in Buf

MemSk1:	cmp	al,','			;	Else If (Character eq Comma)
	je	Short MemNxt		;		Ignore the Character

	;must be '1'-'9'
	mov	ah,al			;  AH <- '1'(31h), '2'(32h), etc.
	sub	ah,2fh			;  AH <- '1' -> 2, '2' -> 3, etc.

MemPut:	call	Far Ptr Put_Key_Buff	; ... KBD buffer
MemNxt:	loop	memget			;next character

Exit:	PopReg	<si,di,es,ds,bp>	;Restore Registers
	popf				;restore direction and interupts
	ret				;return to Task Handler

Alt_Calc_Function EndP

page
;----------------------------------------------------------------------
wrmini Proc Near; (02_May_85)
;----------------------------
;	1) warm initialization (normal power-up)
;
public	wrmini
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Monitor_Segment

	cld
	push	cs
	pop	es			;ES = Start of Monitor Segment

	mov	di,offset mrg		;set initial destination for data
	mov	cx,L/2			; bytes to be unpacked (2 digits/byte)
	mov	ah,0			; offset to base of calc ram in novram

wrmin0:	call	r_w_calc		;Repeat read novram
	inc	ah			;	read a byte into al
	cmp	al,100			;	if (byte out of range)
	jae	wrmin2			;		perform cold init
	push	ax
	aam				;	unpack the digits
	stosw				;	store in memory register
	pop	ax			;	get back ah (index into novram)
	loop	wrmin0			;Until (memory register unpacked)

	call	r_w_calc		;get exponent for memory register
	inc	ah			; 
	xor	al,80h			; 
	cmp	al,lfx			; if (exponent not in range) then
	jg	wrmin2			; 	perform cold-init of calc
	stosb				; else save exp in memory register
	mov	byte ptr [di],"-" 	; assume memory value is negative
	call	r_w_calc		; get memory sign
	sar	al,1			; if negative then
	jc	wrmin1			; skip
	mov	byte ptr [di],"+"	; else, set it for positive
wrmin1:	jmp	short wrmin3

wrmin2:	mov	di,offset mrg		;BAD MEMORY VALUE
	call	setzer			; ZERO it out
	call	brmupd			; and update NovRam
	stc				;Flag it
	ret				; and return in case Alt Calc

wrmin3: clc
;NOTE: WE NOW INITIALIZE SCREEN (SCRINI) EXPLICITLY IN CALC_ICON_R
	ret

wrmini	EndP

;-------------------------------------------------------------------------
Scrini Proc Near ;(03_May_85)
;----------------------------
;	1) MUST CALL DIRECTLY AFTER WRMINI in Calc_Icon_R, and Calc_Icon_L

	call	clrreg			;clear registers (returns w/ AL=0)
	mov	entflg,al		;Entry_Display_Flag ... cleared
	call	scroll			;clear display screen (AL=0 -> clear)
	mov	cst,offset csta		;initialize calculator state
	ret

Scrini		EndP

page
;----------------------------------------------------------------------
Brmupd Proc Near
;---------------
;	1) update battery backed-up ram calculator state
;
	mov	dl,80h			;pack (msb set -> write)
	mov	si,offset mrg		; two
	mov	cx,l/2			; digits
brmup0:	lodsw					; to each
	aad				; byte and
	mov	ah,dl			; write the
	call	r_w_calc		; byte to
	inc	dl			; battery
	loop	brmup0			; backed-up
	lodsb				; ram
	xor	al,80h			;xor
	mov	ah,dl
	call	r_w_calc		; exponent
	inc	ah			; with
					; 80h
	mov	al,0
	cmp	mrg.sgn,"+"		; truncate (=1)
	je	brmup1			; in bit 1 and
	or	al,1			; mv sign in bit 0
brmup1:					;fall through to write the byte

brmupd		EndP

page
;-------------------------------------------------------------------------
R_W_Calc Proc Near
;-----------------
;	1) this routine is used to read or write bytes from the novram.
;	   it is used to read or write data that is kept up by the calculator.
;	2) on entry: ah bits [6:0] = byte offset to be read
;		  ah bit 7 = 1 for write, 0 for read
;		  al = byte to write if ah msb = 1
;	3) on exit:  al = data read if it was a read command
;		  all registers (except al if read) preserved
;
public	r_w_calc

	push	bx
	push	ax
	push	ax

	; get address being accessed
	and	ah,7fh			; get rid of msb
	mov	al,0			; make ax offset into Calc_Ram array
	xchg	al,ah

	mov	bx,offset [calc_ram]	; get base of calculator ram
	add	bx,ax			; bx = offset to calc_byte
	pop	ax
	test	ah,80h			; determine if reading or writing
	jnz	write_calc		; if reading.....
	pop	ax			; restore ah
	mov	al,[bx]			; read the data
	pop	bx
	ret				; and return
	
write_calc:				; if writing...
	call	batrw			; enable writes
	mov	[bx],al			; write the byte
	call	batro			; disable writes
	pop	ax
	pop	bx
	ret

R_W_Calc	EndP

page
;--------------------------------------------------------------------
ClrReg Proc Near
;----------------
;	1) clear calculator registers (note setzer will return al=0)
;
	mov	kop,4			;clear constant operation
	mov	di,offset krg		;clear the
	call	setzer			; constant register
	mov	di,offset drg		;clear the
	call	setzer			; display register
	mov	di,offset trg		;clear the
	jmp	setzer			; total register

clrreg		EndP


;--------------------------------------------------------------------
ClcErr Proc Near
;---------------
;	1) calculator error routine
;
	cmp	ah,Clr_Cr		;clear ?
	je	clear			; yes -> clear
	jmp	word ptr cst		;ce -> last calculator state

ClcErr		EndP


;--------------------------------------------------------------------
Clear Proc Near
;--------------
;	1) clear routine
;
	mov	al,0			;blank the
	call	scroll			; calculator tape
	call	clrreg			;clear registers

Clear		EndP

page
;--------------------------------------------------------------------
csta Proc Near
;-------------
;	1) This is the calculator state 'A' routine
;	2) initial state on input (and is this state most of the time!)
;	   +,-,x,/ and Clr_Cr puts us here from cstb and cstc as well
;	3) retains state csta on keys ...
;	   d0-d9,dp  : actually will remain in getnum until not these
;	   mr,csg,ce : actually will remain in getnum until not these
;	   mc        : actually will remain in getkey of getnum
;	   +,-,x,/   : processes via csao0
;	   eqs (*)   : if and only if no +,-,x,/ has been entered since
;                    : coming into this state (a trivial case)
;	   Clr_Cr    : processes via clear
;	4) changes state to cstb on keys ...
;	   eqs (*)   : processes via csaeq if +,-,x,/ has been entered
;	   m+,m-     : processes via csbmop
;	5) changes state to cstc ... never!
;
	call	clredsp			;clear entry and display it
csta0:	clc				;do not already have key
	mov	cst,offset csta		;update calculator state
	call	getnum			;get numeric entry
	mov	top,al			;save operation code
	mov	bh,0			;jump to
	mov	bl,ah			; indicated
	sal	bx,1			; function
	jmp	word ptr jmptba[bx-12]

csta		EndP

page
;--------------------------------------------------------------------
cstb Proc Near
;-------------
;	1) This is the calculator state 'B' routine
;	2) eqs,m+,m- on input (from states csta and cstc)
;	3) retains state cstb on keys ...
;	   ce,mc     :
;	   eqs       : processes via csbeq
;	   m+,m-     : processes via csbmop
;	4) changes state to cstc on keys ...
;	   d0-d9,dp  : 
;	   mr,csg    :
;	5) changes state to csta on keys ...
;	   +,-,x,/   : processes via csao1
;	   Clr_Cr    : processes via clear
;
	call	dspblk			;blank the entry line
	mov	cst,offset cstb		;update calculator state
	call	getkey			;get numeric entry
	cmp	ah,3			;digit, dp, mr, or csg?
	jg	cstb0			; no -> cstb0

	push	ax			;save key code
	call	clredsp			;clear entry and display it
	pop	ax			;restore key code
	stc				;already have key
	jmp	short cstc1

cstb0:	mov	top,al			;save operation code
	mov	bh,0			;jump to
	mov	bl,ah			; indicated
	sal	bx,1			; function
	jmp	word ptr jmptbb[bx-10]

cstb		EndP

page
;--------------------------------------------------------------------
cstc Proc Near
;-------------
;	1) This is the calculator state 'C' routine
;	2) d0-d9,dp,mr,csg on input (from state cstb)
;	   cannot be put in this state from csta
;	3) retains state cstc on keys ...
;	   d0-d9,dp  : actually will remain in getnum until not these
;	   mr,csg,ce : actually will remain in getnum until not these
;	   mc        : actually will remain in getkey of getnum
;	   eqs (*)   : if and only if no +,-,x,/ has been entered since
;	             : coming into this state (a trivial case)
;	4) changes state to csta on keys ...
;	   +,-,x,/   : processes via csao0
;	   Clr_Cr    : processes via clear
;	5) changes state to cstb on keys ...
;	   eqs (*)   : processes via csbe0 if +,-,x,/ has been entered
;	   m+,m-     : processes via csbmop
;
	call	clredsp			;clear entry and display it
cstc0:	clc				;do not already have key
cstc1:	mov	cst,offset cstc		;update calculator state
	call	getnum			;get numeric entry
	mov	top,al			;save operation code
	mov	bh,0			;jump to
	mov	bl,ah			; indicated
	sal	bx,1			; function
	jmp	word ptr jmptbc[bx-12]

cstc		EndP
page
;----------------------------------------------------------------------
csaop Proc Near
;--------------
;
	cmp	kop,4			;has operator occured (kop < 4)?
	je	csao0			;no,trivially no intermediate math to do

	call	matht			;yes, do (intermediate) total reg math
	jnc	csao0			;  overflow? no,queue results & display op

	jmp	clcerr			;            yes, display error message
csao0:	call	tdscrl			;queue temp results in total register
csao1:	mov	bl,top			;temp operator index
	mov	kop,bl			;  to constant op index
	mov	bh,0			;display
	mov	al,opchar[bx]		;  the 
	call	dspop			;  operator
	jmp	csta

csaop		EndP

;----------------------------------------------------------------------
csaeq Proc Near
;--------------
;
	cmp	kop,4			;has operator occured (kop < 4)?
	jne	csae0			;yes -> csae0

	jmp	csta0			;no, trivially nothing to do
csae0:	call	kdmath			;do the display math
	jnc	csae1			;  overflow? no,display results & operator

	jmp	clcerr			;            yes, display error message
csae1:	mov	al,1			;scroll the 
	call	scroll			;  intermediate results
	mov	al,"="			;display the
	call	dspop			;  '='sign
	call	dspdrg			;display the results
csae2:	call	tdscrl			;scroll everything to make room for new entry
	jmp	cstb

csaeq		EndP

page
;----------------------------------------------------------------------
csamop Proc Near
;---------------
;
	cmp	kop,4			;has operator occured (kop < 4)?
	je	csam2			;no, trivially no math to add/sub mem

	call	kdmath			;yes, do the display math 
	jnc	csam0			;  overflow? no, do mem math and display

	jmp	clcerr			;            yes, display error message
csam0:	call	mathm			;do the memory math
	jnc	csam1			;  overflow? no, display memory value

	jmp	clcerr			;            yes, display error message
csam1:	call	updmv			;write memory to novram and display it
	jmp	short csae1		;display intermediate results & scroll
csam2:	call	mathm			;do the memory math
	jnc	csam3			;  overflow? no, display memory value

	jmp	clcerr			;            yes, display error message
csam3:	call	updmv			;write memory to novram and display it
	jmp	short csae2		;no intermediate results,so just scroll

csamop		EndP

page
;----------------------------------------------------------------------
csbeq Proc Near
;--------------
;
	cmp	kop,4			;has operator occured (kop < 4)?
	je	csbm1			;no, trivially no math to add/sub mem
csbe0:	call	mathk			;yes, do temp reg math and display it
	jnc	csbe1			;  overflow? no, display memory value

	jmp	clcerr			;            yes, display error message
csbe1:	mov	bh,0			;display
	mov	bl,kop			;  the 
	mov	al,opchar[bx]		;  constant
	call	dspop			;  operator
	call	dspkrg			;display the constant reg
	jmp	short csae1

csbeq		EndP

;----------------------------------------------------------------------
csbmop Proc Near
;---------------
;
	call	mathm			;do the memory math
	jnc	csbm0			;  overflow? no, display mem 
	jmp	clcerr			;            yes,display error message 
csbm0:	call	updmv			;put memory in novram and display it
csbm1:	jmp	word ptr cst

csbmop		EndP

;----------------------------------------------------------------------
csceq Proc Near
;--------------
;
	cmp	kop,4			;has operator occured (kop < 4)?
	jne	csce0			;yes -> csce0

	jmp	cstc0			;no, trivially nothing to do
csce0:	call	tdscrl			;scroll to make room for new entry
	jmp	short csbe0

csceq		EndP

page
;--------------------------------------------------------------------
updmv Proc Near
;--------------
;	1) update memory value routine
;
	mov	si,offset erg		;move temp register
	mov	di,offset mrg		; to
	mov	cx,l+2			; the
	rep	movsb			; memory register

updmv0:	call	dspmv			;display the memory register
	call	dspmln			; also display on screen
	call	brmupd			;save it in novram
	ret

updmv		EndP

;--------------------------------------------------------------------
tdscrl Proc Near
;---------------
;	1) drg to trg and then scroll
;
	mov	si,offset drg		;move display register
	mov	di,offset trg		; to 
	mov	cx,l+2			; the
	rep	movsb			; total register
	mov	al,1			;and
	jmp	scroll			;scroll

tdscrl		EndP

page
;--------------------------------------------------------------------
kdmath Proc Near
;---------------
;	1) krg to drg and then matht routine
;
	mov	si,offset drg
	mov	di,offset krg
	mov	cx,l+2
	rep	movsb

kdmath		EndP


;--------------------------------------------------------------------
matht Proc Near
;--------------
;	1) math routine
;
	mov	bx,offset trg
	mov	si,offset drg
	jmp	short mathk0

matht		EndP


;--------------------------------------------------------------------
mathk Proc Near
;--------------
;	1) math routine
;
	mov	bx,offset drg
	mov	si,offset krg
mathk0:	mov	di,offset erg
	mov	cl,kop
	call	math
	jc	ovfhnd

	mov	si,offset erg
	mov	di,offset drg
	mov	cl,l+2
	rep	movsb
	clc
mathk1:	ret

mathk		EndP

page
;--------------------------------------------------------------------
mathm Proc Near
;--------------
;	1) math routine
;
	mov	bx,offset mrg
	mov	si,offset drg
	mov	di,offset erg
	mov	cl,top

	call	math
	jnc	mathk1

mathm		EndP

;----------------------------------------------------------------------
ovfhnd Proc Near
;---------------
;	1) overflow handler
;
	call	dsperr			;display error message

ovfhn0:	call	getktk			; get a key
	cmp	al,ce			;was clear entry pressed?
	je	ovfhn1			; yes -> ovfhn1

	cmp	al,Clr_Cr		;was clear pressed?
	jne	ovfhn0			; yes -> ovfhn1

ovfhn1:	stc				;indicate error
	ret

ovfhnd		EndP

page
;----------------------------------------------------------------------
getnum Proc Near
;---------------
;	1) get calculator numeric entry
;
	jc	getn1			;already have key -> getn1
getn0:	call	getkey			;get next key
getn1:	cmp	ah,5			;pl, mn, tm, dv, eqs
	jg	getn7			; mp, mm, Clr_Cr, or cxt -> getn7
	cmp	ah,3			;change sign
	je	getn5			; -> getn5
	jg	getn3			;clear entry -> getn3
	cmp	ah,1			;digit
	jl	getn9			; -> getn9
	jg	getn4			;memory recall -> getn4
	cmp	dpflag,0		;decimal point yet?
	jne	getn8			;yes -> getn8
	cmp	mflag,1			;memory value in entry?
	jne	getn2			;no -> getn2
	call	clrent			;clear entry

getn2:	inc	dpflag			;indicate decimal point
	jmp	short getn6

getn3:	call	clrent			;clear entry
	jmp	short getn6

getn4:	mov	mflag,1			;indicate memory value in entry
	mov	al,"m"			;display "m" in the
	call	dspmc			; memory column
	mov	si,offset mrg		;move memory
	mov	di,offset drg		; value register
	mov	cx,l+2			; to the

	rep	movsb			; register
	jmp	short getn6
getn5:	xor	drg.sgn,csgn		;change sign in display register

getn6:	mov	al,mflag		;check for
	xor	al,1			; entry
	mov	entflg,al		; display state
	call	dspdrg			;display the new number
	mov	entflg,0		;set to non-entry display state

	jmp	short getn0
getn7:	ret

getn8:	jmp	short getn0
getn9:	cmp	mflag,0			;mem val in entry line?
	je	getn10			; no -> getn10

	push	ax			;save digit
	call	clrent			;clear entry
	pop	ax			;restore digit

getn10:	cmp	digctr,lfx		;too many digits?
	jge	getn8			; yes -> getn8

	cmp	nzflag,0		;entry zero so far?
	jne	getn12			; no -> getn12

	cmp	al,0			;digit zero?
	jne	getn11			; no -> getn11

	cmp	dpflag,0		;decimal point yet?
	je	getn6			; no -> ignore leading zero

	dec	curpos			;bump cursor position
	jmp	short getn15
getn11:	inc	nzflag			;indicate entry is non-zero
	mov	ah,curpos		;move cursor position
	mov	drg.exp,ah		; to exponent

getn12:	cmp	dpflag,0		;decimal point yet?
	je	getn13			; no -> getn13

	dec	curpos			;bump cursor position
	jmp	short getn14
getn13:	inc	drg.exp			;bump exponent

getn14:	mov	bh,0ffh			;place
	mov	bl,curpos		; digit in
	sub	bl,drg.exp		; display
	mov	drg.mag[bx+l],al	; register
getn15:	inc	digctr			;bump digit count
	jmp	short getn6

getnum		EndP

page
;--------------------------------------------------------------------
clrent Proc Near
;---------------
;	1) clear entry routine
;
	mov	di,offset drg		;zero the
	call	setzer			; display register

	mov	mflag,al		;memory value not in entry
	mov	dpflag,al		;reset the decimal point flag
	mov	nzflag,al		;reset the non-zero flag
	mov	digctr,al		;zero the digit count
	mov	curpos,al		;zero the cursor position

clren0:	mov	al," "			;blank the memory
	jmp	dspmc			; flag column

clrent		EndP

page
;----------------------------------------------------------------------
GetKtk Proc Near; (11_Jul_85)
;----------------------------
;	1) get next calculator key
;	2) ignore calculator function key
;	3) handle: mc clear memory value
;	4) on exit:
;		key	ch	cl		key	ch	cl
;		------------------		------------------
;		d0	0	0		mr	2	0
;		d1	0	1               csg	3	0
;		d2	0	2               ce	5	0
;		d3	0	3               pl	6	0
;		d4	0	4               mn	6	1
;		d5	0	5               tm	6	2
;		d6	0	6               dv	6	3
;		d7	0	7               eqs	7	0
;		d8	0	8               mp	8	0
;		d9	0	9               mm	8	1
;		dp	1	0               Clr_Cr	9	0
;
	cmp	Last_Task_Id,Icon_Clock-2
	jnz	GetTk2			;If (Last Task eq Clock)

	mov	ah,DFlags
	push	ax			;	Save DFlags

	call	Get_Time		;	Get the Time
	call	Drw_Time		;	Draw the Time on the Screen

	pop	ax			;	Restore DFlags
	mov	DFlags,ah

gettk2:	push	ds			; FORCE NUMLOCK OFF

	Assume DS:Rom_Data

	call	DS_To_Rom_Data		; point to Rom_Data segment
	and	Shift_Status,NOT 20h	; force Numlock to be false
	pop	ds

	Assume DS:Monitor_Segment

	call	Get_Key_Status		;If (Keyboard Status eq Active)
	jz	getktk

	call	Get_Key_Buff		;	Get the Key
	cld
	mov	al,ah			;Return scan code in al
	ret				;Return

Getktk	EndP

page
;----------------------------------------------------------------------
getkey Proc Near
;---------------
;
	call	getktk			; get a key
	cmp	al,mc			;was memory clear pressed?
	jne	short getk11		; no -> search key table

	mov	di,offset mrg		;zero the memory
	call	setzer			; value register
	call	updmv0			; and display it
	jmp	short getkey
	
;*******
getk11:
	mov	di,offset keytb		;point to key table
	mov	cx,keytbl		; get length of table
	repne	scasb			; search for key match

	jne	short getkey		; No Match, then get next key
	mov	al,xltbl-keytb-1[di]	; else xlate to function
	aam				; expand code into ah/al
	ret

;**getk13: mov	di,offset key2tb	; point to NumLock table
;**	mov	cx,altln		; get length for table search
;**	repne scasb			; try for an alternate
;**	jne	short getkey		; out if not found
;**	mov	al,xltbl-key2tb-1[di]	; look up new key
;**	aam				; expand code into ah/al
;**	ret

;***getk14:	jmp	short getkey

getkey		EndP

page
;--------------------------------------------------------------------
;	1) clear entry and display the display register in the entry line
;
clredsp	Proc Near
	call	clrent			;clear entry
clredsp	endp

; Fall thru ...

;--------------------------------------------------------------------
dspdrg Proc Near
;---------------
;	1) display the display register in the entry line
;
	mov	si,offset drg		;set up for display of drg
	jmp	short dspkr0

dspdrg		EndP

;--------------------------------------------------------------------
dspkrg Proc Near
;---------------
;	1) display the constant register in the entry line
;
	mov	si,offset krg		;set up for display of krg

dspkr0:	call	filimg			;display register
	jmp	dspeln			; in entry line

dspkrg		EndP

;--------------------------------------------------------------------
dspmv Proc Near
;--------------
;	1) display memory value line
;
	mov	si,offset mrg		;fill the display with
	call	filimg			; formatted memory memory value

	mov	ax,di			;determine
	sub	ax,offset dspim		; and 
	mov	mvlgh,al		; set MV length (also for Alt Calc)

;RETURN NOW and if needed ... call dspmln (Calc_Alt doesn't need to)
;	jmp	dspmln			; in memory value line
	ret

dspmv		EndP

page
;--------------------------------------------------------------------
filimg Proc Near
;---------------
;	1) fill image register, SI = register address to display
;
	mov	di,offset dspim		;blank
	mov	al," "			; display
	mov	cx,20			; image
	rep	stosb			; register
	mov	di,offset rrg		;copy
	mov	cl,l+2			; source
	push	si			; register

	rep	movsb			; to
	pop	si			; rrg
	mov	al,curpos		;get next char position
	cbw
	cmp	entflg,cl		;entry mode (recall cl=0)?
	jne	flim3			;yes -> flim3
	call	getoff			;put the

flim3:	mov	si,offset rrg.exp	; number of
	mov	di,offset dspim		; digits below
	mov	cx,ax			; the decimal
	neg	cx			; point into
	sub	al,byte ptr [si]	; cx
	jo	flim9			;too small -> display 0

	cbw				;negative of number of
	mov	bx,ax			; displayed digits to bx
	jge	flim9			;too small -> display 0

	jcxz	flim6			;integer -> flim6
	cmp	entflg,0		;entry mode?

	jne	flim5			; yes -> flim5
flim4:	cmp	byte ptr [si+bx],0	;remove trailing
	jne	flim5			; zeroes

	inc	bx			; after
	loop	flim4			; decimal
	jmp	short flim6		; point

flim5:	mov	al,[si+bx]		;handle
	add	al,"0"			; the
	stosb				; fractional
	inc	bx			; part
	loopne	flim5			; of

	je	flim10			; number
flim6:	mov	al,"."			;decimal point
	stosb				; here
flim7:	mov	cl,3			;handle

flim8:	mov	al,[si+bx]		; the
	add	al,"0"			; integer
	stosb				; part
	inc	bx			; of
	je	flim12			; number

	loop	flim8			;commas
	mov	al,","			 ; every
	stosb				; three
	jmp	short flim7		; digits

flim9:	cmp	entflg,0		;entry display mode?
	jne	flim10			; yes -> flim10

	jmp	short flim11
flim10:	jcxz	flim11			;fill in
	mov	al,"0"			; zeroes before
	rep	stosb			; decimal point

flim11:	mov	ax,"0."
	stosw				;write "0."
flim12:	cmp	rrg.sgn,"+"		;if sign
	je	flim13			; is minus

	mov	al,"-"			; then
	stosb				; display it
flim13:	ret

filimg		EndP

;--------------------------------------------------------------------
getoff Proc Near
;---------------
;	1)get offset
;
	mov	ah,-lfx			;# of digits
	mov	al,rrg.exp		; to show
	sub	al,lfx			; below
	jo	getof0			; decimal

	cmp	al,ah			; point
	jge	getof1			;also used

getof0:	mov	al,ah			; for rounding
getof1:	cbw				; exponent
	ret

getoff		EndP

Monitor_Segment	EndS
		End
