
;	TREE -  This program displays the tree structured directory
;		Useage:	TREE [drive:][/F]
;		The F switch causes TREE to display the files in
;		each subdirectory.
;
;	Written by: RJM
;
;	Date: April 18, 1984
;
;	Version: 1.00 First release
;		 1.9 release 6/5/84
;		 2.00 release 7/20/84 (no changes from 1.9)
;		 2.01 release 9/26/84 - do error checking on CHDIR
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
	.XLIST
	INCLUDE	..\COMMONS\ASCII.DEF
	INCLUDE ..\COMMONS\MSDOS.DEF
	.LIST

FALSE		EQU	0
TRUE		EQU	NOT FALSE


NBI		EQU	FALSE		; Switch for NBI signon


DIR_ATTR	EQU	10H		; Attribute of a directory
FILE_ATTR	EQU	00H		; Attribute of a file
LABEL_ATTR	EQU	08H		; Attribute of a label


;	Structure for a node in the linked list of pathnames
;	Also used as DMA address of search first and next
NODE	STRUC

LINK_SEGMENT	DW	?
SEARCH_ATTR	DB	?
SEARCH_DRIVE	DB	?
SEARCH_NAME	DB	11 DUP(?)
SEARCH_LAST_ENT	DW	?
SEARCH_DPB	DD	?
SEARCH_DIRSTART	DW	?
FOUND_ATTR	DB	?
FOUND_TIME	DW	?
FOUND_DATE	DW	?
FOUND_LSIZE	DW	?
FOUND_HSIZE	DW	?
FOUND_NAME	DB	13 DUP(?)

NODE	ENDS


CODE	SEGMENT	BYTE PUBLIC
	ASSUME	CS:CODE, DS:CODE, ES:CODE, SS:CODE

ZERO	=	OFFSET $

	ORG	100H
TREE:
	JMP	TREE1

VERSION	DB	'2.01', CC_CR, CC_LF, 0


FSWITCH		DB	FALSE		; Switch for /F specified

DOT		DB	'.', 0		; Current dir. pathname
LENDOT		=	OFFSET $ - OFFSET DOT

DOTDOT	LABEL	BYTE			; (..) directory
PARENT	DB	'..', 0
LENDOTDOT	=	OFFSET $ - OFFSET DOTDOT

SWITCH_CHAR	DB	'/'		; Switch character
ROOT_DIR	LABEL	BYTE		; Path of root directory
PATH_CHAR	DB	'\', 0		; Path character

;	Linked list pointers
HEAD		DW	0		; Null pointer initially
TAIL		DW	0		; Last node initially null

MEM_REQ		DW	?		; Size of a memory request

NO_DIRS_MSG	DB	CC_CR, CC_LF, 'No sub-directories exist', CC_CR, CC_LF, CC_BEL, 0

NONE		DB	'None', CC_CR, CC_LF, CC_LF, CC_LF, 0

PARM_MSG	DB	CC_CR, CC_LF, 'Invalid parameter', CC_CR, CC_LF, CC_BEL, 0

BAD_PATH_MSG	DB	'Invalid Path', CC_CR, CC_LF, CC_LF, CC_BEL, 0

NO_VOL		DB	'???????????', 0

CRLF		DB	CC_CR, CC_LF, 0

TREE_HEADER	DB	CC_CR, CC_LF, 'DIRECTORY PATH LISTING FOR VOLUME ', 0
PATH_HEADER	DB	'Path: ', 0
SUBDIR_HEADER	DB	'Sub-directories:  ', 0
FILES_HEADER	DB	'Files:            ', 0
SPACES		DB	'                  ', 0

MATCH_ALL	DB	'*.*', 0


DEFAULT_DISK	DB	?		; Storage for the current disk

CURRENT_DIR	DB	65 DUP(?)	; Storage for the current directory

	IF	NBI

SIGN1	DB      CC_CR,CC_LF,'                   TREE Version ',0                        
SIGN2	DB	'               Copyright(C) NBI, Inc. 1984',CC_CR,CC_LF,CC_LF, 0

	ELSE

SIGN1	DB	CC_CR, CC_LF, '                        TREE Version ', 0
SIGN2	DB	'       (C) Copyright 1984, Zenith Data Systems Corporation', CC_CR, CC_LF, CC_LF, 0

	ENDIF

 HELP	DB	'TREE  shows the  subdirectory structure of the  default or specified',CC_CR,CC_LF
	DB	'disk. If the optional /F (Files) switch is used, TREE also lists the',CC_CR,CC_LF
	DB	'files contained in each subdirectory.',CC_CR,CC_LF,CC_LF
	DB	'Syntax: TREE ?', CC_CR, CC_LF
	DB	'        TREE [d:][/F]', CC_CR, CC_LF, CC_LF, 0

	DW	128 DUP(?)
STACK_TOP	LABEL	WORD

TREE1:
	MOV	SP,OFFSET STACK_TOP

;	Get the switch character

	CALL	GET_SWITCH_CHAR
	
;	Scan the command line for switches

	CALL	SCAN

;	Free up unused memory

	MOV	BX,TREE_SIZE
	MOV	AH,DOSF_SETBLK
	INT	21H

;	Determine the size of a node in paragraphs

	MOV	AX,TYPE NODE
	ADD	AX,15
	MOV	CL,4
	SHR	AX,CL
	MOV	MEM_REQ,AX

;	Determine the drive to get a tree from

	CALL	GET_DRIVE

;	Get the current directory on this drive

	MOV	AL,PATH_CHAR
	MOV	CURRENT_DIR,AL
	SUB	DL,DL			; Get path off of current drive
	MOV	SI,OFFSET CURRENT_DIR+1
	MOV	AH,DOSF_CWD
	INT	DOSI_FUNC

;	Trap control C's

	MOV	DX,OFFSET TE2
	MOV	AX,DOSF_SIVEC SHL 8 + DOSI_CADDR
	INT	DOSI_FUNC

;	Change directories to the root

	MOV	DX,OFFSET ROOT_DIR
	MOV	AH,DOSF_CHDIR
	INT	DOSI_FUNC
	JNC	SKIP1
	JMP	BAD_PATH

;	Allocate a node
SKIP1:
	CALL	ALLOC_NODE
	JNC	SKIP2
	JMP	TREE_EXIT

;	Try to get the first directory
SKIP2:
	MOV	CX,DIR_ATTR
	CALL	GET_FIRST
	JNC	TREE1A
	JMP	NO_DIRS_ERROR

;	Print volume name

TREE1A:
	CALL	VOL_NAME

;	Change directories to the found directory

TREE2:
	MOV	AX,TAIL
	MOV	DS,AX
	MOV	DX,FOUND_NAME
	MOV	AH,DOSF_CHDIR
	INT	DOSI_FUNC
	PUSH	CS
	POP	DS
	PUSHF

;	Display the current path

	CALL	SHOW_PATH
	POPF
	JNC	SKIP3
	MOV	DX,OFFSET BAD_PATH_MSG
	CALL	SHOW_STRING
	JMP	TREE7

;	Try to get the first directory
SKIP3:
	CALL	ALLOC_NODE
	MOV	DX,OFFSET SUBDIR_HEADER		; Show header message
	CALL	SHOW_STRING
	MOV	CX,DIR_ATTR
	CALL	GET_FIRST
	JNC	TREE4
	MOV	DX,OFFSET NONE
	CALL	SHOW_STRING
	JMP	TREE4A

;	Print the found directory

TREE4:
	CALL	SHOW_DIR
	MOV	DX,OFFSET SPACES
	CALL	SHOW_STRING
	CALL	GET_NEXT
	JNC	TREE4

	MOV	DX,OFFSET CRLF
	CALL	SHOW_STRING
	CALL	SHOW_STRING

;	Show files

TREE4A:
	CMP	FSWITCH,FALSE
	JE	TREE5
	CALL	DISP_FILES

;	Search for the first subdirectory

TREE5:
	MOV	CX,DIR_ATTR
	CALL	GET_FIRST
	JNC	TREE2

;	Check for last node

TREE6:
	CALL	DEALLOC_NODE
	CMP	HEAD,0
	JZ	TREE_EXIT

;	Change directory to the parent node and deallocate the node

	MOV	DX,OFFSET PARENT
	MOV	AH,DOSF_CHDIR
	INT	21H
	JC	BAD_PATH

;	Check for next dir

TREE7:
	CALL	GET_NEXT
	JC	TREE6
	JMP	TREE2

;	All done, free up memory

TREE_EXIT:
	PUSH	HEAD
TE1:
	POP	AX
	OR	AX,AX
	JZ	TE2
	MOV	ES,AX
	MOV	AX,ES:[LINK_SEGMENT]
	PUSH	AX
	MOV	AH,DOSF_DEALLOC
	INT	DOSI_FUNC
	JMP	TE1

;	Select original directory and original drive.
;	Note this is also control C entry point, be careful of segment regs

TE2:
	PUSH	CS
	POP	DS
	MOV	DX,OFFSET CURRENT_DIR
	MOV	AH,DOSF_CHDIR
	INT	DOSI_FUNC
	JC	BAD_PATH

	MOV	DL,DEFAULT_DISK
	MOV	AH,DOSF_SELDISK
	INT	DOSI_FUNC

	INT	DOSI_TERM


NO_DIRS_ERROR:
	MOV	DX,OFFSET NO_DIRS_MSG
	CALL	SHOW_STRING
	JMP	TREE_EXIT

BAD_PATH:
	MOV	DX,OFFSET BAD_PATH_MSG
	CALL	SHOW_STRING
	JMP	TREE_EXIT

;	GET_FIRST - This routine will return the first match
;
;	ENTRY - CX has attribute to search for
;		DMA address is set
;	EXIT -	DMA address has find structure
;
GET_FIRST	PROC	NEAR

;	Search for first

	MOV	AH,DOSF_FFIRST
	MOV	DX,OFFSET MATCH_ALL
GFD1:
	INT	DOSI_FUNC
	JC	GFD_EXIT		; If no match exit
	MOV	AX,ES:TAIL		; Prepare for checking if match
	MOV	DS,AX
	CMP	CX,10H			; Check if looking for directories
	JNZ	GFD2
	CALL	CHECK_DOT		; Check for . and .. entries
	JZ	GFD3

;	Check if finding a file

GFD2:
	CMP	CL,FILE_ATTR
	JNZ	GFD2A
	TEST	BYTE PTR DS:[FOUND_ATTR],DIR_ATTR+LABEL_ATTR
	JZ	GFD_EXIT
	JMP	SHORT GFD3

GFD2A:
	CMP	DS:[FOUND_ATTR],CL
	PUSH	CS
	POP	DS
	JZ	GFD_EXIT		; Exit if directory

;	Search for next match

GFD3:
	MOV	AH,DOSF_FNEXT
	JMP	GFD1

GFD_EXIT:
	PUSH	CS
	POP	DS
	RET

GET_FIRST	ENDP

;	CHECK_DOT - This routine will check for a . entry or a .. entry
;		    to skip in find directory calls.
;
;	ENTRY:	DS points to NODE structure
;
;	EXIT:	'Z' set, dir is . or ..
;		'Z' clear dir is good
CHECK_DOT	PROC	NEAR

	PUSH	SI
	PUSH	DI
	PUSH	CX
	MOV	SI,FOUND_NAME
	MOV	DI,OFFSET DOT
	MOV	CX,LENDOT
	CLD
	REP	CMPSB
	JZ	CD_EXIT
	MOV	SI,FOUND_NAME
	MOV	DI,OFFSET DOTDOT
	MOV	CX,LENDOTDOT
	REP	CMPSB
CD_EXIT:
	POP	CX
	POP	DI
	POP	SI
	RET

CHECK_DOT	ENDP


;GET_NEXT - This routine will get the next file match
;
;	ENTRY:	DMA address has previous match
;
;	EXIT:	'C' clear, DMA address has next match
;		'C' set, No match
GET_NEXT	PROC	NEAR

	MOV	AX,TAIL
	MOV	DS,AX
	MOV	CL,DS:[FOUND_ATTR]
	SUB	CH,CH

GN1:
	MOV	AH,DOSF_FNEXT
	INT	DOSI_FUNC
	JC	GND_EXIT

;	Check if looking for files

	CMP	CL,FILE_ATTR
	JNZ	GN2
	TEST	BYTE PTR DS:[FOUND_ATTR],DIR_ATTR+LABEL_ATTR
	JZ	GND_EXIT		
	JMP	SHORT GN1

;	Match a directory or label

GN2:	
	CMP	DS:[FOUND_ATTR],CL
	JNZ	GN1			; Exit if directory

GND_EXIT:
	PUSH	CS
	POP	DS
	RET

GET_NEXT	ENDP

;	ALLOC_NODE - This routine links a new node (representing
;		a level in the tree) to the list. It accomplishes
;		the following:
;
;		Entry:	None
;		Exit:	CY set, memory could not be allocated
;			CY clear, new node linked to list,
;			 and DMA address is set to new node.
;
ALLOC_NODE	PROC	NEAR

	PUSH	AX
	PUSH	BX
	PUSH	DX
	PUSH	DS

;	Request memory

	MOV	BX,MEM_REQ
	MOV	AH,DOSF_ALLOC
	INT	21H
	JC	AN_EXIT

;	Prepare the node for useage

	MOV	TAIL,AX			; This node is the new tail
	MOV	DX,SEARCH_ATTR
	MOV	DS,AX
	MOV	AH,DOSF_SDIOA		; This node is the new DMA
	INT	DOSI_FUNC
	MOV	DS:[LINK_SEGMENT],0	; This node points to NULL

;	Locate the tail of the linked list

	MOV	AX,ES:HEAD
AN1:
	OR	AX,AX
	JZ	AN2
	MOV	DS,AX
	MOV	AX,DS:[LINK_SEGMENT]
	JMP	AN1

;	Have found end of linked list at this point
;	DS -> last node, 

AN2:
	MOV	AX,ES:TAIL	; Prepare to link
	CMP	ES:HEAD,0	; See if at begining of list
	JNZ	AN3
	MOV	ES:HEAD,AX
	JMP	AN4
AN3:
	MOV	DS:[LINK_SEGMENT],AX

AN4:
	POP	DS
	POP	DX
	POP	BX
	POP	AX
	CLC
AN_EXIT:
	RET

ALLOC_NODE	ENDP


;	DEALLOC_NODE - Deallocate memory assigned to a node
;
DEALLOC_NODE	PROC	NEAR

;	Locate the previous to last node in the linked list

	MOV	AX,HEAD			; Get the head of the list
	MOV	BX,0			; previous node is null
DN1:
	CMP	AX,ES:TAIL		; Check for end of list
	JZ	DN2
	MOV	BX,AX			; Save previous link
	MOV	DS,AX			; Get next link
	MOV	AX,DS:[LINK_SEGMENT]
	JMP	DN1

;	AX -> last node, BX -> previous node
DN2:
	PUSH	AX			; Save last node address
	CMP	BX,0			; Are we at head of list
	JNZ	DN3			; No unlink in the middle
	MOV	ES:HEAD,0		; Yes unlink at the front
	MOV	ES:TAIL,0
	JMP	DN4
DN3:
	MOV	DS:[LINK_SEGMENT],0
	MOV	ES:TAIL,BX
DN4:
	MOV	DX,SEARCH_ATTR
	MOV	AH,DOSF_SDIOA
	INT	DOSI_FUNC
	POP	ES			; Restore last node address and
	MOV	AH,DOSF_DEALLOC		; Deallocate it
	INT	DOSI_FUNC
	MOV	AX,CS
	MOV	DS,AX
	MOV	ES,AX
	RET

DEALLOC_NODE	ENDP

;	GET_SWITCH_CHAR - Get the current switch character and also set
;			  the new path character
;
GET_SWITCH_CHAR	PROC	NEAR

	MOV	AH,DOSF_CHROP
	MOV	AL,0
	INT	DOSI_FUNC
	CMP	DL,'/'
	JZ	SWC_EXIT
	MOV	SWITCH_CHAR,DL
	MOV	PATH_CHAR,'/'

SWC_EXIT:
	RET

GET_SWITCH_CHAR	ENDP	


;	SHOW_PATH - Print a pathname to STDOUT by following
;		the linked list of directories.
;
SHOW_PATH	PROC	NEAR

	MOV	DX,OFFSET CRLF
	CALL	SHOW_STRING

	MOV	DX,OFFSET PATH_HEADER	; Print path message
	CALL	SHOW_STRING

	MOV	AX,HEAD			; Start at head of linked list
SP1:
	PUSH	AX
	PUSH	CS
	POP	DS
	MOV	DX,OFFSET PATH_CHAR	; Print the path seperator
	MOV	CX,1
	MOV	BX,STDOUT
	MOV	AH,DOSF_WRITEH
	INT	DOSI_FUNC
	POP	DS
	
	MOV	DX,FOUND_NAME		; Print first directory name
	CALL	SHOW_STRING

	MOV	AX,DS:[LINK_SEGMENT]	; Get the next directory
	OR	AX,AX			; Is there one
	JNZ	SP1			; Yes, print it

	PUSH	CS			; No exit
	POP	DS
	MOV	DX,OFFSET CRLF
	CALL	SHOW_STRING
	CALL	SHOW_STRING
	RET

SHOW_PATH	ENDP

;	SHOW_DIR - Print the directory name to STDOUT
SHOW_DIR	PROC	NEAR

	MOV	DS,TAIL			; TAIL points to the found directory
	MOV	DX,FOUND_NAME
	CALL	SHOW_STRING

	PUSH	CS
	POP	DS
	MOV	DX,OFFSET CRLF
	CALL	SHOW_STRING
	RET

SHOW_DIR	ENDP

;	SHOW_STRING - This routine displays a null terminated string
;		to STDOUT
;
SHOW_STRING	PROC	NEAR

	PUSH	AX
	PUSH	SI
	PUSH	CX

;	Determine the length of the string

	MOV	SI,DX
	MOV	CX,-1
	CLD
SD1:
	INC	CX
	LODSB
	OR	AL,AL
	JNZ	SD1

;	Print the string

	MOV	BX,STDOUT
	MOV	AH,DOSF_WRITEH
	INT	DOSI_FUNC
	POP	CX
	POP	SI
	POP	AX

	RET

SHOW_STRING	ENDP

;	GET_DRIVE - Get the current drive and select the new one
;
GET_DRIVE	PROC	NEAR

;	Save the old drive

	MOV	AH,DOSF_GETDISK
	INT	DOSI_FUNC
	MOV	DEFAULT_DISK,AL

	MOV	DL,DS:[5CH]
	OR	DL,DL
	JZ	GD_EXIT

;	Select the new drive

	DEC	DL
	MOV	AH,DOSF_SELDISK
	INT	DOSI_FUNC	

GD_EXIT:
	RET

GET_DRIVE	ENDP

;	VOL_NAME - Display the volume name
;
VOL_NAME	PROC	NEAR

	MOV	DX,OFFSET TREE_HEADER
	CALL	SHOW_STRING
	CALL	ALLOC_NODE

	MOV	CX,LABEL_ATTR
	CALL	GET_FIRST
	JC	VN1
	MOV	DX,TAIL
	MOV	DS,DX
	MOV	DX,FOUND_NAME
	CALL	SHOW_STRING
	PUSH	CS
	POP	DS
	JMP	SHORT VN2

VN1:
	MOV	DX,OFFSET NO_VOL
	CALL	SHOW_STRING

VN2:
	CALL	DEALLOC_NODE
	MOV	DX,OFFSET CRLF
	CALL	SHOW_STRING
	CALL	SHOW_STRING
	RET

VOL_NAME	ENDP

;	DISP_FILES - Display found filenames on STDOUT
;
DISP_FILES	PROC	NEAR
	MOV	DX,OFFSET FILES_HEADER		; Print the file header
	CALL	SHOW_STRING
	MOV	CX,FILE_ATTR			; Search for files
	CALL	GET_FIRST
	JNC	DF1				; Any? Yes, continue
	MOV	DX,OFFSET NONE			; No, print none
	CALL	SHOW_STRING
	JMP	DF3

;	Print found name and get next one

DF1:
	MOV	DX,TAIL
	MOV	DS,DX
	MOV	DX,FOUND_NAME
	CALL	SHOW_STRING
	PUSH	CS
	POP	DS
	MOV	DX,OFFSET CRLF
	CALL	SHOW_STRING
	MOV	DX,OFFSET SPACES
	CALL	SHOW_STRING
	CALL	GET_NEXT
	JNC	DF1
DF2:
	MOV	DX,OFFSET CRLF
	CALL	SHOW_STRING
	CALL	SHOW_STRING
DF3:
	RET

DISP_FILES	ENDP


;	SCAN - Scan the command line for switches
;
SCAN	PROC	NEAR

	MOV	SI,080H
	CLD
	LODSB				; Get the count of chars. in command line
	MOV	CL,AL
	SUB	CH,CH
	JCXZ	SCAN_EXIT		; Exit if none

;	Check for help screen

	CALL	SKIP_WHITE
	CMP	WORD PTR [SI], 0DH*256+'?'	; Is it a single question mark?
	JNZ	SCAN0				; No, continue
	MOV	DX,OFFSET SIGN1			; Yes, help the user
	CALL	SHOW_STRING
	MOV	DX,OFFSET VERSION
	CALL	SHOW_STRING
	MOV	DX,OFFSET SIGN2
	CALL	SHOW_STRING
	MOV	DX,OFFSET HELP
	CALL	SHOW_STRING
	INT	DOSI_TERM

SCAN0:
	MOV	DI,SI
	MOV	AL,SWITCH_CHAR		; Scan across for the switch character
	REPNZ	SCASB
	MOV	SI,DI
	JNZ	SCAN_EXIT		; Exit if no switch character found
	JCXZ	SCAN_ERROR		; Error if char found but no switch

;	Get the switch and dispatch it

	LODSB
	CALL	MAP_UPPER

;	Check for F switch

	CMP	AL,'F'
	JNZ	SCAN1
	MOV	FSWITCH,TRUE		; Flag F switch seen
	JMP	SHORT SCAN_EXIT

SCAN1:

;	Error, improper switch specified

SCAN_ERROR:
	MOV	DX,OFFSET PARM_MSG
	CALL	SHOW_STRING
	INT	DOSI_TERM
SCAN_EXIT:
	RET

SCAN	ENDP

SKIP_WHITE	PROC	NEAR

	CMP	BYTE PTR [SI],CC_CR
	JZ	SW_EXIT

	CMP	BYTE PTR [SI],' '
	JZ	SW1
	CMP	BYTE PTR [SI],CC_HT
	JNZ	SW_EXIT
SW1:
	INC	SI
	JMP	SKIP_WHITE

SW_EXIT:
	RET

SKIP_WHITE	ENDP


;	MAP_UPPER - Map lower case to upper case
MAP_UPPER	PROC	NEAR

	CMP	AL,'a'
	JB	MU_EXIT
	CMP	AL,'z'
	JA	MU_EXIT
	ADD	AL,'A'-'a'
MU_EXIT:
	RET

MAP_UPPER	ENDP

TREE_END	=	OFFSET $
TREE_SIZE	=	((TREE_END-ZERO)+15) SHR 4

CODE	ENDS
	END	TREE
