/*
		RESTRICTED RIGHTS LEGEND
		------------------------
	
	    "Use, duplication, or disclosure by the
	Government is subject to restrictions as set forth
	in paragraph (b) (3) (B) of the Rights in Technical
	Data and Computer Software clause in DAR
	7-104.9(a).  Contractor/manufacturer is Zenith
	Data Systems Corporation of Hilltop Road, St.
	Joseph, Michigan 49085.

*/
/*
    These are the structure and miscelaneous definitions needed
    for BACKUP/RESTORE. They are contained in the file BRSTRUCT.H

    Version 2.00 - Update all utils to V2.0
    Version 2.01 - Link new Z150FMT.OBJ, fix bug in opening drive door
    Version 2.02 - Fix problem with version checking
    Version 2.03 - 5/11/84 Z150FMT.ASM fixed for partitions with bad sectors
    Version 2.04 - 5/14/84 ZLOAD.ASM changed to allow larger head settle time
		   for Shugart drives.
    Version 2.05 - 9/4/84 Change for prompting the user in abort situations
    Version 2.06 - 10/13/84 Corrected problem in Z150FMT.ASM which caused
		   double sided floppies to be verified as single sided.
    Version 2.07 - 10/18/84 Corrected problem in Z150FMT.ASM which caused
		   bad sectors on winchesters to be reported as one greater
		   than they really were.
    Version 2.08 - 10/23/84 Corrected problem in Z150FMT.ASM which caused
		   "Format Failure" when the format module was loaded in
		   certain memory locations near 64kb boundries.
*/
#define TRUE	  1
#define FALSE	  0

/* Flags for signons, only one should be true */
#define	ZENITH	TRUE
#define	NBI	FALSE

#define VERSION 2.01	/* version # */
#define RELEASE 2.08	/* release # */

/* This structure represents a MS-DOS extended fcb */
struct ext_fcb
{
    char extend;		/* extended flag */
    char zero[5];		/* zero field */
    char attr;			/* attributes */
    char drive;			/* drive number */
    char name[8];		/* file name */
    char ext[3];		/* file extention */
    unsigned extent;		/* extent counter */
    unsigned rec_size;		/* record size */
    long fsize;			/* file size */
    unsigned date;		/* last mod. date */
    unsigned time;		/* last mod. time */
    char res1[8];		/* 8 MS-DOS reserved */
    char cur_rec;		/* current record */
    long ranrec;		/* random record field */
};

/*
    This structure represents what is returned from the BDOS search
    routines. It resembles a directory entry and the definitions
    of the fields are the same as above
*/
struct search_fcb
{
    char extend;
    char zero[5];
    char attr1;
    char drive;
    char name[8];
    char ext[3];
    char attr2;
    char res1[10];
    unsigned time;
    unsigned date;
    unsigned fau;		/* first allocation unit */
    long fsize;
};
    
/* This structure is a main entry for the backup/restore file */
struct br_entry 
{
    char id;		/* id byte defined below */
    struct ext_fcb fcb;	/* fcb */
    unsigned num_files;	/* number of files contained in this backup */
    unsigned num_dirs;	/* number of directories (MS-DOS 2.0) */
    char pswd[7];	/* coded password */
    char release;	/* release of backup/restore that made entry */
    char version;	/* version of backup/restore that made entry */
    char res2[6];	/* reserved */
};

/* this structure defines a pathname entry (MS-DOS 2.0) */
struct path_entry 
{
    char id;		/* id byte */
    struct ext_fcb fcb;	/* fcb containing path info. */
    char res2[4];	/* reserved */
    char pswd[7];	/* coded password */
    char res3[8];	/* reserved */
};

/* This structure defines a file entry */
struct file_entry 
{
    char id;		/* id byte */
    struct ext_fcb fcb;	/* fcb */
    char s_vol;		/* start volume */
    char e_vol;		/* end volume */
    long s_pos;		/* starting position in start volume */
    long length;	/* length of file */
    char level;		/* level of directory nesting */
    char res2[8];	/* reserved */
};

/* This structure is used for building a directory of files */
struct link_file
{
    struct link_file *link;	/* link to next directory entry */
    char id;			/* id of entry */
    char attr;			/* attributes of fcb */
    char drive;			/* drive number */
    char name[8];		/* name of file */
    char ext[3];		/* extention of file */
    unsigned date;		/* date of file */
    char s_vol;			/* start volume of file */
    char e_vol;			/* end volume of file */
    long s_pos;			/* start position of file */
    long length;		/* length of file */
    char level;			/* level of directory Z-DOS 2.0 */
    char res[8];		/* reserved */
};

/*           ID byte values          */

#define bf_pp     0       /* backup file password protected       */
#define bf_npp    1       /* backup file not password protected   */
#define pth_pp    0       /* pathname node password protected     */
#define pth_npp   1       /* pathname node not password protected */
#define bf	  2       /* backup file entry			  */
#define bfc	  3       /* backup file with text compression    */
#define pth       4	  /* pathname node entry		  */
#define attr_dir  0x10	  /* Attribute bit for DIRECTORY entry	  */
#define attr_arc  0x20	  /* Attribute bit for ARCHIVE entry	  */
#define last_ent  0xff    /* last entry 			  */

#define OK	  TRUE
#define ERROR	  FALSE

/*  buffer for command input  */

#define COMLEN	  130	/* length of command buffer */
struct buffer
{
    char buf_len;	/* buffer length (COMLEN-2) */
    char str_len;	/* returned string length   */
    char buf[COMLEN];	/* character buffer	    */
};

/*  define the number of switches and their values  */

#define NUM_SW	  23
#define A	  0	/*  Operate on files after date 	 */
#define B	  1	/*  Operate on files before date 	 */
#define C	  2	/*  Compression of ASCII files 		 */
#define D	  3	/*  Backup file directory  		 */
#define E	  4	/*  Exception processing 		 */
#define F	  5	/*  Format w/o query 			 */
#define G	  6	/*  Global (all subdirectories)		 */
#define I	  8	/*  Include sub-directories in operation */
#define K	  10	/*  Delete files after backup 		 */
#define L	  11	/*  Backup file listing 		 */
#define M	  12	/*  Map drives 				 */
#define N	  13	/*  Do not format 			 */
#define O	  14	/*  Overwrite files 			 */
#define P	  15	/*  Password protection 		 */
#define Q	  16	/*  Query on this operation 		 */
#define R 	  17	/*  Show status 			 */
#define S	  18	/*  backup hidden and system files 	 */
#define T	  19	/*  Operate on files with todays date 	 */
#define V	  21	/*  Verify 				 */
#define W	  22	/*  Only files written since last backup */

/*  Number of parameters to delimit  */

#define NUM_PAR	3

/*  Some necessary BDOS function numbers  */

#define PUT_CHAR	0x2
#define SEL_DISK	0xe
#define FILE_OPEN	0xf
#define FILE_CLOSE	0x10
#define SRCH_FIRST	0x11
#define SRCH_NEXT	0x12
#define FILE_DELETE	0x13
#define FILE_CREATE	0x16
#define CUR_DISK	0x19
#define SET_DMA		0x1a

#define BUF_SIZ	512	/* input and output buffer size */

#define DATE_SIZE   9	/* size of a date string */
#define FNAME_SIZE 15	/* size of a file name string */

