
.xlist
	INCLUDE	..\ROM\ROM.LIT
	INCLUDE	..\VIDEO\VIDEO.LIT
.list

rom_data	segment	at	040h
	ORG	49H
VIDEO_MODE	DB	?
	org	50h
CURSOR_POSITION	DW	?
	ORG	62H
DISPLAYED_PAGE	DB	?
rom_data	ends


color_mask	equ	77h

code	segment	byte
	assume	cs:code

	org	100h

start:
	jmp	start1

cursor_count		db	0


OLD_CURSOR_POSITION	DW	?

OLD_CURSOR_DATA		DW	?

OLD_VIDEO_MODE		DB	0FFH

OLD_DISPLAYED_PAGE	DB	0FFH


CSR_ON			EQU	1
CURSOR_FLAG		DB	0


CURSOR_LOCKED		DB	FALSE


old_timer_intr		dd	?
old_video_intr		dd	?


VIDEO	PROC	FAR
	MOV	CURSOR_LOCKED,TRUE
	PUSHF
	PUSHREG	<AX,BX,SI,DS,ES>

	MOV	AL,OLD_VIDEO_MODE
	SUB	AL,3
	CMP	AL,4
	JAE	V1
	SUB	AH,AH
	SHL	AX,1
	MOV	SI,AX
	CALL	TURN_CURSOR_OFF
V1:
	POPREG	<ES,DS,SI,BX,AX>
	POPF	

	PUSHF
	CALL	OLD_VIDEO_INTR
	MOV	CURSOR_LOCKED,FALSE
	IRET
VIDEO	ENDP





CURSOR_FUNCTIONS	LABEL	WORD
	DW	OFFSET ALPHA_MODE
	DW	OFFSET G320X200
	DW	OFFSET G320X200
	DW	OFFSET G640X200
NUM_CURSOR_FUNCTIONS	EQU	($-CURSOR_FUNCTIONS)/2


CURSOR_PROC	PROC	FAR
;	Is the cursor locked from update

	CMP	CURSOR_LOCKED,TRUE
	JZ	CURSOR_EXIT

	PUSHREG	<AX,BX,SI,DS,ES>

;	Dispatch according to video mode

	MOV	AX,ROM_DATA
	MOV	DS,AX
	ASSUME	DS:ROM_DATA
	MOV	AL,VIDEO_MODE
	SUB	AL,3
	CMP	AL,NUM_CURSOR_FUNCTIONS
	JAE	C2
	SUB	AH,AH
	SHL	AX,1
	MOV	SI,AX
	MOV	AL,VIDEO_MODE
	CMP	AL,OLD_VIDEO_MODE
	JNZ	C1
	CALL	CURSOR_FUNCTIONS[SI]
	JMP	SHORT C2

C1:
	CALL	PREPARE_NEW_CURSOR
	MOV	CURSOR_COUNT,0
C2:
	POPREG	<ES,DS,SI,BX,AX>
CURSOR_EXIT:
	JMP	OLD_TIMER_INTR


CURSOR_PROC	ENDP




ALPHA_MODE:

	ASSUME	DS:ROM_DATA

;	Did the displayed page change?

	MOV	AL,DISPLAYED_PAGE
	CMP	AL,OLD_DISPLAYED_PAGE
	JNZ	AM1

;	Update the cursor

G320X200:
G640X200:
	CALL	UPDATE_CURSOR
	RET

;	Mode changed or displayed page changed,
;	restore old data and prepare for new cursor.

AM1:
	PUSH	AX
	CALL	TURN_CURSOR_OFF
	POP	AX
	MOV	OLD_DISPLAYED_PAGE,AL
	CALL	PREPARE_NEW_CURSOR
	MOV	CURSOR_COUNT,0
	RET




;	UPDATE_CURSOR - This routine will update the cursor as
;		needed according to the counts.
;
;	ENTRY:	DS - ROM_DATA
;		SI - Index to routine [(VIDEO_MODE - 3) * 2]
;
UPDATE_CURSOR	PROC	NEAR

	MOV	AX,CURSOR_POSITION	; Has the cursor changed?
	CMP	AX,OLD_CURSOR_POSITION
	JZ	UC1

;	AX has new cursor position

	PUSH	AX
	CALL	TURN_CURSOR_OFF		; Replace data, save new data, update old_cursor
	POP	AX
	MOV	CURSOR_COUNT,0
	CALL	PREPARE_NEW_CURSOR
UC1:
	INC	CURSOR_COUNT
	CMP	CURSOR_COUNT,CURSOR_ON_TIME
	JB	UC3
	JA	UC2
	CALL	TURN_CURSOR_ON
UC2:
	CMP	CURSOR_COUNT,CURSOR_OFF_TIME
	JBE	UC3

	CALL	TURN_CURSOR_OFF
	MOV	CURSOR_COUNT,0
UC3:
	RET

UPDATE_CURSOR	ENDP





TC_ON_FUNCTIONS	LABEL	WORD
	DW	OFFSET TC_ON_ALPHA
	DW	OFFSET TC_ON_G320X200
	DW	OFFSET TC_ON_G320X200
	DW	OFFSET TC_ON_G640X200

TURN_CURSOR_ON	PROC	NEAR
	OR	CURSOR_FLAG,CSR_ON
	CALL	INDEX
	JMP	TC_ON_FUNCTIONS[SI]

TC_ON_ALPHA:
	MOV	AL,ES:[BX+1]
	MOV	AH,AL
	AND	AL,NOT COLOR_MASK
	AND	AH,COLOR_MASK
	ROR	AH,1
	ROR	AH,1
	ROR	AH,1
	ROR	AH,1
	OR	AL,AH
	MOV	ES:[BX+1],AL
	RET	

TC_ON_G320X200:
	MOV	WORD PTR ES:[BX+SCREEN_PARTITION_OFS+3*SCAN_LINE_INCREMENT],CURSOR SHL 8 + CURSOR
	RET

TC_ON_G640X200:
	MOV	BYTE PTR ES:[BX+SCREEN_PARTITION_OFS+3*SCAN_LINE_INCREMENT],CURSOR
	RET

TURN_CURSOR_ON	ENDP



TC_OFF_FUNCTIONS	LABEL	WORD
	DW	OFFSET TC_OFF_ALPHA
	DW	OFFSET TC_OFF_G320X200
	DW	OFFSET TC_OFF_G320X200
	DW	OFFSET TC_OFF_G640X200

TURN_CURSOR_OFF	PROC	NEAR
	TEST	CURSOR_FLAG,CSR_ON	; Is the cursor already off?
	JZ	TCO_EXIT		; Yes, do not do anything
	AND	CURSOR_FLAG,NOT CSR_ON	; Show cursor is off
	CALL	INDEX
	JMP	TC_OFF_FUNCTIONS[SI]
TCO_EXIT:
	RET


TC_OFF_ALPHA:
	MOV	AL,ES:[BX+1]
	AND	AL,NOT COLOR_MASK
	MOV	AH,BYTE PTR OLD_CURSOR_DATA
	AND	AH,COLOR_MASK
	OR	AL,AH
	MOV	ES:[BX+1],AL
	RET	

TC_OFF_G320X200:
	MOV	AX,OLD_CURSOR_DATA
	MOV	ES:[BX+SCREEN_PARTITION_OFS+3*SCAN_LINE_INCREMENT],AX
	RET

TC_OFF_G640X200:
	MOV	AL,BYTE PTR OLD_CURSOR_DATA
	MOV	ES:[BX+SCREEN_PARTITION_OFS+3*SCAN_LINE_INCREMENT],AL
	RET

TURN_CURSOR_OFF	ENDP


INDEX_FUNCTIONS	LABEL	WORD
	DW	OFFSET INDEX_ALPHA
	DW	OFFSET INDEX_G320X200
	DW	OFFSET INDEX_G320X200
	DW	OFFSET INDEX_G640X200

INDEX	PROC	NEAR
	MOV	AX,OLD_CURSOR_POSITION
	JMP	INDEX_FUNCTIONS[SI]

INDEX_ALPHA:
	MOV	BL,AL			; Save number of columns
	MOV	AL,AH			; Get number of rows
	MOV	AH,80*2			; Times bytes per row
	MUL	AH
	SUB	BH,BH			; Number of columns times 2
	SHL	BX,1
	ADD	BX,AX			; Gives offset from page start to character
	MOV	AL,DISPLAYED_PAGE	; Determine offset of page
	SUB	AH,AH			; Get displayed page in AX
	PUSH	DX
	MOV	DX,SCREEN_BYTES/4	; Times size of a page
	MUL	DX
	POP	DX
	ADD	BX,AX			; Add into offset to get actual address of character
	MOV	AX,0B800H		; Return full pointer to character in ES:BX
	MOV	ES,AX
	RET

INDEX_G320X200:
	MOV	BL,AL
	SUB	BH,BH
	SHL	BX,1
	JMP	SHORT INDEX_G
INDEX_G640X200:
	MOV	BL,AL
	SUB	BH,BH
INDEX_G:
	MOV	AL,AH
	SUB	AH,AH
	PUSH	DX
	MOV	DX,SCAN_LINE_INCREMENT*4
	MUL	DX
	POP	DX
	ADD	BX,AX
	MOV	AX,0B800H
	MOV	ES,AX
	RET

INDEX	ENDP



PNC_FUNCTIONS	LABEL	WORD
	DW	OFFSET PNC_ALPHA
	DW	OFFSET PNC_G320X200
	DW	OFFSET PNC_G320X200
	DW	OFFSET PNC_G640X200

PREPARE_NEW_CURSOR	PROC	NEAR
	MOV	AL,VIDEO_MODE
	MOV	OLD_VIDEO_MODE,AL
	JMP	PNC_FUNCTIONS[SI]

PNC_ALPHA:
	MOV	BL,DISPLAYED_PAGE
	SUB	BH,BH
	SHL	BX,1
	MOV	AX,CURSOR_POSITION[BX]
	MOV	OLD_CURSOR_POSITION,AX
	CALL	INDEX
	MOV	AL,ES:[BX+1]
	MOV	BYTE PTR OLD_CURSOR_DATA,AL
	RET

PNC_G320X200:
	MOV	AX,CURSOR_POSITION
	MOV	OLD_CURSOR_POSITION,AX
	CALL	INDEX
	MOV	AX,ES:[BX+SCREEN_PARTITION_OFS+3*SCAN_LINE_INCREMENT]
	MOV	OLD_CURSOR_DATA,AX
	JMP	SHORT PNC_G

PNC_G640X200:
	MOV	AX,CURSOR_POSITION
	MOV	OLD_CURSOR_POSITION,AX
	CALL	INDEX
	MOV	AL,ES:[BX+SCREEN_PARTITION_OFS+3*SCAN_LINE_INCREMENT]
	MOV	BYTE PTR OLD_CURSOR_DATA,AL
PNC_G:
	MOV	AX,CURSOR_POSITION
	MOV	OLD_CURSOR_POSITION,AX
	RET

PREPARE_NEW_CURSOR	ENDP



	assume	cs:code, ds:code, es:code, ss:code


start1:

;	Install the timer tick interrupt vector

	mov	di,01ch shl 2
	sub	ax,ax
	mov	es,ax

	mov	ax,es:[di]
	mov	word ptr old_timer_intr,ax
	mov	ax,es:[di+2]
	mov	word ptr old_timer_intr+2,ax

	mov	ax,offset cursor_proc
	cld
	cli
	stosw
	mov	ax,cs
	stosw
	sti

;	Do the video_intr

	mov	di,10h shl 2
	mov	ax,es:[di]
	mov	word ptr old_video_intr,ax
	mov	ax,es:[di+2]
	mov	word ptr old_video_intr+2,ax

	mov	ax,offset video
	stosw
	mov	ax,cs
	stosw


;	Terminate and remain resident

	mov	dx,offset start1
	int	27h

code	ends
	end	start
