	PAGE	,132
	TITLE	Z-150 Firmware Variable Definitions

;**********************************************************************
;
;                       --------------------------
;----------------------- Z-150 Firmware Variables ----------------------
;			--------------------------
;
;		Copyright (C) 1983, by Zenith Data Systems
;
;**********************************************************************

	ASSUME	CS:MONITOR_SEGMENT, DS:ROM_DATA, ES:NOTHING

INTERRUPT_SEGMENT SEGMENT AT (00H)
INTERRUPT_SEGMENT ENDS

	INCLUDE ROM.LIT
	INCLUDE INTR.LIT
	INCLUDE	../VIDEO/VIDEO.LIT
	INCLUDE	../DISK/DISK.LIT
	INCLUDE	../KEYBOARD/KEYBOARD.LIT
	INCLUDE	../SYS/SYS.LIT
	INCLUDE	../DEBUG/DEBUG.LIT

	PUBLIC	SERIAL_TABLE, PRINTER_TABLE, IO_CONFIG, EXT_TEST, MEMORY_SIZE
	PUBLIC	SHIFT_STATUS, LOCK_STATUS, INPUT_VALUE, LAST_KEY, KEY_BUFF
	PUBLIC	RECAL_STATUS, DRIVE_STATUS, DRIVE_MOTOR_COUNT, DISK_STATUS
	PUBLIC	DISK, VIDEO_MODE, NUMBER_OF_COLUMNS, PAGE_SIZE, CRT_START_ADDRESS
	PUBLIC	CURSOR_POSITION, CURSOR_STYLE, DISPLAYED_PAGE, VIDEO_BASE
	PUBLIC	VIDEO_HW_MODE, CURRENT_COLORS, EXT_ROM_INIT, EXT_INTR_FLAG
	PUBLIC	TOD, BREAK_FLAG, RESET_FLAG, PRINTER_TIME_OUT
	PUBLIC	SERIAL_TIME_OUT, KEY_BUFF_START, KEY_BUFF_END, PRINT_SCREEN_STATUS
	PUBLIC	SCROLL_MODE, CURRENT_PAGE, ROW_INCREMENT, COLUMN_INCREMENT
	PUBLIC	NUMBER_OF_PAGES, CURSOR_PTR, PAGE_BASE, PAGE_START, DATA_SEGMENT
	PUBLIC	START_OF_PAGE, END_OF_PAGE, BOOT_DRIVE, CURRENT_DRIVE
	PUBLIC	EOI_FLAG, SCREEN, END_OF_PART, END_OF_SCREEN, BOOT_CODE
	PUBLIC	BOOT_STRING, STACK_TOP, BUS_MEMORY_SIZE, COMMAND_LINE
	PUBLIC	BREAKPOINT_COUNT, TRACE_COUNT, REGISTERS, DISPLAY_PTR
	PUBLIC	STRING_BUFF, BREAKPOINT, LINE_START, MANUFACTURING_BOOT
	PUBLIC	CURSOR_FLAG, CURSOR_TIMER, CURSOR_SAVE, STACK_LEVEL, LOCAL_STACK_TOP
	PUBLIC	CURSOR_ACCESS, KEY_BUFF_SEGMENT, OLD_VIDEO_MODE, RETRY_COUNT
	PUBLIC	WINCHESTER_CMD, WINCHESTER_STAT, WINCHESTER_STATUS
	PUBLIC	WINCHESTER_DRIVES, WINCHESTER_CTRL, WINCHESTER_PORT_OFFSET
	PUBLIC	FEED_KEY, UNASSEMBLE_PTR
	PUBLIC	SEG_, LOC_, NAME_, SRC_, DEST_, CLASS_, OPCODE_, OPERAND_
	PUBLIC	MODVAL_, TYPE_, REG_OFS_, TYPED_, INS_BUFF_, IMM_BUFF_
	PUBLIC	INTR_FLAG_MOD, VIDEO_SEGMENT, CRT_CONTROL
	PUBLIC	NO_BOOT_FLAG, OLD_DISPLAYED_PAGE, LAST_ROW, TEXT_SCREEN_MASK
	PUBLIC	VIDEO_ACTIVE, SUPER_COMPATIBLE, DRIVE_COUNT, BUFF_8087
	PUBLIC	OLD_COLUMNS, DISK_RETRIES, SS_SAVE, SP_SAVE, IP_SAVE

	IF	Z150
MONITOR_SEGMENT SEGMENT WORD PUBLIC
	ELSE
MONITOR_SEGMENT SEGMENT AT (0F000H)
	ENDIF
MONITOR_SEGMENT ENDS

ROM_DATA SEGMENT AT (40H)


;**********************************************************************
;			R O M   V A R I A B L E S
;**********************************************************************
;
; Hardware configuration variables
;
SERIAL_TABLE		DW	4 DUP (?)	;Actual addrs of serial ports
PRINTER_TABLE		DW	4 DUP (?)	;Actual addrs of printers
IO_CONFIG		DW	?		;Power-up I/O configuration
EXT_TEST		DB	?		;External test mode
MEMORY_SIZE		DW	?		;Memory size in K bytes
BUS_MEMORY_SIZE		DW	?		;Memory beyond first 64K
;
; Compatible keyboard variables
;
SHIFT_STATUS		DB	?		;Current shift status
LOCK_STATUS		DB	?		;Current locking-key status
INPUT_VALUE		DB	?		;ALT-nnn code entry storage
KEY_BUFF		KBUFF	<>		;Keyboard buffer and pointers
;
; Compatible disk variables
;
RECAL_STATUS		DB	?		;Drive-recalibrated status
DRIVE_STATUS		DB	?		;Motor-on status of drives
DRIVE_MOTOR_COUNT 	DB	?		;Count-down timer for motor
DISK_STATUS		DB	?		;Status of last disk I/O
WINCHESTER_CMD		EQU	THIS BYTE	;Winchester command string
WINCHESTER_STAT		EQU	THIS BYTE	;Winchester status variables
DISK			DISK_RESULTS <>		;Disk I/O results structure
;
; Compatible video variables
;
VIDEO_MODE		DB	?		;Current CRT mode
NUMBER_OF_COLUMNS	DW	?		;Width of screen in chars
PAGE_SIZE		DW	?		;Number of bytes/page
CRT_START_ADDRESS	DW	?		;Current display start addr
CURSOR_POSITION		DW	8 DUP (?) 	;Cursor posn for current card
CURSOR_STYLE		DW	?		;Current cursor style
DISPLAYED_PAGE		DB	?		;Currently displayed page
VIDEO_BASE		DW	?		;Base addr of CRT controller
VIDEO_HW_MODE		DB	?		;Video hardware mode
CURRENT_COLORS		DB	?		;Storage for color pallette
;
; Pointer to external interface ROM
;
EXT_ROM_INIT		DD	?		;External ROM init routine
EXT_INTR_FLAG		DB	?		;External ROM interrupt flag
;
; System real-time clock variables
;
TOD			TIME	<>		;Current time-of-day
;
; Break/Initialization flags
;
BREAK_FLAG		DB	?		;Break-in-progress flag
RESET_FLAG		DW	?		;Software reset flag
;
; Additional storage for winchester variables
;
WINCHESTER_STATUS	DB	?		;Winchester error status
WINCHESTER_DRIVES	DB	?		;Number of winchester drives
WINCHESTER_CTRL		DB	?		;Control for winchester drives
WINCHESTER_PORT_OFFSET	DB	?		;Offset of winchester controller
;
; Parallel/Serial device driver timeouts
;
PRINTER_TIME_OUT	DB	4 DUP (?)	;Timeouts for parallel ports
SERIAL_TIME_OUT		DB	4 DUP (?)	;Timeouts for serial ports


ROM_DATA ENDS

PRINT_SCREEN_SEG SEGMENT AT (50H)

;
; Print-Screen status byte
;
PRINT_SCREEN_STATUS	DB	?		;Print screen status byte

PRINT_SCREEN_SEG ENDS


;**********************************************************************
;		  E X T E N D E D   V A R I A B L E S
;**********************************************************************
MONITOR_SEGMENT SEGMENT
;
; Extended system variables in monitor RAM
;
ZRESERVED1		DB	?		;Reserved to keep compatible locations
DATA_SEGMENT		DW	?		;Current ROM data segment (can
						;be ROM_DATA or MONITOR_DATA)
;
; Extended video display variables
;
OLD_VIDEO_MODE		DB	?		;Old (current) video mode
SCROLL_MODE		DB	?		;Current scrolling mode
CURRENT_PAGE		DB	?		;Currently active (I/O) page
ROW_INCREMENT		DW	?		;Increment to next row
COLUMN_INCREMENT	DW	?		;Increment to next column
NUMBER_OF_PAGES		DB	?		;Number of pages possible
PAGE_BASE		DW	9 DUP (?) 	;Base address of each page
PAGE_START		DW	9 DUP (?) 	;Start addr of each page
START_OF_PAGE		DW	?		;Start addr of current page
END_OF_PAGE		DW	?		;End address of current page
CURSOR_ACCESS		DB	?		;Flag allowing cursor access
CURSOR_FLAG		DB	?		;Flag - cursor enable/on ctrl
CURSOR_TIMER		DB	?		;Timer for cursor flash
CURSOR_PTR		DW	?		;Pointer to cursor location
CURSOR_SAVE		DB	?		;Save byte for data at cursor
CRT_CONTROL		DB	?		;Value written to CRT ctrl port
VIDEO_SEGMENT		DW	?		;Segment for video I/O
OLD_DISPLAYED_PAGE	DB	?		;Old value of displayed page
LAST_ROW		DB	?		;Last row number on screen
TEXT_SCREEN_MASK	DW	?		;Mask for screen page size
VIDEO_ACTIVE		DB	?		;Scroll-in-progress flag
SUPER_COMPATIBLE	DB	?		;Ultra-compatible (slow) disp flag
OLD_COLUMNS		DB	?		;Old number of columns for POKEs
			DB	12 DUP (?)	;Room for future expansion
;
; 8087 buffer
;
BUFF_8087		DD	?		;Buffer for testing 8087 presence
;
; Extended disk variables in monitor RAM
;
DRIVE_COUNT		DB	?		;Number of floppy drives
DISK_RETRIES		DB	?		;Maximum retries to perform
RETRY_COUNT		DB	?		;Number of disk retries
CURRENT_DRIVE		DB	?		;Drive currently 'on'
BOOT_DRIVE		DB	?		;Drive to boot from
BOOT_STRING		DB	?		;Boot string for mass storage
;
; MFM_150 monitor/debugger variables
;
BREAKPOINT		BRKTAB 	<>		;Breakpoint #1 storage
			BRKTAB	<>		;Breakpoint #2 storage
			BRKTAB	<>		;Breakpoint #3 storage
			BRKTAB	<>		;Breakpoint #4 storage
			BRKTAB	<>		;Breakpoint #5 storage
			BRKTAB	<>		;Breakpoint #6 storage
			BRKTAB	<>		;Breakpoint #7 storage
			BRKTAB	<>		;Breakpoint #8 storage
REGISTERS		REGS	<>		;Register storage
BREAKPOINT_COUNT	DB	?		;Number of active breakpoints
TRACE_COUNT		DW	?		;# times to single-step
INTR_FLAG_MOD		DB	?		;Interrupt status change flag
DISPLAY_PTR		DD	?		;Ptr to next area to display
;
; Reserved locations to keep compatible variable locations later
;
ZRESERVED2		DB	5 DUP (?)
			DB	22 DUP (?)
			DB	8 DUP (?)	;Pad to keyboard variables
;
; Extended keyboard variables in monitor RAM
;
KEY_BUFF_SEGMENT	DW	?		;Segment for keyboard buffer
KEY_BUFF_START		DW	?		;Start offset of keybd buffer
KEY_BUFF_END		DW	?		;End offset of keybd buffer
LAST_KEY		DB	?		;Last key entered
EOI_FLAG		DB	?		;End-of-intr-sent flag
FEED_KEY		DB	?		;Feed key mode flag
;
; Internal Monitor Stack
;
STACK_LEVEL		DB	?		;Stack recursion level counter
SP_SAVE			DW	?		;Monitor stack ptr save
SS_SAVE			DW	?		;Monitor stack segment save
IP_SAVE			DW	?		;Save buffer for return address
LOCAL_STACK		DW	100 DUP (?)	;Internal monitor stack
LOCAL_STACK_TOP		EQU	THIS BYTE	;Top of monitor stack
;
; Search/Fill String Buffer
;
STRING_BUFF		DB	40 DUP (?)	;Maximum amount to fill
;
; Disassembler variables
;
UNASSEMBLE_PTR		DD	?		;Ptr to next area to disasm
SEG_			DW	?		;Segment being disassembled
LOC_			DW	?		;Location being disassembled
NAME_			DW	?		;Instruction name pointer
SRC_			DW	?		;Source operand pointer
DEST_			DW	?		;Dest operand pointer
CLASS_			DW	?		;Class of instruction
OPCODE_			DW	?		;Opcode being disassembled
MODVAL_			DW	?		;Mod/R/M mode value
TYPE_			DW	?		;Type of instruction
REG_OFS_		DW	?		;Offset of register field
TYPED_			DB	?		;Explicit-typing-required flag
INS_BUFF_		DB	32 DUP (?)	;Instruction buffer
OPERAND_		DB	15 DUP (?)	;Operand buffer
IMM_BUFF_		DB	10 DUP (?)	;Immediate parameter buffer
;
; Command line buffer
;
COMMAND_LINE		DB	81 DUP (?)	;Command line input buffer
LINE_START		DB	?		;Start position of cmd line
;
; Auto-boot disable flag
;
NO_BOOT_FLAG		DB	?		;TRUE = No Auto-Boot
;
; Stack buffer
;
STACK			DW	100 DUP (?)	;System (monitor) stack buff
STACK_TOP		EQU	THIS WORD
;
; Pad to fill Code segment to start of ROM memory...
;
ROM_OFS			EQU	NEAR PTR (0FFFFH - ROM_LENGTH + 1)

			ORG	ROM_OFS		;Pad to bottom of ROM
			PUBLIC	ROM_START
ROM_START		EQU	THIS NEAR	;Start of code in ROM

;
; Copyright message at start of ROM
;
			DB	'01/01/85 (C)ZDS CORP'	;Copyright message
			DB	VERSION/10+'0', VERSION MOD 10+'0' ;Version #

MONITOR_SEGMENT ENDS


;**********************************************************************
;	 	   S C R E E N   D E F I N I T I O N
;**********************************************************************
;
; Color video RAM segment
;
SCREEN_SEGMENT SEGMENT AT (0B800H)
SCREEN			DB	(SCREEN_BYTES SHR 1) DUP (?)
END_OF_PART		EQU	$ - 1		;End of graphics partition
			DB	(SCREEN_BYTES SHR 1) DUP (?)
END_OF_SCREEN		EQU	$ - 1		;End of screen RAM
SCREEN_SEGMENT ENDS

;
; Monochrome video RAM segment
;
MONO_SEGMENT SEGMENT AT (0B000H)
MONO_SEGMENT ENDS


;**********************************************************************
;		    D I S K   B O O T   B U F F E R 
;**********************************************************************
INTERRUPT_SEGMENT SEGMENT AT (00H)

		ORG	7C00H		;Absolute disk boot address
BOOT_CODE	EQU	THIS FAR	;Sector buffer for boot

INTERRUPT_SEGMENT ENDS



;**********************************************************************
;	   M A N U F A C T U R I N G   B O O T   B U F F E R
;**********************************************************************
INTERRUPT_SEGMENT SEGMENT AT (00H)

		ORG	500H		;Start of manufacturing boot code
MANUFACTURING_BOOT EQU	THIS FAR	;Manufacturing boot buffer

INTERRUPT_SEGMENT ENDS




	END

