;**********************************************************************
; Z150_COLOR_BAR:
;
;	Z150_Color_Bar displays the color bars present in the
; Z-150 in the 80 x 25 text mode. If the video mode specifies
; the monochrome monitor then no mode switch occurs and the
; command is executed nevertheless.
;
; Input:
;	Z-150 mode
;
; Ouput:
;	Color bars displayed in 80 x 25 mode if color card selected
;	Bars displayed on monochrome card as is
;**********************************************************************
Z150_COLOR_BAR PROC NEAR
	PUBLIC	Z150_COLOR_BAR
	PUSHREG	<AX,BX,CX,DX,SI>
	PUSH	WORD PTR VIDEO_MODE	;Save current video mode
	MOV	AL,3			;Choose 80x25 color
	CMP	VIDEO_MODE,7		;Is the monochrome card selected?
	JNZ	ZCB_0			;No - switch to 80x25 mode
	MOV	AL,7			;Choose monochrome mode
ZCB_0:	MOV	AH,0			;Set video mode function
	INT	VIDEO_IO_INTERRUPT	;Set video mode to 80x25 color
	MOV	BX,0			;Page 0, Foregrd & Backgrd = 0
	MOV	DX,0			;Row = 0
	MOV	AL,REV_VIDEO_BLANK	;Character to be displayed
	MOV	CX,5			;Number of chars for each color
ZCB_1:	MOV	AH,2			;Set cursor position function
	INT	VIDEO_IO_INTERRUPT	;Update cursor position
	MOV	AH,9			;Write character with attributes func
	INT	VIDEO_IO_INTERRUPT	;Display 5 chars of specified color
	ADD	DX,CX			;Update col. pos. (no overflow to DH)
	INC	BL			;Go to next color
	CMP	BL,10H			;Have all colors been displayed?
	JC	ZCB_1			;No - display chars in next color
	MOV	BL,0			;Reset color of character for display
	MOV	DL,BL			;Init column to 0
	INC	DH			;Update row position
	CMP	DH,NUMBER_OF_ROWS/2	;Has half the screen been filled?
	JC	ZCB_1			;No - repeat till done
	POP	CX			;Retrieve old video mode
	CMP	CL,7			;Was the monochrome card the default?
	JZ	ZCB_2			;Yes - no video mode change
	CMP	CL,3			;Was the orig. video mode 80x25 color?
	JZ	ZCB_2			;Yes - no video mode change
	MOV	DH,NUMBER_OF_ROWS-1	;Last row of display
	MOV	DL,0			;Init column position
	MOV	AH,2			;Set cursor position function
	INT	VIDEO_IO_INTERRUPT	;Position cursor on last row (BH=page)
	MOV	SI,OFFSET CONTINUE_MSG	;Pointer to message to be displayed
	CALL	DISP_STRING		;Display the string
	MOV	AH,0			;Read character from keyboard function
	INT	KEYBOARD_IO_INTERRUPT	;Wait till a key is struck
	MOV	AL,CL			;Retrieve old video mode
	MOV	AH,0			;Set video mode function
	INT	VIDEO_IO_INTERRUPT	;Reset video mode to original mode
ZCB_2:	POPREG	<SI,DX,CX,BX,AX>
	RET
Z150_COLOR_BAR ENDP
