Page	60,132
Title	-System Setup program
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 4_Jun_85
;
;
%Out	Setup.asm
page
;----------------------------------------------------------------------
; Equates (21_Apr_85)
;--------------------
;
; Include Files
;--------------
;	Rom.lit				;Basic System Definitions
;	Intr.lit			;Interrupt Codes and Masks
;	Icon.lit			;General Icon Definitions
;
	.xlist
	Include ..\Rom\Rom.lit		;Basic System Definitions
	Include ..\Rom\Intr.lit		;Interrupt Codes and Masks
	Include	..\Icon\Icon.lit	;General Icon Definitions
	.list

page
;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	;External Subroutines
	extrn	R_W_Rtc_Ram:Near	; read/write to rtc chip
	extrn	Put_String_Imm:Near
	extrn	Put_String:Near
	extrn	Drw_Time_DX:near
	extrn	Put_Ascii:near
	extrn	Put_Ascii_word:near
	extrn	Put_String_n:near
	extrn	Put_Chr:near
	extrn	Set_DFlag:near
	extrn	Draw_Vertical: near
	extrn	Draw_Horizontal: near
	extrn	Re_Init: near
	extrn	Flush_Keyboard:Near	;Flush the Keyboard Buffer

	;External Variables in SRam
	extrn	Clock_Second:Byte
	extrn	Clock_Minute:Byte
	extrn	Clock_Hour:Byte
	extrn	Clock_Day:Byte
	extrn	Clock_Month:Byte
	extrn	Clock_Year:Word

	extrn	Disp_Zone:Byte
	extrn	Serial_Setup:Word
	extrn	Modem_Setup:Word
	extrn	System_Setup:Word
	extrn	DFlags:Byte
	extrn	Xor_Flag:Byte
	extrn	Mono_Exist:Byte		; True--> mono card exists in system
	extrn	Modem_Exist:Byte	; True--> serial device at Com2
	extrn	Upd_Mode:Byte  		;function being updated
	extrn	NmDays:Byte		;number of days in month
	extrn	Upd_Cmp:Byte		;compare value for reverse vid

	;External Variables in NovRam
	extrn	NovRam_Setup:Abs
	extrn	N_Serial_Setup:Word
	extrn	N_Modem_Setup:Word
	extrn	N_System_Setup:Word
	extrn	N_Year:Word
	extrn	N_Month:Byte

	; externals in Compatbl
	extrn	Set_Part1: Near
	extrn	Set_Part2: Near

page
;----------------------------------------------------------------------
; Fixed Data Area; (18_May_85)
;-----------------------------
;
ch_tbl	dw	ch_hour			;change table
	dw	ch_minute
	dw	ch_second
	dw	ch_month
	dw	ch_day
	dw	ch_year
	dw	ch_format
	dw	ch_zone
	dw	ch_display
	dw	ch_timeout
	dw	ch_auto
	dw	ch_printer
	dw	ch_modem
	dw	ch_sbaud
	dw	ch_sdatabit
	dw	ch_sstopbit
	dw	ch_sparity
	dw	ch_shandshake
	dw	ch_mbaud
	dw	ch_mdatabit
	dw	ch_mstopbit
	dw	ch_mparity     
Num_Funs	equ	($-Ch_Tbl)/2

Mondays Label Byte
;-----------------
;
Public	Mondays

	db	31,29,31,30,31,30	;Leap YEARs
	db	31,31,30,31,30,31

Moda1 Label Byte
;---------------
;	1) This Table MUST Immediatly follow the Mondays Table.
;
Public	Moda1

	db	31,28,31,30,31,30	;Normal Years
	db	31,31,30,31,30,31


page
;----------------------------------------------------------------------
Sys_Setup Proc Near; (16_May_85)
;-------------------------------
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Sys_Setup

	mov	ax,6		; clear the screen by setting hi-res mode
	int	10h
	
	mov	Upd_Mode,0	; set initial fields being updated 
	mov	DFlags,0	; select normal video
	mov	si,offset Set_Part1	; point to first part of setup screen
	call	Put_String	; label static areas of screen
	mov	si,offset Set_Part2	; point to 2nd part of screen
	call	Put_String

	; Headings are up, now box everything
	mov	al,0
	mov	Xor_Flag,al		; no Xor'ing of dots
	mov	cx,172			; Length

	mov	ax,14			; dot 	Row
	mov	bx,232			; 	Column
	call	Draw_Vertical
	inc	bx			; make line 2 pixels wide
	call	Draw_Vertical

	mov	ax,14
	mov	bx,424			; reset Column
	call	Draw_Vertical
	inc	bx			; make line 2 pixels wide
	call	Draw_Vertical

	mov	ax,86			; draw a line across screen now
	mov	bx,0
	mov	cx,640
	call	Draw_Horizontal

	mov	ax,14
	call	Draw_Horizontal		; draw line across top of screen
	mov	ax,186
	call	Draw_Horizontal		; draw line at bottom also

	mov	ax,142			; row
	mov	cx,232
	call	Draw_Horizontal

;==========================================================================
; SETLP:	This is the refresh-display loop. The current values for all
;		parameters that can be changed are put up in this loop.
;		This loop is called on entry to display current values, and
;		then, it is called anytime a valid key is processed.
;
;		The routine uses calls to Set_Dflags throughout.  
;		The purpose of this, is to provide a means of highlighting
;		the current update field, as follows:
;			The value UPD_Mode corresponds to the field to be
;		updated.  Before any field is displayed, a call is made to
;		Set_Dflags.  Set_Dflags uses a variable called UPD_Cmp to
;		keep track of the field being updated.  When it is called,
;		Set_Dflags increments UPD_Cmp, and compares it to UPD_Mode.
;		If the two variables are equal, then DFLAGS is set to
;		reverse, otherwise, it is set to normal.
;			The special case is Drw_Time_DX which puts up hours,
;		minutes, and seconds.  Since any of these fields may be 
;		highlighted, drw_time_DX makes it's own calls to Set_Dflags.
;
;==================

setlp:	; month
	call	set_dflag		; update field counter (set attribute)
	mov	dx,0609h		; set location to display current month
	mov	al,Clock_Month		; get the month
	call	put_string_n		; display it
	mov	al,' '			; pad with a space
	call	put_chr

	; day of month
	call	set_dflag		; update field counter (set attribute)
	mov	al,Clock_Day		; get day of month
	call	put_ascii		; display it
	mov	al,','			; display a comma
	call	put_chr

	; year
	call	set_dflag		; update field counter (set attribute)
	mov	ax,Clock_Year		; get the year
	call	put_ascii_word		; and display it
	and	dflags,not rev_chr	; make sure not reverse video
	or	dflags,zer_sup		; set to suppress zeroes

setlp2:	mov	al,' '			; clear rest of date field to spaces
	call	put_chr
	cmp	dl,26
	jc	setlp2

	; Time format 12/24 hours
	call	set_Dflag		; update field counter (set attribute)
	mov	dx,070Bh		; location to display format
	mov	al,byte ptr system_setup ;determine if 12 or 24 hour
	mov	ah,12			; assume 12 hour format
	test	al,40h			; test bit
	jz	TF1			; if 12 hour then jump
	mov	ah,24			; else set 24 hour
TF1:	mov	al,ah			; print format
	call	put_ascii
	and	dflags,Not rev_chr	; turn off reverse if it's on.
	call	put_string_imm		; followed by 'Hr'
	db	' Hr.',eos

	; time zone
	call	set_dflag		; update field counter (set attribute)
	mov	dx,080Eh		; location to display time zone number
	mov	al,byte ptr system_setup+1 ;get current time zone
	and	al,1fh			; mask off other bits
	push	ax
	call	put_ascii		; display zone number
	pop	ax			; get back time zone
	add	al,48			; get cities string for zone
	mov	dx,0902h		; location to display list of cities
	call	put_string_n		; display city names
	and	dflags,not rev_chr	; blank rest of city names field

setlp3:	mov	al,' '
	call	put_chr
	cmp	dl,29
	jc	setlp3

	; Default display mode
	call	set_dflag		; update field counter (set attribute)
	mov	dx,0E17h		; location for type of display
	mov	al,byte ptr system_setup ;get type of display
	and	al,1
	xor	al,1			; correct for proper value for char display
	add	al,42			; assume it's color
	call	Put_String_n		; and display it

;==>	; Graphics Cursor  -- REPLACE WITH REVERSE CHAR SET!!!!!!!!!!!
;==>	call	set_dflag
;==>	mov	dx,0F17h		; location for graphics cursor status
;==>	mov	al,byte ptr system_setup ;get type of display
;==>	shr	al,1			; get graphics cursor flag to bit 0
;==>	and	al,1			; check status
;==>	add	al,42
;==>	call	put_string_n

	; EL panel timeout
	call	set_dflag
	mov	dx,1017h		; location for el timeout status
	mov	al,byte ptr system_setup+1 ;get timeout status
	mov	cl,5
	shr	al,cl			; get timeout status flag to bit 0
	and	al,1			; check status
	add	al,42
	call	put_string_n

	; Auto Boot
	call	set_dflag		; update field counter (set attribute)
	mov	dx,150Bh		; location for auto boot status
	mov	al,byte ptr system_setup
	mov	cl,7
	shr	al,cl			; get auto boot status to bit 0
	and	al,1
	add	al,46
	call	put_string_n

	; printer
	call	set_dflag		; update field counter (set attribute)
	mov	dx,0528h		; location for printer mapping display
	mov	al,byte ptr system_setup ;determine printer mapping
	and	al,4
	sub	al,1
	adc	al,0
	neg	al
	add	al,20			; 17 for serial, 20 for parallel
	call	put_string_n		; display current mapping

	; modem internal or external
	call	set_dflag		; update field counter (set attribute)
	mov	dx,0e2bh		; location for string
	mov	al,byte ptr system_setup ;check if internal or ext.
	mov	cl,3			; modem
	shr	al,cl
	and	al,1
	add	al,36
	call	put_string_n

	; Serial baud rate
	call	set_dflag		; update field counter (set attribute)
	mov	dx,0546h		; location to display com1 baud rate
	mov	al,byte ptr serial_setup ;get serial baud rate
	mov	cl,5
	shr	al,cl
	add	al,21			; get pointer to baud rate string 
	call	put_string_n		; display it

	; Serial  data bits
	call	set_dflag		; update field counter (set attribute)
	mov	dx,0646h		; location to display
	mov	al,byte ptr serial_setup ;get number of data bits
	and	al,3
	add	al,5
	call	put_ascii		; display Number of data bits

	; Serial stop bits
	call	set_dflag		; update field counter (set attribute)
	mov	dx,0746h
	mov	al,byte ptr serial_setup ;get number of stop bits
	shr	al,1
	shr	al,1
	and	al,1
	inc	ax
	call	put_ascii		; display # of stops

	; Serial parity
	call	set_dflag		; update field counter (set attribute)
	mov	dx,0846h
	mov	al,byte ptr serial_setup ;get parity type
	and	al,18h
	mov	cl,3
	shr	al,cl
	add	al,29
	call	put_string_n		; display parity

	; handshake type
	call	set_dflag		; update field counter (set attribute)
	mov	dx,0946h
	mov	al,byte ptr serial_setup+1 ;get handshake
	and	al,3
	add	al,33
	call	put_string_n		; display it

	; Modem Baud
	call	set_dflag		; update field counter (set attribute)
	mov	dx,0E46h
	mov	al,byte ptr modem_setup	; get modem baud rate
	mov	cl,5
	shr	al,cl
	and	al,7
	add	al,21			; add offset to baud rate strings
	call	put_string_n

	; Modem data bits
	call	set_dflag		; update field counter (set attribute)
	mov	dx,0F46h
	mov	al,byte ptr modem_setup	; data bits
	and	al,1
	add	al,7			; 7 or 8 bits
	call	put_ascii

	; Modem stop bits
	call	set_dflag		; update field counter (set attribute)
	mov	dx,01046h
	mov	al,byte ptr Modem_Setup	; get number of stop bits
	shr	al,1
	shr	al,1
	and	al,1
	inc	ax
	call	put_ascii		; display # of stops

	; modem parity
	call	set_dflag		; update field counter (set attribute)
	mov	dx,1146h
	mov	al,byte ptr modem_setup	; get modem parity
	and	al,18h
	mov	cl,3
	shr	al,cl
	add	al,29
	call	put_string_n
MDONE:

;====== screen update done here ===================
Get_Key:
	call	Flush_Keyboard		;Flush keyboard buffer
GkLp1:	call	Disp_Time		;Repeat	Repeat display the time
	mov	ah,1			;		If (Get Keyboard Status)
	int	16h
	jz	GkLp1			;	Until (Keyboard Active)
	mov	ah,0
	int	16h			;	Read Keyboard Character
	cmp	al,0
	jnz	GkLp1			;Until (Key eq Function Key)

	mov	al,ah
	cmp	al,fxbase+1		;f2?
	jz	s_skip
	cmp	al,77			;RIGHT ARROW ??
	jz	S_Skip
	cmp	al,80			;DOWN ??
	jz	S_Skip

	cmp	al,fxbase		;F1 ??
	jz	s_skiprev
	cmp	al,72			;UP ARROW ??
	jz	S_SkipRev
	cmp	al,75			;LEFT ARROW ??
	jz	S_SkipRev

	cmp	al,71			;HOME ??
	jz	S_Change
	cmp	al,fxbase+3		;F4 ??
	jz	S_Change

	cmp	al,fxbase+9		;F10 ??
	jnz	Get_Key
	ret				;return to clk program from here


; Move Back One Entry
;--------------------
;
S_SkipRev:				; skip back one field
	mov	al,Upd_Mode
	dec	al
	jns	S_Skip2
	mov	al,Num_Funs-1
	jmp	Short S_Skip2


; Move Forward One Entry
;-----------------------
;
S_Skip:					; skip forward one field
	mov	al,Upd_Mode
	inc	al
	cmp	al,Num_Funs		; too big ??
	jc	s_skip2
	mov	al,0

S_Skip2:
	mov	Upd_Mode,al
SetLp9:	jmp	setlp


; Change the Current Entry
;-------------------------
;
s_change:
	mov	ah,0
	mov	al,Upd_Mode
	shl	ax,1
	mov	si,ax
	cli
	call	ch_tbl[si]
	sti
	jmp	short setlp9

Sys_Setup	EndP

page
;----------------------------------------------------------------------
Disp_Time Proc Near; (16_May_85)
;-------------------------------
;
	mov	ah,Tod_Get_Time
	int	Time_of_Day_Intr	;Update the Display Time

	mov	Upd_Cmp,0FFh		;reset display field count (Set_Dflags)
	mov	al,zer_sup		;supress zeroes
	mov	dx,0509h		;location for displaying time
	call	Drw_Time_dx		;draw time in
	ret

Disp_Time	EndP

;----------------------------------------------------------------------
; Update Routines (21_Apr_85)
;----------------------------
;
; Update Clock Hour
;------------------
;
Ch_Hour:
	inc	Clock_hour
	cmp	Clock_hour,24
	jc	Short Time_Change
	mov	Clock_Hour,0
	jmp	Short Time_Change


; Update Clock Minute
;--------------------
;
Ch_Minute:
	inc	Clock_Minute
	cmp	Clock_Minute,60
	jc	Short Time_Change
	mov	Clock_Minute,0
	jmp	Short Time_Change

; Update Clock Second
;--------------------
;
ch_second:
	mov	Clock_Second,0
	jmp	Short Time_Change


; Common Return for Updating Hours, Minutes and Seconds
;------------------------------------------------------
;
Time_Change:
	mov	ah,ToD_Set_Time		;AH:= Set Time extended Tod Function
	mov	ch,Clock_Hour		;CH:= Hour
	mov	cl,Clock_Minute		;CL:= Minutes
	mov	dh,Clock_Second		;DH:= Seconds
	mov	dl,0			;DL:= 1/100th's of Seconds
	int	Time_of_Day_Intr	;Update the Time
	ret				;Return

page
; Update Year
;------------
;
ch_year:
	inc	Clock_Year
	cmp	Clock_Year,2016		; wrap years at 2015
	jc	Short Date_Change
	mov	Clock_Year,1985
	jmp	Short Date_Change

; Update Month
;-------------
;
ch_month:
	inc	Clock_Month
	cmp	Clock_Month,13
	jc	Short Date_Change
	mov	Clock_Month,1
	jmp	Short Date_Change

; Update Day
;-----------
;
ch_day:
	mov	al,Clock_Day
	inc	al
	cmp	al,Nmdays
	jle	ch_d2
	mov	al,1
ch_d2:	mov	Clock_Day,al
	jmp	Short Date_Change


; Common Return after updating the Year Month or Day.
;----------------------------------------------------
;
Date_Change:
	mov	ax,Clock_Year
	mov	bx,Offset Mondays	; number of days table pointer
	test	al,3
	jz	dyof3

	add	bx,12
dyof3:	mov	cl,Clock_Month		; get month
	dec	cl
	mov	ch,0
	add	bx,cx
	mov	al,byte ptr cs:[bx]	; get number of days
	mov	Nmdays,al
	mov	ah,Clock_Day
	cmp	ah,al
	jle	dyof4

	mov	Clock_Day,al
dyof4:	mov	ah,ToD_Set_Date		;AH:= Set Date extended Tod Function
	mov	cx,Clock_Year		;CX:= Year
	mov	dh,Clock_Month		;DH:= Month
	mov	dl,Clock_Day		;DL:= Day
	int	Time_of_Day_Intr	;Update the Date
	ret
	page

; Update 12/24 Hour Format
;-------------------------
;
ch_format:
	mov	al,byte ptr system_setup ;get setup
	xor	al,40h			; change time format bit
	jmp	ch_pr3			; restore it and save in NVRAM

ch_zone:
	mov	al,byte ptr system_setup+1 ; get zone
	mov	ah,al			; make sure zone is valid
	and	ah,0e0h			; preserve non-zone bits
	inc	al			; next time zone
	and	al,01Fh	
	cmp	al,24
	jb	ch_zon2			; if (Zone out of range)
	mov	al,00h			; jam to zone 0 for wraping around world
	

ch_zon2:
	or	al,ah
	mov	byte ptr system_setup+1,al
	and	al,1Fh			; mask out timeout bit
	mov	disp_zone,al		; set displayed zone also
	jmp	Sys_Save		; save system setup


; Update the Default Display (MonoChrom/Color)
;---------------------------------------------
;
Ch_Display:
	mov	al,Mono_Exist		; check if mono card exists
	cmp	al,true			; if Mono card installed
	jz	Ch_OK			; then it's ok to toggle to it
	ret				; else leave option alone
Ch_OK:
	mov	al,byte ptr system_setup
	xor	al,1			; other mode
	jmp	ch_pr3


; Update the Cursor	REPLACE WITH REVERSE CHARACTER SET SELECT
;------------------
;
;==>	ch_Cursor:
;==>	mov	al,byte ptr system_setup
;==>	xor	al,2			; other mode
;==>	jmp	ch_pr3


; Update the EL Panel TimeOut
;----------------------------
;
ch_timeout:
	mov	al,byte ptr system_setup+1 ; get zone and timeout flag
	xor	al,20h			; toggle timeout flag
	mov	byte ptr system_setup+1,al
	jmp	Sys_Save		; save system setup


; Update the Auto Boot Flag
;--------------------------
;
ch_auto:
	mov	al,byte ptr system_setup
	xor	al,80h			; other mode
	jmp	ch_pr3
	

; Update the Serial Port Baud Rate
;---------------------------------
;
ch_sbaud:	; 9
	mov	ax,serial_setup		; change baud rate
	add	al,20h
chs22:	mov	byte ptr serial_setup,al
	sub	dx,dx			; select com1
ch_mb5:	mov	ah,0
	int	14h
	cmp	dx,0			; check which port being changed
	jnz	Save_Mod		; if COM2 then save Modem_Setup


Save_Ser:
	mov	ax,Serial_Setup		;AX:= New Serial Setup Word
	mov	bx,Offset N_Serial_Setup;BX:= Pointer to Serial_Setup in NovRam
	jmp	Save_Update		;Write new setup and return


Save_Mod:
	mov	ax,Modem_Setup		;AX:= New Modem Setup Word
	mov	bx,Offset N_Modem_Setup	;BX:= Pointer to Modem_Setup in NovRam
	jmp	Save_Update		;Write new setup and return


; Update the Serial Port Number of Data Bits
;-------------------------------------------
;
ch_sdatabit:	; 10
	mov	ax,serial_setup
	mov	ah,al
	inc	al
	and	ax,0fc03h
chs33:	add	al,ah
	jmp	chs22


; Update the Serial Port Stop Bit Selection
;------------------------------------------
;
ch_sstopbit:	; 11
	mov	ax,serial_setup
	xor	al,4
	jmp	chs22


; Update the Serial Port Parity Selection
;----------------------------------------
;
ch_sparity:	; 12
	mov	al,byte ptr serial_setup
	mov	ah,al
	add	al,8
	and	ax,0e718h
	jmp	chs33

ch_shandshake:
	mov	al,byte ptr serial_setup+1
	inc	al
	and	al,3			; overflow ??
	cmp	al,3
	jnz	chsh_1
	and	al,0fch			; then wrap if overflow
chsh_1:	mov	byte ptr serial_setup+1,al
	jmp	Save_Ser		; save new serial setup


; Update the Printer Assignment
;------------------------------
;
ch_printer:
	mov	al,4
ch_pr2:	xor	al,byte ptr system_setup
ch_pr3:	mov	byte ptr system_setup,al


Sys_Save:
	mov	ax,System_Setup		;AX:= New System Setup Word
	mov	bx,Offset N_System_Setup;BX:= Pointer to System Setup in NovRam
	jmp	Save_Update		;Write it and re-initialize


; Update Modem Baud Rate
;-----------------------
;
ch_mbaud:
	mov	al,byte ptr modem_setup	; get current modem setup
	add	al,40h			; bump baud rate
	mov	ah,al			; save new value
	and	al,0c0h			; check if bits 6 & 7 set
	cmp	al,0c0h			; if both set, then clear both
	jnz	mb_ok
	mov	al,ah			; else, reset to 110 baud
	and	al,3fh
	jmp	ch_mb4			; and set new values

mb_ok:	mov	al,ah
ch_mb4:	mov	byte ptr modem_setup,al
	mov	dx,1
	jmp	ch_mb5


; Update Modem Port Number of Data Bits
;--------------------------------------
;
ch_mdatabit:
	mov	al,1
	xor	al,byte ptr modem_setup
	jmp	ch_mb4


; Update Modem Port Number of Stop Bits
;--------------------------------------
;
ch_mstopbit:
	mov	ax,Modem_Setup
	xor	al,4			; toggle number of stop bits
	jmp	ch_mb4


; Update Modem Port Parity Selection
;-----------------------------------
;
ch_mparity:
	mov	al,byte ptr modem_setup
	mov	ah,al
	add	al,8			; next parity
	and	ax,0E718h
	add	al,ah
	jmp	ch_mb4


; Change Modem Location between Com1 and Com2
;---------------------
;
ch_modem:
	mov	al,Modem_Exist		; check if modem card exists
	cmp	al,true			; if Modem card installed
	jz	Ch_Modem_OK		;    then it's ok to toggle to it
	ret				; else leave option alone
Ch_Modem_OK:
	mov	al,8
	jmp	ch_pr2


;----------------------------------------------------------------------
Save_Update Proc Near; (4_May_85)
;--------------------------------
;	1) This routine is used to save setup data in the Novram, and
;	   to update the system to reflect changes made to system parameters.
;	   It is called anytime a user changes a setup selection
;	   other than date, or time.
;	2) ON ENTRY:
;		AX = Word to save in NovRam
;		BX = Pointer into Novram
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Save_Update

	push	ds			;save current data segment
	push	cs
	pop	ds			;DS:= Start of SRam

	push	ax
	mov	al,1			;Enable NovRam Writes
	call	R_W_Rtc_Ram
	pop	ax

	mov	[bx],ax			;write the data
	xor	al,al			;Disable Ram writes
	call	R_W_Rtc_Ram

	call	Re_Init			; re-initialize system from changes
	pop	ds			;restore data seg
	ret	

Save_Update	EndP

Monitor_Segment	EndS
		End
