Page	60,132
Title	-Telephone Dialer Routines
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 7_July_85
;
;	
%Out	Phone.asm
page
;----------------------------------------------------------------------
; Equates (22_May_85)
;--------------------
;
; Include Files
;--------------
;	Rom.lit
;	Io.lit
;	Icon.lit
;	Pequ.lit
;	Pdata.lit
;
	.xlist
	Include	..\Rom\Rom.lit		; PIVOT specific definitions
	Include ..\IO\Io.lit		;Interrupt Definition (for Icon_Phone)
	Include Icon.lit
	Include	Pequ.lit
	Include	Pdata.lit
	.list

.SALL
RW	MACRO
	CALL	BATRW
	ENDM

RO	MACRO
	CALL	BATRO
	ENDM

page
;======================================================================
PhNovRam Segment At (0F110h)
;===========================
;	1) Phone and Appointment Scheduler Variables in NovRam
;	2) Use the routines RHOLE and RERASE to allocate and de-allocate from
;	   RAMBOT up to the end of battery RAM.

	Extrn	BAT1ST: Byte	; First location in battery RAM
	Extrn	CHKSUM: Byte	; Checksum on battery RAM contents
	Extrn	ALMTIME: Word	; Time of next alarm Hi-Byte=hour, Lo-Byte=min.
	Extrn	ALMYR: Byte	; Year as offset from 1985 (i.e. 1986 = 1)
	Extrn	ALMMD: Word	; Month and day
	Extrn	ALMPEND: Byte	; Alarm pending counter
	Extrn	AREACD: Byte	; Current area code
	Extrn	PREFIX: Byte	; Dial prefix up to 11 digit prefix
	Extrn	CALTIM: Byte	; Call time (hrs, min, sec)
	Extrn	REDIAL: Byte	; Re-dial number ( 64 char re-dial buffer)
	Extrn	RAMTOP: Word	; Pointer to first byte of stored data
	Extrn	APP1ST: Word	; Pointer to first appointment record
	Extrn	RAMBOT: Byte	; Starting location of stored data

PhNovRam	EndS

page
;======================================================================
Monitor_Segment Segment Word Public	;(7_July_85)
;==================================
;
Assume	cs:Monitor_Segment, ds:PhNovRam, es:PhNovRam

	extrn	dflags:byte
	extrn	System_Setup:word
	extrn	Check_Delay:Byte

	extrn	beep:near
	extrn	Put_String:Near
	extrn	Put_String_n:Near
	extrn	Put_String_Imm:Near
	extrn	Put_chr:Near
	extrn	Put_Ascii:Near
	extrn	Put_Ascii_Word:Near
	extrn	R_W_RTC_RAM:Near
	extrn	Term_Entry:Near

	; String data externals
	extrn	DILFUN:near
	extrn	EDTFUN:near
	extrn	Kbrd_Help:near
	extrn	N_2_Dial:near
	extrn	BFRD12:near
	extrn	BFRD13:abs
	extrn	BFRD15:near
	extrn	BFRD16:near
	extrn	KEY13A:near
	extrn	DILCHR:near
	extrn	DILCHZ:abs
	extrn	U_D_Help:near
	extrn	Dial_Pfx:near
	extrn	M_Init:near
;	extrn	M_Init_2:near
;	extrn	H_Up_Cmnd:near
	extrn	PHMFUN:near

	; Externals in PUTIL.ASM
	extrn	BATRO:Near
	extrn	BATRW:Near
	extrn	BLANK:Near
	extrn	CI:Near
	extrn	CISTAT:Near
	extrn	CO:Near
	extrn	CURSOR:Near
	extrn	DISHR:Near
	extrn	DISMIN:Near
	extrn	KEYS:Near
	extrn	No_Zero_Supp:Near
	extrn	REMAIN:Near
	extrn	RERASE:Near
	extrn	RHOLE:Near
	extrn	RSIZE:Near
	extrn	RSUM:Near
	extrn	SCLEAR:Near
	extrn	Set_Norm_Att:Near
	extrn	Set_Rev_Att:Near
	extrn	Str_Out:Near
	extrn	Str_Out_Cur:Near
	extrn	UPPER:Near

If Enable_Term

; Externals for terminal
	extrn	Term_Carr:byte		; carrier Check flag
	extrn	Term_Port:byte		; Port Com1 vs Com2
Endif



Subttl	Phone List
page
;-------------------------------------------------------------------------
; There are three distinct modes of operation while working with the phone
; directory.  The primary mode lets the user quickly search the directory
; and dial a number from there.  Secondarily, the user may switch to keying
; in a number.  Thirdly, the user may switch to an edit mode which allows
; changes to the directory.
;------------------------------------------------------------------------

;--------------------------------------------------------------------------
; Function key dispatch table for keyboard dialing
;-------------------
PHMKEY	DW	CR
	DW	PHMDIL

	DW	KF1
	DW	PHMPFX

	DW	KF2
	DW	PHMDIL

	DW	KF8
	DW	PHMERA

	DW	KF10
	DW	PHMEXT

	DW	KLEFT
	DW	PHMLFT

	DW	KRIGHT
	DW	PHMRGT

	DW	BS
	DW	PHMBS

	DW	KINS
	DW	PHMINS

	DW	KDEL
	DW	PHMDEL

	DW	0
	DW	PHMCHG

page
;---------------------------------------------------------------------------
; Keystroke Dispatch for main dial menu
;--------------------
DILKEY	DW	CR
	DW	PHDWN

	DW	KDOWN
	DW	PHDWN

	DW	KUP
	DW	PHUP

	DW	KPGUP
	DW	PHPRV

	DW	KPGDN
	DW	PHNXT

	DW	KF1
	DW	PHDPFX

	DW	KF2
	DW	PHGET

	DW	KF3
	DW	PH1ST

	DW	KF4
	DW	PH2ND

	DW	KF5
	DW	PHKEYB

	DW	KF6
	DW	PHRDIL

	KHANG	EQU	KF7
	DW	KHANG
	DW	PHHANG

	DW	KF8
	DW	PHTIMR

If Enable_Term

	DW	KF9
	DW	PHTERM		; direct connect terminal

Endif

	DW	KF10
	DW	PHEDIT

	DW	0
	DW	PHSRCH
page
;--------------------------------------------------------------------------
; keystroke dispatch for editing directory
;--------------------------------
EDTKEY	DW	CR
	DW	PHDWN

	DW	KDOWN
	DW	PHDWN

	DW	KUP
	DW	PHUP

	DW	KLEFT
	DW	PHLFT

	DW	KRIGHT
	DW	PHRGT

	DW	KPGUP
	DW	PHPRV

	DW	KPGDN
	DW	PHNXT

	DW	BS
	DW	PHBS

	DW	KINS
	DW	PHINS

	DW	KDEL
	DW	PHDEL

	KPFIX	EQU	KF1
	DW	KPFIX
	DW	PHPFIX

	KAREA	EQU	KF2
	DW	KAREA
	DW	PHAREA

	DW	KF3
	DW	PHE1ST

	DW	KF4
	DW	PHE2ND

	DW	KF5
	DW	PHADD

	DW	KF6
	DW	PHREMV


	DW	KF10
	DW	PHEXIT


	DW	0
	DW	PHCHG
page
;----------------------------------------------------------------------------
; Keystroke dispatch for update menu
;---------------------
PHADFN	DW	CR
	DW	PHAD15

	DW	BS
	DW	PHAD19

	DW	KDEL
	DW	PHAD24

	DW	KINS
	DW	PHAD25

	DW	KLEFT
	DW	PHAD29

	DW	KRIGHT
	DW	PHAD30

	DW	ESC
	DW	PHAD11

	DW	0
	DW	PHA12A

page
;---------------------------------------------------------------------------
; Initialize
;-----------------------
PUBLIC	PHONE_ICON
PHONE_ICON:
	SUB	SP,MAXRAM		; Allocate stack space for local variables
	MOV	BP,SP
	call	Init_Dflags		; clear dflags, and determine com port to use

; initialize modem
	call	Carrier			; If (Modem Has Carrier)
	jz	No_Init			;  then don't touch DTR
					; Else
	call	DTR_Off			;    turn OFF DTR to put in cmnd mode
; now send modem initialization data
	mov	si,offset M_Init	;    send modem init string
	call	Modem_String

No_Init:
	XOR	AX,AX			; Reset position flag & new dial flag
	MOV	EDPOS[BP],AL		; clear dial buffer
	mov	dial_delay[bp],al	; clear dial delay accumulator

	INC	AL			; Set timer flag
	MOV	TIMER[BP],AL
	mov	Delay_Val[bp],al	; set dial delay value for touch tone
	CALL	DILERA			; Clear dial stream

;---------------------------------------------------------------------------
; Display Directory
;-----------------------
	MOV	SI,OFFSET RAMBOT ; Start at beginning of NovRam
;DH = Row, DL=Col, with bit 7 being a flag indicatin mode edit or not
PH0:	MOV	DX,100H		; Set cursor pos. to First line, not editing
	JMP	SHORT PH1

PH0A:	MOV	DX,100H+PHNAMZ+1 ; First line, editing
	JMP	SHORT PH1

PH0B:	MOV	DH,1		; First line, DL already set

PH1:	MOV	TOPLINE[BP],SI	; point to top line displayed

	MOV	AX,-1		; Set last time read to -1
	MOV	TIMPRV[BP],AL	; to disable time display
	MOV	TIMPRV[BP+1],AX

	CALL	SCLEAR			; clear screen, attr., and home cursor
	push	dx
	push	si
	mov	si,offset edtfun	; assume we're in edit mode
	OR	DL,DL			; test if edit mode
	JNZ	PH1A			; if Not editing,
	mov	si,offset dilfun	; then display dialing function keys
ph1a:	push	bx
	push	cx
	mov	bl,normal
	call	Put_String		; display the function keys

	pop	cx
	pop	bx
	pop	si
	pop	dx


	CALL	PHEADER		; display top status line
	CALL	DHELP		; display Special chars or dialed #

; Display entire directory screenful
	MOV	CX,DX		; save cursor pos. and edit status
	MOV	DH,1		; set to row 1
PH2:	XOR	AL,AL		; assume displaying in normal video
	CMP	CH,DH		; if drawing selected name
	JNZ	PH4

	MOV	BX,SI		; bx -> pointer to name in directory
	MOV	AL,1		; then set AL to draw reverse video

PH4:	CALL	PHSHOW		; Display name and number

	CALL	PHNEXT		; Find next name, return size in al
	JZ	PH5		; No more Names found so jump
	INC	DH		; next line
	CMP	DH,PENDIR	; if Not last line of directory display
	JBE	PH2		; then display another


;End of directory or full screen
; so reset cursor position, and name 
PH5:	MOV	DX,CX		; Restore cursor & pointer to barred line
	MOV	SI,BX	
	JMP	SHORT PH7

;------------------------------------------------------------------------
; The following functions expect the register to contain the following:
;
;	DH = directory row
;	DL = name or phone number column
;	SI -> phone directory name in battery RAM
;-------------------------

PH6:	MOV	AL,1		; Show bar over a directory line
	CALL	PHSHOW		; display name and number

PH7:	PUSH	DX		; save cursor position and edit flag
	OR	DL,DL		; if editing a number
	JZ	PH8		; then

	ADD	DL,EDPOS[BP]	; Put cursor in phone number for editing
PH8:	CALL	CURSOR		; set cursor position
	POP	DX		; restore cursor

;-------------------------------------------------------------------------
; Screen setup is done, so drop into routine that gets keys
;-----------------------

PH9:	MOV	BX,OFFSET EDTKEY	; assume in edit mode
	OR	DL,DL			; test if in edit mode
	JNZ	PH10			; if NOT in edit mode 
	MOV	BX,OFFSET DILKEY 	; then point to dialing key dispatch table
PH10:	JMP	KEYS			; get a key to process


;----------------------------------------------------------------------------
; Down
;
;	Mode:	Dial or edit
;-----------------------

PHDWN:	MOV	BYTE PTR EDPOS[BP],0  ; Set so cursor goes to left after entry
	MOV	DI,SI		; No next name
	CALL	PHNEXT		; get next name
	JZ	PH7		; if no more names then ignore
	CALL	PHMOVE		; else save changes to this number and get next
	INC	DH		; next row
	CMP	DH,PENDIR	; if NOT end of screen
	JBE	PH6		; then show new name/number
				; else
	MOV	SI,TOPLINE[BP]	; Scroll up one line
	CALL	PHNEXT		; next name
	DEC	DH		; back a row
	JMP	PH1		; rewrite screen

;--------------------------------------------------------------------------
; Up
;
;	Mode:	Dial or edit
; to move up, we have to start from the beginning, and look until we get
; back to where we are. We then go back to the name/number pointed to just
; previous. It's Kind of like a search of a singly-linked list
;-------------------------

PHUP:	MOV	DI,SI		; Save the name we are at now
	MOV	SI,OFFSET RAMBOT
	CMP	DI,SI		; if already at top
	JZ	PH7		; loop back for next key

PHU0:	MOV	BX,SI		; Save the name we'are at in search
	CALL	PHNEXT		; get next name
	CMP	DI,SI		; if we are NOT back where we started
	JNZ	PHU0		; keep skipping through names
	MOV	SI,BX		; else, BX is the last name before we got
				;   back to where we started
	CALL	PHMOVE		; Moving

	DEC	DH		; back a line
	JNZ	PH6		; if not at top then loop back 
	JMP	PH0B		; else, re-display before looping for new key


;--------------------------------------------------------------------------
; Next Screen
;
;	Mode:	All
;-------------------------

PHNXT:	CALL	DFLUSH		; save any changes in NovRam
PHNX0:	CALL	PHNEXT		; Move to first one on next screen
	INC	DH
	CMP	DH,PENDIR
	JBE	PHNX0
	JMP	PH0B

;--------------------------------------------------------------------------
; Previous Screen
;
;	Mode:	All
;
;-------------------------

PHPRV:	CMP	SI,OFFSET RAMBOT ; At very top?
	JZ	PH7
;
	CALL	DFLUSH		; Find previous screenful
	MOV	SI,OFFSET RAMBOT
	MOV	DI,SI
;
	MOV	CX,PENDIR
PHPR0:	CALL	PHNEXT		; End or there?
	JZ	PHPR1
	CMP	TOPLINE[BP],SI
	JZ	PHPR1
	LOOP	PHPR0
;
	XCHG	SI,DI		; Scoot up first line of screen
	CALL	PHNEXT
	XCHG	SI,DI
	JMP	SHORT PHPR0
;
PHPR1:	MOV	SI,DI		; Display it
	JMP	PH0B

;--------------------------------------------------------------------------
; Put 1st Directory Number into Dial Stream
;
;	Mode:	Dial
;
;-------------------------

PH1ST:	CALL	PH1INS		; Insert it
	JMP	PH7
;
PH1INS:				; Copy 1st directory item into stream
	MOV	DI,OFFSET RAMBOT
	JMP	SHORT PH1IN0
;
PH2INS:				; Copy 2nd
	PUSH	SI
	MOV	SI,OFFSET RAMBOT
	CALL	PHNEXT
	MOV	DI,SI		; No 2nd?
	JZ	PH1IN9
	POP	SI
;
PH1IN0:				; Dial phone number at DI
	PUSH	SI
	MOV	SI,EDBFR	; Put number to dial into EDBFR
	XOR	CH,CH
	MOV	[BP+SI],CH
;
	MOV	CL,[DI]		; Skip over name to phone number
	ADD	DI,CX
	INC	DI
;
	MOV	CL,[DI]		; No phone number?
	JCXZ	PH1IN8
;
PH1IN1:	INC	DI		; Copy phone number
	MOV	AL,[DI]
	CMP	AL,'('		; Not an area code?
	JNZ	PH1IN5
;
	PUSH	CX
	PUSH	DI
	DEC	CX		; Ends with parentheses?
	JCXZ	PH1IN3
;
	MOV	BX,OFFSET AREACD ; See if it matches current area code
PH1IN2:	INC	DI
	MOV	AL,[DI]
	CMP	AL,')'		; End of area code?
	JZ	PH1IN4
;
	CMP	AL,[BX]		; Doesn't match?
	JNZ	PH1IN3
;
	INC	BX		; Next
	LOOP	PH1IN2
;
PH1IN3:	POP	DI		; Continue
	POP	CX
	MOV	AL,[DI]
	JMP	SHORT PH1IN5
;
PH1IN4:	CMP	BYTE PTR [BX],0	; Not same size?
	JNZ	PH1IN3
;
	POP	AX		; Ignore area code, restore stack
	POP	AX
	JMP	SHORT PH1IN6
;
PH1IN5:	CMP	AL,' '		; Ignore blanks
	JZ	PH1IN6
;
	XOR	AH,AH		; Store the number followed by a null
	MOV	[SI+BP],AX
	INC	SI
PH1IN6:	LOOP	PH1IN1
	JMP	SHORT PH1IN8
;
PH1IN7:				; Entry for prefix dial
	PUSH	SI
PH1IN8:	CALL	BFRDIL		; Dial the buffered number
	JZ	PH1IN9
	mov	si,offset dilfun	; Restore function keys
	call	Str_Out		; output the string
PH1IN9:	POP	SI
	RET

;--------------------------------------------------------------------------
; Put 1st Directory Number into Dial Stream
;
;	Mode:	Dial
;
;-------------------------

PH2ND:	CALL	PH2INS
	JMP	PH7


;--------------------------------------------------------------------------
; Add Number at Cursor to Dial Stream
;
;	Mode:	Dial
;
;-------------------------

PHGET:	MOV	DI,SI
	CALL	PH1IN0
	JMP	PH7

;--------------------------------------------------------------------------
; Dial the Prefix
;
;	Mode:	Dial
;
;-------------------------

PHDPFX:	CMP	BYTE PTR NEW[BP],0 ; Not a new number?
	JNZ	PHDPF2

	MOV	DI,EDBFR	; Put prefix into edit buffer & dial
	MOV	BX,OFFSET PREFIX
PHDPF0:	MOV	AL,[BX]
	OR	AL,AL
	JZ	PHDPF1
	MOV	[DI+BP],AL
	INC	BX
	INC	DI
	JMP	SHORT PHDPF0
;
PHDPF1:	MOV	WORD PTR [DI+BP],'+' ; Only partial number
	CALL	PH1IN7
PHDPF2:	JMP	PH7


;--------------------------------------------------------------------------
; Re-Dial
;
;	Mode:	Dial
;
;-------------------------

PHRDIL:	PUSH	SI
	MOV	SI,OFFSET REDIAL ; Copy dial stream into edit buffer
	MOV	DI,EDBFR
	MOV	CX,DILMAX+1
	CLD
PHRDI0:	LODSB
	MOV	[DI+BP],AL
	INC	DI
	LOOP	PHRDI0
	POP	SI

	MOV	NEW[BP],CL	; New dial, just in case "+" last dial

	CALL	BFRDIL		; Dial from edit buffer
	push	si
	mov	si,offset dilfun	; Restore function keys
	call	Str_Out		; output the string
	pop	si
	JMP	PH7

;--------------------------------------------------------------------------
; Remove Directory Entry
;
;	Mode:	Edit
;
;-------------------------

PHREMV:	MOV	DI,SI		; Don't allow erasure of #1 or #2
	MOV	SI,OFFSET RAMBOT
	CMP	DI,SI
	JZ	PHREMA
	CALL	PHNEXT
	CMP	DI,SI
	JNZ	PHREMB
;
PHREMA:	MOV	SI,DI		; Restore SI and ignore
	JMP	PH9
;
PHREMB:	MOV	SI,DI		; Determine size of entry
	MOV	CL,[DI]
	XOR	CH,CH
	ADD	DI,CX
	ADD	CL,[DI+1]
	ADD	CX,2
;
	CALL	PHERASE		; Erase it
	CALL	RSUM
	CALL	REMAIN
;
	XOR	AL,AL		; New position of zero
	MOV	EDPOS[BP],AL
;
	CMP	[SI],AL		; Erased last line?
	JZ	PHREM3
;
	PUSH	DX
	PUSH	SI
	MOV	AL,1
PHREM0:	CALL	PHSHOW		; Display rest of directory
	CALL	PHNEXT
	JZ	PHREM1
	XOR	AL,AL
	INC	DH
	CMP	DH,PENDIR
	JBE	PHREM0
	JMP	SHORT PHREM2
;
PHREM1:	INC	DH		; Erase last line
	CALL	PHREM9
;
PHREM2:	POP	SI
	POP	DX
	JMP	PH7
;
PHREM3:	CALL	PHREM9		; Erase current screen line
;
	MOV	SI,OFFSET RAMBOT
PHREM4:	CALL	PHNEXT		; Move to last line of file
	JNZ	PHREM4
;
	DEC	DH		; Move cursor onto previous line
	JNZ	PHREM5
	JMP	PH0A
;
PHREM5:	JMP	PH6
;
PHREM9:				; Blank line DH
	PUSH	DX
	XOR	DL,DL
	CALL	CURSOR
	CALL	Set_Norm_Att
	MOV	CX,80
	CALL	BLANK
	POP	DX
	RET


;--------------------------------------------------------------------------
; Left
;
;	Mode:	Edit
;
;-------------------------

PHLFT:	DEC	BYTE PTR EDPOS[BP]
	JNS	PHLF1
	INC	BYTE PTR EDPOS[BP]
PHLF0:	JMP	PH9
PHLF1:	JMP	PH7


;--------------------------------------------------------------------------
; Right
;
;	Mode:	Edit
;
;-------------------------

PHRGT:	CMP	BYTE PTR EDPOS[BP],PHNUMZ
	JZ	PHLF0
	INC	BYTE PTR EDPOS[BP]
	JMP	SHORT PHLF1


;--------------------------------------------------------------------------
; Backspace
;
;	Mode:	Edit
;
;-------------------------

PHBS:	MOV	AL,EDPOS[BP]	; At start of line?
	DEC	AL
	JS	PHLF0
	MOV	EDPOS[BP],AL
;
PHBA:	MOV	CL,[SI]		; Point to start of message
	XOR	CH,CH
	MOV	DI,SI
	ADD	DI,CX
	INC	DI
	MOV	CL,[DI]
	SUB	CL,AL
	JBE	PHLF1
;
	CBW			; Point to current char in buffer
	ADD	DI,AX
	INC	DI
;
	PUSH	DX		; Move cursor to erasure point
	ADD	DL,AL
	CALL	CURSOR
	POP	DX
;
	CALL	Set_Rev_Att	; Erased last char of line?
	DEC	CX
	JCXZ	PHB1
;
PHB0:	INC	DI		; Close up line
	MOV	AL,[DI]
	RW
	MOV	[DI-1],AL
	RO
	CALL	CO
	LOOP	PHB0
;
PHB1:	MOV	AL,' '		; Blank char at end
	RW
	MOV	[DI],AL
	RO
	CALL	CO
	CALL	Set_Norm_Att
	CALL	RSUM
	JMP	PH7


;--------------------------------------------------------------------------
; Delete Character
;
;	Mode:	Edit
;
;-------------------------

PHDEL:	MOV	AL,EDPOS[BP]	; Not right end?
	CMP	AL,PHNUMZ
	JNZ	PHBA
PHDE0:	JMP	PH9


;--------------------------------------------------------------------------
; Insert Character
;
;	Mode:	Edit
;
;-------------------------

PHINS:	MOV	AL,EDPOS[BP]	; At right end?
	CMP	AL,PHNUMZ
	JZ	PHDE0
;
	MOV	DI,SI		; Point to phone number
	MOV	CL,[DI]
	XOR	CH,CH
	ADD	DI,CX
	INC	DI
;
	CALL	PHCH2		; Extend message to full size
;
	CBW			; Determine how many chars will move
	MOV	CX,PHNUMZ
	ADD	DI,CX
	SUB	CX,AX
	PUSH	CX
	DEC	CX		; At end?
	RW
	JCXZ	PHIN1
;
PHIN0:	MOV	AL,[DI-1]	; Move chars up
	MOV	[DI],AL
	DEC	DI
	LOOP	PHIN0
;
PHIN1:	MOV	BYTE PTR [DI],' ' ; Blank at insertion
	RO
;
	POP	CX		; Display changed line
	CALL	Set_Rev_Att
PHIN2:	MOV	AL,[DI]
	CALL	CO
	INC	DI
	LOOP	PHIN2
	CALL	RSUM
	JMP	PH7

;--------------------------------------------------------------------------
; Search for Number
;
;	Mode:	Dial
;
;-------------------------

PHSRCH:	CALL	UPPER		; Search 0-9, A-Z only, & blank
	CMP	AL,' '
	JZ	PHSRC1
	CMP	AL,'0'
	JB	PHSRC0
	CMP	AL,'9'
	JBE	PHSRC1
	CMP	AL,'A'
	JB	PHSRC0
	CMP	AL,'Z'
	JBE	PHSRC1
;
PHSRC0:	JMP	PH9		; Ignore
;
PHSRC1:	MOV	EDBFR[BP],AL	; Find it
	XOR	DL,DL
	MOV	CX,1
	CALL	PSEARCH
	JNZ	PHSRC2
;
	MOV	SI,AX		; Point to last entry in dir
;
PHSRC2:	MOV	DH,1		; Repaint from first line
	JMP	PH1


;--------------------------------------------------------------------------
; Change #1 Description
;
;	Mode:	Edit
;
;-------------------------

PHE1ST:	MOV	DI,SI
	MOV	SI,OFFSET RAMBOT
	JMP	SHORT PHE2N0

;--------------------------------------------------------------------------
; Change #2 Description
;
;	Mode:	Edit
;
;-------------------------

PHE2ND:	MOV	DI,SI
	MOV	SI,OFFSET RAMBOT
	CALL	PHNEXT
;
PHE2N0:	PUSH	SI		; Flush screen bar
;
	CALL	PHAD11		; Get new description
;
	MOV	AL,PHNAMZ-4	; Make sure not too big
	CMP	CL,AL
	JBE	PH2N0A
	MOV	CL,AL
;
PH2N0A:	POP	SI		; Get current size
	PUSH	SI
	PUSH	CX
	MOV	AL,[SI]
	ADD	SI,5
;
	SUB	AL,4		; Same size as old one?
	SUB	CL,AL
	JZ	PHE2N2
;
	JNC	PHE2N1		; New one bigger?
;
	NEG	CL		; Erase excess
	CALL	PHERASE
	JMP	SHORT PHE2N2
;
PHE2N1:	CALL	PHHOLE		; More room for bigger message
	JC	PHE2N2
;
	CALL	BEEP		; Can't
	POP	CX
	JMP	SHORT PHE2N4
;
PHE2N2:	POP	CX		; Size of new message
	MOV	AL,CL
	ADD	AL,4
	RW
	MOV	[SI-5],AL
;
	MOV	DI,EDBFR	; Store new message
PHE2N3:	MOV	AL,[DI+BP]
	MOV	[SI],AL
	INC	DI
	INC	SI
	LOOP	PHE2N3
	RO
	CALL	RSUM
;
PHE2N4:	POP	SI		; Display results
	JMP	PH0A


;--------------------------------------------------------------------------
; Change to Edit Mode
;
;	Mode:	Dial or key
;
;-------------------------

PHEDIT:	MOV	DL,PHNAMZ+1	; Bar over phone number only
;
	push	si
	mov	si,offset edtfun	; Restore function keys
	push	bx
	push	cx
	push	dx
	mov	bl,normal
	call	Put_String
	pop	dx
	pop	cx
	pop	bx
	pop	si
	CALL	DHELP
	MOV	BYTE PTR EDPOS[BP],0
	JMP	PH6


;--------------------------------------------------------------------------
; Change to Dial Mode
;
;	Mode:	Edit
;
;-------------------------

PHEXIT:	XOR	DL,DL		; Bar over whole line
	MOV	EDPOS[BP],DL
	push	si
	mov	si,offset dilfun	; Restore function keys
	call	Str_Out		; output the string
	pop	si
	CALL	DHELP
	JMP	PH6


;--------------------------------------------------------------------------
; Change Directory Phone Number
;
;	Mode:	Edit
;
;-------------------------

PHCHG:	CALL	DILLGL		; Illegal dial char?
	JNZ	PHCH1
;
	MOV	DL,AL		; Save char
;
	MOV	DI,SI		; Get current size of phone number
	MOV	AL,[DI]
	XOR	AH,AH
	INC	AX
	ADD	DI,AX
;
	MOV	AL,EDPOS[BP]	; At right end?
	CMP	AL,PHNUMZ
	JAE	PHCH1
;
	CMP	AL,[DI]		; Still within message?
	JB	PHCH0
;
	CALL	PHCH2		; Extend message
	JNC	PHCH1
;
PHCH0:	INC	AL		; Increment position
	MOV	EDPOS[BP],AL
;
	ADD	DI,AX		; Insert char & display it
	RW
	MOV	[DI],DL
	RO
	CALL	Set_Rev_Att
	MOV	AL,DL
	CALL	CO
	CALL	Set_Norm_Att
	CALL	RSUM
PHCH1:	MOV	DL,PHNAMZ+1
	JMP	PH7
;
PHCH2:				; Extend phone number to full size for changes
	PUSH	AX		;	DI->phone number
	PUSH	DI
	PUSH	SI
	MOV	CL,PHNUMZ
	XOR	CH,CH
	MOV	AL,[DI]
	CBW
	SUB	CL,AL
	ADD	DI,AX
	INC	DI
	MOV	SI,DI
	CALL	PHHOLE
	JNC	PHCH3
;
	JCXZ	PHCH3		; Blank it
	RW
	MOV	AL,' '
	CLD
	REP	STOSB
	RO
;
PHCH3:	POP	SI		; Pop stack, CY if successful
	POP	DI
	POP	AX
	JC	PHCH4
;
	CALL	BEEP		; Unable to insert
	CLC
	RET
;
PHCH4:	RW
	MOV	BYTE PTR [DI],PHNUMZ ; Phone number is max size now
	RO
	RET


;--------------------------------------------------------------------------
; Add to Directory
;
;	Mode:	Edit
;
;-------------------------

PHADD:	CALL	DFLUSH		; Remove bar
;
	CALL	PHAD11		; Get name
;
	CALL	PSEARCH		; Find a spot for name
;
	ADD	CX,2		; Make a spot for it in RAM
	CALL	PHHOLE
	JC	PHAD0
;
	CALL	BEEP		; Couldn't
	JMP	SHORT PHAD8
;
PHAD0:	PUSH	SI
	SUB	CX,2		; Store size of name
	RW
	MOV	[SI],CL
	INC	SI
;
	MOV	DI,EDBFR	; Store name
PHAD1:	MOV	AL,[DI+BP]
	MOV	[SI],AL
	INC	DI
	INC	SI
	LOOP	PHAD1
;
	MOV	[SI],CL		; At start of null phone number
	RO
	MOV	EDPOS[BP],CL
	POP	SI
	CALL	RSUM
;
PHAD8:	CALL	REMAIN
	JMP	PH0A
;
PHAD9:				; Inverse bar at DX, CX long
	CALL	CURSOR
	CALL	Set_Rev_Att
	CALL	BLANK
	CALL	CURSOR
;
	PUSH	DI		; Blank edit buffer
	PUSH	CX
	MOV	DI,EDBFR
	MOV	CX,EDMAX
PHAD10:	MOV	[DI+BP],CH
	INC	DI
	LOOP	PHAD10
	MOV	EDPOS[BP],CH
	POP	CX
	POP	DI
	RET
;
PHAD11:				; On exit, EDBFR contains CX chars typed
	XOR	DX,DX		; Put inverse bar over name
	MOV	CX,PHNAMZ
	CALL	PHAD9
;
	MOV	DI,EDBFR
PHAD12:	MOV	BX,OFFSET PHADFN ; Process keystroke
	JMP	KEYS
;
PHA12A:	CMP	AL,' '		; Control char?
	JB	PHAD12
;
	OR	DL,DL		; Not first position?
	JNZ	PHAD13
;
	CMP	AL,' '		; Don't allow blank first char so it won't
	JZ	PHAD12		;	come before #1 and #2
;
PHAD13:	CMP	DL,PHNAMZ	; Full?
	JZ	PHAD12
;
	MOV	[DI+BP],AL	; Store char in buffer & echo
	INC	DI
	INC	DL
	CALL	CO
	JMP	SHORT PHAD12
;
PHAD15:	MOV	DI,EDBFR	; Determine how many chars to CX
	MOV	CL,PHNAMZ
	XOR	CH,CH
	ADD	DI,CX
	MOV	AX,' '
PHAD16:	DEC	DI		; Eliminate trailing blanks at the same time
	CMP	[DI+BP],AH
	JZ	PHAD17
	CMP	[DI+BP],AL
	JNZ	PHAD18
	MOV	[DI+BP],AH
PHAD17:	LOOP	PHAD16
;
	JMP	SHORT PHAD11	; Try again since empty
;
PHAD18:	RET
;
PHAD19:	OR	DL,DL		; Can't backspace?
	JZ	PHAD23
;
	DEC	DL		; Erase char to left
	DEC	DI
;
PHAD20:	PUSH	DI
	MOV	CX,PHNAMZ	; Close up line
	CALL	CURSOR
PHAD21:	INC	DI
	MOV	AL,[DI+BP]
	MOV	[DI+BP-1],AL
	OR	AL,AL
	JZ	PHAD22
	CALL	CO
	LOOP	PHAD21
	MOV	[DI+BP],CL
;
PHAD22:	MOV	AL,' '		; Blank char at end
	CALL	CO
	POP	DI
	CALL	CURSOR
PHAD23:	JMP	PHAD12
;
PHAD24:	CMP	DL,PHNAMZ	; Right end?
	JZ	PHAD23
	JMP	PHAD20

PHAD25:	CMP	DL,PHNAMZ	; At very end?
	JZ	PHAD23
;
	MOV	AL,DL		; Rightmost char?
	CBW
	CMP	[DI+BP],AH
	JZ	PHAD23
;
	PUSH	DI
	MOV	CX,PHNAMZ	; Determine how many chars will move
	DEC	AX
	SUB	DI,AX
	ADD	DI,CX
	SUB	CX,AX
	PUSH	CX
	DEC	CX		; At end?
	JCXZ	PHAD27
;
PHAD26:	MOV	AL,[DI+BP-1]	; Move chars up 1
	MOV	[DI+BP],AL
	DEC	DI
	LOOP	PHAD26
;
PHAD27:	MOV	BYTE PTR [DI+BP],' ' ; Blank at insertion
;
	POP	CX		; Display changed line
PHAD28:	MOV	AL,[DI+BP]
	CALL	CO
	INC	DI
	LOOP	PHAD28
	POP	DI
	JMP	SHORT PHAD31
;
PHAD29:	OR	DL,DL		; Can't go left?
	JZ	PHAD32
;
	DEC	DL		; Left
	DEC	DI
	JMP	SHORT PHAD31
;
PHAD30:	CMP	DL,PHNAMZ	; Can't go right?
	JZ	PHAD32
	CMP	BYTE PTR [DI+BP],0
	JZ	PHAD32
;
	INC	DL		; Right
	INC	DI
;
PHAD31:	CALL	CURSOR
PHAD32:	JMP	PHAD12


;--------------------------------------------------------------------------
; Set Area Code
;
;	Mode:	Edit
;
;-------------------------

PHAREA:	CALL	DFLUSH		; Turn off bar
;
	PUSH	DX
	MOV	DX,12		; Put bar over area code
	MOV	BX,OFFSET AREACD
	MOV	AL,3
	CALL	PHREV
;
PHAREX:	MOV	BX,OFFSET AREACD ; Get new area code
	MOV	CX,3
PHARE0:	CALL	CI
	CMP	AL,BS		; Backspace or CR?
	JZ	PHARE3
	CMP	AX,KAREA
	JZ	PHARE2
	CMP	AL,CR
	JZ	PHARE1
;
	CALL	DILLGL		; Make sure a digit
	JNZ	PHARE0
;
	RW
	MOV	[BX],AL		; Store digit & echo
	RO
	INC	BX
	PUSH	AX
	CALL	RSUM
	POP	AX
	CALL	CO
	LOOP	PHARE0
;
PHARE1:	POP	DX
	JMP	PH0A
;
PHARE2:	CALL	CURSOR		; Start over
	JMP	SHORT PHAREX
;
PHARE3:	CMP	CL,3		; At left?
	JZ	PHARE0
;
	INC	CL		; Move left
	DEC	BX
	PUSH	DX
	MOV	DX,CURPOS[BP]
	DEC	DL
	CALL	CURSOR
	POP	DX
	JMP	SHORT PHARE0


;--------------------------------------------------------------------------
; Set Prefix
;
;	Mode:	Edit
;
;-------------------------

PHPFIX:	CALL	DFLUSH		; Turn off bar
;
	PUSH	DX
	MOV	DX,26		; Put bar over prefix
	MOV	BX,OFFSET PREFIX
	MOV	AL,10
	CALL	PHREV
;
PHPFIA:	MOV	BX,OFFSET PREFIX ; Get new prefix
	MOV	CX,10
PHPFI0:	CALL	CI
	CMP	AL,BS		; Backspace or CR?
	JZ	PHPFI3
	CMP	AX,KPFIX
	JZ	PHPFI2
	CMP	AL,CR
	JZ	PHPFI1
;
	CALL	DILLGL		; Not a legal dial char?
	JNZ	PHPFI0
;
	RW
	MOV	[BX],AL		; Store digit & echo
	RO
	INC	BX
	PUSH	AX
	CALL	RSUM
	POP	AX
	CALL	CO
	LOOP	PHPFI0
PHPFI1:	POP	DX
	JMP	PH0A
;
PHPFI2:	CALL	CURSOR		; Start over
	JMP	SHORT PHPFIA
;
PHPFI3:	CMP	CL,10		; At left?
	JZ	PHPFI0
;
	INC	CL		; Move left
	DEC	BX
	PUSH	DX
	MOV	DX,CURPOS[BP]
	DEC	DL
	CALL	CURSOR
	POP	DX
	JMP	SHORT PHPFI0


;--------------------------------------------------------------------------
; Hang Up
;
;-------------------------

PHHANG:	CALL	DILERA			; clear dial stream to blanks
	CALL	DSTREAM			; display blank dial stream
	CALL	HANGUP			; disconnect modem
	JMP	PH7



If Enable_Term
;-----------------------------------------------------------------------------
; PHTERM	- Enters terminal mode using COM1, without checking carrier
;		Used for a direct connection.
;------------------------

Phterm:	mov	al,0
	mov	Term_Carr,al	; don't check carrier if direct connect mode
	mov	Term_Port,al	; Direct connect is always COM1
	jmp	Term_Entry	; Enter the Terminal Emulator

Endif



;--------------------------------------------------------------------------
; Start/Stop Timer
;
;-------------------------

PHTIMR:	CMP	[CALTIM],-1	; Timer off?
	JZ	PHTIM0
;
	CALL	TSTOP		; Stop timer
	JMP	PH7
;
PHTIM0:	CALL	TSTART		; Start timer
	JMP	PH7
;
SUBTTL	Phone from Keyboard

page
;----------------------------------------------------------------------------
; Dial From Keyboard
;---------------------
PHKEYB:	CALL	SCLEAR		; clear screen, home cursor, reset attriibute
	PUSH	SI
	CALL	PHEADER		; display header line
	mov	si,offset Kbrd_Help	; point to keyboard dial help text
	call	Str_Out_Cur	; output text, and set cursor position
	CALL	KEYERA		; clear dial buffer
	CALL	DKEY		; display current entered phone number
	CALL	DSTREAM		; display current dial stream
	POP	SI

PHKEY8:	push	si
	mov	si,OFFSET PHMFUN	; display function key labels
	call	Str_Out			; output the string
	pop	si

PHKEY9:	CALL	KEYCUR			; put cursor at dial position
	mov	bx,offset phmkey	; point to key vector table
	JMP	KEYS			; get a key
;
; Left
;
PHMLFT:	DEC	BYTE PTR EDPOS[BP] ; Not at start of line?
	JNS	PHMRG0
;
PHMLF0:	INC	BYTE PTR EDPOS[BP] ; Increment back to first position
	JMP	PHKEY9
;
; Right
;
PHMRGT:	MOV	AL,EDPOS[BP]	; End of line?
	CMP	AL,DILMAX 
	JZ	PHMRG0
;
	CBW			; Not null at end of data?
	ADD	AX,EDBFR
	MOV	DI,AX
	CMP	BYTE PTR [DI+BP],AH
	JNZ	PHMLF0
PHMRG0:	JMP	PHKEY9
;
; Backspace
;
PHMBS:	MOV	AL,EDPOS[BP]	; At start of line?
	DEC	AL
	JS	PHMRG0
	MOV	EDPOS[BP],AL
;
PHMBA:	CBW			; Point to current char in buffer
	ADD	AX,EDBFR
	MOV	DI,AX
	MOV	CX,DILMAX
;
	CALL	KEYCUR		; Close up line
	CALL	Set_Rev_Att
PHMB0:	INC	DI
	MOV	AL,[DI+BP]
	MOV	[DI+BP-1],AL
	OR	AL,AL
	JZ	PHMB1
	CALL	CO
	LOOP	PHMB0
	MOV	[DI+BP],CL
;
PHMB1:	MOV	AL,' '		; Blank char at end
	CALL	CO
	CALL	Set_Norm_Att
	JMP	PHKEY9
;
; Delete Character
;
PHMDEL:	MOV	AL,EDPOS[BP]	; Not right end?
	CMP	AL,DILMAX
	JNZ	PHMBA
PHMDE0:	JMP	PHKEY9
;
; Insert Character into Dial Stream
;
PHMINS:	MOV	AL,EDPOS[BP]	; At very end?
	CMP	AL,DILMAX
	JZ	PHMDE0
;
	CBW			; Rightmost char?
	MOV	DI,EDBFR
	ADD	DI,AX
	CMP	[DI+BP],AH
	JZ	PHMDE0
;
	MOV	CX,DILMAX	; Determine how many chars will move
	SUB	DI,AX
	ADD	DI,CX
	SUB	CX,AX
	PUSH	CX		; At end?
	JCXZ	PHMIN1
;
PHMIN0:	MOV	AL,[DI+BP-1]	; Move chars up 1
	MOV	[DI+BP],AL
	DEC	DI
	LOOP	PHMIN0
;
PHMIN1:	MOV	BYTE PTR [DI+BP],' ' ; Blank at insertion
;
	POP	CX		; Display changed line
	CALL	Set_Rev_Att
PHMIN2:	MOV	AL,[DI+BP]
	CALL	CO
	INC	DI
	LOOP	PHMIN2
	JMP	PHKEY9
;
; Erase Dial Stream
;
PHMERA:	CALL	KEYERA
	CALL	DKEY
	JMP	PHKEY9
;
; Type Character
;
PHMCHG:	CALL	KEYINS
PHMCH0:	JMP	PHKEY9
;
; Insert Prefix
;
PHMPFX:	MOV	BX,OFFSET PREFIX
PHMPF0:	MOV	AL,[BX]		; Null terminator?
	OR	AL,AL
	JZ	PHMCH0
;
	CMP	AL,' '		; Ignore blanks
	JZ	PHMPF1
	CALL	KEYINS
PHMPF1:	INC	BX
	JMP	SHORT PHMPF0
;
; Exit
;
PHMEXT:	XOR	DL,DL
	JMP	PH0B
;
; Dial Number Entered from Keyboard
;
PHMDIL:	CALL	BFRDIL
	JMP	SHORT PHMEXT
;
; Insert Char to Dial
;
;	On entry: AL contains char
;
KEYINS:
	PUSH	BX
	PUSH	DI
	CALL	DILLGL		; Illegal dial char?
	JNZ	KEYIN1
;
	MOV	BL,EDPOS[BP]	; Past right end?
	CMP	BL,DILMAX
	JZ	KEYIN1
;
	XOR	BH,BH		; Insert char into buffer & display it
	ADD	BX,EDBFR
	MOV	DI,BX
	MOV	[DI+BP],AL
	CALL	Set_Rev_Att
	CALL	CO
	CALL	Set_Norm_Att
;
	INC	BYTE PTR EDPOS[BP] ; Increment position & clear flag
KEYIN1:	POP	DI
	POP	BX
	RET
;
; Move Cursor to Dial Position
;
KEYCUR:
	PUSH	DX
	MOV	DL,EDPOS[BP]
	ADD	DL,DILCOL
	MOV	DH,PKEY
	CALL	CURSOR
	POP	DX
	RET
;
; Display Current Entered Keyboard Number
;
DKEY:
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	CURPOS[BP]	; Save current cursor
	MOV	DH,VIDATT[BP]	; Save video
	CALL	Set_Norm_Att
	mov	si,offset N_2_Dial	; point to number to dial message
	call	Str_Out_Cur		; output message and set curpos

	CALL	Set_Rev_Att

	MOV	SI,EDBFR	; Display it
	MOV	CX,DILMAX
DKE2:	MOV	AL,[SI+BP]
	OR	AL,AL
	JZ	DKE3
	CALL	CO
	INC	SI
	LOOP	DKE2
;
DKE3:	mov	al,pad
	add	al,cl
	mov	cl,al
	CALL	BLANK		; Blank the rest
;
	MOV	VIDATT[BP],DH	; Restore video & cursor
	POP	DX
	CALL	CURSOR
	POP	SI
	POP	DX
	POP	CX
	RET
;
; Erase Dial Stream
;
KEYERA:
	PUSH	CX
	PUSH	DI
	MOV	DI,EDBFR	; Zero dial buffer
	MOV	CX,DILMAX
KEYER0:	MOV	[DI+BP],CH
	INC	DI
	LOOP	KEYER0
	MOV	EDPOS[BP],CH
	POP	DI
	POP	CX
	RET
;---------------------------------------------------------------------------
; Dial Number in EDBFR
;
;	On exit: Z if "+" ends number or buffer empty
;------------------------------
PUBLIC	BFRDIL
BFRDIL:
	MOV	DI,EDBFR	; Empty buffer?
	MOV	CX,DILMAX
	CMP	[DI+BP],CH
	JNZ	BFRDI0
;
BFRDIB:	CALL	BEEP		; beep if no number to dial or '+' ends number
	XOR	AL,AL
	RET

BFRDI0:	XOR	BL,BL		; Clear first digit and modem flags
	MOV	First_Digit[bp],BL	
	MOV	MODEM[BP],BL

BFRDI1:	CMP	[DI+BP],CH	; At end of dial stream?
	JZ	BFRD11

	MOV	AL,[DI+BP]	; More number?
	CMP	AL,'+'
	jnz	Not_More
	mov	al,';'		; send a ';' to signify that modem should dial and wait
	call	Modem_Out
	mov	al,cr		; end modem dial command
	Call	Modem_Out
	mov	byte ptr First_Digit[bp],0	; reset first digit flag
	Jmp	short BFRDIB	; beep for the user

Not_More:
	PUSH	AX		; Display char being dialed
	CALL	DILINS
	POP	AX

	MOV	BL,NEW[BP]	; Redial buffer full?
	CMP	BL,DILMAX
	JZ	BFRD1A

	PUSH	AX
	XOR	BH,BH		; Store char at next position in redial buffer
	INC	BYTE PTR NEW[BP]
	ADD	BX,OFFSET REDIAL
	XOR	AH,AH		; (Null in AH is stored after char)
	RW
	MOV	[BX],AX
	RO
	CALL	RSUM
	POP	AX
;
BFRD1A:	CMP	AL,' '		; Ignore certain chars
	JZ	BFRDI5
	CMP	AL,'-'
	JZ	BFRDI5
	CMP	AL,')'
	JZ	BFRDI5
	CMP	AL,'('
	JZ	BFRDI5
;
BFRDI2:	CALL	BFRD22		; Hangup key hit?
	JZ	BFRDI4		; if no, then dial a digit 
	JMP	BFRD20		; else hangup, clear buffer, and return
;
BFRDI4:	MOV	AL,[DI+BP]	; Get a character
	CMP	AL,'M'		; if it's a MODEM call...
	JZ	BFRD10		; set modem flag
	CMP	AL,'W'		; Wait a second?
	jnz	Not_Wait
	mov	al,','

Not_Wait:
	call	Acc_Delay_Count		; accumulate dial delay count

	CALL	DIAL		; Dial a digit

BFRDI5:	INC	DI
	LOOP	BFRDI1
	JMP	SHORT BFRD11

BFRD10:	MOV	BYTE PTR MODEM[BP],1 ; Modem call

BFRD11:
	mov	al,cr		; send cr to initiate dialing
	call	Modem_Out
	call	Wait_Dial	; delay for (Dial_Delay) millisecs
	mov	byte ptr Dial_Delay[bp],20	; reset delay count
	PUSH	DX		; Display message indicating dial
	PUSH	SI
	MOV	DX,256*PDIAL+DILCOL
	CALL	CURSOR
	CALL	Set_Rev_Att
	push	bx
	push	cx
	push	dx
	mov	bl,vidatt[bp]
	mov	dx,CURPOS[bp]
	mov	si,offset Bfrd15	; assume modem call message

	TEST	BYTE PTR MODEM[BP],1 ; Modem call?
	JNZ	BFRD14
	mov	si,offset Bfrd12	; point to Normal end of dialing prompt
Bfrd14:
	call	Put_String		; display appropriate end of dialing prompt
	call	cursor
	pop	dx
	pop	cx
	pop	bx
	MOV	CX,DILMAX-BFRD13+1

BFRD17:	mov	al,pad
	add	al,cl
	mov	cl,al
	CALL	BLANK			; blank rest of line

	CALL	Set_Norm_Att
	mov	si,OFFSET key13a 	; get pointer to display hangup key label
	call	Str_Out			; output the string
	POP	SI
	POP	DX
;
	CALL	TSTART		; Start call timer
;
BFRD18:	TEST	BYTE PTR MODEM[BP],1 ; Not a modem call?
	JZ	BFRD19
;
	CALL	CARRIER		; No carrier?
	JNZ	BFRD19
If Enable_Term
	mov	al,0			; assume modem is on COM1
	test	byte ptr System_Setup,8	; check setup setting
	jnz	Ext_Modem		; if it's internal...
	inc	al			;  then select com2
Ext_Modem:
	mov	Term_Port,al		; tell terminal which port to use
	mov	al,1			; AL:= New State Number (State 1)
	mov	Term_Carr,al		; to turn on carrier check 
	jmp	Term_Entry		; Enter the Terminal Emulator
Endif

BFRD19:	CALL	BFRD22		; Not HANGUP?
	JZ	BFRD18

BFRD20:				; Hang-up
	CALL	DILERA
	CALL	DSTREAM
	CALL	HANGUP

	OR	AL,1		; NZ
	RET

BFRD22:				; Check if user wants to hang up
	CALL	CISTAT
	JZ	BFRD23
;
	CALL	CI		; Not hang-up key?
	CMP	AX,KHANG
	JNZ	BFRD22
;
	OR	AL,1		; NZ means hang up
BFRD23:	RET

;--------------------------------------------------------------------------
; before dialing the digit, accumulate an appropriate delay value in Dial_Delay
;	This delay value will be used to delay the hangup msg. so the modem has time 
;	to dial.
;------------------------

Acc_Delay_Count:
	push	ax
	push	bx
	push	cx
	cmp	al,';'			; only 0-9 and ',' cause delays
	jge	No_Add			; so don't add anything
	mov	bx,Dial_Delay[bp]	; get current delay time
	xor	ah,ah
	cmp	al,','			; ',' is a two second delay
	jne	Add_Digits		; digits are treated differently
	mov	ax,22			; 2200 ms delay for ','
	jmp	short Add_Delay		; to be added
Add_Digits:
	and	al,0fh			; convert digit to binary
	cmp	al,0
	jnz	NOT_0			; convert zeroes to 10 for pulsing
	mov	al,10
NOT_0:
	mov	cl,Delay_Val[bp]	; determine if TT or pulse
	or	cl,cl
	jz	Add_Delay		; if Pulse, ax = number of 100 ms counts
	mov	ax,1			; TT digits are all 100 ms delay
Add_Delay:
	add	bx,ax			; accumulate...
	mov	Dial_Delay[bp],bx	; ... into Dial_Delay
	jmp	short	Go_Dial		; and now we can dial
No_Add:
	cmp	al,'P'			; if ';', then go dial
	jl	Go_Dial
	mov	al,0			; assume Pulse dial delays
	jz	Set_Delay		; if 'T' then set delay val for tone
	inc	al
Set_Delay:
	mov	Delay_Val[bp],al
Go_Dial:
	pop	cx
	pop	bx
	pop	ax
	ret	

page
SUBTTL	Phone Directory Utilities

page
;--------------------------------------------------------------------------
; Init_Dflags	Clears dflags, and also sets COM1_2 to use the modem port 
;		selected from the setup menu. Then, It uses Rsize to checksum
;		the NovRam. Also, initializes the delay counter used by distim.
;------------------------
Init_Dflags:
Public	Init_Dflags
	push	ds			; move to correct data segment
	mov	ax,Monitor_Segment
	mov	ds,ax			; and...
Assume	ds: Monitor_Segment
	mov	dflags,0		; initialize dflags
	mov	Check_Delay,0		; and time delay for distim
	mov	ax,03f8h		; assume external modem (COM1)
	test	Byte ptr System_Setup,8	; init modem port flag
	jnz	Use_Com1
	mov	ax,2f8h			; use com2
Use_Com1:
	mov	Com1_2[bp],ax		; init for proper modem port
	pop	ds			; restore dataseg

Assume	ds:PhNovRam

PHX:	CALL	RSIZE		; Size memory, checksum, and reset NovRam if bad
	ret


;---------------------------------------------------------------------------
; Reverse Video Bar Over Chars
;
;	On entry: BX -> chars in battery RAM
;		  DX contains cursor address of field
;		  AL contains size of field
;
;	On exit:  VIDATT is reverse
;-----------------------------

PHREV:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	CL,AL		; CX is count
	XOR	CH,CH
	CALL	CURSOR		; Display chars in reverse
	CALL	Set_Rev_Att
PHRE0:	MOV	AL,[BX]		; End of chars?
	CMP	AL,CH
	JZ	PHRE1
	CALL	CO
	INC	BX
	LOOP	PHRE0
;
PHRE1:	CALL	BLANK		; Blank unused part of field
;
	CALL	CURSOR		; New cursor
;
	POP	DX
	POP	CX
	POP	BX
	RET

;------------------------------------------------------------------------
; Next Name
;
;	On entry: SI -> name in battery RAM
;
;	On exit:  SI -> next name
;		  AL contains size of name
;		  Z flag set if on last one
;---------------------

PHNEXT:
	PUSH	BX
	CMP	BYTE PTR [SI],0	; At end of directory?
	JZ	PHNEX1
;
	MOV	BX,SI
PHNEX0:	MOV	AL,[BX]		; Add size of name
	XOR	AH,AH
	ADD	BX,AX
;
	INC	BX		; Add size of phone number
	MOV	AL,[BX]
	ADD	BX,AX
	INC	BX
;
	MOV	AL,[BX]		; No more?
	OR	AL,AL
	JZ	PHNEX1
;
	AND	AL,01111111B	; Return size in AL & NZ
	MOV	SI,BX
;
PHNEX1:	POP	BX
	RET

;-------------------------------------------------------------------
; Show Directory Line on Screen
;
;	On entry: SI -> name in battery RAM
;		  DH contains cursor row
;		  DL contains cursor column (0 if bar over whole line)
;		  AL contains 1 for bar over phone number, 0 otherwise
;---------------------

PHSHOW:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	MOV	BL,AL		; No bar on line?
	CALL	Set_Norm_Att
	TEST	BL,1
	JZ	PHSHO0
;
	OR	DL,DL		; Not whole line?
	JNZ	PHSHO0
;
	CALL	Set_Rev_Att		; Bar over whole line
;
PHSHO0:	XOR	DL,DL		; Move to start of line
	CALL	CURSOR
;
	MOV	CL,[SI]		; Name size
	XOR	CH,CH
;
	MOV	BH,PHNAMZ+1	; Display name
	CALL	PHSHO3
;
	INC	SI		; No phone number?
	MOV	CL,[SI]
;
	DEC	BL		; No bar?
	JNZ	PHSHO1
	CALL	Set_Rev_Att
;
PHSHO1:	MOV	DL,PHNAMZ+1	; Move cursor
	CALL	CURSOR
;
	MOV	BH,PHNUMZ	; Display number
	CALL	PHSHO3
;
	CALL	Set_Norm_Att
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	RET
;
PHSHO3:				; Display CX chars starting at SI+1
	PUSH	CX
	JCXZ	PHSHO5		; None?
;
PHSHO4:	INC	SI		; Each char
	MOV	AL,[SI]
	CALL	CO
	LOOP	PHSHO4
;
PHSHO5:	POP	AX		; Blank the rest
	SUB	BH,AL
	MOV	CL,BH
	JMP	BLANK

;----------------------------------------------------------------------
; Prepare to Move Cursor
;
;	On entry: DI -> name from where moving
;		  SI -> name to where moving
;		  DX -> spot where cursor last was
;
;	On exit:  SI may be adjusted for size change during storage
;-----------------------

PHMOVE:
	CMP	BYTE PTR [DI],0	; Empty?
	JZ	PHMOV2
;
	CALL	PHSTORE		; Store any phone number revisions
;
	MOV	BYTE PTR EDPOS[BP],0 ; Zero position
;
	CMP	DI,SI		; New one same or below old one in RAM?
	JAE	PHMOV1
;
	SUB	SI,AX		; Adjust pointer from PHSTORE
;
PHMOV1:	PUSH	SI
	MOV	SI,DI		; Remove bar from line
	XOR	AL,AL
	CALL	PHSHOW
	POP	SI
;
PHMOV2:	JMP	REMAIN

;-------------------------------------------------------------------------
; Store Phone Number in Edit Buffer
;
;	On entry: DI -> name in edit buffer
;
;	On exit:  AX contains change in size
;-----------------------

PHSTORE:
	PUSH	CX
	PUSH	DI
	PUSH	SI
	MOV	AL,[DI]		; Point to phone number
	XOR	AH,AH
	ADD	DI,AX
	INC	DI
;
	XOR	CH,CH		; No phone number?
	MOV	CL,[DI]
	JCXZ	PHSTO2
;
	MOV	SI,DI		; Determine number of trailing blanks
	ADD	DI,CX
	MOV	AX,CX
PHSTO0:	CMP	BYTE PTR [DI],' '
	JNZ	PHSTO1
	DEC	DI
	LOOP	PHSTO0
;
PHSTO1:	RW
	MOV	[SI],CL		; New size of phone number
	RO
;
	SUB	AX,CX		; No trailing blanks?
	MOV	CX,AX
	JCXZ	PHSTO2
;
	MOV	SI,DI		; Delete excess baggage
	INC	SI
	CALL	PHERASE
	CALL	RSUM
	MOV	AX,CX
	JMP	SHORT PHSTO3
;
PHSTO2:	XOR	AX,AX		; No change in size
;
PHSTO3:	POP	SI
	POP	DI
	POP	CX
	RET

;-------------------------------------------------------------------------
; Check for Legal Dial Character
;
;	On entry: AL contains char
;
;	On exit:  Z if legal
;---------------------------

;
DILLGL:
	PUSH	CX
	PUSH	DI
	MOV	DI,OFFSET DILCHR ; Scan table for match
	MOV	CX,DILCHZ
	CALL	UPPER
DILLG0:	CMP	AL,CS:[DI]
	JZ	DILLG1
	INC	DI
	LOOP	DILLG0
DILLG1:	POP	DI
	POP	CX
	RET

;-------------------------------------------------------------------------
; Display Current Dial Stream
;----------------------------

DSTREAM:
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	CURPOS[BP]	; Save current cursor
;
	MOV	DH,VIDATT[BP]	; Save video
	CALL	Set_Norm_Att
;
	push	bx
	push	cx
	push	dx
	mov	dx,curpos[bp]
	mov	bx,normal
	CALL	Put_String_imm
	DB	30,0,PDIAL,"Dialed so far:  ",eos
	call	cursor
	pop	dx
	pop	cx
	pop	bx
	MOV	SI,DILBFR	; Display it
	MOV	CX,DILMAX
DSTRE2:	MOV	AL,[SI+BP]
	OR	AL,AL
	JZ	DSTRE3
	CALL	CO
	INC	SI
	LOOP	DSTRE2
;
DSTRE3:	mov	al,pad+1
	add	al,cl
	mov	cl,al
	CALL	BLANK		; Blank the rest
;
	MOV	VIDATT[BP],DH	; Restore video & cursor
	POP	DX
	CALL	CURSOR
	POP	SI
	POP	DX
	POP	CX
	RET

;-------------------------------------------------------------------------
; Erase Dial Stream
;------------------------------

DILERA:
	PUSH	CX
	PUSH	DI
	MOV	DI,DILBFR	; Zero dial buffer
	MOV	CX,DILMAX
DILER0:	MOV	[DI+BP],CH
	INC	DI
	LOOP	DILER0
	MOV	DILPOS[BP],CH
	MOV	NEW[BP],CH
	POP	DI
	POP	CX
	RET

;-------------------------------------------------------------------------
; Insert Char to Dial
;
;	On entry: AL contains char
;------------------------------

DILINS:
	PUSH	DX
	PUSH	DI
	CALL	DILLGL		; Illegal dial char?
	JNZ	DILIN1
;
	MOV	DL,DILPOS[BP]	; Not right end?
	CMP	DL,DILMAX
	JNZ	DILIN0
;
	CALL	BEEP		; Oops
	JMP	SHORT DILIN1
;
DILIN0:	XOR	DH,DH		; Insert char into buffer
	MOV	DI,DILBFR
	ADD	DI,DX
	MOV	[DI+BP],AL
;
	ADD	DL,DILCOL	; Display inserted char
	MOV	DH,PDIAL
	PUSH	AX
	CALL	CURSOR
	POP	AX
	CALL	CO
;
	INC	BYTE PTR DILPOS[BP] ; Increment position & clear flag
DILIN1:	POP	DI
	POP	DX
	RET

;-------------------------------------------------------------------------
; Search Directory Alphabetically
;
;	On entry: EDBFR contains search string
;		  CL contains non-zero number of search chars
;
;	On exit:  SI -> found spot
;		  Z flag set if end of directory (AX -> last dir entry)
;
;	Note that this routine can return SI pointing to the null at the
;	end of the directory.  AX points to the last entry in the directory
;	in this case only.
;-----------------------------

PSEARCH:
	PUSH	CX
	PUSH	DI
	MOV	SI,OFFSET RAMBOT ; Anything in directory?
	MOV	AX,SI
	MOV	CH,[SI]
	OR	CH,CH
	JZ	PSEAR5
;
PSEAR0:	PUSH	CX
	PUSH	SI
	MOV	DI,EDBFR	; Compare to EDBFR
PSEAR1:	INC	SI
	MOV	AL,[SI]
	CALL	UPPER
	MOV	AH,AL
	MOV	AL,[DI+BP]
	CALL	UPPER
	CMP	AH,AL
	JA	PSEAR4
;
	JNZ	PSEAR2		; No match
;
	INC	DI		; Exhausted EDBFR?
	DEC	CL
	JZ	PSEAR3
;
	DEC	CH		; More in dir string?
	JNZ	PSEAR1
;
PSEAR2:	POP	SI		; Next in dir
	POP	CX
	CALL	PHNEXT
	MOV	CH,AL
	JNZ	PSEAR0
;
	MOV	AX,SI		; AX -> last dir entry
;
	XOR	CH,CH		; Point to null at end of dir
	MOV	CL,[SI]
	INC	CX
	ADD	SI,CX
	MOV	CL,[SI]
	INC	CX
	ADD	SI,CX
;
	XOR	CL,CL		; Z
	JMP	SHORT PSEAR5
;
PSEAR3:	INC	CL		; NZ
;
PSEAR4:	POP	SI
	POP	CX
;
PSEAR5:	POP	DI
	POP	CX
	RET

;-------------------------------------------------------------------------
; Insert Directory Data
;
;	On entry: SI -> spot in battery RAM
;		  CX contains number of bytes to be inserted
;
;	On exit:  CY if successful
;----------------------

PHHOLE:
	CALL	RHOLE		; No insert error?
	JC	PHHOL1
;
	PUSH	CX
	PUSH	SI		; Any appointments?
	MOV	SI,[APP1ST]
	CMP	BYTE PTR [SI],-1
	JNZ	PHHOL0
;
	POP	SI		; Oops
	POP	CX
	CLC
	RET
;
PHHOL0:	MOV	CL,[SI+5]	; Erase oldest appointment to make room
	AND	CL,01111111B
	XOR	CH,CH
	ADD	CX,6
	CALL	RERASE
	POP	SI
	POP	CX
	JMP	SHORT PHHOLE
;
PHHOL1:	RW
	ADD	[APP1ST],CX	; Adjust where appointments start
	RO
	STC
	RET

;-------------------------------------------------------------------------
; Erase Directory Data
;
;	On entry: SI -> spot in battery RAM
;		  CX contains number of bytes to be erased
;------------------------

PHERASE:
	CALL	RERASE
	RW
	SUB	[APP1ST],CX
	RO
	RET

;-------------------------------------------------------------------------
; Flush Directory Edit Buffer into RAM
;-------------------------

DFLUSH:
	MOV	DI,SI
	JMP	PHMOVE
;
; Display Dial Help if Editing or Number Dialed So Far if Not
;
DHELP:
	OR	DL,DL		; Editing?
	JNZ	DHEL0
;
	JMP	DSTREAM		; Display dialed number
;
DHEL0:	PUSH	SI
	PUSH	DX
	PUSH	CURPOS[BP]	; Save cursor & video
	MOV	DH,VIDATT[BP]
	CALL	Set_Norm_Att

	mov	si,offset U_D_Help
	call	Str_Out_Cur

DHEL1:	MOV	VIDATT[BP],DH	; Restore video & cursor
	POP	DX
	CALL	CURSOR
	POP	DX
	POP	SI
	RET

;-------------------------------------------------------------------------
; Display Screen Header
;---------------------------
PHEADX:
	PUSH	BX
	PUSH	DX
	PUSH	SI
	JMP	SHORT PHEAD2
;
PHEADER:
	PUSH	BX
	push	cx
	PUSH	DX
	PUSH	SI
	CALL	Set_Norm_Att
	mov	dx,curpos[bp]
	mov	bx,normal
	CALL	Put_String_imm
	DB	"Area Code: ",eos
	call	cursor
	MOV	BX,OFFSET AREACD
	MOV	AL,'('
	CALL	CO
	MOV	CX,3
PHEAD0:	MOV	AL,[BX]			; put out area code in NovRAM
	CALL	CO
	INC	BX
	LOOP	PHEAD0
	MOV	AL,')'
	CALL	CO

; now display prefix number
	mov	bx,normal
	CALL	Put_String_imm
	DB	30,18,0,"Prefix: ",0
	call	cursor
	MOV	BX,OFFSET PREFIX
PHEAD1:	MOV	AL,[BX]		; Null?
	OR	AL,AL
	JZ	PHEAD2
	CALL	CO
	INC	BX
	JMP	SHORT PHEAD1
;
PHEAD2:	
	mov	bx,normal
	CALL	Put_String_imm
	DB	30,40,0,"Call Timer: ",0
	call	cursor
	MOV	AX,CURPOS[BP]
	MOV	TIMPOS[BP],AX

	CMP	[CALTIM],-1	; Timer running?
	JNZ	PHEAD3

	mov	dx,curpos[bp]
	mov	bx,normal
	CALL	Put_String_imm
	DB	"00:00:00",eos
	call	cursor
	JMP	SHORT PHEAD4
;
PHEAD3:	CALL	DISTIM		; Display actual time
;
PHEAD4:	MOV	WORD PTR REMCUR[BP],64 ; Remaining memory & dial stream
	MOV	BYTE PTR RAMCHG[BP],1
	CALL	REMAIN
	POP	SI
	POP	DX
	pop	cx
	POP	BX
	RET

;-------------------------------------------------------------------------
; Display Elapsed Call Time
;
;	On entry: TIMPOS contains cursor position for time
;----------------------
public	Distim

DISTIM:
	CMP	[CALTIM],-1		; Call timer not running?
	JZ	DIST11
	push	ds
	mov	ax,Monitor_Segment	; get proper segment
	mov	ds,ax
Assume	ds: Monitor_Segment
	dec	Check_Delay		; time to check RTC?
	pop	ds
Assume	ds: PhNovRam

	jnz	Dist11			; skip if counter not timed out
;
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	MOV	AH,2CH		; Get current time
	INT	1AH

	MOV	SI,TIMPRV	; Store time just read
	MOV	DL,DH
	XCHG	[SI+BP],DL
	MOV	AX,CX
	XCHG	[SI+BP+1],AX

	CMP	DL,DH		; Matches previous time?
	JNZ	DIST0
	CMP	AX,CX
	JZ	DIST10
;
DIST0:	PUSH	CURPOS[BP]	; Save cursor & video attributes there
	MOV	BL,VIDATT[BP]
	CALL	Set_Norm_Att
;
	MOV	SI,DX
	MOV	DX,TIMPOS[BP]	; Move cursor to timer spot
	CALL	CURSOR
	MOV	DX,SI
;
	MOV	SI,OFFSET CALTIM ; Compute elapsed time
	SUB	DH,[SI+2]
	JNC	DIST1
	ADD	DH,60
	STC
DIST1:	SBB	CL,[SI+1]
	JNC	DIST2
	ADD	CL,60
	STC
DIST2:	SBB	CH,[SI]
	JNC	DIST3
;
	CALL	TSTOP		; Turn off timer if too long
	JMP	SHORT DIST4
;
DIST3:	MOV	AL,CH		; Display hrs, min, secs
	call	No_Zero_Supp	; don't suppress zeroes in hours
	CALL	DISHR
	CALL	DIST12
	MOV	AL,CL
	CALL	DISMIN
	CALL	DIST12
	MOV	AL,DH
	CALL	DISMIN
;
DIST4:	POP	DX		; Restore cursor & video
	CALL	CURSOR
	MOV	VIDATT[BP],BL
;
DIST10:	POP	SI
	POP	DX
	POP	CX
	POP	BX
DIST11:	RET
;
DIST12:				; Display part of time
	MOV	AL,':'
	JMP	CO
;
; Start Call Timer
;
TSTART:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	AH,2CH		; Get current time
	INT	1AH

	MOV	BX,OFFSET CALTIM ; Store time
	RW
	MOV	[BX],CH
	MOV	[BX+1],CL
	MOV	[BX+2],DH
	RO
	POP	DX
	POP	CX
	POP	BX
	JMP	RSUM
;
; Stop Call Timer
;
TSTOP:
	RW
	MOV	[CALTIM],-1	; -1 means stopped
	RO
	JMP	RSUM

page
;---------------------------------------------------------------------------
; THE FOLLOWING ROUTINES ARE USED TO CONTROL THE MODEM.
;	The routines will dial digits, hangup, initialize, and check carrier
;	of the Modem.
;-------------------------

;----------------------------------------------------------------------------
; Dial One Digit
;----------------------

DIAL:
	PUSH	DX
	cmp	byte ptr First_Digit[bp],0	; see if this is the first digit being dialed
	jnz	Not_1st
	push	ax
	push	si
	call	DTR_On			; turn on DTR
	mov	si,offset Dial_Pfx	; point to dial prefix
	call	Modem_String
	pop	si
	pop	ax			; get back char to dial
	inc	Byte Ptr First_Digit[bp]	; not first digit anymore
Not_1st:
	call	Modem_Out		; send char to modem
	pop	dx
	ret

;--------------------------------------------------------------------------
; Hang Up Receiver
;--------------------------


HANGUP:
	mov	byte ptr First_Digit[bp],0	; next number needs pre-dial cmnd
	PUSH	DX
	push	cx
	push	si
	call	DTR_Off				; drop DTR to Modem
	pop	si
	pop	cx
	POP	DX
	RET
;---------------------------------------------------------------------------
; Carrier Status
;
;	On exit:  Z if carrier detected
;-----------------------

CARRIER:
	PUSH	DX
	MOV	DX,Com1_2[bp]	; USE Modem port
	add	dx,6		; index to line status register
	in	al,dx		; get the modem status
	XOR	AL,10000000B	; Carrier Detect?
	TEST	AL,10000000B
	POP	DX
	RET


;-----------------------------------------------------------------------------
; DTR_On -- DTR_Off
; 	turns DTR on or off depending on the entry point.  It delays for
; 300ms following the change to allow the modem to detect it.
;-----------------------

DTR_On:		; enable dtr on COM1_or COM2 whichever is being used
	push	ax
	mov	al,1			; set to turn on DTR
	jmp	short DTR_Chg	; change DTR

DTR_Off:
	push	ax
	xor	al,al			; Set to turn off DTR
DTR_Chg:
	push	cx
	push	dx
	mov	dx,Com1_2[bp]		; get bit that indicates port to ah bit 0
	add	dx,4			; select Modem control register
; dx = COM1 or COM2 modem control reg port addr.

	out	dx,al			; turn on DTR
	mov	cx,3			; delay 3*100 ms
	call	M_Delay	
	pop	dx
	pop	cx
	pop	ax
	ret




;-----------------------------------------------------------------------
; Modem_String	On entry, CS:si points to the string of characters to be
;		sent to the modem.  The string must be terminated with a
;		'0'.  On exit, SI points to end of string, ax changed,
;		all other registers preserved.
;-------------------

Modem_String	proc	near
	Public	Modem_String
	cld				; clear direction
Next_M_Char:
	lods	byte ptr cs:[si]	; get a character
	cmp	al,eos			; if
	jnz	M_S_1			;  (end of string)
	ret				; then return
M_S_1:					; else
	call	Modem_Out		;   send the character
	jmp	Next_M_Char		;   and get the next one
Modem_String	endp




page
;-------------------------------------------------------------------------
; Modem_Out	Sends the character in AL out to Com1 or Com2 depending 
;		on whether the Modem is internal (Com2) or external (Com1)
;		according to the setup selection.
;		ON entry, AL=char
;		On Exit	AX altered, all other registers preserved.
;
;		This routine will wait until the character can be sent.
;-----------------------
Modem_Out	Proc	near
	Public	Modem_Out
	push	dx
	push	ax
	mov	dx,Com1_2[bp]			; select modem port to use
	add	dx,5				; select status register
Not_Rdy:
	in	al,dx				; get port status
	and	al,60h				; get THRE and TE bits
	cmp	al,60h				; see if ready for next character
	jnz	Not_Rdy				; loop until ready
	pop	ax				; get char to send to al
	sub	dx,5				; point back to XMIT data register
	out	dx,al
	pop	dx
	ret
Modem_Out	Endp

Wait_Dial:
	mov	cx,Dial_Delay[bp]
	add	cx,30			; add 2 second delay for dial tone wait
	
;--------------------------------------------------------------------
; M_DELAY: Delays for (cx) * 100 ms    CX destroyed
;---------------------

M_Delay:
	push	cx
	mov	cx,24800		; loop count for 100 ms
Inner_Lp:
	loop	Inner_Lp
	pop	cx
	loop	M_Delay
	ret

Monitor_Segment	ENDS

	END
