;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;	These routines are used for formatting disks in BACKUP/RESTORE
;	They are contained in the file BR4.ASM


;	This routine will set up the drive and side parameters
;	needed for formatting disks and do a long call to
;	a routine to do the formatting. This routine is needed
;	so that an 8080 program model can be set up for the
;	format subroutine. It returns 1 (TRUE) if the disk
;	has been formatted correctly else 0 (FALSE).

PGROUP	GROUP	PROG
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME CS:PGROUP
	PUBLIC	FRMT

PARMS	STRUC
OLD_BP	DW	?
RETN	DW	?
DRV	DW	?
SINGLE	DW	?
PARMS	ENDS

FRMT	PROC	NEAR
	PUSH	BP
	MOV	BP,SP

;  SET UP AH WITH DRIVE NUMBER (A: = 0) AND AL WITH FLAG (NON-ZERO
;  MEANS SINGLE SIDED

	MOV	AX,[BP].DRV	; GET DRIVE AND
	MOV	AH,AL		; MOVE IT TO AH
	MOV	AL,0		; ASSUME DBL. SIDED
	CMP	[BP].SINGLE,0	; TEST
	JZ	SKIP
	MOV	AL,1		; SINGLE SIDED
SKIP:	PUSH	DS		; SAVE SEGMENT REGS.
	PUSH	ES
	CALL	FAR PTR FRMT1	; FORMAT DISK
	POP	ES		; RESTORE REGS AND RETURN
	POP	DS
	POP	BP
	MOV	AX,1		; ASSUME NO ERROR
	JNC	EXIT
	SUB	AX,AX		; ERROR IN FORMAT
EXIT:	RET
FRMT	ENDP
PROG	ENDS


;	This routine will initialize the format program and 
;	call the format subroutine. It expects AH to have the
;	drive (A: = 0 etc.) and AL to have a flag for the number
;	of sides (non-zero is single sided)

CODE	SEGMENT PUBLIC 'PROG'
	ASSUME	CS:CODE,DS:CODE,ES:CODE
	EXTRN	DSKINIT:NEAR,DSKFMT:NEAR
	EXTRN	SWITCHMAP:WORD,SWITCHCOPY:WORD
	EXTRN	DRIVE:BYTE
	PUBLIC	FRMT1

	ORG	100H
PROGSTRT LABEL	BYTE

	ORG	0
FRMT1	PROC	FAR
	PUSH	AX		; SAVE PARAMETERS
	MOV	AX,CS		; SET UP LIKE 8080 MODEL
	MOV	DS,AX
	MOV	ES,AX
	POP	AX		; RESTORE PARAMETERS
	MOV	DRIVE,AH	; SET DRIVE FROM AH
	MOV	BX,10H		; VERIFY AND DBL. SIDED
	CMP	AL,0		; IF AL = 0 THEN DBL. SIDED
	JZ	NEXT
	MOV	BX,14H		; ELSE SINGLE SIDED
NEXT:	MOV	SWITCHMAP,BX
	PUSH	BX		; SAVE FLAGS
	CALL	DSKINIT		; INITIALIZE FORMAT
	POP	BX		; RESTORE FLAGS
	MOV	SWITCHMAP,BX
	MOV	SWITCHCOPY,BX
	CALL	DSKFMT		; FORMAT DISK
	RET
FRMT1	ENDP
	DB	OFFSET (PROGSTRT-$) DUP(?)
CODE 	ENDS
	END
