	PAGE ,132
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

TITLE	Z150FMT

;***
;
;  Z-150 FORMAT OEM MODULE
;
;	9/9/83 - RJM
;
;	Supports the following formats:
;		1) 8x512 single sided
;		2) 8x512 double sided
;		3) 9x512 single sided
;		4) 9x512 double sided
;		5) Winchester disk partitions
;
;	Version 1.01 - Flag partition as formatted in the BIOS
;	Version 1.02 - Flag bad sectors from bad sector table
;	Version 1.03 - Use new configuration table at beginning of BIOS
;	Version 1.04 - Fix bug in formatting single sided floppies
;	Version 1.05 - Fix bug in WRTFAT, mismatched push/pop in case
;		       of error writing FAT
;	Version 1.06 - BIOS moved to 70H
;	Version 1.07 - Flag partition as formatted at end of DISKFORMAT
;		       instead of at end of BADSECTOR so that reporting of
;		       bad sector does not cause Abort, Retry or Ignore
;	Version 1.08 - Module now gets Sector per track info. from
;		       controller.
;	Version 1.09 - Module clears directory of winchester drive to prevent
;		       Microsoft FORMAT's DEL *.* command from trashing the FAT.
;		       Also the presence of the MAP program is detected, and
;		       FORMAT not allowed if so.
;	Version 1.10 - Correct problem with verifying double sided disks as if
;		       they were single sided. i.e. Bad sectors were marked
;		       approximately half as far into the disk as they should
;		       have been.
;	Version 1.11 - 10/17/84 Correct off by one problem in reporting bad
;		       sector number of winchester bad sectors.
;	Version 1.12 - 10/23/84 Correct problem with "Format Failure" depending
;			on load address of the format program. Caused by buffer
;			address passed by format track call crossing 64k DMA
;			boundry.
;***

FALSE	=	0
TRUE	=	NOT FALSE

ZENITH		=	TRUE
NBI		=	FALSE

	.XLIST
	INCLUDE ..\COMMONS\MSDOS.DEF
	INCLUDE ..\COMMONS\LOADER.DEF		;Loader Format definitions
	INCLUDE ..\COMMONS\Z150ROM.DEF
	INCLUDE	..\COMMONS\Z150BIOS.DEF
	INCLUDE ..\COMMONS\MACRO.ASM
	INCLUDE ..\COMMONS\DRIVERS.DEF
	INCLUDE ..\COMMONS\CONFIG.DEF
	INCLUDE ..\COMMONS\ASCII.DEF
	.LIST


CODE	SEGMENT PARA PUBLIC 'PROG'  	; This segment def. must appear as is for
				    	; linking as a subroutine
CODORG = $

	ASSUME	CS:CODE, DS:CODE, ES:CODE

;	Publics for FORMAT module

	PUBLIC	FATID, STARTSECTOR, SWITCHLIST, FREESPACE
	PUBLIC	INIT, DISKFORMAT, BADSECTOR, DONE, WRTFAT
	PUBLIC	FATSPACE, HARDFLAG

	EXTRN	SWITCHMAP:WORD, DRIVE:BYTE

	IF	ZENITH
	DB	'Z150FMT - (C) Copyright 1983 by Zenith Data Systems'
	ENDIF

	IF	NBI
	DB	'Z150FMT - (C) Copyright 1983 by NBI'
	ENDIF

	DB	'Version 1.12'

FATID	DB	?		; Fat ID

STARTSECTOR DW	?		; Sector number of start of data area

;	Switches: 8=8X512, V=verify, M=Min, O = version 1.1 compatible
;		  C=Clr, S=Sys, N=noprmpt)
SWITCHLIST DB	6,"8VNMCS"

FREESPACE DW	ENDBOOT 	; Addr of end of program

FATSPACE  DW	OFFSET FATBUF
FATBUF    DB	6*1024 DUP(0)	; Space for maximum size FAT

HARDFLAG  DB	0		; Hard disk flag (initially false)

FFLAG	DB	?		; Storage for partition flags



;	Sector interleave table
;
;	First entry is count of sector entries that follow
;

INTTAB	DW	?		; Pointer to correct table
INT8	DB	8, 1, 2, 3, 4, 5, 6, 7, 8
INT9	DB	9, 1, 2, 3, 4, 5, 6, 7, 8, 9

;
;  DATA
;

BUF		DW	?		; Buffer pointer for z150fmt
DUMMY_BUF	DB	2*SEC_SIZE DUP(0)	; Half used for disk buffer
					; other half used for bad sector table
NTRACKS		DW	?		; Number of tracks (1 per side)
DRV1		DB	?

;	Floppy formatting variables

TRACK	DB	0		; Current track number
SECTOR	DB	0
SIDE	DB	0		; Current side number
BPS	DB	2		; Bytes per sector (0=128, 1=256, 2=512, 3=1024)

;	Fixed disk formatting variables

NUMSECS	DW	?
LSECTOR	DW	?

;	Bad sector related variables

BS_FLAG	DB	?		; Flag for valid bad sector table found
BS_BUF	DW	?		; Offset of bad sector buffer
NEXT_BS	DW	?		; Offset (into BS_BUF) of the next bad sector
HEADS	DW	?		; Number of heads on the winchester disk
SPT	DW	?		; Number of sectors per track


RETRY_COUNT DB	?

DISK_MSG   DB	'Place disk '
DRV	   DB	'A in drive A:.', 0DH, 0AH
	   DB	'Press any key when ready.$'
CRLF	   DB	0DH, 0AH, '$'

EXTRA_SEG	=	60H	; Extra segment to ensure no DMA errors at format time
ADDR_FIELD 	=	0	; Address fields for floppy format, located
				; at offset 0 of EXTRA_SEG

ONE_DRIVE  DB	?
NUM_FLOPPY DB	?

;	BPB's for floppys, must be in the following order
;	 9x1, 9x2, 8x1, 8x2
;
FLOPPY_BPBS	LABEL	BYTE
BPB_9X1	BPB_STRUC <512, 1, 1, 2,  64,   9*40, 0FCH, 2, 9, 1, 0, 0>
BPB_9X2	BPB_STRUC <512, 2, 1, 2, 112, 9*40*2, 0FDH, 2, 9, 2, 0, 0>
BPB_8X1	BPB_STRUC <512, 1, 1, 2,  64,   8*40, 0FEH, 1, 8, 1, 0, 0>
BPB_8X2	BPB_STRUC <512, 2, 1, 2, 112, 8*40*2, 0FFH, 1, 8, 2, 0, 0>

;	Message for if MAP program is installed

MAP_MSG	DB	CC_CR, CC_LF,"Error - Cannot format with MAP installed", CC_CR, CC_LF, "$"


;**
;  Initialization code
;
;      This routine is called once at the start of the
;      FORMAT program after the switches have been processed.
;	It first sets up a buffer pointer to a buffer that does
;	not cross a 64Kb memory boundry (so ROM disk writes will
;	work correcty) then it sets up the loader table at the start of the
;	cold boot loader
;
;	EXIT:	DS:SI - Loader table to be put on disk
;

INIT	PROC	NEAR

	CALL	LOCMAP			; Ensure MAP is not present
	JNZ	INIT0			; Skip if MAP not present else

	MOV	DX,OFFSET MAP_MSG	; Issue message and fail format
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	STC
	RET

INIT0:
	CALL	SETBUF			; Prepare buffer
	CALL	COUNT_FLOPPY		; Determine number of floppys
	MOV	AL,DRIVE
	MOV	DRV1,AL
	CMP	AL,NUM_FLOPPY		; Check for fixed disk
	JB	INIT2			; Jmp for floppy disk

;	Fixed disk drive preparation

	SUB	AL,NUM_FLOPPY		; Bias the fixed disk number
	MOV	DRV1,AL
	MOV	HARDFLAG,1		; Flag as hard disk to format module
	OR	SWITCHMAP,1 SHL 1	; Set /C switch for fixed disk

	MOV	AX,BIOS2_SEG		; Address BIOS data for fixed disk info.
	MOV	DS,AX

	ASSUME	DS:NOTHING

;	Check to see fixed disk is assigned

	MOV	DI,DS:[CONFIG_PTR]
	MOV	SI,DS:[DI+FIXED_FLAGS]	; Ensure disk is assigned
	MOV	AL,ES:DRV1
	CBW
	ADD	SI,AX
	TEST	BYTE PTR [SI],1
	JNZ	INIT1
	PUSH	CS			; Restore data
	POP	DS
	STC				; Error disk not assigned
	RET

;	Address the correct BPB

INIT1:
	MOV	SI,DS:[DI+FIXED_BPBS]		; Get pointer to BPB's
	MOV	AL,TYPE BPB_STRUC		; Calculate offset
	MUL	ES:DRV1
	ADD	SI,AX

;	Move fixed BPB into the loader

	MOV	DI,OFFSET BPBTAB		; Get loader dest.
	MOV	CX,TYPE BPB_STRUC		; Number of bytes to move
	CLD
	REP	MOVSB
	PUSH	CS
	POP	DS

	ASSUME	DS:CODE

	MOV	AL,BYTE PTR BPBTAB+BPB_UNIT
	MOV	DRV1,AL

;	Get the bad sector table from the winchester

	CALL	GET_BST			; Set BS_FLAG to TRUE if good table found
	CMP	BS_FLAG,TRUE
	JNZ	INIT1A
	CALL	LOCATE_BS
INIT1A:
	MOV	SI,OFFSET BPBTAB		; Return offset of BPB
	JMP	INIT4

;	Prepare for floppy format

INIT2:
	CMP	ONE_DRIVE,1		; Is this a one drive system
	JNZ	INIT3
	MOV	DRV1,0			; Ensure unit 0 is accessed
INIT3:
	CALL	PLFT			; Patch loader format table
	CALL	SIT			; Set up the interleave table

INIT4:
	CALL	SET_START

	JMP	GOODRET 		; No special initialization needed

INIT	ENDP


;	SETBUF - Prepare a buffer that does not cross a 64kb boundry
;
SETBUF	PROC	NEAR

	MOV	BUF,OFFSET DUMMY_BUF	; Save address of buffer
	MOV	BS_BUF,OFFSET DUMMY_BUF+SEC_SIZE	; Set up bad sector buffer
	MOV	AX,CS			; Get physical address of buffer
	MOV	CL,4
	SHL	AX,CL
	ADD	AX,OFFSET DUMMY_BUF
	ADD	AX,SEC_SIZE		; Add size of buffer
	JNC	SB1			; Jmp if buffer not over 64k boundry
	ADD	BUF,SEC_SIZE		; Get good buffer
	SUB	BS_BUF,SEC_SIZE		; Flip BS buffer to unused half
SB1:
	RET

SETBUF	ENDP

;	COUNT_FLOPPY - Determine the number of floppy drives in the system.
;		Set the location NUM_FLOPPY with the count and set ONE_DRIVE
;		to 1 if a 1 floppy system is present.
;
;	ENTRY:	None
;
;	EXIT:	NUM_FLOPPY - Number of floppy drives in the system
;		ONE_DRIVE -  Set to 1 if a one floppy system
;
COUNT_FLOPPY	PROC	NEAR

	MOV	ONE_DRIVE,0		; Assume more than one drive
	INT	EQUIPMENT_INTR		; Get equipment info.
	ROL	AL,1			; Isolate drive bits
	ROL	AL,1
	AND	AL,3
	JNZ	CF1			; Jmp if more than 1 drive
	MOV	ONE_DRIVE,1		; Flag one drive system
	INC	AL			; Account for imaginary drive
CF1:
	INC	AL			; Correct count
	MOV	NUM_FLOPPY,AL		; Return count of floppys
	RET

COUNT_FLOPPY	ENDP


SET_START	PROC	NEAR

;	Calculate the data start sector (directory sectors + reserved sectors
;		+ fat sectors).

	MOV	AX,WORD PTR BPBTAB+BPB_DIRENTS	; Get number of directories
	MOV	BX,32			; times bytes per entry
	MUL	BX
	ADD	AX,WORD PTR BPBTAB+BPB_SECSZ	; Round up to next sector
	DEC	AX
	SUB	DX,DX
	DIV	WORD PTR BPBTAB+BPB_SECSZ	; Number of directory sectors
	ADD	AX,WORD PTR BPBTAB+BPB_RES	; Add in reserved
	MOV	BX,AX			; Save current count

	MOV	DX,WORD PTR BPBTAB+BPB_FATSECS	; find number of fat sectors
	MOV	AL,BYTE PTR BPBTAB+BPB_NFATS	; Times number of FAT's
	CBW
	MUL	DX
	ADD	AX,BX			; Get final result

	MOV	STARTSECTOR,AX		;Set it
	RET

SET_START	ENDP


;**
;  Disk formatting routine
;	This routine will check for a one drive system and
;	if necessary get a disk from the user. It initializes
;	variables needed by BADSECTOR when it formats the disk
;
;	ENTRY:	None
;	EXIT:	TRACK = 0 (Start track)
;		SIDE  = 0 (Start side)
;
DISKFORMAT:

	MOV	AH,DIO_RESET		; Get recall command
	INT	DISK_IO_INTR

;	Test for a fixed disk drive

	TEST	DRV1,80H
	JNZ	DF2

	CMP	ONE_DRIVE,1
	JNZ	DF0

	SUB	BX,BX			; Address bios data
	MOV	DS,BX

	ASSUME	DS:NOTHING

	MOV	AL,DRIVE		; Get formats drive number
	MOV	AH,AL			; Save this drive number
	TMP	=	BIOS_EXTRA SHL 4 + OFFSET LAST_DRIVE
	XCHG	AL,DS:[TMP]		; Get last accessed drive
	PUSH	CS
	POP	DS

	ASSUME	DS:CODE

	CMP	AL,AH			; Same as this one
	JE	DF0
	ADD	AH,'A'			; No get new disk
	MOV	BYTE PTR DRV,AH
	SYS	DOSF_OUTSTR,<OFFSET DISK_MSG>
	MOV	AH,DOSF_CONINF
	MOV	AL,DOSF_CONIN
	INT	DOSI_FUNC
	SYS	DOSF_OUTSTR,<OFFSET CRLF>

;	Prepare for a floppy operation

DF0:

;	Check which sector per track format and ensure floppy
;	disk table agrees

	SUB	AX,AX
	MOV	ES,AX

	ASSUME	ES:NOTHING

	TMP	=	BIOS_EXTRA SHL 4 + OFFSET BIOS_DPT + 4
	MOV	BYTE PTR ES:[TMP],9	; Set the disk parameter block

	TEST	SWITCHMAP,1 SHL 5
	JZ	DF0A

	MOV	BYTE PTR ES:[TMP],8

;	Set up number of tracks

DF0A:
	PUSH	CS
	POP	ES

	ASSUME	ES:CODE

	MOV	NTRACKS,40
	TEST	SWITCHMAP,1 SHL 2
	JNZ	DF1
	SHL	NTRACKS,1
DF1:
	MOV	TRACK,0 		; Start at track zero
	MOV	SIDE,0			; Start with side zero
	JMP	SHORT GOODRET

;	Prepare for fixed disk verification

DF2:
	CALL	CLEAR_DIR	; Clear the directory of the disk to prevent
				; a later DEL *.* command from picking up a
				; bad directory and screwing up the FAT
	JC	SHORT BADRET
	MOV	AX,WORD PTR BPBTAB+BPB_SECS	; Save number of sectors
	MOV	NUMSECS,AX

	MOV	AX,WORD PTR BPBTAB+BPB_HIDDEN	; Set start sector for verify
	MOV	LSECTOR,AX

;	Flag partition as formatted

	MOV	AL,DRIVE		; Determine drive index
	SUB	AL,NUM_FLOPPY
	CBW
	MOV	SI,AX
		
	MOV	AX,BIOS2_SEG		; Address BIOS data for fixed disk info.
	MOV	DS,AX

	ASSUME	DS:NOTHING

	MOV	DI,DS:[CONFIG_PTR]
	ADD	SI,DS:[DI+FIXED_FLAGS]		; Get index to flags
	MOV	AL,[SI]				; Save old flag values
	MOV	ES:FFLAG,AL
	OR	BYTE PTR [SI],6			; Flag partition as formatted
						; and changed
	PUSH	CS				; Restore data
	POP	DS

	ASSUME	DS:CODE

	JMP	SHORT GOODRET

;
;  Done routine
;
;      This routine is called after the formatting is complete,
;      the disk directory has been initialized, and the system
;      has been transfered. It is called once for each disk that
;      is formatted.
;

DONE:
;	JMP	GOODRET 	; No special processing to do

;
;  Success return
;

GOODRET:
	CLC			; Show no error
	RET

;
;  Error return - This exit is only to be used on fatal errors from
;		  the OEM format modules	
;

BADRET:
	CALL	RESTORE_FFLAG	; Restore partition flags
	STC			; Show error
	RET


;*	BADSECTOR - Locate bad disk sectors
;
;	BADSECTOR Formats the disk and locates bad sectors
;
;	ENTRY:	TRACK = Next track to format
;		SIDE  = Next side to format
;		
;
;	EXIT:	If bad sector found
;			AX = Sector number
;			'CY' clear
;		If end of diskette
;			AX = 0
;			'CY' Clear
;
;	NOTE: If a bad sector is located, BADSECTOR returns
;	 to it's caller. The caller will note the bad sector,
;	 and then call BADSECTOR again to continue where it left off
;
;	USES:	ALL
;

BADSECTOR PROC	NEAR

;	Check if this is a winchester drive, if so then do verifying

	TEST	DRV1,80H
	JNZ	BS7

;	Format a floppy drive

BS1:
	CMP	NTRACKS,0		; Are we done?
	JNZ	BS1A
	JMP	BS8

BS1A:
	TEST	SWITCHMAP,1 SHL 1	; Test for /C
	JNZ	BS2			; If /C then skip formatting

	CALL	FORMAT_TRACK		; Format this track
	JC	BADRET
BS2:
	CALL	VERIFY_TRACK		; Verify this track
	PUSHF				; Save flags
	JNC	BS4			; If no error skip calculations

;	Calculate bad sector number

	MOV	AL,BYTE PTR TRACK	; Track times sectors per track
	MOV	AH,8
	TEST	SWITCHMAP,1 SHL 5
	JNZ	BS3
	MOV	AH,9
BS3:
	MOV	BL,AH			; Sector count in BX
	SUB	BH,BH
	MUL	AH			; Sector number in AX
	XCHG	AX,BX			; Set up return values
					; AX = Number of sectors, BX = Base sector

;	Calculate next track and side, if /M, If so, don't do side logic

BS4:
	TEST	SWITCHMAP,1 SHL 2	; See if /M specified
	JNZ	BS5			; yes, step head and do next

	SHL	BX,1			; Double sector number for 2 sided disk
	XOR	SIDE,1			; Toggle side number
	JNZ	BS6			; Just came from side 0, don't do next track
	ADD	BX,AX			; Just came from side 1, account for 1 track
BS5:
	INC	TRACK
BS6:
	DEC	NTRACKS
	POPF				; If a verify error occured, return
	JNC	BS1
	JMP	GOODRET

;	Prepare a fixed disk partition. If verify requested then read
;	sector by sector and if an error occurs report it to format.

BS7:
	CMP	NUMSECS,0		; Else do detection
	JZ	BS8

;	Check if sector is bad in bad sector table

	CMP	BS_FLAG,TRUE
	JNZ	BS7A
	CALL	MATCH_BS
	JC	BS7B
BS7A:
	TEST	SWITCHMAP,1 SHL 4	; Test for verify selected
	JNZ	BS7AA			; Do the verify
	CLC
	JMP	SHORT BS7B
BS7AA:
	MOV	BX,BUF			; Pass the buffer address
	CALL	GET_SECTOR		; Attempt to read the sector
BS7B:
	PUSHF				; Save result of read
	INC	LSECTOR			; Update the next sector to read
	DEC	NUMSECS			; Update the count of sectors
	POPF				; Restore result of read
	JNC	BS7			; If no error, do next sector 

;	Error reading sector, report it

	MOV	AX,1			; One bad sector
	MOV	BX,LSECTOR		; Return sector number
	DEC	BX			; LSECTOR was already bumped, undo it
	SUB	BX,WORD PTR BPBTAB+BPB_HIDDEN	; Remove hidden bias

;	Check if this is and error in a fatal sector

	CMP	BX,STARTSECTOR
	JGE	BS7C
	CALL	RESTORE_FFLAG		; Restore winchester flags
BS7C:
	JMP	GOODRET


;	Formatting all done. Put the loader on the disk

BS8:
	MOV	SI,OFFSET LDSTART	; Copy loader to buffer
	MOV	DI,BUF
	MOV	CX,SEC_SIZE/2
	CLD
	REP	MOVSW
	MOV	BX,BUF			; Set up transfer address for ROM
	MOV	AX,WORD PTR BPBTAB+BPB_HIDDEN
	MOV	LSECTOR,AX
	CALL	PUT_SECTOR
	JNC	BS9
	JMP	BADRET			; Can't write sector

;	Disk has been formatted, If winchester then flag formatted in BIOS

BS9:
	SUB	AX,AX			; else good return
	JMP	GOODRET

BADSECTOR ENDP


;	PUT_SECTOR - This routine will put a sector on the disk
;		it does NUM_RETRY retries on the disk if an
;		error is encountered.
;
;	ENTRY:	LSECTOR - Logical sector to write
;		DRV1   - Correct ROM drive unit to write to
;		ES:BX  - Address of buffer to write
;
;	EXIT:	'C' clear - Sector written correctly
;		'C' set - Error in writing sector
;
PUT_SECTOR	PROC	NEAR
	MOV	RETRY_COUNT,NUM_RETRY	; Set up for retries
	MOV	DL,DRV1			; Pass the unit number
	CALL	ENCODE			; Encode the track, sector and head
PS1:
	MOV	AH,DIO_WRITE		; ROM write code
	MOV	AL,1			; Write 1 sector
	INT	DISK_IO_INTR
	JNC	PS2			; Jump no error
	DEC	RETRY_COUNT		; Do retries
	JNZ	PS1
	STC				; Error, retries failed
PS2:
	RET

PUT_SECTOR ENDP


;	GET_SECTOR - This routine will get a sector from the disk.
;		It does NUM_RETRY retries on the disk if an
;		error is encountered.
;
;	ENTRY:	LSECTOR - Logical sector to read
;		DRV1   - Correct ROM drive unit to read from
;		ES:BX  - Address of buffer
;
;	EXIT:	'C' clear - Sector read correctly
;		'C' set - Error in reading sector
;
GET_SECTOR	PROC	NEAR

	MOV	RETRY_COUNT,NUM_RETRY	; Set up for retries
	MOV	DL,DRV1			; Pass the unit number
	CALL	ENCODE			; Encode the track, sector and head
GS1:
	MOV	AH,DIO_READ		; ROM read code
	MOV	AL,1			; read 1 sector
	INT	DISK_IO_INTR
	JNC	GS2			; Jump no error
	DEC	RETRY_COUNT		; Do retries
	JNZ	GS1
	STC				; Error, retries failed
GS2:
	RET

GET_SECTOR ENDP


;	ENCODE - This routine will encode the LSECTOR
;		variable into the head (DH), sector and cylinder
;		(CX) information the ROM needs.
;
;	ENTRY:	LSECTOR - Sector to be accessed
;
;	EXIT:	DH - Head of specified LSECTOR
;		CX - Cylinder and sector of specified LSECTOR
;
ENCODE	PROC	NEAR

	PUSH	AX			; Save all registers used
	PUSH	DX

;	Get the sector number in CL

	MOV	AX,LSECTOR
	SUB	DX,DX
	DIV	WORD PTR BPBTAB+BPB_SPT		; Divide by sectors per track
	MOV	CL,DL			
	INC	CL			; Base sector at 1

;	Get the head number and cylinder

	SUB	DX,DX
	DIV	WORD PTR BPBTAB+BPB_HEADS	; Divide by number of heads
	MOV	CH,AL			; Save low portion of cylinder
	MOV	AL,DL

;	Pack cylinder number

	ROR	AH,1
	ROR	AH,1
	OR	CL,AH			; Pack high cylinder with sector

	POP	DX
	MOV	DH,AL			; Update head number

	POP	AX
	RET

ENCODE	ENDP


;	FORMAT_TRACK - Format a track of the floppy disk
;
FORMAT_TRACK PROC NEAR

	PUSH	ES

	MOV	DI,EXTRA_SEG		; Pass the address of the buffer for
					; the sector headers
	MOV	ES,DI
	MOV	DI,ADDR_FIELD		; Pass buffer address in ES:DI

	CALL	SETHDR			; Store track/side in sector headers
	MOV	DL,DRV1
	MOV	DH,SIDE
	MOV	CL,1			; Starting at sector 1
	MOV	CH,BYTE PTR TRACK	;  and the necessary track
	MOV	AL,8			; Assume 8 sectors per track
	TEST	SWITCHMAP,1 SHL 5	;  test /8 switch
	JNZ	FT1			; Yes it was 8
	MOV	AL,9			; No needed 9 sectors per track
FT1:
	MOV	AH,DIO_FORMAT		; Get format track function
	MOV	BX,ADDR_FIELD		; Get address of parm table
	INT	DISK_IO_INTR

	POP	ES
	RET

FORMAT_TRACK ENDP

;	VERIFY_TRACK - Verify a track of the floppy disk
;
VERIFY_TRACK PROC NEAR

	MOV	BX,CS			; Ensure no 64kb boundry error
	MOV	CL,4			;  will occur
	SHL	BX,CL
	NEG	BX
	MOV	DL,DRV1			; Drive
	MOV	DH,SIDE			; Head
	MOV	CH,BYTE PTR TRACK	; Track
	MOV	CL,1			; Start sector
	MOV	AL,8			; Assume 8 sectors per track
	TEST	SWITCHMAP,1 SHL 5	; test /8 switch
	JNZ	VT1
	MOV	AL,9
VT1:
	MOV	AH,DIO_VERIFY		; Get write track function
	INT	DISK_IO_INTR
	RET

VERIFY_TRACK ENDP


;	SET_HDR - Set track and side values in sector headers for floppys
;
SETHDR	PROC	NEAR

	PUSH	CX			; Save Registers
	PUSH	SI

	MOV	SI,INTTAB		; Offset of interleave table
	CLD
	LODSB				; Get number of sectors per track
	MOV	CL,AL			; Into CX
	SUB	CH,CH
SETHDR1:
	MOV	AL,BYTE PTR TRACK	; Store track
	STOSB
	MOV	AL,SIDE			; Store side
	STOSB
	LODSB				; Store sector
	STOSB
	MOV	AL,BPS 	; Store bytes per sector
	STOSB
	LOOP	SETHDR1

	POP	SI
	POP	CX			; Recover CX
	RET				;   and return

SETHDR	ENDP


;**	PLFT - Patch Loader Format Table
;
;	PLFT Patches the loader format table in the
;	loader code at address LDSTART. The loader table
;	starts at address LDSTART + 2 (2 byte short jump)
;	and contains device specific information used
;	by the cold boot loader
;

PLFT	PROC	NEAR

;	Set up the SI to the proper table
;	Is a 5" drive check for 8x512 format

	SUB	AL,AL			; Clear out index
	TEST	SWITCHMAP,1 SHL 5
	JZ	PLFT1
	OR	AL,FAT_ID_8		; Set bit for 8x512

;	Check for single sided

PLFT1:
	TEST	SWITCHMAP,1 SHL 2	; Test for /M switch
	JNZ	PLFT2
	OR	AL,FAT_ID_DS		; Set bit for 2 sides

;	Set SI to the appropriate loader table

PLFT2:
	MOV	AH,TYPE BPB_STRUC	; Size of a BPB table
	MUL	AH			; Index into table
	ADD	AX,OFFSET FLOPPY_BPBS
	MOV	SI,AX

;	Move the loader table into the loader

	MOV	AL,BPB_MBYTE[SI]
	MOV	FATID,AL


	MOV	CX,TYPE BPB_STRUC	;Length of data to move
	MOV	DI,OFFSET BPBTAB	; DI points to destination
	PUSH	SI			; Save address
	CLD				;Clear the direction flag
	REP	MOVSB
	POP	SI			; Return pointer to caller

	RET

PLFT	ENDP


;*	SIT - Setup interleave table
SIT	PROC	NEAR

	MOV	INTTAB,OFFSET INT8	; Assume 8 sector interleave
	TEST	SWITCHMAP,1 SHL 5	; Check /8 switch
	JNZ	SIT1
	MOV	INTTAB,OFFSET INT9	; 9 sector interleave table
SIT1:
	RET

SIT	ENDP

;	WRTFAT - This routine will write copies of the FAT to
;		the selected disk.
;
WRTFAT	PROC	NEAR

	PUSH	LSECTOR				; Save the current sector
	MOV	AX,WORD PTR BPBTAB+BPB_RES	; after reserved sectors
	ADD	AX,WORD PTR BPBTAB+BPB_HIDDEN
	MOV	LSECTOR,AX
	MOV	BX,BUF			; Buffer address for ROM

;	Set up for multiple copies of the FAT

	MOV	CL,BYTE PTR BPBTAB+BPB_NFATS
	SUB	CH,CH
WF1:
	PUSH	CX
	MOV	SI,FATSPACE		; Point SI to the FAT

;	Set up for multiple sectors in the FAT

	MOV	CX,WORD PTR BPBTAB+BPB_FATSECS
WF2:
	PUSH	CX

;	Copy a FAT sector to the internal buffer

	MOV	DI,BUF
	MOV	CX,SEC_SIZE/2
	CLD
	REP	MOVSW

;	Write the sector and check for errors

	CALL	PUT_SECTOR
	JNC	WF3			; Skip if no errors
	POP	CX			; Else restore stack and exit
	POP	CX
	POP	LSECTOR
	JMP	BADRET			; Exit error

;	Prepare for the next sector

WF3:
	INC	LSECTOR			; Get next sector
	POP	CX
	LOOP	WF2			; Loop for more FAT sectors

	POP	CX
	LOOP	WF1			; Loop for multiple FAT's

	POP	LSECTOR
	JMP	GOODRET

WRTFAT	ENDP


;	CLEAR_DIR - This routine will clear out the directory of a
;		    winchester disk. This is required because later in
;		    the Microsoft FORMAT module, a call to DEL *.* is
;		    made, which attempts to use whatever data is out
;		    in the directory area of the disk to delete all files.
;		    Under certain circumstances data on the disk looks
;		    like a directory entry and causes MSDOS to screw up
;		    the FAT for this disk.
;
CLEAR_DIR	PROC	NEAR

	MOV	AX,WORD PTR BPBTAB+BPB_DIRENTS	; Determine number of directory sectors
	MOV	DX,DE_SIZE
	MUL	DX
	MOV	BX,WORD PTR BPBTAB+BPB_SECSZ	; Bytes divided by bytes per sector
	DIV	BX
	MOV	CX,AX			; Save sector count in CX

;	Determine start sector of directory

	MOV	AX,WORD PTR BPBTAB+BPB_FATSECS
	MOV	DL,BYTE PTR BPBTAB+BPB_NFATS
	SUB	DH,DH
	MUL	DX
	ADD	AX,WORD PTR BPBTAB+BPB_HIDDEN
	ADD	AX,WORD PTR BPBTAB+BPB_RES
	MOV	LSECTOR,AX

;	Fill the buffer with E5's and clear the directory on the disk

	MOV	DI,BUF
	MOV	BX,DI
	PUSH	CX
	MOV	CX,WORD PTR BPBTAB+BPB_SECSZ
	MOV	AL,0E5H
	CLD
	REP	STOSB
	POP	CX
CD1:
	PUSH	CX
	CALL	PUT_SECTOR
	POP	CX
	JC	CD_EXIT
	INC	LSECTOR
	LOOP	CD1
	CLC
CD_EXIT:
	RET

CLEAR_DIR	ENDP	


;***********************************************************************
;
;	Winchester bad sector table processing routines
;
;***********************************************************************

;	GET_BST: This routine will get the bad sector table from the
;		winchester disk. If sucessful then BS_FLAG is set to TRUE
;		else BS_FLAG is set to FALSE
GET_BST	PROC	NEAR

	MOV	BS_FLAG,FALSE

;	Get the maximum number of heads and locate the bad sector table

	MOV	AH,DIO_GETPARMS
	MOV	DL,BYTE PTR BPBTAB+BPB_UNIT
	INT	DISK_IO_INTR
	SUB	DL,DL			; Make heads into a word
	INC	DH
	XCHG	DL,DH
	MOV	HEADS,DX

;	Get the logical sector of the bad sector table

	MOV	AX,CX
	AND	AL,0C0H			; Fix cylinder in AX
	ROL	AL,1
	ROL	AL,1
	XCHG	AL,AH
	INC	AX			; Bad sector table in 1 cylinder
	MUL	HEADS
	AND	CX,3FH			; 8/3/84 Get sectors per track
	MOV	SPT,CX
	MUL	CX
	PUSH	CX			; Save this value for later compare
	MOV	LSECTOR,AX		; Logical sector of bad sector table

;	Attempt to read in a bad sector table

	CALL	GET_BS
	POP	CX
	JNC	GB1
	ADD	LSECTOR,CX
	CALL	GET_BS
	JC	GB2
GB1:
	MOV	BS_FLAG,TRUE		; Valid bad sector table, flag as such
GB2:
	RET

GET_BST	ENDP

;	GET_BS: This routine will attempt to read in the bad sector table
;		at LSECTOR. If the read fails or if the check sum is not
;		correct then 'C' is set. If a valid table is read then
;		'C' is cleared.
GET_BS	PROC	NEAR

	MOV	BX,BUF
	CALL	GET_SECTOR
	JC	GBS1
	CALL	MOV_BST
	CALL	CHECK_BST
GBS1:
	RET

GET_BS	ENDP

;	MOV_BST: This routine will move the bad sector table from
;		it's current location at BUF to BS_BUF
MOV_BST	PROC	NEAR

	PUSH	DI
	PUSH	SI
	PUSH	CX

	MOV	SI,BUF
	MOV	DI,BS_BUF
	MOV	CX,SEC_SIZE/2
	CLD
	REP	MOVSW

	POP	CX
	POP	SI
	POP	DI
	RET

MOV_BST	ENDP


;	CHECK_BST: This routine will return 'C' clear if the bad sector
;		table at BS_BUF is valid. Else 'C' is set.
CHECK_BST PROC	NEAR

	PUSH	CX
	PUSH	BX
	PUSH	AX

	MOV	BX,BS_BUF
	MOV	CX,[BX+SEC_SIZE-2]
	MOV	WORD PTR [BX+SEC_SIZE-2],0
	CALL	CHECK_SUM
	CMP	AX,CX
	JZ	CB1
	STC
	JMP	SHORT CB2
CB1:
	CLC
CB2:
	POP	AX
	POP	BX
	POP	CX
	RET

CHECK_BST ENDP

CHECK_SUM PROC	NEAR

	PUSH	BX
	PUSH	SI
	MOV	SI,SEC_SIZE
	SUB	AX,AX
CS1:
	ADD	AL,[BX+SI-1]
	ADC	AH,0
	DEC	SI
	JNZ	CS1
	NOT	AX

	POP	SI
	POP	BX
	RET

CHECK_SUM ENDP

;	MAP_HCS: This routine will turn a head sector cylinder and turn
;		it into a logical sector number.
;
;	ENTRY:	BX - offset of H, C, S
;
;	EXIT:	AX - logical sector
;
;	USES:	AX
MAP_HCS	PROC	NEAR

	PUSH	DX
	PUSH	CX

;	Decode the cylinder number

	MOV	CX,[BX+1]
	AND	CL,0C0H
	ROL	CL,1
	ROL	CL,1
	XCHG	CL,CH
	MOV	AX,CX			; Cylinder number into AX
	MUL	HEADS			; Times number of heads

;	Add in the head number

	MOV	CL,[BX]
	SUB	CH,CH
	ADD	AX,CX

;	Times the number of sectors per track

	MOV	CX,SPT
	MUL	CX

;	Add in the number of sectors

	MOV	CL,[BX+1]
	AND	CL,03FH
	SUB	CH,CH
	JCXZ	MAP1			; Ensure that the last entry of
					;  zeros doesn't match anything
	DEC	CX			; Sector based at 0
	ADD	AX,CX			; AX = Logical sector
MAP1:
	POP	CX
	POP	DX
	RET

MAP_HCS	ENDP


;	LOCATE_BS: This routine will locate the first bad sector
;		candidate that is above or equal to the first
;		sector in the partition. The address of the first
;		bad sector is stored in NEXT_BS
LOCATE_BS PROC	NEAR

	PUSH	AX
	PUSH	BX

	MOV	BX,BS_BUF
LB1:
	MOV	AX,[BX]
	OR	AL,AH
	OR	AL,[BX+2]
	JZ	LB2
	CALL	MAP_HCS
	CMP	AX,WORD PTR BPBTAB+BPB_HIDDEN
	JAE	LB2
	ADD	BX,3
	JMP	LB1
LB2:
	MOV	NEXT_BS,BX

	POP	BX
	POP	AX
	RET

LOCATE_BS ENDP

;	MATCH_BS: This routine will see if the bad sector currently
;		being operated on by FORMAT (in LSECTOR) is the next
;		bad sector in the bad sector table. If so then 'C' is
;		set and the next bad sector in the list becomes active.
;		If the sector is not in the table then 'C' is clear.
MATCH_BS PROC	NEAR

	PUSH	AX
	PUSH	BX

	MOV	BX,NEXT_BS
	CALL	MAP_HCS
	CMP	AX,LSECTOR
	JNZ	MBS1			; Sector not found
	ADD	NEXT_BS,3		; This sector is bad, prepare for next
	STC
	JMP	SHORT MBS2
MBS1:
	CLC				; No bad sector, return 'C' clear
MBS2:
	POP	BX
	POP	AX
	RET

MATCH_BS ENDP

;	RESTORE_FFLAG - This routine will restore the state
;		of the partition flags if a fatal error occured during 
;		formatting
;
RESTORE_FFLAG	PROC	NEAR

	PUSH	AX
	PUSH	SI
	PUSH	DS

	MOV	AL,DRIVE		; Determine drive index
	SUB	AL,NUM_FLOPPY
	CBW
	MOV	SI,AX
		
	MOV	AX,BIOS2_SEG		; Address BIOS data for fixed disk info.
	MOV	DS,AX

	ASSUME	DS:NOTHING

	MOV	DI,DS:[CONFIG_PTR]
	ADD	SI,DS:[DI+FIXED_FLAGS]		; Get index to flags
	MOV	AL,ES:FFLAG			; Get old flag values
	MOV	BYTE PTR [SI],AL		; Restore old flags

	POP	DS

	ASSUME	DS:CODE

	POP	SI
	POP	AX
	RET

RESTORE_FFLAG	ENDP

;**	LOCMAP - Locate the MAP submodule
;
;	LOCMAP locates the MAP submodule
;
;	ENTRY:	NONE
;
;	EXIT:	PSW.ZR	=	Map is in ram
;		PSW.NZ	=	Map is not in ram
;
;	USES:	PSW
;

MAPID_OFFSET	=	3 * 3		; Offset of Map Id
MAPID_INT	=	021H*4		; Interrupt vector address

LOCMAP	PROC	NEAR
	PUSH	ES
	PUSH	BX
	PUSH	SI
	XOR	BX,BX
	MOV	ES,BX			; ES = interrupt vector address
	MOV	BX,MAPID_INT		; ES:BX points to int vector
	MOV	SI,ES:WORD PTR [BX]
	MOV	ES,ES:WORD PTR [BX+2]	; ES:SI = pointer to int 21 routine
	ADD	SI,MAPID_OFFSET

;	If map is installed then *ES:SI = 'MAP'

	CMP	ES:WORD PTR [SI],'AM'	; First two correct?
	JNZ	LOCMAP1			; Nope
	CMP	ES:BYTE PTR [SI+2],'P'	; Check out last one
LOCMAP1:
	POP	SI			; PSW set from CMP instruction
	POP	BX
	POP	ES
	RET
LOCMAP	ENDP

;	Patch area

	DB	128 DUP(?)

;	Make sure we are paragraph alligned for the loader

	ORG	($-CODORG) + 16 - (($ - CODORG) MOD 16)

LDSTART =	$			; Start of the loader
BPBTAB	=	LDSTART+DISK_BPB_OFFSET	; Start of loader info
ENDBOOT =	LDSTART+520
CODE	ENDS
	END
