/*
    MSDOS.H - This file defines information about MS-DOS such
	as fcb's and function numbers.
*/

/*
		RESTRICTED RIGHTS LEGEND
		------------------------
	
	    "Use, duplication, or disclosure by the
	Government is subject to restrictions as set forth
	in paragraph (b) (3) (B) of the Rights in Technical
	Data and Computer Software clause in DAR
	7-104.9(a).  Contractor/manufacturer is Zenith
	Data Systems Corporation of Hilltop Road, St.
	Joseph, Michigan 49085.
*/

/* This structure represents a MS-DOS extended fcb */
struct ext_fcb
{
    char extend;		/* extended flag */
    char zero[5];		/* zero field */
    char attr;			/* attributes */
    char drive;			/* drive number */
    char name[8];		/* file name */
    char ext[3];		/* file extention */
    unsigned extent;		/* extent counter */
    unsigned rec_size;		/* record size */
    long fsize;			/* file size */
    unsigned date;		/* last mod. date */
    unsigned time;		/* last mod. time */
    char res1[8];		/* 8 MS-DOS reserved */
    char cur_rec;		/* current record */
    long ranrec;		/* random record field */
};


/* Some necessary BDOS function definitions */
#define PUT_CHAR	0x2
#define SEL_DISK	0Xe
#define FILE_OPEN	0xf
#define FILE_CLOSE	0x10
#define SRCH_FIRST	0x11
#define SRCH_NEXT	0x12
#define FILE_DELETE	0x13
#define FILE_CREATE	0x16
#define CUR_DISK	0x19
#define SET_DMA		0x1a
