/*
		RESTRICTED RIGHTS LEGEND
		------------------------
	
	    "Use, duplication, or disclosure by the
	Government is subject to restrictions as set forth
	in paragraph (b) (3) (B) of the Rights in Technical
	Data and Computer Software clause in DAR
	7-104.9(a).  Contractor/manufacturer is Zenith
	Data Systems Corporation of Hilltop Road, St.
	Joseph, Michigan 49085.

*/
/*
    These routines are the second group of routines used
    for BACKUP/RESTORE. Thsy are contained in the file BR2.C
*/

struct link_file *optimize();

#define bld_debug FALSE
#if BACKUP

struct search_fcb p_fcb;		/* fcb for return from BDOS */
struct link_file *head, *link_entry();

/*
    This routine will build a linked list of filenames to
    back up. It is passed a string of characters with no 
    imbedded spaces which represents an ambiguous file name.
    (i.e. *.asm+b:*.com+file.ext) It's return value is the 
    head pointer of the linked list.
*/
struct link_file *bld_bdir(afn)
char *afn;	/* pointer to afn */
{
    extern char dir_level;
    extern int file_count, dir_count;
    char *p, d; 
    int i;
    static struct ext_fcb fcb1,fcb2;	/* fcb for finding files */

#if bld_debug
char *dptr, c;
printf("BLD_DIR: Got here, parameter:%s\r\n", afn);
#endif

    dir_level = 0;
    file_count = 0;
    dir_count = 0;
    
    head = NULL;		/* list initially NULL */
    p = afn;
    while (TRUE)		/* more afn's to process ? */
    {
	while (*p != '+' && *p != '\0') ++p;
	d = *p;
	*p = '\0';
    
	   /* scan the file name and place it in fcb1 */

	init_fcb(&fcb1);
	init_fcb(&fcb2);
	fcb2.attr = fcb1.attr | attr_dir; /* Set the DIRECTORY attribute */
	for (i=0;i<8;i++) fcb2.name[i]='?';
	for (i=0;i<3;i++) fcb2.ext[i]='?';
	if (scan_afn(afn, &fcb1) == ERROR)
	{
	    free_mem(head);	/* if error free up memory */
	    return(NULL); 	/* and return 		   */
	}
	fcb2.drive = fcb1.drive;
	p_fcb.drive = fcb1.drive;
	p_fcb.name[0]=p_fcb.name[1]='.';
	for (i=2;i<8;i++) p_fcb.name[i]=' ';
	for (i=0;i<3;i++) p_fcb.ext[i]=' ';
	p_fcb.attr1 = p_fcb.attr2 = attr_dir;

/*	fcb1 = matching file names, fcb2 = search fcb	*/

	findfiles(&fcb1,&fcb2);		/* Get all matching files */

	afn = p;		/* get next afn for searching */
	if (d == '+') ++afn;	/* skip over '+' sign */
	else break;
	p = afn;
    }
#if bld_debug
dmp_list(head);
#endif
    return(head);		/* return head pointer */
}

/*	This routine finds all matching files for the fcb pointers
	and links them into the list. Directories are scanned and
	a stack of known directories is kept		*/

findfiles(nfcb,sfcb)
struct ext_fcb *nfcb, *sfcb;
{
	struct search_fcb s_fcb;	/* fcb for return from BDOS */
	int srch_type = SRCH_FIRST;
	char *name1, *name2;
	bdos(SET_DMA, &s_fcb);			/* set the DMA address and */

	while(bdos(srch_type, sfcb) != 0xff)	/* Find one */
	{
	    if ((s_fcb.attr2 & attr_dir) != 0)
	     if ((s_fcb.name[0] != '.') && (sw_list[G])) {
		head = link_entry(head, &s_fcb);
		pushfcb(sfcb,&s_fcb);		/* Save this state */
		chdir(&s_fcb);		/* Go to the directory */
		findfiles(nfcb,sfcb);	/* Find all of them */
		popfcb(sfcb,&s_fcb);		/* Restore state */
		p_fcb.date = s_fcb.date;
		head = optimize(link_entry(head, &p_fcb));
		chdir(&p_fcb);		/* Return to parent */
		}
	     else {
		  }
	    else {
	    name1 = &(nfcb->drive);
	    name2 = &(s_fcb.drive);
	    if (amb_match(name1,name2))
	      if (select(&s_fcb))	/* check selection criteria, */
	    	if (query(&s_fcb))		/* ask the user if OK */
			head = link_entry(head, &s_fcb);
		}
	    bdos(SET_DMA, &s_fcb);		/* set the DMA address and */
	    srch_type = SRCH_NEXT;
	}
}    

#define FCB_SPSIZ (sizeof(struct ext_fcb))*32
static char fcb_stack[FCB_SPSIZ];
static int fcb_sp = 0;

pushfcb(fcbptr,fcb2)				/* Push an FCB */
struct ext_fcb *fcbptr, *fcb2;
{
	int i;
	char *myfcb;
	if ((fcb_sp + sizeof(struct ext_fcb) + 2) >= FCB_SPSIZ) {
		printf("\n\n**** Error - FCB stack overflow ****\n\n");
		exit(1);
		}
	myfcb = (char *) &fcb2->date;
	fcb_stack[fcb_sp++]=*(myfcb++);
	fcb_stack[fcb_sp++]=*(myfcb);
	myfcb = (char *) fcbptr;
	for (i=0;i<sizeof(struct ext_fcb);i++) {
		fcb_stack[fcb_sp++]=*(myfcb++);
		}
}

popfcb(fcbptr,fcb2)
struct ext_fcb *fcbptr, *fcb2;			/* Pop an FCB */
{
	int i;
	char *myfcb;
	if (fcb_sp < (sizeof(struct ext_fcb)+2)) {
		printf("\n\n**** Error - FCB stack underflow ****\n\n");
		exit(1);
		}
	myfcb = (char *) fcbptr + sizeof(struct ext_fcb);
	for (i=sizeof(struct ext_fcb);i>0;i--) {
		*(--myfcb)=fcb_stack[--fcb_sp];
		}
	myfcb = (char *) &(fcb2->date);
	++myfcb;
	*myfcb = fcb_stack[--fcb_sp];
	*(--myfcb) = fcb_stack[--fcb_sp];
}

#endif

static char fcb_string[15];

char *get_fname();

chdir(s_fcb)
struct search_fcb *s_fcb;
{
	int i;
	char *file;
	file = get_fname(s_fcb);
	i=zcdir(file);
	rls_mem(file, (unsigned) FNAME_SIZE);
	return(i);
}

mkdir(s_fcb)
struct search_fcb *s_fcb;
{
	char *file;
	file = get_fname(s_fcb);
	zmdir(file);
	rls_mem(file, (unsigned) FNAME_SIZE);
}

#if !BACKUP

/*
    This routine will build a restore directory. The directory
    is a linked list of file entrys chosen from the users
    selection criteria as well as date, exception and query
    information.
*/
struct link_file *bld_rdir()
{
    extern struct br_entry br_id;
    extern char *parms[];
    extern int drive_map[];
    struct file_entry f_ent;
    struct link_file *head, *link_entry();
    int ret, i;
    
    head = NULL;	/* start with NULL directory */

    /* try to get first entry */
    clear_inp();
    if (get_all(&br_id.fcb, &f_ent, sizeof(struct file_entry)) == 0)
    {
	printf("Invalid backup file.\r\n");
	return(NULL);
    }
    if (!br_verify((struct br_entry *) &f_ent))	/* verify correct file */
    {
	printf("Invalid backup file.\r\n");
	return(NULL);
    }

    /* build the directory */
    while ((ret = get_all(&br_id.fcb, &f_ent,
				sizeof(struct file_entry))) != 0)
    {
	if (f_ent.id == last_ent) break;
	if ((f_ent.fcb.attr & attr_dir) != 0)
		{
	        f_ent.fcb.drive = drive_map[f_ent.fcb.drive];
		head = optimize(link_entry(head, &f_ent));
		}
	else
	if (file_match(&f_ent.fcb, parms[1]))
	{
	    if (select(&f_ent.fcb))
	    {
		if (query(&f_ent.fcb)) {
		        f_ent.fcb.drive = drive_map[f_ent.fcb.drive];
			head = link_entry(head, &f_ent);
			}
	    }
	}
    }
    if (ret == 0)
    {
	printf("Invalid backup file.\r\n");
	free_mem(head);
	return(NULL);
    }
    return(head);
}

#endif

/*
    This routine will link an FCB to the directory (if it is not 
    already there) and return a new head pointer
*/
struct link_file *link_entry(head, s_fcb)
struct link_file *head;
#if BACKUP
struct search_fcb *s_fcb;
#else
struct file_entry *s_fcb;
#endif
{
    extern char dir_level;
    extern int file_count;
    struct link_file *l, *l1;
    char *get_mem();
    
	/* check linked list for file already selected */
    l = head;
    l1 = head;
    while (l != NULL)
    {
	l1 = l;
	l = l->link;
    }
    if (l == NULL)
    {
	l=(struct link_file *) get_mem((unsigned) sizeof(struct link_file));

#if BACKUP
	    /* copy fcb and link to list at head */
	fcb_lnk(s_fcb, l);	/* copy an fcb to a link_file */
#else
	    /* move entry and link at head of list */
	ent_lnk(s_fcb, l);
#endif
	if (l1 == NULL)
	{
	    l->link = head;
	    head = l;
	}
	else
	{
	    l->link = l1->link;
	    l1->link = l;
	}
	l->id = bf;
	l->level = dir_level;
#if BACKUP
	if ((s_fcb->attr2 & attr_dir) == 0)
		++file_count;	/* count as accepted file */
#endif
    }
    return(head);
}


/*
    This routine will ask the user if the file is to be operated upon.
    the /Q switch must be set. TRUE is returned if /Q is not set or
    if the user says YES else FALSE is returned
*/
query(s_fcb)
#if BACKUP
struct search_fcb *s_fcb;
#else
struct ext_fcb *s_fcb;
#endif
{
    extern char sw_list[];
    char *fname, *get_fname();

    if (!sw_list[Q]) return(TRUE);
#if BACKUP
    if ((s_fcb->attr2 & attr_dir) != 0) return (TRUE);
#else
    if ((s_fcb->attr & attr_dir) != 0) return (TRUE);
#endif
    fname = get_fname((struct ext_fcb *) s_fcb);
#if BACKUP
    printf("Backup %s (Y/N) ?", fname);
#else
    printf("Restore %s (Y/N) ?", fname);
#endif
    rls_mem(fname, (unsigned) FNAME_SIZE);
    return(yes_no());
}
    
/*
    This routine will return TRUE if the user types a 'Y', or
    will return FALSE if the user types an 'N'
*/
yes_no()
{
    char c;
    do
    {
	c = getch();
	if(islower(c)) c = toupper(c);
    }
    while(c != 'Y' && c != 'N');
    putch(c);
    putch('\r');
    putch('\n');
    if (c == 'Y') return(TRUE);
    return(FALSE);
}
	
#if bld_debug
dmp_list(head)
struct link_file *head;
{
extern struct br_entry br_id;
    int i;
    char *p, d;
    printf("Directory dump\r\n");
printf("master is ");
p = (char *) &br_id.fcb.name[0];
for (i = 0; i < 11; ++i) printf("%c", ++p);
printf("\r\n");

    while (head != NULL)
    {
	d = head->drive+'A'-1;
	putch(d);
	putch(':');
	p = (char *) &head->name;
	for (i = 0; i < 11; ++i)
	    printf("%c", *p++);
	putch('\r');
	putch('\n');
	head = head->link;
    }
    return;
}
#endif

/*
    This routine will display the files that will take part
    in the current operation and ask if they are OK. If the user
    answers yes then the operation proceeds if no then the operation
    is aborted.
*/
display(head)
struct link_file *head;
{
    extern char sw_list[];
    struct file_entry f_ent;
    char *fname[4], *get_fname();
    int i;
    
    if (!sw_list[R]) return(TRUE);
#if BACKUP
    printf("\nFiles to be backed up are:\r\n");
#else
    printf("\nFiles to be restored are:\r\n");
#endif
    while (head != NULL)
    {
	for (i = 0; i < 4; ++i) fname[i] = NULL;
	for (i = 0; i < 4; ++i)
	{
	    lnk_ent(head, &f_ent);
	    fname[i] = get_fname(&f_ent.fcb);
	    head = head->link;
	    if (head == NULL) break;
	}
	for (i = 0; i < 4; ++i)
	    if (fname[i] != NULL) printf("%-19s", fname[i]);
	putch('\r');
	putch('\n');
	for (i = 0; i < 4; ++i)
	    if (fname[i] != NULL) rls_mem(fname[i], (unsigned) FNAME_SIZE);
    }
    printf("Is this correct (Y/N) ?");
    if (yes_no()) return(TRUE);
    return(FALSE);
}

/*
    This routine will determine if the fcb passed is 
    acceptable for backup/restore on the criteria of
    date and exception processing
*/
select(s_fcb)
#if BACKUP
struct search_fcb *s_fcb;
#else
struct ext_fcb *s_fcb;
#endif
{
    extern char sw_list[];
    extern unsigned today, before, after;
#if BACKUP
    unsigned stamp_date();
    
    if (!sw_list[T] && !sw_list[A] && !sw_list[B])
	if (stamp_date(s_fcb->drive) >= s_fcb->date) return(FALSE);

    if (sw_list[W])
	if ((s_fcb->attr2 & attr_arc) == 0)	/* Archive bit not set? */
		return(FALSE);			/* not set, bail out */
#endif
 
    if (sw_list[T])	/* check todays date */
	if (s_fcb->date != today) return(FALSE);
	
    if (sw_list[A])	/* check after date */
	if (s_fcb->date <= after) return(FALSE);

    if (sw_list[B])	/* check before date */
	if (s_fcb->date >= before) return(FALSE);
	    
    if (except(s_fcb)) return(FALSE);   /* check exception files */

    return(TRUE);
}

/*
    This routine will free up the memory used by the linked list
*/
free_mem(head)
struct link_file *head;
{
    struct link_file *l;
    
    while (head != NULL)
    {
	l = head->link;		/* save link */
	rls_mem((char *) head, (unsigned)(sizeof(struct link_file)));
	head = l;		/* get next link */
    }
    return;
}

/*
    This routine will do a comparison of two strings of a 
    given length to determine which is greater or if they
    are equal. It returns:
			    -1 first string < second string
			     0 strings equal
			    +1 second string > first string
*/
stccmp(p1, p2, c)
char *p1, *p2;
int c;
{
    for (; c > 0; --c)
    {
	if (*p1 < *p2) return(-1);
	if (*p1 > *p2) return(1);
	++p1;
	++p2;
    }
    return(0);
}

/*
    This routine will copy an FCB that looks like a directory
    entry to one that looks like a standard FCB.
*/
copy_fcb(e_fcb, s_fcb)
struct ext_fcb *e_fcb;
struct search_fcb *s_fcb;
{
    int i;
    e_fcb->extend = s_fcb->extend;		/* extended flag */

    for (i=0; i < 5; ++i)			/* zero field    */
	e_fcb->zero[i] = s_fcb->zero[i];

    e_fcb->attr = s_fcb->attr1;			/* attributes	*/
    e_fcb->drive = s_fcb->drive;		/* drive	*/

    for (i = 0; i < 8; ++i)			/* file name	*/
	e_fcb->name[i] = s_fcb->name[i];
    for (i = 0; i < 3; ++i)			/* extention	*/
	e_fcb->ext[i] = s_fcb->ext[i];

    e_fcb->fsize = s_fcb->fsize;		/* file size	*/
    e_fcb->time = s_fcb->time;			/* time		*/
    e_fcb->date = s_fcb->date;			/* date		*/

    return;
}

/*
    This routine will verify that the backup/restore has
    been done correctly. The verification is done on a file
    by file basis. TRUE is returned if the verification is
    correct else FALSE.
*/
verify(f_ent)
struct file_entry *f_ent;
{
    extern char *in_buf, *out_buf;
    extern char sw_list[];
    extern struct br_entry br_id;
    int i, size;
    char *p1, *p2, *fname, *get_fname();

    if (!sw_list[V]) return(TRUE);
    if (!get_vol(f_ent->s_vol-1)) return(-1);

    /* print verifying message */
    fname = get_fname(&f_ent->fcb);	/* get name */
    printf("Verifying %s\r\n", fname);	/* print message */
    rls_mem(fname, FNAME_SIZE);
    
    br_id.fcb.ranrec = f_ent->s_pos;	/* set starting position */
    file_open(&f_ent->fcb);
    clear_inp();
    while(TRUE)
    {
	size = rread(&f_ent->fcb, out_buf, BUF_SIZ);
	if (size == 0) return(TRUE);
	if (get_all(&br_id.fcb, in_buf, size) == 0) return(-1);
	p1 = out_buf;
	p2 = in_buf;
	for (i = 0; i < size; ++i)
	{
	    if (*p1++ != *p2++) 
	    {
#if BACKUP
		/* attempt to skip over possible bad spot in disk */
		br_id.fcb.ranrec = f_ent->s_pos + f_ent->length;
#endif
		return(FALSE);
	    }
	}
    }
}
/*
    This routine will process the exception files. It takes an fcb as
    input and returns TRUE if it matches an ambiguous file specification
    string, else FALSE.
*/
except(e_fcb)
struct ext_fcb *e_fcb;
{
    extern char sw_list[], *xcpt_ptr;
    char *p, c;
    int ret;
    if (!sw_list[E]) return(FALSE); /* exception not in effect */
    
    /* make exception string into a "C" string */
    p = xcpt_ptr;
    while (*p != '/' && *p != '\0') ++p;
    c = *p;
    *p = '\0';
    ret = file_match(e_fcb, xcpt_ptr);	/* find match */
    *p = c;	/* restore switch string */
    return(ret);
}
/*
    This routine will put the current volume number in the master
    fcb entry
*/
set_vol()
{
    extern char cur_vol;
    extern struct br_entry br_id;
    char vol;
    int i;
    
    vol = cur_vol;
    for (i = 2; i >= 0; --i)
    {
	br_id.fcb.ext[i] = vol%10 + '0';
	vol /= 10;
    }
    return;
}
/*
    This routine will dump the backup/restore directory to
    the disk.
*/
#if BACKUP

dmp_dir(head)
struct link_file *head;
{
    extern struct br_entry br_id;
    extern char *out_buf, *out_ptr, max_vol, cur_vol;
    struct file_entry f_ent;
    char *get_mem(), vol;
    int ret;
    
    vol = cur_vol;		/* set the max volume on the */
    cur_vol = max_vol;		/* backup entry */
    set_vol();
    cur_vol = vol;
    clear_out();
    if (put_all(&br_id.fcb, (char *)&br_id,
		sizeof(struct br_entry)) == 0) return(FALSE);
    set_vol();
    while(head != NULL)		/* dump entry */
    {
	/* if a verify error has occured then id will have value
	    last_ent so skip it
	*/
	if (head->id != last_ent)
	{
	    lnk_ent(head, &f_ent);	/* make a link into a file entry */
	    if (put_all(&br_id.fcb, (char *) &f_ent,
			     sizeof(struct file_entry)) == 0) return(FALSE);
	}
	head = head->link;	/* get next entry */
    }
    
    /* dump last entry */
    f_ent.id = last_ent;	/* flag as last entry */
    ret = put_all(&br_id.fcb, (char *) &f_ent,
			     sizeof(struct file_entry));
    if (ret == 0) return(FALSE);

    if (!flsh_all(&br_id.fcb)) return(FALSE); /* flush directory */
    return(TRUE);
}

#endif

#if BACKUP
    
/*
    This routine will dump files to the disk. It will set up
    the directory of the backup file to reflect start location
    size and starting and ending volume numbers.
*/
#define DFILES_DEBUG FALSE
dmp_files(head)
struct link_file *head;
{
    extern struct br_entry br_id;
    struct file_entry f_ent;
    int ret;
    
    while (head != NULL)     /* dump files */
    {
	if (head->id == pth_pp)	/* pathname password protect */
	{
	}
	else if (head->id == pth_npp) /* pathname no password */
	{
	}
	else if (head->id == bf)	/* normal backup file */
	{
	    if ((head->attr & attr_dir) != 0) {
		chdir(&(head->drive)-7);
		lnk_ent(head, &f_ent);
		f_ent.s_vol = f_ent.e_vol = f_ent.length = 0;
		}
	    else {

		    lnk_ent(head, &f_ent);    /* link entry to file entry */
		    while (TRUE)
		    {
			if (!copy_file(&f_ent)) return(FALSE);
			if ((ret = verify(&f_ent)) < 0) return(FALSE);
			if (ret) break;
			printf("Verify error, try backup again (Y/N) ?");
			if (!yes_no())
			{
			    /* set id value to last_ent so the directory will
				not dump this entry */
			    f_ent.id = last_ent;
			    /* correct number of files copied */
			    break;
			}
		    }
		}
	}	
	else if (head->id == bfc)	/* file with text compression */
	{
	}
	else		/* invalid entry, bad backup file */
	{
	    printf("Invalid backup file.\r\n");
	    return(FALSE);
	}
	ent_lnk(&f_ent, head);
	head = head->link;		/* get next entry */
    }
    return(TRUE);
}

#endif

#if BACKUP

/*
    This routine will copy a file to the disk backup file.
*/
copy_file(f_ent)
struct file_entry *f_ent;
{
    extern char *out_buf, *out_ptr, cur_vol;
    char *fname, *get_fname();
    int status;
    long size;

    fname = get_fname(&f_ent->fcb);
    if (!file_open(&f_ent->fcb))	/* open input file */
    {
	printf("Can't open %s\r\n", fname);
    }
    else
    {		/* initialize entry */
	printf("%s\r\n", fname);		/* print name */
	f_ent->s_pos = br_id.fcb.ranrec;	/* set start pos. */
	f_ent->s_vol = cur_vol + 1;		/* set current vol. */
	size = 0L;				/* set size counter */
	status = rread(&f_ent->fcb, out_buf, BUF_SIZ);
	if (status != 0)
	while(TRUE)	/* dump file */
	{
	    size += status;	/* update file size */
	    out_ptr = out_buf + status; /* show buffer full */
	    if (!flsh_all(&br_id.fcb))  /* flush buffer */
	    {
		rls_mem(fname, (unsigned) FNAME_SIZE);
		return(FALSE);
	    }
	    if (status < BUF_SIZ) break;
	    status = rread(&f_ent->fcb, out_buf, BUF_SIZ);
	}
	if (!file_close(&f_ent->fcb)) /* close file */
	    printf("Can't close %s\r\n", fname);
	
	    /* get the rest of the file info. */
	f_ent->length = size;		/* size */
	f_ent->e_vol = cur_vol + 1;	/* end volume */
	zchmd(fname,1,f_ent->fcb.attr & !attr_dir);
    }
    rls_mem(fname, (unsigned) FNAME_SIZE); /* free filename memory */
    return(TRUE);
}

#endif

#if !BACKUP

/*
    This routine will dump files to the disk. It requires the head
    of the directory list and traverses it dumping files as it goes.
    If the file already exists, the user is prompted for overwriting
    the existing file of the /O switch omits this prompting. The return
    is TRUE if the directory has been properly dumped else FALSE.
*/
dmp_files(head)
struct link_file *head;
{
    struct file_entry f_ent;
    int flag1, flag2, ret, i;
    
    while(head != NULL)		/* do the whole directory */
    {
	lnk_ent(head, &f_ent);
	if ((f_ent.fcb.attr & attr_dir) != 0) {
		if (!sw_list[F]) {
			i = chdir(&(f_ent.fcb));
			if (i == -1) {
				mkdir(&(f_ent.fcb));
				chdir(&(f_ent.fcb));
				}
			}
		}
	else {
		if ((flag1 = file_open(&f_ent.fcb))) /* check if exists */
		{
		    file_close(&f_ent.fcb);
		    /* delete old file if overwrite */
		    if ((flag2 = overwrite(&f_ent.fcb))) file_delete(&f_ent.fcb);
		}

	/* if the file doesn't exist or if it does exist and over write is
	   in effect then copy the file */

		if (!flag1 || (flag1 && flag2))
		{
		    while(TRUE)
		    {	
			if (!copy_file(&f_ent)) return(FALSE); /* user aborted */
			if ((ret = verify(&f_ent)) < 0) return(FALSE);
			if (ret) break;
			printf("Verify error, try restore again (Y/N) ?");
			if (!yes_no()) break;
		    }
		}
	}
	head = head->link;
    }
    return(TRUE);
}

#endif

#if !BACKUP

/*
    This routine will return TRUE if the /O switch is on, else it 
    will prompt the user if overwrite is desired and return TRUE
    if so else FALSE.
*/
overwrite(e_fcb)
struct ext_fcb *e_fcb;
{
    extern char sw_list[];
    char *fname, *get_fname();
    
    if (sw_list[O]) return(TRUE);
    fname = get_fname(e_fcb);
    printf("\nFile %s already exists, do you wish to delete it (Y/N) ?",
		fname);
    rls_mem(fname, (unsigned) FNAME_SIZE);
    return(yes_no());
}

#endif

#if !BACKUP

/*
    This routine will copy a restore file to a disk. It will return 
    TRUE if the operation is sucessful. If not enough room exists
    on the disk then the user will be asked to put another disk in or
    abort. If abort is chosen then FALSE is returned.
*/
copy_file(f_ent)
struct file_entry *f_ent;
{
    extern char *out_buf;
    extern struct br_entry br_id;
    unsigned old_date;
    char *fname, *get_fname();
    long size;
    int b_size;
    
    while(TRUE)
    {
	if (!get_vol(f_ent->s_vol - 1)) return(FALSE); /* get starting volume */
	br_id.fcb.ranrec = f_ent->s_pos;	/* get start poistion */
	old_date = f_ent->fcb.date;			/* save old date of file */
	while (!file_create(&f_ent->fcb))
		    if (!get_disk(&f_ent->fcb)) return(FALSE);
	fname = get_fname(&f_ent->fcb);
	printf("%s\r\n", fname);
	clear_inp();
	size = f_ent->length;	/* get file size */
	while (size > 0L)	/* flush entire file */
	{
	    b_size = BUF_SIZ;	/* get buffer size */
	    if (size < (long) BUF_SIZ) b_size = (int) size;
	    if (get_all(&br_id.fcb, out_buf, b_size) == 0) return(FALSE);
	    if (rwrite(&f_ent->fcb, out_buf, b_size) == 0) break;
	    size = size - (long) b_size;	/* update size */
	}
	f_ent->fcb.date = old_date;	/* restore with old date */
	file_close(&f_ent->fcb);	/* incomplete file, close it and */
	zchmd(fname,1,f_ent->fcb.attr & !attr_dir);
	rls_mem(fname, (unsigned) FNAME_SIZE);
	if (size == 0L) break;	/* done */
	file_delete(&f_ent->fcb);	/* delete it */
	if (!get_disk(&f_ent->fcb)) return(FALSE);
    }
    return(TRUE);
}

#endif

#if !BACKUP

/*
    This routine will tell the user that not enough disk
    space existed for restoration and get another disk.
    If another disk is gotten TRUE is returned else FALSE and
    the operation is aborted.
*/
get_disk(e_fcb)
struct ext_fcb *e_fcb;
{
    char *fname, *get_fname();
    
    fname = get_fname(e_fcb);
    printf("\r\nOut of disk on restoration of %s,\r\n", fname);
    printf("insert another disk and press RETURN,\r\n");
    printf("or press any other key to abort.\r\n");
    rls_mem(fname, (unsigned) FNAME_SIZE);
    return(chkabrt());
}

#endif
    
#if BACKUP

/*
    This routine will put info. to the disk and overlap on other
    disks if necessary
*/
put_all(fcb1, ptr, count)
struct ext_fcb *fcb1;
char *ptr;
int count;
{
    extern char cur_vol, open_flag;
    int ret, count1;
	
    if (count == 0) return(0);
    if ((ret = put_buf(fcb1, ptr, count)) == count) return(count);
    count1 = count;
    do
    {
	if (open_flag)
	{
	    if (!get_vol(cur_vol + 1)) return(0);  /* get the next file */
	}
	else
	{
	    if (!get_disk()) return(0);		/* get a new disk */
	    if (!create_next()) return(0);	/* get the next file */
	}
	ptr += ret;	/* update pointer */
	count1 -= ret;	/* update count */
    }
    while((ret = put_buf(fcb1, ptr, count1)) != count1);
    return(count);
}

#endif

/*
    This routine will put a section of memory of to the disk.
    It requires a pointer to the memory and a count of the number
    of bytes to output.
*/
put_buf(fcb1, ptr, count)
struct ext_fcb *fcb1;
char *ptr;
int count;
{
    extern char *out_buf, *out_ptr;
    static char *end_buf;		/* get addr. of last slot */
    int cnt, ret;
    
    end_buf = out_buf + BUF_SIZ;
    cnt = count;
    for (; cnt > 0; --cnt)
    {
	if(out_ptr == end_buf)		/* if at end, flush buffer  */
	{
	    if ((ret = dmp_buf(fcb1, out_buf, BUF_SIZ)) != BUF_SIZ)
		break;
	    clear_out();
	}
	*out_ptr++ = *ptr++;		/* move a byte */
    }
    return(count - cnt);
}
/*
    This routine will dump the output buffer to disk. If the 
    disk is full it will get a new disk and format it if 
    necessary.
*/
dmp_buf(fcb1, buf, size)
struct ext_fcb *fcb1;
int size;		/*  size of buffer  */    
char *buf;		/*  output buffer  */
{
    int status, i;
    char *ptr;

    if (size == 0) return(0);
    if ((status = rwrite(fcb1, buf, size)) == size) /* empty the buffer */
	return(size);
    if (status == 0) return(0);
    ptr = buf + status;
    for (i = size - status; i > 0; --i)
	*buf++ = *ptr++;
    return(status);
}

#if BACKUP

/*
    This routine will flush the output buffer to the disk.
    It returns FALSE if it can not be done else TRUE.
*/
flsh_all(fcb1)
struct ext_fcb *fcb1;
{
    extern char *out_buf, *out_ptr, cur_vol, open_flag;
    int size, ret;
    char *buf;
 
    size = out_ptr - out_buf;
    if (size == 0) return(TRUE);
    if ((ret = rwrite(fcb1, out_buf, size)) < size)
    {
	buf = out_buf;
	do
	{
	    if (open_flag)
	    {
		if (!get_vol(cur_vol + 1)) return(FALSE);
	    }
	    else
	    {
		if (!get_disk()) return(FALSE);
		if (!create_next()) return(FALSE);
	    }
	    buf += ret;
	    size -= ret;
	}
	while((ret = rwrite(fcb1, buf, size)) < size);
    }
    clear_out();
    return(TRUE);
}

#endif

/*
    This routine will clear the output buffer.
*/
clear_out()
{
    extern char *out_buf, *out_ptr;
    out_ptr = out_buf;
    return;
}
    
/*
    This routine will get return information from the disk.
    it will cross volume (disk) boundrys to do so.
*/
get_all(fcb1, ptr, count)
struct ext_fcb *fcb1;
char *ptr;
int count;
{
    extern char cur_vol;
    int ret, count1;

    if (count == 0) return(0);
    if ((ret = get_buf(fcb1, ptr, count)) == count) return(count);
    count1 = count;	/* save count */
    do
    {
	if (!get_vol(cur_vol+1)) return(0);
	ptr += ret;	/* update pointer */
	count1 -= ret;	/* update count */
    }
    while((ret = get_buf(fcb1, ptr, count1)) < count1);
    return(count);
}
/*
    This routine will get input from the input file (in_file)
    and pass back as many bytes as possible to the specified
    address. It returns an integer count of the number of bytes
    returned.
*/
get_buf(fcb1, ptr, cnt1)
struct ext_fcb *fcb1;
char *ptr;
int cnt1;
{
    extern char *in_buf, *in_ptr, *last_in;
    int cnt2, size;
    
    cnt2 = cnt1;
    for (; cnt1 > 0; --cnt1)
    {
	if(in_ptr == last_in) 
	{
	    size = fill_buf(fcb1); /* fill buffer */
	    if (size == 0) break;
	}
	*ptr++ = *in_ptr++;		/* move a byte */
    }
    return(cnt2 - cnt1);
}

/*
    This routine will fill the input buffer from disk. If it 
    can't fulfill the request it returns 0.
*/
fill_buf(fcb1)
struct ext_fcb *fcb1;
{
    extern char *in_buf, *in_ptr, *last_in;
    int status;
    status = rread(fcb1, in_buf, BUF_SIZ);
    in_ptr = in_buf;
    last_in = in_buf + status;
    return(status);
}
/*
    This routine will clear the input buffer, discarding any
    information that was left in the buffer.
*/
clear_inp()
{
    extern char *in_ptr, *last_in, *in_buf;
    in_ptr = in_buf;
    last_in = in_buf;
    return;
}

#if BACKUP

/*
    This routine will prompt the user for a new disk and
    wait for a response.
*/
get_disk()
{
    extern struct br_entry br_id;
    extern char cur_vol;
    extern int out_file;
    int c;
    
    file_close(&br_id.fcb);
    printf("\nInsert another disk in drive %c for backup,\r\n", 
	    br_id.fcb.drive + ('A' - 1));
    printf("and press RETURN when ready,\r\n");
    printf("or press any other key to abort.\r\n");
    putch('\r');
    putch('\n');
    if (chkabrt() == FALSE) return(FALSE);
    if (!form_disk()) return(FALSE);
    return(TRUE);
}

#endif

#if BACKUP

/*
    This routine will create the next file in the backup file
    sequence. It will return TRUE if it was able to do so, else
    FALSE will be returned.
*/
create_next()
{
    extern char cur_vol, max_vol;
    extern struct br_entry br_id;
    
    cur_vol += 1;	/* count next volume */
    set_vol();		/* set the volume in the fcb */
    if (file_create(&br_id.fcb))
    {
	max_vol = cur_vol;
	return(TRUE);	/* make new file */
    }
    cur_vol -= 1;	/* else fix up info. */
    set_vol();
    return(FALSE);	/* couldn't create it */
}

#endif

#if BACKUP

/*
    This routine will examine the F and N switches and 
    do one of the following
    1. if /N is set then a return is done
    2. if /F is set then the disk will be formatted
    3. if neither is set, then the uset will be asked if
       the disk should be formatted or not, and the appropriate
       action taken.
*/
form_disk()
{
    extern char sw_list[];
    int c;
    if (sw_list[N]) return(TRUE);	/* return if no format */
    while(TRUE)
    {
	if (!sw_list[F]) /* then prompt for format */
	{
	    printf("Format backup disk (Y/N) ?");
	    if (!yes_no()) return(TRUE);	/* pretend formatted */
	}
	printf("Format single or double sided (S/D) ?");
	c = getch();
	if (islower(c)) c = toupper(c);
	putch(c);
	putch('\r');
	putch('\n');
	if (c == 'S' || c == 'D') break; /* re-prompt if not S or D */
    }
    
    /* pass the drive (A: = 0) and 0 for dbl. sided non-0 for single */
    while (!frmt((int) br_id.fcb.drive - 1, c - 'D'))	/* format the disk */
    {
	printf("\nFormat failure, insert another disk and press RETURN\r\n");
	printf("or press any other key to abort.\r\n");
	if (chkabrt() == FALSE) return(FALSE);
    }
    return(TRUE);
}

#endif

/*
	This routine removes directory entries that are a
	subdirectory immediately followed by a subdirectory
	of .., in other words, no files exist.
*/

struct link_file *optimize(head)
struct link_file *head;
{
struct link_file *previous, *current, *stash2;
previous = current = head;
while((current->link != NULL) && (current != NULL)) {
	if (candidate(current)) {
		stash2 = current->link->link;
		if (current == head) {
			rls_mem(current->link,sizeof(struct link_file));
			rls_mem(current,sizeof(struct link_file));
			current = previous = head = stash2;
			}
		else	{
			rls_mem(current->link,sizeof(struct link_file));
			rls_mem(current,sizeof(struct link_file));
			previous->link = stash2;
			current = previous = head;
			};
		}
	else	{
		previous = current;
		current = current->link;
		};
	};
	return(head);
}

candidate(ptr)
struct link_file *ptr;
{
	if ((ptr->attr & attr_dir) != 0)
		if (ptr->name[1] != '.')
			if ((ptr->link->attr & attr_dir) != 0)
				if (ptr->link->name[1] == '.')
					return(TRUE);
	return(FALSE);
}

/*	This routine will check for a carriage return or
	any other key. If CR is hit, then return TRUE, else
	if any other key is hit (user wants to abort) then
	require the user to reply Y to "are you sure".	*/

chkabrt()
{
   char c;

   if ((c=getch()) == '\r') return (TRUE);
   printf("Are you sure you wish to abort? (Y/N) ");
   for(;;) {
      c = getch();
      printf("\n\r");		/* Go to a new line */
      if (islower(c)) c = toupper(c);
      if (c == 'Y') return (FALSE);
      if (c == 'N') return (TRUE);
      printf("Please answer Y to confirm the abort or N to cancel: ");
   };
}

