Page	60,132
Title	-Error Message Display Routines
;
;
;	Copyright (c) 1983
;	Zenith Data Systems
;	St. Joseph, Michigan
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 7_Aug_85
;
%Out	Error.asm
page
;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing

; Include Files
;--------------
;	Rom.lit
;	IO.lit
;	Video.lit
;	Video.ext
;	Disk.lit
;	Disk.ext
;
	.xlist
	include	..\Rom\Rom.lit
	include ..\IO\IO.lit
	include ..\Video\Video.lit
	include ..\Video\Video.ext
	include ..\Disk\Disk.lit
	include ..\Disk\Disk.ext
	.list

	extrn	Diag_Disp_Hex_Byte:Near
	extrn	Diag_Disp_Hex_Word:Near
	extrn	Diag_Display_Char:Near
	extrn	Diag_Disp_Dec_Word:Near
	extrn	Diag_Console_Output:Near

	extrn	Diag_Disp_String:Near
	extrn	Disp_String:Near
	extrn	Clear_Video_Ram:Near

	extrn	Beep:Near
	extrn	Read_Dip_Switches:Near
	extrn	Out_Morrow_6845:Near
	extrn	Delay:Near

	extrn	Crt_Mode:Byte
	extrn	Disk_Msg_Table:Byte
	extrn	Bad_Ram_Msg1:Byte
	extrn	Bad_Ram_Msg2:Byte
	extrn	Bad_Ram_Msg3:Byte
	extrn	Bad_Ram_Msg4:Byte
	extrn	Error_Msg:Byte
	extrn	Disk_Error_Msg:Byte

page
;----------------------------------------------------------------------
Bad_Ram Proc Near; (7_Aug_85)
;----------------------------
;	1) Bad_Ram is called when one of the system memory tests
;	   detects a failure during diagnostics.  It displays the
;	   address and failed bit on the console. Then the routine
;	   hangs forever reading and writing the error location.
;	3) Entry Register Values:
;		ES:DI -> Pointer to failed memory location
;		AL    -> Bad data (data actually contained in RAM)
;
Public	Bad_Ram

	push	es
	push	di
	mov	bx,es			;Save the failed RAM segment in BX
	mov	cx,Screen_Segment
	mov	es,cx			;ES:= Cga Segment

	push	ax			;Save the failed bit string
	mov	si,Offset Bad_Ram_Msg1	;Point to the RAM failure message
	call	Disp_Ram_Failure	;Display 'RAM failure!' and address

	mov	si,Offset Bad_Ram_Msg2	;Display ', Bit: ' following address
	call	Diag_Disp_String
	pop	cx			;AL:= Failed Bits

	mov	al,0			;AL:= Bit Offset
	mov	ch,7			;CH:= Shift Counter
BmLp1:	shr	cl,1			;Repeat
	jnc	BmSk1			;	If (this bit was in error)

	add	al,'0'			;		Translate bit to Ascii
	call	Diag_Console_Output	;		Display bit number
	jmp	BmSk2			;		Quit

BmSk1:	inc	al			;	Advance to the next bit name
	dec	ch			;	Decrement the bit offset
	test	cl,cl
	jnz	BmLp1			;Until (all bits yet)

BmSk2:	mov	al,' '			;AL:= Displayed Character (Space)
	mov	cx,40			;CX:= Character Count
BmLp2:	call	Diag_Console_Output	;Repeat	Display character
	loop	BmLp2			;Until (Character Counter - 1 eq 0)
	call	Beep			;BEEP! to signal error condition

	pop	di
	pop	es			;ES:DI:= Error Address

BmLp3:	mov	Byte Ptr es:[di],0FFh	;Loop	Store 0FFh at error location
	mov	al,Byte Ptr es:[di]	;	Read back the error location

	mov	Byte Ptr es:[di],0	;	Store 0000 at error location
	mov	al,Byte Ptr es:[di]	;	Read back the error location
	jmp	BmLp3

Bad_Ram EndP

page
;----------------------------------------------------------------------
Disp_Ram_Failure Proc Near
;-------------------------
;	1) Disp_RAM_Failure is called by the BAD_RAM and BAD_PARITY
;	   routines to display the failure message and the failed address.
;	2) Input Register Values:
;	     BX:DI -> Pointer containing bad RAM address
;		SI -> Pointer with error message to be displayed
;	3) Output Register Values:
;		DX -> Cursor position following displayed messages.
;		ES -> Pointing to the current video segment
;
Public	Disp_Ram_Failure

	PushReg	<ax,si>
	mov	dx,(0 Shl 8) or 0	;Home the software cursor position

	push	si			;Save ptr to error cause message
	mov	si,Offset Error_Msg	;Display the 'ERROR:  ' message
	call	Diag_Disp_String
	pop	si			;Restore text for error cause

	call	Diag_Disp_String	;Display the actual cause message
	mov	ax,bx			;Get the failed RAM segment
	call	Diag_Disp_Hex_Word	;Display the failed memory segment

	mov	al,':'			;Display an address separator
	call	Diag_Console_Output	;...between the segment and offset
	mov	ax,di			;Get the failed RAM offset

	call	Diag_Disp_Hex_Word	;Display the failed address offset

	PopReg	<SI,AX>
	ret

Disp_Ram_Failure EndP

page
;----------------------------------------------------------------------
Display_Disk_Error Proc Near; (20_Mar_85)
;----------------------------------------
;	Display_Disk_Error is called when an error has been encountered
; during a disk boot, or during the disk diagnostics.  It will
; display a text message, wait for break to be entered, and then
; it will transfer control to the World Map Routine.  Note that, unlike
; the other error routines, this routine uses that standard video output
; routines, since diagnostics must have passed to permit a disk boot 
; to occur.
;
; Input:
;	AH: Disk error code (see definition for DISK_STATUS)
;
Public	Display_Disk_Error

	push	cs
	pop	es			;ES:= Current Monitor Segment
	mov	si,Offset Disk_Error_Msg;SI:= Pointer to Start of Message
	mov	dx,0			;DX:= Cursor to Home Position
	call	Disp_String		;Display 'Disk Error: '
	mov	si,Offset Disk_Msg_Table;SI:= Base of disk error table

DeLp1:	cmp	Byte Ptr cs:[si],Nil	;While (Not end of the table)
	je	DeSk1

	test	ah,Byte Ptr cs:[si]	;	If (Error Code eq Found)
	jnz	DeSk1			;		Break

	add	si,3			;	SI:= Pointer to Next error Msg
	jmp	DeLp1

DeSk1:	inc	si			;SI:= Pointer to text ptr for this msg
	mov	si,Word Ptr cs:[si]	;SI:= Pointer to the error message
	call	Disp_String		;Display rest of message
	jmp	Error_Return		;Exit to World Map

Display_Disk_Error EndP

page
;----------------------------------------------------------------------
Display_Error_Msg Proc Near; (2_Jul_85)
;--------------------------------------
;	1) Display_Error_Msg is called when a hardware fault has been
;	   detected and an error message must be displayed.  It sets up
;	   the diagnostics mode CRT display, displays the user's error
;	   message, and then waits for a break code from the keyboard.
;	   Once the break code has been received, control does NOT return
;	   to the caller, but rather the World Map Routine is executed.
;	2) The alternate entry point ERROR_RETURN is available for
;	   routines which display their own error message.
;	3) Notice that the Video Area is forced to Screen_Segment
;	4) Notice that Nmi Interrupts are forced on. This is necessary
;	   because of calls from Main (i.e. before Nmi's have be enabled).
;	5) Entry Register Values:
;		SI -> Pointer to null-terminated message to be displayed.
;		ES -> Current Video Display Segment (FORCED to SCREEN_RAM)
;
Public	Display_Error_Msg

	mov	dx,Color_Card
	in	al,dx			;Enable Nmi's
	mov	bx,Screen_Segment
	mov	es,bx			;ES:= Cga Segment

	mov	dx,(0 Shl 8) or 0	;Set DX to the home position
	push	si			;Save pointer to the error message
	mov	si,Offset Error_Msg	;Point to the generic error message
	call	Diag_Disp_String	;Display 'Error:  '
	pop	si			;Restore pointer to specific message
	call	Diag_Disp_String	;Display the specific error message


Error_Return:
;------------
;
	mov	al,' '			;AL:= Displayed Character (Space)
	mov	cx,40			;CX:= Character Count
DeM1:	call	Diag_Console_Output	;Repeat	Display character
	loop	DeM1			;Until (Character Counter - 1 eq 0)

	call	Beep			;BEEP! to signal error condition
	mov	cx,1000h
	call	Delay			;Delay

	mov	ax,Icon_Clock Shl 8 + Nmi_Regenerate
	call	Out_Morrow_6845		;Switch to the Clock Icon
DeLp2:	jmp	DeLp2			;Wait to enter world map

Display_Error_Msg EndP

Monitor_Segment	EndS

		End
