/*****************************************************************
 *                                                               *
 *                         Copyright (c) 1984                    *
 *               Massachusetts Institute of Technology           *
 *                                                               *
 * This material is a component of the TRIX system, developed by *
 * D. Goddeau, J. Sieber, and S. Ward of the                     *
 *                                                               *
 *                          RTS group                            *
 *               Laboratory for Computer Science                 *
 *            Massachusetts Institute of Technology              *
 *                Cambridge, Massachusetts 02139                 *
 *                                                               *
 * Permission to copy this software, to redistribute it, and to  *
 * use it for any purpose is granted, subject to the conditions  *
 * that (1) This copyright notice remain, unchanged and in full, *
 * on any copy or derivative of the software; and (2) that       *
 * references to or documentation of any copy or derivative of   *
 * this software acknowledge its source in accordance with the   *
 * usual standards in academic research.                         *
 *                                                               *
 * MIT has made no warrantee or representation that the          *
 * operation of this software will be error-free, and MIT is     *
 * under no obligation to provide any services, by way of        *
 * maintenance, update, or otherwise.                            *
 *                                                               *
 * In conjunction with products arising from the use of this     *
 * material, there shall be no use of the name of the            *
 * Massachusetts Institute of Technology nor of any adaptation   *
 * thereof in any advertising, promotional, or sales literature  *
 * without prior written consent from MIT in each case.          *
 *                                                               *
 *****************************************************************/


/*
 * Simple standalone driver for NU video display.
 */

#define	CHARWIDTH	8	/* width of font in bits	*/
#define	LINESPERCHAR	12	/* height of font in bits	*/
#define	BYTESPERLINE	128	/* length of scan line in bits	*/

#define	MINX	0			/* left margin		*/
#define	MINY	528			/* top margin		*/
#define	MAXX	(70*CHARWIDTH)		/* right margin		*/
#define	MAXY	(70*LINESPERCHAR)	/* bottom margin	*/


extern char vcram[];
static	char	SFont[128][LINESPERCHAR] =
{
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 0125,0252,0125,0252,0125,0252,0125,0252,0125,0252,0125,0252 },
	{ 021, 0210, 021, 042, 021, 0210, 021, 042, 021, 0210, 021, 042 },
	{ 021, 0, 0104, 0, 021, 0, 0104, 0, 021, 0, 0104, 0 },
	{ 0, 0, 0, 0, 010, 034, 066, 0143, 0101, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0177, 0140, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 076, 03, 037, 03, 076, 0, 0, 0 },
	{ 0, 0, 0, 0, 0177, 066, 066, 066, 066, 0, 0, 0 },
	{ 0, 0, 03, 06, 014, 034, 066, 0143, 0101, 0, 0, 0 },
	{ 0, 0, 0, 0101, 0143, 066, 034, 014, 06, 03, 0, 0 },
	{ 0, 0, 017, 0, 03, 0, 016, 0, 076, 0, 0143, 0 },
	{ 0, 0, 014, 0, 036, 0, 077, 0, 014, 0, 014, 0 },
	{ 0, 0, 014, 014, 077, 014, 014, 0, 077, 0, 0, 0 },
	{ 0, 0, 0, 0, 076, 0153, 0177, 0153, 076, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 066, 0111, 0111, 066, 0, 0, 0 },
	{ 0, 0, 074, 0140, 0140, 0176, 0143, 0143, 076, 0, 0, 0 },
	{ 0, 0, 0, 0, 0176, 03, 03, 0176, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 077, 0140, 0140, 077, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 076, 0143, 0143, 0143, 0143, 0, 0, 0 },
	{ 0, 0, 0, 0, 0143, 0143, 0143, 0143, 076, 0, 0, 0 },
	{ 0, 0143, 0143, 0143, 0177, 0143, 0143, 066, 034, 0, 0, 0 },
	{ 0, 0177, 0140, 0140, 0174, 0140, 0140, 0140, 0177, 0, 0, 0 },
	{ 0, 0, 0, 0, 076, 0167, 0153, 0167, 076, 0, 0, 0 },
	{ 0, 0, 0, 0, 066, 0177, 066, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 06, 0177, 06, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 060, 0177, 060, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 060, 0177, 034, 0177, 06, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 014, 036, 063, 036, 014, 0, 0, 0 },
	{ 0, 0, 0160, 034, 07, 034, 0160, 0, 0177, 0, 0, 0 },
	{ 0, 0, 07, 034, 0160, 034, 07, 0, 0177, 0, 0, 0 },
	{ 0, 0, 0, 0, 0177, 0, 0177, 0, 0177, 0, 0, 0 },
	{ 0, 0, 0, 0, 0101, 0143, 066, 034, 010, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 014, 014, 014, 014, 014, 0, 014, 014, 0, 0, 0 },
	{ 0, 063, 063, 063, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 066, 066, 0177, 066, 066, 0177, 066, 066, 0, 0, 0 },
	{ 0, 014, 076, 015, 036, 054, 037, 014, 014, 0, 0, 0 },
	{ 0, 0143, 0143, 060, 030, 014, 06, 0143, 0143, 0, 0, 0 },
	{ 0, 036, 063, 063, 036, 0116, 0163, 063, 0156, 0, 0, 0 },
	{ 0, 030, 014, 06, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0140, 060, 030, 030, 030, 030, 060, 0140, 0, 0, 0 },
	{ 0, 03, 06, 014, 014, 014, 014, 06, 03, 0, 0, 0 },
	{ 0, 0, 0, 063, 036, 077, 036, 063, 0, 0, 0, 0 },
	{ 0, 0, 0, 014, 014, 077, 014, 014, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0, 034, 014, 06, 0, 0 },
	{ 0, 0, 0, 0, 0, 0177, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0, 016, 016, 0, 0, 0 },
	{ 0, 0100, 0140, 060, 030, 014, 06, 03, 01, 0, 0, 0 },
	{ 0, 076, 0143, 0163, 0173, 0157, 0147, 0143, 076, 0, 0, 0 },
	{ 0, 030, 034, 030, 030, 030, 030, 030, 074, 0, 0, 0 },
	{ 0, 076, 0143, 0140, 060, 030, 014, 06, 0177, 0, 0, 0 },
	{ 0, 0177, 060, 030, 074, 0140, 0140, 0143, 076, 0, 0, 0 },
	{ 0, 070, 074, 066, 063, 0177, 060, 060, 060, 0, 0, 0 },
	{ 0, 0177, 03, 03, 077, 0140, 0140, 0143, 076, 0, 0, 0 },
	{ 0, 076, 0143, 03, 077, 0143, 0143, 0143, 076, 0, 0, 0 },
	{ 0, 0177, 0140, 060, 030, 014, 06, 03, 03, 0, 0, 0 },
	{ 0, 076, 0143, 0143, 076, 0143, 0143, 0143, 076, 0, 0, 0 },
	{ 0, 076, 0143, 0143, 0176, 0140, 0140, 0143, 076, 0, 0, 0 },
	{ 0, 0, 0, 016, 016, 0, 0, 016, 016, 0, 0, 0 },
	{ 0, 0, 0, 034, 034, 0, 0, 034, 014, 06, 0, 0 },
	{ 0, 0, 0140, 070, 016, 03, 016, 070, 0140, 0, 0, 0 },
	{ 0, 0, 0, 0, 0177, 0, 0177, 0, 0, 0, 0, 0 },
	{ 0, 0, 03, 016, 070, 0140, 070, 016, 03, 0, 0, 0 },
	{ 0, 076, 0143, 0140, 074, 014, 0, 014, 014, 0, 0, 0 },
	{ 0, 076, 0143, 0173, 0153, 0153, 073, 03, 0176, 0, 0, 0 },
	{ 0, 034, 066, 0143, 0143, 0177, 0143, 0143, 0143, 0, 0, 0 },
	{ 0, 077, 0146, 0146, 076, 0146, 0146, 0146, 077, 0, 0, 0 },
	{ 0, 076, 0143, 03, 03, 03, 03, 0143, 076, 0, 0, 0 },
	{ 0, 077, 0146, 0146, 0146, 0146, 0146, 0146, 077, 0, 0, 0 },
	{ 0, 0177, 03, 03, 037, 03, 03, 03, 0177, 0, 0, 0 },
	{ 0, 0177, 03, 03, 037, 03, 03, 03, 03, 0, 0, 0 },
	{ 0, 076, 0143, 03, 03, 0163, 0143, 0143, 076, 0, 0, 0 },
	{ 0, 0143, 0143, 0143, 0177, 0143, 0143, 0143, 0143, 0, 0, 0 },
	{ 0, 036, 014, 014, 014, 014, 014, 014, 036, 0, 0, 0 },
	{ 0, 0140, 0140, 0140, 0140, 0140, 0140, 0143, 076, 0, 0, 0 },
	{ 0, 0143, 063, 033, 017, 017, 033, 063, 0143, 0, 0, 0 },
	{ 0, 03, 03, 03, 03, 03, 03, 03, 0177, 0, 0, 0 },
	{ 0, 0143, 0167, 0177, 0153, 0143, 0143, 0143, 0143, 0, 0, 0 },
	{ 0, 0143, 0143, 0147, 0157, 0173, 0163, 0143, 0143, 0, 0, 0 },
	{ 0, 076, 0143, 0143, 0143, 0143, 0143, 0143, 076, 0, 0, 0 },
	{ 0, 077, 0143, 0143, 077, 03, 03, 03, 03, 0, 0, 0 },
	{ 0, 076, 0143, 0143, 0143, 0143, 0153, 063, 0156, 0, 0, 0 },
	{ 0, 077, 0143, 0143, 077, 017, 033, 063, 0143, 0, 0, 0 },
	{ 0, 076, 0143, 03, 076, 0140, 0140, 0143, 076, 0, 0, 0 },
	{ 0, 077, 014, 014, 014, 014, 014, 014, 014, 0, 0, 0 },
	{ 0, 0143, 0143, 0143, 0143, 0143, 0143, 0143, 076, 0, 0, 0 },
	{ 0, 0143, 0143, 0143, 0143, 066, 066, 034, 010, 0, 0, 0 },
	{ 0, 0143, 0143, 0143, 0143, 0153, 0153, 0153, 066, 0, 0, 0 },
	{ 0, 0143, 0143, 066, 034, 034, 066, 0143, 0143, 0, 0, 0 },
	{ 0, 063, 063, 063, 036, 014, 014, 014, 014, 0, 0, 0 },
	{ 0, 0177, 0140, 060, 030, 014, 06, 03, 0177, 0, 0, 0 },
	{ 0, 0170, 030, 030, 030, 030, 030, 030, 0170, 0, 0, 0 },
	{ 0, 01, 03, 06, 014, 030, 060, 0140, 0100, 0, 0, 0 },
	{ 0, 017, 014, 014, 014, 014, 014, 014, 017, 0, 0, 0 },
	{ 0, 014, 036, 063, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0177, 0, 0, 0 },
	{ 0, 014, 030, 060, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 076, 0140, 0176, 0143, 0176, 0, 0, 0 },
	{ 0, 0, 03, 03, 077, 0143, 0143, 0143, 077, 0, 0, 0 },
	{ 0, 0, 0, 0, 076, 0143, 03, 0143, 076, 0, 0, 0 },
	{ 0, 0, 0140, 0140, 0176, 0143, 0143, 0143, 0176, 0, 0, 0 },
	{ 0, 0, 0, 0, 076, 0143, 0177, 03, 076, 0, 0, 0 },
	{ 0, 0, 070, 0154, 014, 077, 014, 014, 014, 0, 0, 0 },
	{ 0, 0, 0, 0, 0176, 0143, 0143, 0143, 0176, 0140, 076, 0 },
	{ 0, 0, 03, 03, 077, 0143, 0143, 0143, 0143, 0, 0, 0 },
	{ 0, 0, 014, 0, 016, 014, 014, 014, 036, 0, 0, 0 },
	{ 0, 0, 0, 0, 070, 060, 060, 060, 060, 063, 036, 0 },
	{ 0, 0, 03, 03, 063, 033, 017, 033, 063, 0, 0, 0 },
	{ 0, 0, 016, 014, 014, 014, 014, 014, 036, 0, 0, 0 },
	{ 0, 0, 0, 0, 077, 0153, 0153, 0153, 0153, 0, 0, 0 },
	{ 0, 0, 0, 0, 077, 0143, 0143, 0143, 0143, 0, 0, 0 },
	{ 0, 0, 0, 0, 076, 0143, 0143, 0143, 076, 0, 0, 0 },
	{ 0, 0, 0, 0, 077, 0143, 0143, 0143, 077, 03, 03, 0 },
	{ 0, 0, 0, 0, 0176, 0143, 0143, 0143, 0176, 0140, 0140, 0 },
	{ 0, 0, 0, 0, 075, 0147, 03, 03, 03, 0, 0, 0 },
	{ 0, 0, 0, 0, 0176, 03, 076, 0140, 077, 0, 0, 0 },
	{ 0, 0, 014, 014, 077, 014, 014, 0154, 070, 0, 0, 0 },
	{ 0, 0, 0, 0, 0143, 0143, 0143, 0143, 0176, 0, 0, 0 },
	{ 0, 0, 0, 0, 0143, 0143, 066, 066, 034, 0, 0, 0 },
	{ 0, 0, 0, 0, 0143, 0143, 0153, 0153, 066, 0, 0, 0 },
	{ 0, 0, 0, 0, 0143, 066, 034, 066, 0143, 0, 0, 0 },
	{ 0, 0, 0, 0, 0143, 0143, 0143, 0143, 0176, 0140, 076, 0 },
	{ 0, 0, 0, 0, 077, 030, 014, 06, 077, 0, 0, 0 },
	{ 0, 0160, 030, 030, 016, 016, 030, 030, 0160, 0, 0, 0 },
	{ 0, 014, 014, 014, 014, 014, 014, 014, 014, 0, 0, 0 },
	{ 0, 07, 014, 014, 070, 070, 014, 014, 07, 0, 0, 0 },
	{ 0, 0, 0, 0, 0140, 076, 03, 0, 0, 0, 0, 0 },
	{ 0377,0377,0377,0377,0377,0377,0377,0377,0377,0377,0377,0377 },
};

static	long	ACurX = 128;
static	long	ACurY = 528;


vid_reset()
{
	register long	i, *vmp;

	vmp = (long *)(vcram);
	for (i = 0; i < ((800*1024)>>2); i++) *vmp++ = 0;
	ACurX = MINX;
	ACurY = MINY;
}

int	morewait;

vid_char(c)
register char	c;
{
	register int	cnt;
	register int	shift;
	register char	*linep;
	register char	*charp;
	int i;

/*	vid_cursor(0); */
	switch (c &= 0177) {
	    case '\n':
		ACurY += LINESPERCHAR;
		if(ACurY >= MAXY) {
			ACurY = MINY;
			while(morewait)
				if(keystat())
					break;
		}
		linep = (char *)(vcram + (ACurY*BYTESPERLINE));
		cnt = (BYTESPERLINE*LINESPERCHAR)/4;
		/* clear line */
		do {
			*(long *)(linep)++ = 0;
		} while(--cnt > 0);
		break;

	    case '\r':
		ACurX = MINX;
		break;

	    case '\b':
		ACurX -= CHARWIDTH;
		if(ACurX < MINX)
			ACurX = MINX;
		break;

	    case '\t':
		ACurX = ((((ACurX>>3) + CHARWIDTH) & ~7)<<3);
		break;

	    case '\f':
		vid_reset();
		break;

	    default:
		linep = (char *)(vcram + (ACurY*BYTESPERLINE) +
							 ((ACurX>>3)));
		charp = SFont[c];
		cnt = LINESPERCHAR;
		do {
			*linep = *charp++;
			linep += BYTESPERLINE;
		} while(--cnt > 0);
		ACurX += 8;
		if(ACurX >= MAXX) {
			ACurY += LINESPERCHAR;
			if(ACurY >= MAXY)
				ACurY = MINY;
			ACurX = MINX;
			linep = (char *)(vcram + (ACurY*BYTESPERLINE));
			cnt = BYTESPERLINE*LINESPERCHAR/4;
			/* clear line */
			do {
				*(long *)(linep)++ = 0;
			} while(--cnt > 0);
		}
	}
/*	vid_cursor(1); */
}


vid_cursor(mode)
{
	register int	cnt;
	register char	cch;
	register char	*linep;

	linep = (char *)(vcram + (ACurY*BYTESPERLINE) + ((ACurX>>3)^1));
	cch = (mode ? -1 : 0);
	cnt = LINESPERCHAR;
	do {
		*linep ^= cch;
		linep += BYTESPERLINE;
	} while(--cnt > 0);
}
