/* Copyright (C) 1986 Free Software Foundation, Inc.

		       NO WARRANTY

  BECAUSE THIS PROGRAM IS LICENSED FREE OF CHARGE, WE PROVIDE ABSOLUTELY
NO WARRANTY, TO THE EXTENT PERMITTED BY APPLICABLE STATE LAW.  EXCEPT
WHEN OTHERWISE STATED IN WRITING, FREE SOFTWARE FOUNDATION, INC,
RICHARD M. STALLMAN AND/OR OTHER PARTIES PROVIDE THIS PROGRAM "AS IS"
WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY
AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE
DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR
CORRECTION.

 IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL RICHARD M.
STALLMAN, THE FREE SOFTWARE FOUNDATION, INC., AND/OR ANY OTHER PARTY
WHO MAY MODIFY AND REDISTRIBUTE THIS PROGRAM AS PERMITTED BELOW, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR
OTHER SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE
USE OR INABILITY TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR
DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR
A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS) THIS
PROGRAM, EVEN IF YOU HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGES, OR FOR ANY CLAIM BY ANY OTHER PARTY.

		GENERAL PUBLIC LICENSE TO COPY

  1. You may copy and distribute verbatim copies of this source file
as you receive it, in any medium, provided that you conspicuously
and appropriately publish on each copy a valid copyright notice
"Copyright (C) 1986 Free Software Foundation, Inc"; and include following the
copyright notice a verbatim copy of the above disclaimer of warranty
and of this License.

  2. You may modify your copy or copies of this source file or
any portion of it, and copy and distribute such modifications under
the terms of Paragraph 1 above, provided that you also do the following:

    a) cause the modified files to carry prominent notices stating
    that you changed the files and the date of any change; and

    b) cause the whole of any work that you distribute or publish,
    that in whole or in part contains or is a derivative of this
    program or any part thereof, to be freely distributed
    and licensed to all third parties on terms identical to those
    contained in this License Agreement (except that you may choose
    to grant more extensive warranty protection to third parties,
    at your option).

  3. You may copy and distribute this program or any portion of it in
compiled, executable or object code form under the terms of Paragraphs
1 and 2 above provided that you do the following:

    a) cause each such copy to be accompanied by the
    corresponding machine-readable source code, which must
    be distributed under the terms of Paragraphs 1 and 2 above; or,

    b) cause each such copy to be accompanied by a
    written offer, with no time limit, to give any third party
    free (except for a nominal shipping charge) a machine readable
    copy of the corresponding source code, to be distributed
    under the terms of Paragraphs 1 and 2 above; or,

    c) in the case of a recipient of this program in compiled, executable
    or object code form (without the corresponding source code) you
    shall cause copies you distribute to be accompanied by a copy
    of the written offer of source code which you received along
    with the copy you received.

  4. You may not copy, sublicense, distribute or transfer this program
except as expressly provided under this License Agreement.  Any attempt
otherwise to copy, sublicense, distribute or transfer this program is void and
your rights to use the program under this License agreement shall be
automatically terminated.  However, parties who have received computer
software programs from you with this License Agreement will not have
their licenses terminated so long as such parties remain in full compliance.

*/

/*
 * Fmt.  This program performs a very simple-minded text fill.  The input is
 *  read as a stream of words (a `word' is any string not containing space,
 *  tab, or newline).  The output consists of the same stream of words, but
 *  with output lines as close to 72 columns as possible.  Interword spacing
 *  is preserved in general.  Interword space disappears when a line break is
 *  generated by fmt; when a line break in the input is removed, fmt inserts
 *  one space unless the word before the break ends with one of .!?: in which
 *  case it inserts two spaces.  Fmt makes an attempt to preserve whitespace
 *  at the beginnings of lines; but if you have variable amounts of
 *  whitespace the algorithm can lose.  It behaves fairly well for simple
 *  cases (such as reformatting a letter before sending).  This algorithm is
 *  very simple:  Whenever fmt needs to output whitespace at the beginning of
 *  a line, it outputs a copy of the whitespace it most recently read at the
 *  beginning of a line.  Completely blank lines in the input are preserved.
 *  Trailing space is not preserved.
 *
 * If an input word is longer than 72 characters the algorith may stutter,
 *  producing extra blank lines, but will not break.
 */

/*
 * This program contains a set of routines which are interesting in their own
 *  right.  They are init_accum, accum_char, accum_regret, and accum_result.
 *  They provide a facility for accumulation of strings one character at a
 *  time into a malloc ()ed buffer which grows as necessary.  This is done
 *  with an internal structure (the typedef ACCUM below), one of which is
 *  allocated for each string being accumulated at once.  A pointer to this
 *  structure is cast to `char *' and returned to the user as a handle on the
 *  accumulation.  He should not touch it himself; it should be used only by
 *  passing it to accum_char, accum_regret, and accum_result.  The calling
 *  sequences are as follows:
 *
 *	char *init_accum ();
 *		Allocates a new ACCUM structure and initializes it.  The
 *		handle is returned.
 *
 *	accum_char (acc,c);
 *	char *acc;
 *	char c;
 *		Acc should be an ACCUM structure handle as returned by
 *		init_accum ().  The character c is added onto the end of the
 *		string being accumulated in this structure.
 *
 *	char accum_regret (acc);
 *	char *acc;
 *		Acc should be an ACCUM structure handle as returned by
 *		init_accum ().  The last character added onto this string with
 *		accum_char is removed and returned.  Multiple calls to
 *		accum_regret without intervening accum_char calls are
 *		permitted; if accum_regret is called more than accum_char
 *		then nulls ('\0') will be returned when the accumulated
 *		characters run out.
 *
 *	char *accum_result (acc);
 *	char *acc;
 *		Acc should be an ACCUM structure handle as returned by
 *		init_accum ().  The accumulated string is returned.  When this
 *		routine is called, the ACCUM structure is destroyed and the
 *		handle must not be used further.
 *
 * Author: Mike Parker
 */

/*
 * This program assumes the following:
 *
 *	If DEBUG is defined, a routine unctrl () must exist.  This routine
 *	  should take a (possibly non-printable or non-ascii) character and
 *	  return a character pointer to a printable version of it.  It is ok
 *	  for unctrl () to return a pointer to static storage.
 */

#include <stdio.h>
#include <ctype.h>

/* #define DEBUG/**/

#ifdef DEBUG
char *unctrl ();
#endif

/* Characters are read and possibly pushed back.  This is the maximum number
    of characters which may be pushed back.  Actually, we should never need
    to push more than 1. */
#define MAXPUSHBACK 8
/* Column at which to break output. */
#define BREAK_COL 72

#define NEW(type) ((type *) malloc (sizeof (type)))
#define OLD(x) free ((char *) x)
#define check_malloc(ptr) Check_malloc ((char *)(ptr))

char *malloc ();
char *realloc ();

char *pgm;

/* remaining arguments (file names) */
char **args;
/* FILE from which we're currently reading input */
FILE *infile;
/* array of pushed-back characters */
char pushback[MAXPUSHBACK];
/* number of pushed-back characters */
char npushed;
/* at-end-of-input-p (ie, eof on last input file) */
int at_end;
/* what column we're at in the output */
int outcol;

/* the accum routines' internal structre */
typedef struct {
	  int have;
	  int used;
	  char *buf; } ACCUM;

/* see header for the function of the next four routines */
char *
init_accum ()
{
  ACCUM *a;

  a = NEW (ACCUM);
  check_malloc (a);
  a->used = 0;
  a->have = 8;
  a->buf = malloc (8);
  check_malloc (a->buf);
  return ((char *)a);
}

accum_char (A, c)
     char *A;
#define a ((ACCUM *)A)
char c;
{
  while (a->used >= a->have)
    {
      a->buf = realloc (a->buf, a->have+=8);
      check_malloc (a->buf);
    }
  a->buf[a->used++] = c;
}
#undef a

char
accum_regret (A)
     char *A;
#define a ((ACCUM *)A)
{
  if (a->used > 0)
    {
      return (a->buf[--a->used]);
    }
  else
    {
      return (0);
    }
}
#undef a

char *
accum_result (A)
     char *A;
#define a ((ACCUM *)A)
{
  char *cp;

  cp = realloc (a->buf, a->used+1);
  check_malloc (cp);
  cp[a->used] = '\0';
  OLD (a);
  return (cp);
}
#undef a

/* return a copy of the string in malloc ()ed storage */
char *
copyofstr (s)
     char *s;
{
  int l;
  char *cp;

  l = strlen (s);
  cp = malloc (l+1);
  check_malloc (cp);
  strcpy (cp, s);
  return (cp);
}

/* is the character a horizontal space (isspace () says '\n' is whitespace) */
int
ishspace (c)
     char c;
{
  return ((c == ' ') || (c == '\t'));
}

/* bomb in case a malloc () failed */
Check_malloc (ptr)
     char *ptr;
{
  if (ptr == 0)
    {
      fprintf (stderr, "%s: out of memory\n", pgm);
      exit (-1);
    }
}

/* set up the input stream variables */
setup_input (av)
     char **av;
{
  args = av;
  if (*args)
    {
      infile = fopen (*args++, "r");
    }
  else
    {
      infile = stdin;
    }
  npushed = 0;
  at_end = 0;
}

/* get the next input character, from input or pushback as appropriate */
char
Get ()
{
  char c;

  if (npushed > 0) /* there's stuff in pushback */
    {
      c = pushback[--npushed];
#ifdef DEBUG
      fprintf (stderr, "Got %s from pushback\n", unctrl (c));
#endif
      return (c);
    }
  if (at_end) /* at end of input */
    {
#ifdef DEBUG
       fprintf (stderr, "Virtual EOF\n");
#endif
      return ((char)EOF);
    }
  while (1)
    {
      if (infile == NULL) /* failed to open last time through loop */
	{
	  fprintf (stderr, "%s: cannot open %s for input\n", pgm, args[-1]);
	}
      else
	{
	  c = getc (infile);
	  if (ferror (infile) || feof (infile)) /* eof on current input file */
	    {
#ifdef DEBUG
	       fprintf (stderr, "Real EOF\n");
#endif
	      if (infile != stdin) /* close the file, if it's a real file */
		{
		  fclose (infile);
		}
	    }
	  else /* we got the character OK */
	    {
	      break;
	    }
	}
      if (*args) /* if we get here, we want to open a new file */
	{
	  infile = fopen (*args++, "r");
	}
      else /* no more arguments */
	{
	  at_end = 1;
	  c = (char)EOF;
	  break;
	}
    }
#ifdef DEBUG
  fprintf (stderr, "Got %s\n", unctrl (c));
#endif
  return (c);
}

/* shove a character back into the input stream */
char
Push (c)
     char c;
{
  if (npushed >= MAXPUSHBACK)
    {
      fprintf (stderr, "%s: INTERNAL BUG: pushing more than %d chars back\n",
	       pgm, MAXPUSHBACK);
      exit (-1);
    }
#ifdef DEBUG
  fprintf (stderr, "Push %s\n", unctrl (c));
#endif
  pushback[npushed++] = c;
}

/* need I comment?? */
main (ac, av)
     int ac;
char **av;
{
  pgm = *av++;
  ac --;
  setup_input (av);
  doit ();
}

/* Algorithm is fairly straightforward.  This is an FSM in one of three
    states:  NEWLINE, reading whitespace at the beginning of a line, WORD,
    reading characters in a word, or SPACE, reading inter-word space.  In
    each case, we read a character and save it up and/or change state as
    appropriate. */
doit ()
{
  char *last_leader; /* last leading whitespace */
  char *word; /* last word */
  char *interword; /* last interword space */
  enum {
    NEWLINE,
    WORD,
    SPACE } state; /* FSM state */
  char c;
  int fresh_line; /* are we outputting on a fresh line? */
  int ended_sentence; /* true if last word ended with one of .?!: */

  state = NEWLINE;
  last_leader = init_accum ();
  outcol = 1;
  fresh_line = 1;
  ended_sentence = 1;
  while (1)
    {
      c = Get ();
      if (c == (char)EOF)
	{
	  break;
	}
      switch (state)
	{
	case NEWLINE:
	  if (ishspace (c))
	    {
	      accum_char (last_leader, c);
	    }
	  else
	    {
	      last_leader = accum_result (last_leader);
	      if (c == '\n') /* totally blank line */
		{
		  if (! fresh_line)
		    {
		      putchar ('\n');
		    }
		  printf ("%s\n", last_leader);
		  fresh_line = 1;
		  outcol = 1;
		  free (last_leader);
		  last_leader = init_accum ();
		}
	      else
		{
		  Push (c);
		  state = WORD;
		  word = init_accum ();
		  interword = copyofstr (ended_sentence?"  ":" ");
		}
	    }
	  break;
	case WORD:
	  if (ishspace (c) || (c == '\n')) /* end of word */
	    {
	      int len;
	      word = accum_result (word);
	      len = strlen (word);
	      if (fresh_line) /* force at least one word per line */
		{
		  outstring (last_leader);
		  outstring (word);
		  fresh_line = 0;
		}
	      else if (outcol+len > BREAK_COL) /* must break */
		{
		  putchar ('\n');
		  outcol = 1;
		  outstring (last_leader);
		  outstring (word);
		}
	      else /* normal case */
		{
		  outstring (interword);
		  outstring (word);
		}
	      ended_sentence = (index (".!?:", word[len-1]) != 0);
	      free (interword);
	      free (word);
	      if (c == '\n')
		{
		  state = NEWLINE;
		  free (last_leader);
		  last_leader = init_accum ();
		}
	      else
		{
		  Push (c);
		  state = SPACE;
		  interword = init_accum ();
		}
	    }
	  else /* still in the same word */
	    {
	      accum_char (word, c);
	    }
	  break;
	case SPACE:
	  if (c == '\n') /* line with trailing space -- trash the space */
	    {
	      free (accum_result (interword));
	      state = NEWLINE;
	      free (last_leader);
	      last_leader = init_accum ();
	    }
	  else if (ishspace (c)) /* still reading interword space */
	    {
	      accum_char (interword, c);
	    }
	  else /* new word comes along */
	    {
	      interword = accum_result (interword);
	      state = WORD;
	      Push (c);
	      word = init_accum ();
	    }
	  break;
	}
    }
  switch (state) /* EOF, clean up if we're still in a word */
    {
    case WORD:
      word = accum_result (word);
      printf ("%s", word);
      free (word);
      break;
    }
  putchar ('\n'); /* make sure there's the last newline */
  outcol = 1; /* should never get used, but for consistency... */
}

/* print a string, updating outcol.  Newlines are not considered. */
outstring (s)
     char *s;
{
  for (; *s; s++)
    {
      if (*s == '\t')
	{
	  outcol = (((outcol-1) >> 3) << 3) + 1;
	}
      else
	{
	  outcol ++;
	}
      putchar (*s);
    }
}
