#include "../h/param.h"
#include "../h/systm.h"
#include "../h/acct.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/inode.h"
#include "../h/proc.h"
#include "../h/seg.h"
#include "../h/map.h"
#include "../h/reg.h"
#include "../h/buf.h"

/*
 * Machine-dependent startup code
 */
startup()
{
	register i;
	char *a;

	/*
	 * zero and free all of core
	 */

	a = &u;			/* Virtual address of process 0 u area */
	lraddr(&a, kisa);		/* Physical address */
	i = btoc(a) + USIZE;		/* Start of user memory */
	trace(2<<24, "umem", i);
	trace(2<<24, "memtop", memtop);
	for ( ; ctob(i) < memtop; i++) {
		clearseg(i);
		maxmem++;
		freemem++;
		mfree(coremap, 1, i);
	}
/**
	printf("Memory = %d.%d K\n", maxmem/4, (maxmem%4)*25);
**/
	printf("Memory = %d.%d K\n", (maxmem<<CSHIFT)/1024,
		(((maxmem<<CSHIFT)/256)%4)*25);
	if(MAXMEM < maxmem)
		maxmem = MAXMEM;
	mfree(swapmap, nswap, 1);
	swplo--;
}

/*
 * set up a physical address
 * into users virtual address space.
 */
sysphys()
{
	register i, s, d;
	register struct a {
		int	segno;
		int	size;
		int	phys;
	} *uap;

	if(!suser())
		return;
#ifndef	M3240
	uap = (struct a *)u.u_ap;
	i = uap->segno;
	if(i < 0 || i >= 16)
		goto bad;
	s = uap->size;
	if(s < 0 || s > 256)
		goto bad;
	d = u.u_uisa[i];
	if(d != 0 && (d&ABS) == 0)
		goto bad;
	if(s)
		u.u_uisa[i] = ((s-1)<<20) | (uap->phys&SEGMASK) | RW|ABS;
	sureg();
	return;

bad:
#endif
	u.u_error = EINVAL;
}

/*
 * Let a process handle a signal by simulating an interrupt
 */
sendsig(p, signo)
caddr_t p;
{
	register unsigned n;
	register aps;

	aps = u.u_ar0[RPS];
	if (u.u_nostack) {
		/* No user stack -- set up stack for signal routine */
		u.u_nostack = 0;
		aps =| (1<<31);
		n = ctob(stoc(u.u_sseg) + u.u_ssize-2) - 4*NBPW;
	} else
		n = u.u_ar0[RSP] - 3*NBPW;

	grow(n);
	suword((caddr_t)n, aps);
	suword((caddr_t)n+NBPW, u.u_ar0[PC]);
	suword((caddr_t)n+2*NBPW, u.u_ar0[RSP]);
	u.u_ar0[RSP] = n;
	u.u_ar0[PC] = (int)p;
}

mapalloc()
{}

mapfree()
{}
