h03408
s 00095/00000/00000
d D 1.1 82/08/02 16:27:26 cecily 1 0
e
u
U
t
T
I 1
/*
 * Reorder typesetter motions
 *      Input & output: lines of 5 decimal integers
 *              ch size font esc lead
 *
 * where        ch = character (in C/A/T set - not ASCII order)
 *              size = current type size in points
 *              font = current font position [0..3]
 *              esc = horizontal space to move (in 1/432 inch) before printing
 *              lead = vertical space to move (in 1/144 inch) before printing
 *
 * The output lines satisfy the relation:
 *
 *      (esc < 0) => (lead != 0)
 *
 * i.e., horizontal movements are towards the right EXCEPT when changing
 * vertical lines
 */

int	ch, size, font, esc, lead;
int	pos;
int	opos, vert;
main()
{
	emptyline();
	while (getcmd()) {
		if (lead) {
			printline();
			emptyline();
			vert += lead;
		}
		pos += esc;
		insertchar();
	}
	printline();
}

getcmd()
{
	return(scanf("%d %d %d %d %d", &ch, &size, &font, &esc, &lead) == 5);
}

struct node {
	int	pos;
	char	ch, size, font;
	struct node *left, *right;
} nodes[512];
struct node first = { -1000000 };
struct node last = { 1000000 };
struct node *freep;
struct node *cursor;


emptyline()
{
	cursor = &first;
	first.right = &last;
	last.left = &first;
	freep = nodes;
}

insertchar()
{
	register struct node *p, *q, *f;
	p = cursor;
	while (p->pos > pos)
		p = p->left;
	while ((q = p->right)->pos < pos)
		p = q;

	f = freep;
	f->pos = pos;
	f->ch = ch;
	f->size = size;
	f->font = font;

	f->left = p;
	f->right = q;
	p->right = f;
	q->left = f;

	freep = ++f;
	cursor = p;
}

printline()
{
	register struct node *p;
	for (p = first.right; p != &last; p = p->right) {
		printf("%d	%d	%d	%d	%d\n",
			p->ch, p->size, p->font, p->pos - opos, vert);
		opos = p->pos;
		vert = 0;
	}
}
E 1
