/* SCCS_ID @(#)stat.h    	3.1	 01:20:55 - 81/10/27 */

#ifndef LOCALS_INCLUDED
# include <sys/local.h>
#endif

struct	stat
{
	dev_t	st_dev;
	ino_t	st_ino;
	unsigned short st_mode;
	short	st_nlink;
	short  	st_uid;
	short  	st_gid;
	dev_t	st_rdev;
	off_t	st_size;
	time_t	st_atime;
	time_t	st_mtime;
	time_t	st_ctime;
};

#define	S_IFMT	0170000		/* type of file */
#define		S_IFDIR	0040000	/* directory */
#define		S_IFCHR	0020000	/* character special */
#define		S_IFBLK	0060000	/* block special */
#define		S_IFREG	0100000	/* regular */
#define		S_IFMPC	0030000	/* multiplexed char special */
#define		S_IFMPB	0070000	/* multiplexed block special */
#define	S_ISUID	0004000		/* set user id on execution */
#define	S_ISGID	0002000		/* set group id on execution */
#define	S_ISVTX	0001000		/* save swapped text even after use */
#define	S_IREAD	0000400		/* read permission, owner */
#define	S_IWRITE	0000200		/* write permission, owner */
#define	S_IEXEC	0000100		/* execute/search permission, owner */
#ifdef SVC6
struct v6stat
{
	int	st6_dev;
	int	st6_ino;
	int	st6_mode;
	char	st6_nlink;
	char  	st6_uid;
	char  	st6_gid;
	char	st6_siz0;
	int	st6_siz1;
	int	st6_addr[8];
	int	st6_atm0;
	int	st6_atime;
	int	st6_mtm0;
	int	st6_mtime;
};
#endif
