/*
 * Segmentation hardware definitions
 */

physadr uisa;		/* first user segmentation register */
physadr kisa;		/* first kernel segmentation register */

#define SEGMASK		0xfff00		/* segment start address */
#define	SEGEP		0x80		/* execute protect */
#define SEGIP		0x40		/* write-interrupt protect */
#define SEGWP		0x20		/* write protect */
#define SEGPRES		0x10		/* present */

#define	RO	(SEGWP|SEGPRES)		/* access abilities */
#define	RW	SEGPRES
#define	TX	0x01		/* Software: text segment */
#define	ABS	0x02		/* Software: absolute address */

physadr ka6;		/* pointer to u segment register */
