h32783
s 00076/00000/00000
d D 1.1 82/08/03 08:44:42 cecily 1 0
e
u
U
t
T
I 1
/*
 *	floating point conversion routine for _doprnt
 *	(kept separate so 'fflptr' can replace it if no floats in prog)
 */

char *_prflt(x, str, ndig, prec, fmt)
double x;
register char *str;
register ndig, prec;
char fmt;
{
	register char *p;
	register n;
	int sign, decpt;
	extern char *fcvt(), ecvt(), gcvt();

	switch (fmt) {
	case 'g':		/* general */
		p = gcvt(x, prec ? ndig : 6, str);
		while (*p)
			p++;
		return(p);

	case 'f':		/* floating point */
		p = fcvt(x, ndig = prec ? ndig : 6, &decpt, &sign);
		if (sign)
			*str++ = '-';
		if ((n = decpt) <= 0)
			*str++ = '0';
		else do
			*str++ = *p++;
		while (--n > 0);
		if ((n = ndig) != 0)
			*str++ = '.';
/***/		if ((decpt = -decpt) > 0)
/***/			while (n > 0 && decpt > 0) {
/***/				*str++ = '0';
/***/				n--;
/***/				decpt--;
/***/			}
		if (n > 0) do
			*str++ = *p++;
		while (--n > 0);
		*str = 0;
		return(str);

	case 'e':
		ndig++;
		p = ecvt(x, ndig = prec ? ndig : 7, &decpt, &sign);
		if (sign)
			*str++ = '-';
		if (*p == '0')
			decpt++;
		*str++ = *p++;
		*str++ = '.';
		if ((n = ndig - 1) > 0) do
			*str++ = *p++;
		while (--n > 0);
		*str++ = 'e';
		if ((n = decpt - 1) < 0) {
			*str++ = '-';
			n = -n;
		} else
			*str++ = '+';
		*str++ = (unsigned)n / 10 + '0';
		*str++ = (unsigned)n % 10 + '0';
		*str = 0;
		return(str);
	default:
		*str = '?';
		str[1] = 0;
		return(str);
	}
}

int fltused = 0;	/* to force loading when needed */
E 1
