/*
 *              cvtsk  infile  outfile
 *
 *      Convert Interdata TSK file to UNIX a.out file
 */

#include <stdio.h>
int ibuf[64];
FILE *obuf;

main(argc, argv)
char *argv[];
{
	register in, progsize, i;

	if (argc != 3)
		error("Usage: cvtsk invile outfile");
	if ((in=open(argv[1], 0)) < 0)
		error("Can't open %s", argv[1]);
	if ((obuf = fopen(argv[2], "w")) == NULL)
		error("Can't create %s", argv[2]);

/* read loader info block to get program size */

	if (read(in, ibuf, 256) != 256)
		error("Read error");
	progsize = ibuf[26];

/* write size information on a.out file */

	putw(0407, obuf);
	putw(0, obuf);
	putw(progsize, obuf);
	for (i=1; i<=5; i++)
		putw(0, obuf);

/* copy program to a.out file */

	while (progsize >= 256) {
		read(in, ibuf, 256);
		for (i=0; i<64; i++)
			putw(ibuf[i], obuf);
		progsize =- 256;
	}
	if (progsize > 0) {
		read(in, ibuf, progsize);
		for (i=0; i<progsize/4; i++)
			putw(ibuf[i], obuf);
	}
	exit(0);
}
error(s, x)
char *s;
{
	fprintf(stderr, s, x);
	fprintf(stderr, "\n");
	exit(1);
}
