#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/text.h"
#include "../h/seg.h"

/*
 * Load the user hardware segmentation
 * registers from the software prototype.
 * The software registers must have
 * been setup prior by estabur.
 */
sureg()
{
	register *up, *rp, a, t;
	register struct text *tp;

	t = a = (u.u_procp->p_addr) << 8;
	if ((tp=u.u_procp->p_textp) != NULL)
		t = (tp->x_caddr)<<8;
	up = &u.u_uisa[16];
	rp = &uisa0[16];
	while (--up >= &u.u_uisa[0])
		*--rp = (*up + (*up&TX? t: (*up&ABS? 0: a))) & ~(TX|ABS);
}

/*
 * Set up software prototype segmentation
 * registers to implement the 3 pseudo
 * text,data,stack segment sizes passed
 * as arguments.
 * The argument sep specifies if the
 * text and data+stack segments are to
 * be separated (meaningless on Interdata).
 * The last argument determines whether the text
 * segment is read-write or read-only.
 */
estabur(nt, nd, ns, sep, xrw)
unsigned nt, nd, ns;
{
	register a, *ap, *dp;

	if(sep) 
		goto err;
	else
		if(ctos(nt)+ctos(nd)+ctos(ns) > 15)
			goto err;
	if(nt+nd+ns+USIZE > maxmem)
		goto err;
	a = 0;
	ap = &u.u_uisa[0];
	while(nt >= 256) {
		*ap++ = (a<<8) | (255<<20) | xrw|TX;
		a += 256;
		nt -= 256;
	}
	if(nt) {
		*ap++ = (a<<8) | ((nt-1)<<20) | xrw|TX;
	}
	a = USIZE;
	while(nd >= 256) {
		*ap++ = (a<<8) | (255<<20) | RW;
		a += 256;
		nd -= 256;
	}
	if(nd) {
		*ap++ = (a<<8) | ((nd-1)<<20) | RW;
		a += nd;
	}
	u.u_sseg = 15-ctos(ns);
	dp = &u.u_uisa[u.u_sseg];
	while(ap < dp) {
		*ap++ = 0;
	}
	while(ns >= 256) {
		*ap++ = (a<<8) | (255<<20) | RW;
		a += 256;
		ns -= 256;
	}
	if(ns) {
		*ap++ = (a<<8) | ((ns-1)<<20) | RW;
	}
	sureg();
	return(0);

err:
	u.u_error = ENOMEM;
	return(-1);
}
