h28366
s 00024/00006/01275
d D 1.3 82/09/13 12:32:47 ross 3 2
c Install conf code for new mx and uv drivers.
c Output error logger on/off switch in .s code.
e
s 00000/00000/01281
d D 1.2 82/09/13 10:50:26 ross 2 1
c 
e
s 01281/00000/00000
d D 1.1 82/09/13 10:13:12 ross 1 0
e
u
U
t
T
I 1
/*
 *		Perkin-Elmer UNIX Configuration Utility
 *
 *
 *		(C) 1980, Richard Miller
 *		    University of Wollongong
 */

#include <stdio.h>
#include <ctype.h>

/*
 * Table describing device characteristics
 */

#define CDEV		01	/* is a character device */
#define BDEV		02	/* is a block device */
#define DEVAD		04	/* device addresses required */
#define CNTLAD		010	/* controller address required */
#define SELCHAD		020	/* selector channel address required */
#define SIZE		040	/* size specification required */
#define MAP		0100	/* logical device map required */
#define SPEEDS		0200	/* baud rate table required */
#define CONSDEV		0400	/* can be console device */
#define FSDEV		01000	/* can be file system device */
#define	DREQ		02000	/* must be defined */

char	null[]	= "nulldev";	/* name of no-op fill-in routine */
char	no[]	= "nodev";	/* name of error fill-in routine */
char	zero[]	= "0";		/* null fill-in entry */

struct devconf {
			/* Static data */
	char	*d_name;	/* external name */
	int	d_flags;	/* device attributes - see #defines above */
	int	d_maxdev;	/* maximum number of devices permitted
					(or 0 for no limit) */
	int	d_nccb;		/* number of channel control blocks per dev */
	char	*d_bsw[5];	/* names ofbuf	%s;\n", dp->d_bsw[3]);
		}
	}
	/*
	 * bdevsw
	 */
	printf("\nstruct bdevsw	bdevsw[] = {\n");
	major = 0;
	for (dp = devconf; dp->d_name; dp++) if (dp->d_flags&BDEV) {
		if (dp->d_ndev > 0) {
			printf("\t%s, %s, %s, ",
				dp->d_bsw[0], dp->d_bsw[1], dp->d_bsw[2]);
			if (dp->d_bsw[3] == zero)
				printf("0,");
			else
				printf("&%s,", dp->d_bsw[3]);
		} else
			printf("\tnodev, nodev, nodev, 0,");
		printf("\t/* %s = %d */\n", dp->d_name, major);
		dp->d_major = major;
		major++;
	}
	printf("\t0\n};\n\n");
	/*
	 * declarations for char switch routines
	 */
	for (dp = devconf; dp->d_name; dp++) {
		if ((dp->d_flags&CDEV) && dp->d_ndev > 0) {
			register char *sep = "int\t";

			for (i = 0; i < 6; i++) {
				if (dp->d_csw[i] != no && dp->d_csw[i] != null) {
					printf("%s%s()", sep, dp->d_csw[i]);
					sep = ", ";
				}
			}
			printf(";\n");
			if (dp->d_csw[6] != zero)
				printf("struct tty	%s[%d];\n",
					dp->d_csw[6], dp->d_ndev);
		}
	}
	/*
	 * cdevsw
	 */
	printf("\nstruct cdevsw	cdevsw[] = {\n");
	major = 0;
	for (dp = devconf; dp->d_name; dp++) if (dp->d_flags&CDEV) {
		if (dp->d_ndev > 0) {
			printf("\t%s, %s, %s, %s, %s, %s, %s,",
				dp->d_csw[0], dp->d_csw[1], dp->d_csw[2],
				dp->d_csw[3], dp->d_csw[4], dp->d_csw[5],
				dp->d_csw[6]);
		} else
			printf("\tnodev, nodev, nodev, nodev, nodev, nodev, 0,");
		printf("\t/* %s = %d */\n", dp->d_name, major);
		if (!(dp->d_flags & BDEV))
			dp->d_major = major;
		major++;
	}
	printf("\t0\n};\n\n");
	/*
	 * Definitions for linesw
	 */
	for (lp = lineconf; lp->l_name; lp++) {
		if (lp->l_include) {
			register char	*sep = "int\t";
			for (i = 0; i < 10; i++)
				if (lp->l_lsw[i] != no && lp->l_lsw[i] != null) {
					printf("%s%s()", sep, lp->l_lsw[i]);
				sep = ", ";
			}
			printf(";\n");
		}
	}
	/*
	 * linesw
	 */
	printf("\nstruct linesw	linesw[] = {\n");
	major = 0;
	for (lp = lineconf; lp->l_name; lp++) {
		if (lp->l_include) {
			for (i = 0; i < 10; i++) {
				printf(i==0? "\t": i==5? ",\n\t\t": ", ");
				printf("%s", lp->l_lsw[i]);
			}
			printf(",\t/* %s = %d */\n", lp->l_name, major);
			if (lp->l_select)
				nldisp++;
			major++;
		}
	}
	printf("\t0\n};\n\nint	nldisp = %d;\n", nldisp);
	if (!mx)	/* force loading of fake mx routines */
D 3
		printf("int\tmpxchan();\nint\t(*ldmpx)() = mpxchan;\n");
E 3
I 3
		printf("int\tmxsys();\nint\t(*ldmpx)() = mxsys;\n");
E 3
	/*
	 * Special device assignments
	 */
	{	register struct spdev	*sp;

		for (sp = spdev; sp->s_name; sp++)
			printf("dev_t\t%sdev = makedev(%d, %d);\n",
				sp->s_name, sp->s_dev->d_major, sp->s_minor);
	}
	/*
	 * Assorted configuration variables
	 */
	printf("daddr_t\tswplo\t= %d;\nint\tnswap\t= %d;\n", swaplo, nswap);
	printf("caddr_t\tmemtop\t= %d;\n", memory);
	printf("\nint\t%s();\nint\t(*dumpsw)() = %s;\n\n", dumpsw, dumpsw);
	{	register char	**pp;

		for (pp = junk; *pp; pp++)
			printf("struct\t%s;\n", *pp);
	}
	/*
	 * Driver configuration data
	 */
	for (dp = devconf; dp->d_name; dp++) if (dp->d_ndev > 0) {
		if (dp->d_flags & DEVAD) {
			if (dp->d_maxdev != 1)
				printf("int\tn%s = %d;\n", dp->d_name,
					dp->d_ndev);
			printf("char\t%saddr[] = {", dp->d_name);
			for (i = 0; i < dp->d_ndev; i++)
				printf("%s0x%02x,", i&07 ? " " : "\n\t",
					dp->d_dev[i]);
			printf("\n};\n");
		}
		if (dp->d_flags & CNTLAD)
			printf("int\t%scntl = 0x%02x;\n", dp->d_name, dp->d_cntl);
		if (dp->d_flags & SELCHAD)
			printf("int\t%sselch = 0x%02x;\n", dp->d_name, dp->d_selch);
		if (dp->d_nccb) {
			printf("struct ccb *%sccb = &ccb[%d];\n", dp->d_name,
				nccb);
			nccb += dp->d_ndev * dp->d_nccb;
		}
		if (dp->d_flags & SIZE)
			printf("int\t%ssize = %d;\n", dp->d_name, dp->d_size);
		if (dp->d_flags & MAP) {
			printf("int\t%smap[] = {", dp->d_name);
			for (i = 0; i < 16; i++)
				printf("%s%8d,", i&01 ? "\t" : "\n\t",
					dp->d_map[i]);
			printf("\n};\n");
		}
		if (dp->d_flags & SPEEDS) {
			printf("char\t%srate[][4] = {", dp->d_name);
			for (i = 0; i < nspeeds; i++)
				printf("%sB%d,", i&03 ? " " : "\n\t",
					speeds[i]);
			printf("\n};\n");
		}
	}
	/*
	 * devmap
	 */
	printf("\nchar\tdevmap[] = {\n");
	for (i = 0; i < 256; i++)
		printf("%s%2d,", (i&017)? " ": "\n\t", devmap[i]);
	printf("\n};\n");
	/*
	 * devint
	 */
	printf("\nchar\tdevint[] = {\n");
	for (i = 0; i < 256; i++)
		printf("%s%2d,", (i&017)? " ": "\n\t", devint[i]);
	printf("\n};\n");
	/*
	 * handler table
	 */
	{	register char	*sep = "int\t";

		for (i = 0; i < nhandler; i++) {
			printf("%s%s()", sep, handler[i]);
			if (i%6 == 5)
				sep = ";\nint\t";
			else
				sep = ", ";
		}
	}
	printf(";\n\nint\t(*handler[])() = {\n");
	for (i = 0; i < nhandler; i++)
		printf("\t%s,\n", handler[i]);
	printf("};\n");
}

/*
 * Find entry in keyword table
 * It had better be there!
 */
struct keyparm *
findkey(name)
register char	*name;
{
	register struct keyparm	*kp;

	for (kp = keyparm; kp->k_name; kp++)
		if (!strcmp(kp->k_name, name))
			return(kp);
	abort();
}


/*
 * Make "param.s" file
 *
 * Contains	parameters for conditional assembly of UNIX kernel routines
 */
putsfile()
{
	putparm("M3200", (cpu == 3220) || (cpu == 3240));
	putparm("M3240", cpu == 3240);
	putparm("FPREGS", singlefloat == 1);
	putparm("DPREGS", doublefloat == 1);
	putparm("SPFPT", singlefloat == 2);
	putparm("DPFPT", doublefloat == 2);
	putparm("NCCB", nccb);
	putparm("WCS", findkey("wcs")->k_defined);
	putparm("LRA", (cpu == 3220) || (cpu == 3240) || findkey("lra")->k_defined);
	putparm("PIC", findkey("pic")->k_defined);
I 3
	putparm("ERRLOGGER", findkey("elog")->k_defined);
E 3
}

/*
 * Equate assembly parameter name to value
 */
putparm(name, value)
char	*name;
{
	printf("%s\tequ\t%d\n", name, value);
}

/*
 * Check validity of input data and generate internal parameters
 */
mkconf()
{
	register struct devconf	*dp;

	/*
	 * Check that all required main keywords are defined
	 */
	{	register struct keyparm	*kp;

		for (kp = keyparm; kp->k_name; kp++)
			if ((kp->k_flags & K_REQ) && !kp->k_defined)
				error("%s not specified", kp->k_name);
	}

	/*
	 * Check that special device assignments have been defined
	 */
	{	register struct spdev	*sp;

		for (sp = spdev; sp->s_name; sp++)
			if (sp->s_dev == 0)
				error("%s device not specified", sp->s_name);
	}

	/*
	 * Device processing
	 */
	for (dp = devconf; dp->d_name; dp++) {
		register struct devparm	*pp;

		/*
		 * Check that required devices & parameters are defined
		 */
		if (dp->d_ndev == 0) {
			if (dp->d_flags & DREQ)
				error("%s not defined", dp->d_name);
			continue;
		}
		for (pp = devparm; pp->p_name; pp++)
			if ((dp->d_flags & pp->p_flag)
			    && ! (dp->d_defined & pp->p_flag))
				error("%s not specified for %s", pp->p_name,
					dp->d_name);
		/*
		 * Remember interrupt information
		 */
		if (dp->d_flags & DEVAD) {
			register int	i;
			register char	*int0, *int1;

			int0 = mkhandler(dp->d_int[0]);
			if (dp->d_int[1])
				int1 = mkhandler(dp->d_int[1]);
			else
				int1 = 0;
			for (i = 0; i < dp->d_ndev; i++) {
				register int	dev = dp->d_dev[i];

				mkintvec(dev, int0);
				devmap[dev] = i;
				if ((dp->d_flags&(CDEV|BDEV)) == CDEV && int1) {
					if (dev & 01)
						error("%s addresses must be even",
							dp->d_name);
					mkintvec(dev + 1, int1);
					devmap[dev + 1] = i;
				}
			}
			if (dp->d_flags & CNTLAD)
				mkintvec(dp->d_cntl, int1);
			if (dp->d_flags & SELCHAD)
				mkselch(dp->d_selch);
		}
	}
}

/*
 * Add a name to the interrupt handler table
 *
 * Return offset in table (in bytes)
 */
mkhandler(name)
char	*name;
{
	handler[nhandler] = name;
	if (++nhandler > MAXHANDLER)
		error("Interrupt table overflow");
	return((nhandler-1) * sizeof(*handler));
}

/*
 * Add an address to the selch address table (if not already present)
 * Also record 'minor device number' and interrupt handler for selch address
 */
mkselch(address)
register int	address;
{
	register int	i;

	for (i = 0; i < nselch; i++)
		if (selchaddr[i] == address)
			return;
	selchaddr[i] = address;
	devmap[address] = i;
	devint[address] = SELCHOFFS;
	nselch = ++i;
}

/*
 * Put interrupt handler table offset into interrupt table for given device
 *
 * Check that addresses are not reassigned
 */
mkintvec(address, offset)
{
	if (devint[address] != 0)
		error("device address 0x%02x reassigned", address);
	devint[address] = offset;
}

/*
 * Get the next complete configuration entry from the input file
 *
 * Returns 0 at end of file
 */
getconfig()
{
	register struct devconf		*dp;
	register struct keyparm		*kp;
	register struct spdev		*sp;

	/*
	 * First thing must be a keyword
	 */
	switch (token_type) {
		case ENDFILE:
			return(0);

		case NUMERIC:
			error("Extraneous numeric data");
			return(0);

		case KEYWORD:
			break;

		default:
			abort();
	}
	/*
	 * Check for device declaration
	 */
	for (dp = devconf; dp->d_name; dp++) {
		if (match(dp->d_name)) {
			token();
			while (getdevice(dp))
				;
			if (!(dp->d_flags & DEVAD))
				dp->d_ndev = 1;
			/*
			 * Some device names are also line discipline names
			 */
			getline(dp->d_name);
			return(1);
		}
	}
	/*
	 * Check for line discipline declaration
	 */
	if (getline(token_key)) {
		token();
		return(1);
	}
	/*
	 * Check for special device assignment
	 */
	for (sp = spdev; sp->s_name; sp++) {
		if (match(sp->s_name)) {
			token();
			if (token_type != KEYWORD)
				error("%s requires device name",
					sp->s_name);
			for (dp = devconf; dp->d_name; dp++) {
				if (match(dp->d_name)) {
					token();
					if (!(dp->d_flags & sp->s_flag))
						error("%s is wrong type of device",
							dp->d_name);
					sp->s_dev = dp;
					dp->d_flags |= DREQ;
					if (token_type != NUMERIC)
						error("missing minor device number");
					sp->s_minor = token_value;
					token();
					break;
				}
			}
			if (dp->d_name == 0)
				error("unknown device %s", token_key);
			return(1);
		}
	}
	/*
	 * Check for other main-level keywords
	 */
	for (kp = keyparm; kp->k_name; kp++) {
		if (match(kp->k_name)) {
			token();
			getkey(kp);
			kp->k_defined = 1;
			return(1);
		}
	}
	error("Unknown keyword %s", token_key);
}

/*
 * Process a single main-level non-device entry
 */
getkey(kp)
register struct keyparm	*kp;
{
	if (kp->k_flags & K_NUM) {
		if (token_type != NUMERIC)
			error("%s requires a numeric parameter",
				kp->k_name);
		(*kp->k_fn)();
		token();
	} else if (kp->k_flags & K_KEY) {
		if (token_type != KEYWORD)
			error("%s requires a keyword parameter",
				kp->k_name);
		(*kp->k_fn)();
		token();
	}
}

/*
 * Main keyword parameter routines
 */
Pcpu()
{
	switch (token_value) {
		case 732: case 832: case 3220: case 3240:
			cpu = token_value;
			break;

		default:
			error("Unknown CPU model %d", token_value);
	}
I 3
}

Pelog()
{
	if (cpu != 3220  ||  cpu != 3240)
		error("Error logger cannot be on a series %d machine\n", cpu);
E 3
}

Pmemory()
{
	if (token_value < 128*1024)
		error("Sorry, not enough memory to run UNIX");
	if (token_value > 960*1024)
		error("Sorry, a maximumum of 960K memory currently supported");
	memory = token_value;
}

Pfloat()
{
	if (match("hard"))
		singlefloat = 1;
	else if (match("soft"))
		singlefloat = 2;
	else
		error("'hard' or 'soft' expected");
}

Pdfloat()
{
	if (match("hard"))
		doublefloat = 1;
	else if (match("soft"))
		doublefloat = 2;
	else
		error("'hard' or 'soft' expected");
}

Pswaplo()
{
	swaplo = token_value;
}

Pnswap()
{
	nswap = token_value;
}

Pdump()
{
	if (match("mt"))
		dumpsw = "mtdump";
	else if (match("dsk"))
		dumpsw = "dskdump";
	else
		error("%s not a dump device", token_key);
}

/*
 * Get next entry in input description of a device
 *
 * Check that parameter is permitted for this device type
 * Call routine to process parameter
 * Returns 0 for failure
 */
getdevice(dp)
register struct devconf	*dp;
{
	register struct devparm		*pp;

	for (pp = devparm; pp->p_name; pp++) {
		if (match(pp->p_name)) {
			token();
			if (!(dp->d_flags & pp->p_flag))
				error("%s not permitted for %s", pp->p_name,
					dp->d_name);
			(*pp->p_fn)(dp);
			dp->d_defined |= pp->p_flag;
			return(1);
		}
	}
	return(0);
}

/*
 * Device parameter routines
 */

Pdev(dp)
register struct devconf	*dp;
{
	getlist(&dp->d_ndev, &dp->d_dev);
	if (dp->d_maxdev && dp->d_ndev > dp->d_maxdev)
		error("Too many device addresses for %s", dp->d_name);
}

Pcntl(dp)
register struct devconf	*dp;
{
	dp->d_cntl = getnum();
}

Pselch(dp)
register struct devconf *dp;
{
	dp->d_selch = getnum();
}

Psize(dp)
register struct devconf *dp;
{
	register int	size;

	size = getnum();
	if (!strcmp(dp->d_name, "dsk")) {
		switch (size) {
			case 10: case 10*1024*1024:
				dp->d_size = 1;
				return;
			case 2: case 2*1024*1024:
				dp->d_size = 0;
				return;
		}
	} else if (!strcmp(dp->d_name, "msm")) {
		switch (size) {
			case 67: case 67*1024*1024:
				dp->d_size = 0;
				return;
			case 256: case 256*1024*1024:
				dp->d_size = 1;
				return;
		}
	}
	error("incorrect size for %s", dp->d_name);
}

Pmap(dp)
register struct devconf *dp;
{
	int	nmap;

	getlist(&nmap, &dp->d_map);
	if (nmap != 16)
		error("%s map must have 16 entries", dp->d_name);
}

Pspeeds(dp)
register struct devconf *dp;
{
	getlist(&nspeeds, &speeds);
	if (nspeeds & 03)
		error("must define 4 speeds per port");
}

/*
 * If key is name of a line discipline, mark it for inclusion
 *
 * Return 0 if not found
 * make special note of "mx" discipline, to prevent loading of fakemx
 */
getline(key)
char	*key;
{
	register struct lineconf	*lp;

	for (lp = lineconf; lp->l_name; lp++) {
		if (!strcmp(key, lp->l_name)) {
			lp->l_include = 1;
			if (!strcmp(key, "mx"))
				mx = 1;
			return(1);
		}
	}
	return(0);
}

/*
 * Get a list of (one or more) input numbers
 *
 * Return indirectly in *length the number of addresses read, and in *list
 * a pointer to the array of integer values read
 * The space for the list is allocated using sbrk
 */
getlist(length, list)
int	*length;
int	**list;
{
	extern int	end[];
	static int	*avail = end;		/* top of available memory */
	static int	*next = end;		/* next available word */
	register int	len = 0;

	*list = next;
	if (token_type != NUMERIC)
		error("Numeric item expected");
	while (token_type == NUMERIC) {
		if (next >= avail) {
			avail += 64;
			if (brk(avail) != 0)
				error("Out of memory");
		}
		*next++ = token_value;
		len++;
		token();
	}
	*length = len;
}

/*
 * Get a number from the input
 *
 * Return its value
 * Check that not more than one number is supplied
 */
getnum()
{
	register	retval;

	if (token_type != NUMERIC)
		error("Numeric item required");
	retval = token_value;
	token();
	if (token_type == NUMERIC)
		error("Only one numeric item expected");
	return(retval);
}

/*
 * Get the next input token
 *
 *	Skip white space
 *	Skip comments (from '*' to end of line)
 *	Read the next token (non-white-space string)
 *	Set token_type to:
 *		ENDFILE		- no more input
 *		NUMERIC		- integer (may be preceded by 0 or 0x for octal
 *				 or hex, followed by K or M for kilo- or mega-)
 *				- store value in token_value
 *		KEYWORD		- anything else
 *				- store keyword string in token_key
 */
token()
{
	register int	c;

	skipspace();
	if (feof(stdin) || (c = getchar()) == EOF) {	/* no more input */
		token_type = ENDFILE;
		return;
	}
	if (isdigit(c)) {	/* a number */
		register int	accum = 0, base = 10;

		if (c == '0') {
			c = getchar();
			if (c == 'x' || c == 'X') {
				c = getchar();
				base = 16;
			} else
				base = 8;
		}
		for (;;) {
			if (isdigit(c))
				c -= '0';
			else if (c >= 'a' && c <= 'f')
				c -= 'a'-10;
			else if (c >= 'A' && c <= 'F')
				c -= 'A'-10;
			else
				break;
			if (c >= base)
				error("Malformed number");
			accum *= base;
			accum += c;
			c = getchar();
		}
		if (c == 'k' || c == 'K') {
			c = getchar();
			accum *= 1024;
		} else if (c == 'm' || c == 'M') {
			c = getchar();
			accum *= 1024*1024;
		}
		ungetc(c, stdin);
		token_type = NUMERIC;
		token_value = accum;
		return;
	} else {		/* a keyword */
		register char	*p = token_key;
		register int	room = sizeof(token_key);

		while (!(isspace(c)) && c != EOF) {
			if (--room == 0)
				error("Impossibly long word");
			*p++ = c;
			c = getchar();
		}
		*p = '\0';
		token_type = KEYWORD;
		ungetc(c, stdin);
	}
}

/*
 * Skip space and comments on the input file
 * Also keep track of line numbers
 */
skipspace()
{
	register int	c;

	for (;;) {
		c = getchar();
		if (c == '*')
			while ((c = getchar()) != '\n')
				;
		if (c == '\n')
			linenumber++;
		else if (!(isspace(c)))
			break;
	}
	if (c != EOF)
		ungetc(c, stdin);
}

/*
 * Print error message and exit
 */
error(msg, a1, a2)
char *msg;
{
	if (linenumber != 0)
		fprintf(stderr, "Line %d: ", linenumber);
	fprintf(stderr, msg, a1, a2);
	fprintf(stderr, "\n");
	exit(1);

}
E 1
ce and comments on the input file
 * Also keep track of line numbers
 */
skipspace()
{
	register int	c;

	for (;;) {
		c = getchar();
		if (c == '*')
			while ((c = getchar()) !sys/conf/s.trace.s                                                                                     444       2       2         4154  2770530452   7305                                                                                                                                                                                                                                                                                                                                                                      h21628
s 00000/00000/00103
d D 1.3 82/09/13 12:34:12 ross 3 2
c 
e
s 00000/00001/00103
d D 1.2 82/09/13 10:50:57 ross 2 1
c 
e
s 00104/00000/00000
d D 1.1 82/09/13 10:13:25 ross 1 0
e
u
U
t
T
I 1
*************************************************************************
*									*
*			UNIX event-trace routine			*
*									*
* trace(mask, label, value)						*
* char *label;								*
*									*
*	- log message label (first 4 chars) & value in 			*
*	  circular trace buffer "trbuff".				*
*	- if any bits in the mask are on in the trace-control word	*
*	  "trmask", display message on the system console		*
*									*
*************************************************************************

	entry	trace,trbuff,trmask
	extrn	trmask
	extrn	panicstr
	extrn	printf

r0	equ	0
r1	equ	1
r2	equ	2
r3	equ	3
r4	equ	4
r5	equ	5
r6	equ	6
sp	equ	7
r8	equ	8
rf	equ	15

* structure of arguments

args	struc
mask	ds	adc
label	ds	adc
value	ds	adc
	ends
	pure
trace	equ	*

* Don't trace if panicking

	l	r0,panicstr
	bnzr	rf


* get first 4 chars of message label

	l	r1,label(sp)	message pointer
	lb	r2,0(r1)	first byte
	exbr	r2,r2
	lb	r0,1(r1)	second byte
	stbr	r0,r2
	exhr	r2,r2		move to upper half of word
	lb	r0,2(r1)	third byte
	stbr	r0,r2
	exbr	r2,r2
	lb	r0,3(r1)	fourth byte
	stbr	r0,r2

* put message & value in trace buffer

	la	r4,trbuff	point to trace buffer
tr.abl	equ	*
	abl	r2,0(r4)	add to bottom of list
	bfc	4,tr.ablok	no overflow - continue
	lis	r0,0		else reset buffer to 'empty'
	sth	r0,2(r4)
	st	r0,4(r4)
	b	tr.abl		try again
tr.ablok	equ	*
	l	3,value(sp)	value
	abl	r3,0(r4)	add to bottom of list

* test whether this trace is masked on

	l	r0,mask(sp)	get mask
	n	r0,trmask	check with trace control word
	bzr	rf		no bits on - return

* display message on system console

	shi	sp,32+12	save regs first
	stm	r8,12(sp)
	la	r0,tr.fmt	message format
	st	r0,0(sp)
	st	r1,4(sp)	message
	st	r3,8(sp)	value
	bal	rf,printf	display it on console
	lm	r8,12(sp)	restore regs
	ahi	sp,32+12
	br	rf		return

* format for display

tr.fmt	equ	*
	db	c'%s %x',x'0a',0
	db	*

* trace mask & buffer

trmask	dcf	0
trbuff	dlist	64
D 2
	end
E 2
E 1
s trace is masked on

	l	r0,mask(sp)	get mask
	n	r0,trmask	check with trace control word
	bzr	rf		no bits on - return

* display message on system console

	shi	sp,32+12	save regs first
	stm	r8,12(sp)
	la	r0,tr.fmt	message format
	st	r0,0(sp)
	st	r1,4(sp)	message
	st	r3,8(sp)	value
	bal	rf,printf	display it on console
	lm	r8,12(sp)	restore regs
	ahi	sp,32+12
	br	rf		return

* format for display

tr.fmsys/conf/call.s                                                                                        644      14       2        20702  3013334370   6713                                                                                                                                                                                                                                                                                                                                                                      *****************************************************************
*								*
*		UNIX First-level Interrupt Handler		*
*								*
*		Perkin-Elmer 7/32, 8/32, 3220, 3240		*
*								*
*****************************************************************

	extrn	trap
	extrn	printf
	extrn	kisa,uisa
	extrn	runrun
	extrn	u

* PSW bit definitions

ps.flm	equ	y'40000'	floating-point masked (3200)
ps.iip	equ	y'20000'	interruptible instruction in progress (3200)
ps.wait equ	x'8000'		wait state
ps.io	equ	x'4000'		immediate interrupt mask
ps.mm	equ	x'2000'		machine malfunction interrupt mask
ps.af	equ	x'1000'		arith fault interrupt mask
ps.il	equ	x'0800'		multi level interrupts (8/32 & 3200)
ps.rp	equ	x'0400'		memory relocation / protection
ps.sq	equ	x'0200'		system queue service mask
ps.prot equ	x'0100'		protect mode
ps.ureg equ	x'00f0'		user register set

* PSW definitions

ps.user equ	ps.io+ps.mm+ps.af+ps.rp+ps.prot+ps.ureg
ps.idle equ	ps.wait+ps.io+ps.mm+ps.af+ps.rp+ps.ureg
ps.kern equ	ps.io+ps.mm+ps.af+ps.rp+ps.ureg
ps.disb equ	ps.mm+ps.af+ps.rp+ps.ureg
ps.trap equ	ps.mm+ps.af

* Register definitions

r0	equ	0
r1	equ	1
r2	equ	2
r3	equ	3
r4	equ	4
r5	equ	5
r6	equ	6
r7	equ	7
r8	equ	8
r9	equ	9
ra	equ	10
rb	equ	11
rc	equ	12
rd	equ	13
re	equ	14
rf	equ	15
sp	equ	r7

*****************************************************************
*								*
* call:		interface to C interrupt handlers		*
*								*
*	re-rf	- old PSW					*
*	rd	- current (interrupt) PSW status		*
*	rc	- interrupt routine address			*
*	rb	- interrupt routine PSW status			*
*	r3	- device status ( or SVC arg address )		*
*	r2	- device address ( or trap code )		*
*								*
*****************************************************************

	pure
	entry	call
call	equ	*

    ifnz PIC
	bal	r6,rdpic	get last pic timing interval
    endc

* if trap from user mode, switch to kernel address space 

	thi	re,ps.prot	user mode?
	bz	kernel		no - kernel already

    ifnz PIC
	am	r5,utime	add new interval to user time
    endc

	l	r1,kisa		kernel seg regs
	bal	r6,addrsw	switch address space
	b	nkernel

* else trap from kernel mode -- get stack pointer from register set f

	entry	kernel
kernel	equ	*

    ifnz PIC
	thi	re,ps.wait
	bz	kernel2		not in wait
	am	r5,itime	if wait add current interval to idle time
	b	kernel3
kernel2	am	r5,sytim	if kernel and not wait increment sys time
kernel3	equ	*
    endc

	st	rd,nr.psw	set up resume psw
	la	r1,nkernel
	st	r1,nr.psw+adc
	lr	r1,rd		current psw
	ohi	r1,ps.ureg	switch to reg set f
	epsr	r0,r1
	st	sp,ksp		save stack pointer
	lpsw	nr.psw		back to reg set 0
	entry	nkernel
nkernel	equ	*

* enable memory relocation / protection

	ohi	rd,ps.rp	enable relocation
	epsr	r0,rd

* if stack pointer is out of range, set it to top of u area and force a panic

	l	sp,ksp		get kernel stack pointer
	ci	sp,u		below bottom of u area?
	bl	badsp
	c	sp,maxsp	above top of u area?
	bnp	goodsp
badsp	l	sp,maxsp	set to top of u area
*	shi	sp,3*adc
*	l	0,ksp
*	st	0,adc(sp)
*	l	0,maxsp
*	st	0,2*adc(sp)
*	la	0,badsps
*	st	0,0(sp)
*	bal	15,printf
*	ahi	sp,3*adc
	la	rc,stkovflo	force a panic
goodsp	equ	*

    ifnz	M3200
* save microcode scratchpad registers if necessary (3200 only)

	ti	re,ps.iip		interruptible instruction in progress?
	bz	nsiip			  no - skip
	shi	sp,16*adc		space on stack for scratchpad regs
	psf	5,0(sp)			save scratchpad regs
nsiip	equ	*
    endc

* save psw & status on kernel stack

	shi	sp,14*adc	space for 14 words
	stm	re,11*adc(sp)	save old psw
	st	rb,13*adc(sp)	save new psw
	st	r2,0(sp)	save dev code
	st	r3,adc(sp)	save status

* switch to user register set, and save regs

	st	rc,nr.intp	save routine address
	st	sp,ksp		save stack pointer
	ohi	rd,ps.ureg	switch to user regs
	epsr	r0,rd
	stm	r0,nr.regs	save all regs
	l	sp,ksp		restore stack pointer
	lm	r8,nr.regs	stack regs r0-sp
	stm	r8,2*adc(sp)

* reload user high regs ( to be saved by standard c linkage )
*  and call c trap handler

	lm	r8,8*adc+nr.regs	restore regs r8-rf
	st	rf,10*adc(sp)	stack link reg
	l	r1,nr.intp	trap routine address
	l	r0,13*adc(sp)	new psw
	epsr	r2,r0
	balr	rf,r1		call trap routine

* on return from trap routine, check whether higher-priority process
* is now ready to run

	l	r1,11*adc(sp)	old psw
	thi	r1,ps.prot	user mode ?
	bz	noswtch		no - don't switch kernel process

	entry	switch
switch	equ	*
	li	r0,ps.disb	disable interrupts
	epsr	r1,r0
	lb	r1,runrun	higher-priority process waiting?
	lr	r1,r1
	bz	nswtch		no - restore interrupted process
	li	r0,ps.kern	enable interrupts
	epsr	r1,r0
	li	r0,12		trap 12 is give up cpu
	st	r0,0(sp)
	bal	rf,trap		call trap routine again
	entry	nswtch
nswtch	equ	*

* restore status of interrupted process

noswtch	equ	*
	li	r0,ps.disb	disable interrupts
	epsr	r1,r0
	l	rf,10*adc(sp)	restore link reg
	stm	r8,8*adc+nr.regs	save r8-rf
	lm	r8,2*adc(sp)	save r0-sp
	stm	r8,nr.regs
	lm	re,11*adc(sp)	old psw
	ahi	sp,14*adc	pop stack

    ifnz	M3200
* restore microcode scratchpad registers (3200 only)

	ti	re,ps.iip	interruptible instruction interrupted?
	bz	noriip		  no - skip
	psf	6,0(sp)		restore scratchpad regs
	ahi	sp,16*adc	pop stack
noriip	equ	*
    endc

* if previous mode was user, switch back to user address space

	thi	re,ps.prot	user mode?
	bz	kernel1		no - stay in kernel mode
	epsr	rd,rd		current psw
	nhi	rd,x'ffff'-ps.rp	disable relocation
	epsr	r0,rd
	l	r1,uisa		user seg regs
	bal	r6,addrsw
kernel1 equ	*

* return to previous status

	st	sp,ksp		save kernel stack pointer
	ni	re,y'ffffffff'-ps.wait	turn off 'wait' bit
	stm	re,nr.psw	save return psw

    ifnz PIC
	bal	r6,rdpic	get last pic timing interval
	am	r5,sytim	add interval to sys time
    endc

	lm	r0,nr.regs	restore all regs
	lpsw	nr.psw		back to previous mode

* stack overflow panic - called instead of 'trap' or interrupt routine
*	to force a panic when kernel stack overflows

stkovflo equ	*
	dc	f'0'		crash with illegal instruction
*badsps	db	c'ksp=%x maxsp=%x',x'a',x'0'

	impur

* Non-reentrant save area for use while switching register sets

nr.intp das	1		interrupt handler address save
nr.psw	das	2		psw save
nr.regs das	16		register save

* Kernel mode stack pointer save

	entry	ksp,maxsp
ksp	das	1	save stack pointer during user mode execution
maxsp	das	1	pointer to top of stack segment (initialized by start)

*****************************************************************
*								*
* addrsw:	Switch Address Space Mapping			*
*								*
* input: r1 = &(new segment table descriptor)			*
*        r6 = return address				