/*
 *              fr [ N ]
 *
 * Filter to convert UNIX text file to "fixed-length records":
 *      newlines are removed, tabs expanded, and lines blank-padded or
 *      truncated to N bytes (default 80)
 */

#include "stdio.h"

char line[512];
int width = 80;

main(argc, argv)
char **argv;
{
	register n;

	if (argc > 1 && (n = atoi(argv[1])) != 0)
		width = (n<0? -n : n);
	while (getline())
		putline();
}

getline()
{
	register c, i;

	for (i = 0; (c=getchar()) != EOF;) {
		if (c == '\n') {
			while (i < width)
				line[i++] = ' ';
			return(1);
		}
		if (i<width) {
			if (c == '\t') {
				do
					line[i++] = ' ';
				while (i < width && (i&7));
				continue;
			}
			line[i++] = c;
		}
	}
	return(0);
}

putline()
{
	register i;

	for (i = 0; i < width; i++)
		putchar(line[i]);
}
