.pl 12i
.TL
Conversion of SCCS Version 4 for Version 7 UNIX
.AU
Tony McGrath
.AI
Department of Computing Science
University of Wollongong
.AB
This paper describes the changes made to the Source Code Control System
Version 4 from PWB/UNIX to Version 7 UNIX. This document is not a manual
for the use of SCCS and only describes the changes made to implement it
under Version 7 UNIX. For information concerning the use of SCCS one should
see the \fIPWB/UNIX User's Manual\fR[3] or the \fISCCS/PWB User's Manual\fR[4]
which is available with the PWB/UNIX documentation. For information concerning
Version 7 UNIX, see the UNIX Programmer's Manual, Seventh Edition[2].
.AE
.NH
INTRODUCTION
.PP
The Source Code Control System (SCCS) was a system designed for use with the
PWB/UNIX system to allow control and account for changes in files of text.
It comprises of a number of commands which allowed changes to be made and
recorded to these text files and allow reconstruction of the file at any point
in its development. Our Department investigated the possibility of using
SCCS on our UNIX[1] system without using PWB/UNIX to support it. This showed
that SCCS could be modified to run under Version 7 UNIX without too many
changes and still retain all of the features of the PWB/UNIX version.
.PP
This document details the changes made to make the system work on Version
7 UNIX.
.NH
HOW SCCS WORKS
.PP
SCCS is based, primarily, on the use of one file to hold all the information
pertaining to the source text. It consists of control information, such as
insertions and deletions, who made the changes and when they were made.
All this information is in ASCII and is thus "transportable" between systems
on differing machines.
.PP
When a user wants to make a change to the source text, a copy of the text
is placed in a file for the user to modify and another file is created with
the information required to make the change. Once the user had changed the
text it is compared with the original text using a version of \fIdiff\fR(1).
The output from \fIdiff\fR(1) is used to add control information to the
master file and the user's name and the date is also added to allow others
to see when and who made changes to the source text. Since more than one
change can be made at a time, the master file is locked whenever any
modifications are being made, effectively stopping any corruption of the master
file.
.NH
SCCS COMPOSITION
.PP
SCCS is made up of a series of commands. These commands are used to create,
update and modify the master files and create the intermediate files used to
convey information needed by the system. Other commands allow accounting and
other information to be gathered for use by the users. Most of these commands
use common routines which have been grouped into libraries for easier access.
.NH 2
The Basic Commands
.PP
There are 11 different commands used within SCCS. Each performs some
function within the whole SCCS system. There are 4 commands used frequently,
being those used for creating, editing and updating master files. The other
commands are used for administrative uses, such as printing internal
information, user names, changes, or for removing unneeded sections and packing
of large master files.
.PP
One basic concept must be explained at this point. Throughout this paper and
the other documentation is the concept of a "delta". A "delta" is the name
of any change made to the source text of an SCCS file. Each delta is numbered
and this number is called a \fISCCS ID\fRentification string, or SID. Each SID
is composed of 2 to 4 components, called the "release", "level", "branch" and
"sequence" numbers. These are represented by a number seperated by a period.
For example, "1.1" is the first release, first level of an SCCS file. This is
the default "starting" form of an SCCS file. After making a change to the 
original source text, the new text would be called "1.2", being first release,
second level of the SCCS file. If at any point in the future life of this SCCS
file we wanted to make changes to the original "1.1" text, the resulting text
would be called "1.1.1.1", meaning first release, first level, first branch,
first sequence of the SCCS file. In this way the SCCS system keeps track of the
changes within the master file by refering to the delta number. This concept
of deltas and branching is crucial to the understanding and use of SCCS.
.PP
This concept is much better described in the \fISCCS/PWB User's Manual\fR[2].
.NH 3
The SCCS Commands - admin
.PP
The \fIadmin\fR command is used to create and administer SCCS files. Basically
it is used to initialize the SCCS file and to alter various internal data, such
as who is allowed to make changes to the file, add a basic description of the
file, set internal flags and perform internal consistancy checks.
.NH 3
bdiff
.PP
The \fIbdiff\fR command is a special version of \fIdiff\fR(1) which does some
initial segmenting of input files as the old Version 6 \fIdiff\fR had limits
to its internal storage and could not work with larger files. This is not the
case with Version 7 \fIdiff\fR but this command has been retained to minimize
the changes to programs that call it. In all other respects it is like
\fIdiff\fR except that it has no keyword arguments an produces only standard
\fIdiff\fR output.
.NH 3
chghist
.PP
The \fIchghist\fR command allows the changing of the history of an SCCS file.
When any changes are made the user is allowed to enter a commentary for that
change. \fIChghist\fR is used to modify that commentary if needed.
\fIChghist\fR is actually an alias for the \fIrmdel\fR command (covered later).
.NH 3
comb
.PP
The \fIcomb\fR command is used to compact SCCS files in an attempt to conserve
space. This command actually produces a shell file which can be executed to
compact the SCCS file. Optionally, it can produce a shell file to help
determine what, if any, space will be saved by compaction.
.NH 3
delta
.PP
The \fIdelta\fR command is the command that finds the changes between the
SCCS file text and the new user text. It calls \fIbdiff\fR to determine the
differances and uses its output to put control lines into the SCCS file. It
also asks for any commentary to be placed into the SCCS file and updates the
file accordingly. \fIDelta\fR also places the name of the user and the date
onto the file and reports the number and types of changes that needed to be
made. Note that \fIdelta\fR will never allow the changes of a delta to be
placed on the delta itself (ie delta 1.1 will become either delta 1.2 or delta
1.1.1.1 or something similar, depending on the currently existing deltas).
.NH 3
get
.PP
The \fIget\fR command is the command used to get source text from SCCS files.
\fIGet\fR retrieves text either for use or for editing. If the text is for
editing, \fIget\fR places editing information in a file so that the \fIdelta\fR
command can place the edited text back into the SCCS file. \fIGet\fR can also
be used to discover what deltas were used to create a given delta as well as
print a summary of the deltas used. \fIGet\fR also does some replacement of
\fIidentification keywords\fR, a group of special text patterns within the
source text that are expanded into appropriate identification text.
.NH 3
help
.PP
The \fIhelp\fR command is used to expand on error messages from the SCCS
system. Each error message has an error code which can be passed to \fIhelp\fR.
\fIHelp\fR then searches through a number of files looking for a text that may
help to explain the error and how to correct it. The \fIhelp\fR messages have
not been altered and there are likely to be several references to PWB UNIX in
them.
.NH 3
prt
.PP
The \fIprt\fR command is used to print out various sections of the SCCS file.
It is very useful for dumping parts of SCCS files to examine their contents
and for finding corruption with an SCCS file.
.NH 3
rmdel
.PP
The \fIrmdel\fR command is used to mark a delta as being removed from the
SCCS file. This is actually done by marking the delta as deleted rather than
deleting it from the source text.
.NH 3
sccsdiff
.PP
The \fIsccsdiff\fR command is a shell procedure that calculates the differences
between two deltas in SCCS files. The output of this command is that of
\fIdiff\fR(1). Primarily, \fIsccsdiff\fR extracts the two deltas and runs
\fIbdiff\fR on them.
.NH 3
what
.PP
The \fIwhat\fR command is used to identify the exact contents of a file or
program. \fIWhat\fR searches for the string "@(#)", which is an identification
pattern that can be optionally entered by \fIget\fR. When this string is found
\fIwhat\fR prints the following characters until a quote, newline, null or
greater-than character is seen. This allows the user to place identification
information within his programs or source code and then get this information
quickly when he needs it. \fIWhat\fR also works on object files and a.out files
if the information is stored as a string within the program.
.NH 1
THE SCCS SOURCE CODE
.PP
The source code for SCCS is broken up into 3 sections. These are the code for
the commands, the code common to the commands and code that performs various
utility functions. Since the last 2 sections are common routines, so to speak,
they are saved as object libraries which are linked to the command routines.
The utility routines are primarily one of two types. The first type are those
routines to do general data manipulation, string handling and memory
allocation. The second type are special interface routines to the UNIX system
calls that trap system errors and attempt to give meaningful error messages.
There is also a special error handling system that traps all internal errors
and gives the commands greater control over errors. This allows the system to
keep integrity even when disaster strikes (such as running out of disk space).
.PP
The original source code was written in Version 6 C. This, added to the fact
that the code was written with an eye for running on a PDP-11, meant that there
were some changes needed to the code. Firstly, the code had no external
declarations of functions or variables. We cleaned up the function declarations
so that the code currently passes \fIlint\fR(1) with only a few (expected)
comments. The exernal variable declarations were not changed and were left to
the compiler. Some functions were inherently machine dependent and were
re-written in a machine independent form. Typical examples of routines that
were changed would be memory allocation and memory manipulation which were
written for speed but not for portability.
.PP
Some changes were made for accessing Version 7 UNIX features that were similar
to the PWB/UNIX features used internally. Primarily these included using the
\fIgetlogin\fR(3) routines to replace the PWB routine \fIlogname\fR(3).
The \fIstat\fR(2) system call has changed as well so that references to it
were changed significantly. One major change was the \fIchown\fR(2) call
which has 3 arguments under Version 7 UNIX, compared with 2 under PWB/UNIX.
Another change was inside the \fIsetjmp\fR(3) and \fIlongjmp\fR(3)
routines. The size of the jump buffer was changed from int[3] to int[9] for
Version 7 UNIX and the code has been modified accordingly. In all other cases
there was no trouble in converting the code, other than the placement of casts
to stop some of \fIlint\fR's complaints.
.PP
There were a few changes made to the output of some commands. \fIComb\fR was
modified to produce Version 7 \fIsh\fR(1) commands rather that the PWB/UNIX
\fIsh\fR(1) commands. The checksum output from all the commands was changed
to guarentee that it was a 16 bit unsigned quantity. This was necessary as the
file format required this to be written as a 5 digit unsigned decimal. Another
major change was the re-writing of the \fIsccsdiff\fR command into Version 7
\fIsh\fR(1).
.NH 1
CHANGES MADE TO SCCS FOR VERSION 7 UNIX
.PP
The modifications made to get SCCS running under Version 7 UNIX are
detailed below. Small changes, such as placement of function declarations
or changing of assignment operators,
are not mentioned but all other changes made are given. In all cases the
function modified is named to allow the implementer easier access to them.
.NH 2
Changes to the Main Routines
.PP
The following details the changes made to the main routines.
.IP admin.c 1.1i
The routine \fIgetlogin\fR(3) was used to replace \fIlogname\fR(3) in
function \fIadmin\fR.
.IP comb.c 1.1i
The major changes were the modification of the shell command
output. This output works with the Version 7 shell only. The old code
had PWB shell commands and would only work with it. The function involved
was \fIcomb\fR.
.IP delta.c 1.1i
The routine \fIgetlogin\fR(3) was used to replace \fIlogname\fR(3) in
function \fIrdpfile\fR.
.IP get.c 1.1i
The routine \fIgetlogin\fR(3) was used to replace \fIlogname\fR(3) in
function \fIwrtpfile\fR.
.IP rmdel.c 1.1i
The routine \fIgetlogin\fR(3) was used to replace \fIlogname\fR(3) in
function \fIrmchg\fR.
.NH 2
Changes to the Auxiluary Routines
.PP
The following details the changes to the auxiluary routines.
.IP date_ab.c 1.1i
This routine was rewritten to use the Version 7 time routines. These routines
are \fIftime\fR(2) and \fIlocaltime\fR(2). \fIFtime\fR was used to get the
timezone information and \fIlocaltime\fR to get the daylight saving time flag.
.IP dodelt.c 1.1i
The use of a special memory allocation routine was removed and replaced with
calls to \fIalloc\fR().
.IP dohist.c 1.1i
The routine \fIexecvp\fR(3) is used to replace \fIpexec\fR(3). This simulates
the shell's search process on its program argument. This appears in function
\fIvalmrs\fR.
.IP getline.c 1.1i
The checksum hash comparisons were changed to make them 16 bit quantities by
anding 0177777 to them.
.IP permiss.c 1.1i
The routine \fIgetlogin\fR(3) was used to replace \fIlogname\fR(3) in
function \fIfinduser\fR.
.IP pf_ab.c 1.1i
The use of a special memory allocation routine was removed and replaced with
calls to \fIalloc\fR().
.IP putline.c 1.1i
The routine \fIchown\fR(2) was changed to Version 7 standard in function
\fIputline\fR. The checksum hash was modified to be a 16 bit quantity by
anding 0177777 to it in function \fIflushline\fR.
.NH 2
Changes to the Utility Routines
.PP
The following details the changes to the utility routines.
.IP curdir.c 1.1i
This routine was completely rewritten for Version 7. It consists
primarily of the code for \fIpwd\fR(1) modified to return a character
string rather than print to the terminal.
.IP fdfopen.c 1.1i
This routine was rewritten for Version 7. Since this routine is
primarily \fIfdopen\fR(3), it calls it to do the hard work. \fIFdfopen\fR
was not replaced as it appeared in several macros and it relied on a
numerical argument rather than a string argument.
.IP move.c 1.1i
This routine was rewritten as it was \fBvery\fR machine dependent.
.IP syswrite.s 1.1i
This routine is basically \fIwrite\fR(2) renamed to \fIsyswrite\fR. The
code currently there is the version of \fIwrite\fR currently on our
Perkin-Elmer system. Replace it with the one on your system.
.IP userdir.c 1.1i
This routine was modified to replace the "group" field in the password
file. This field is missing under PWB/UNIX.
.IP xalloc.c 1.1i
This routine has been modified extensively. It is \fBnot\fR machine
independent at the time of this writing. It will be replaced with a more
machine independent routine soon.
.IP xcreat.c 1.1i
The use of a special memory allocation routine was removed and replaced with
calls to \fIalloc\fR().
.IP xmsg.c 1.1i
The use of a special memory allocation routine was removed and replaced with
calls to \fIalloc\fR().
.IP zero.c 1.1i
This routine was rewritten as it was \fBvery\fR machine dependent.
.NH 1
KNOWN BUGS
.PP
There is only one known bug in the system at the current time.
It is the -fv option to \fIadmin\fR. This flag sets up the need
for a verification procedure for modification requests. If no program is
given, the system fails. I could see no easy fix except that of making sure
that a program name is given to -fv that returns a zero exit code to keep
the system working.
.SH
REFERENCES
.IP [1]
Ritchie D.M., and Thompson, K. The UNIX Time-Sharing System.
\fIComm. ACM \fB17\fR(7):365-75, July 1974.
.IP [2]
Kernigan, B.W., and McIlroy, M.D., eds. \fIUNIX Programmer's Manual - Edition
7\fR. Bell Laboratories, 1979.
.IP [3]
Dolotta, T.A., Haight, R.C., and Piskorik, E.M., eds. \fIPWB/UNIX User's
Manual - Edition 1.0.\fR Bell Laboratories, May 1977.
.IP [4]
Bonanni, L.E., and Glasser, A.L. SCCS/PWB User's Manual. Bell Laboratories,
November 1977.
