/*
 * header file for standalone package
 */

/*
 * io block: includes an
 * inode, cells for the use of seek, etc,
 * and a buffer.
 */
struct	iob {
	char	i_flgs;
	char    i_deva, i_cntl, i_selch;
	struct inode i_ino;
	int i_unit;
	daddr_t	i_boff;
	daddr_t	i_cyloff;
	off_t	i_offset;
	daddr_t	i_bn;
	char	*i_ma;
	int	i_cc;
#ifndef UCB_NKB
	char	i_buf[512];
#else
	char	i_buf[BSIZE];
#endif
};

#define F_READ	01
#define F_WRITE	02
#define F_ALLOC	04
#define F_FILE	010
#define F_BLK   020



/*
 * dev switch
 */
struct devsw {
	char	*dv_name;
	int	(*dv_strategy)();
	int	(*dv_open)();
	int	(*dv_close)();
	int     dv_flgs;
};

extern struct devsw devsw[];

/*
 * request codes. Must be the same a F_XXX above
 */
#define	READ	1
#define	WRITE	2


#define	NBUFS	4


#ifndef UCB_NKB
extern char    b[NBUFS][512];
#else
extern char    b[NBUFS][BSIZE];
#endif
extern daddr_t blknos[NBUFS];



#define NFILES	4
extern struct  iob iob[NFILES];

/*
 * Set to which 32Kw segment the code is physically running in.
 * Must be set by the users main (or there abouts).
 */
extern int segflag;

extern int verbose;
