/* SCCS_ID @(#)seg.h    	3.1	 23:28:33 - 81/11/06 */

#ifndef LOCALS_INCLUDED
# include <sys/local.h>
#endif

#ifdef M3240

/*
 * Segmentation hardware definitions
 *		PE 3240
 */

struct seg {
	int	seg_hste;
	int	seg_sste;
};

struct seg * uisa;		/* first user segmentation register */
struct seg * kisa;		/* first kernel segmentation register */

struct seg	useg;		/* u segment register */

struct seg	uisa0[];	/* user segment table */

#define	NSEGS	256			/* # of segmentation regs */
/*#define NUSEGS  256 moved to param.h */     /* number uf user segments */

	/* hste fields */
#define	SEGMASK		0x1ffff		/* address part (SRF) */
#define	SEGLEN		0x3e0000	/* segment length (SLF) */
#define	SEGSHARE		0x800000	/* shared segment */
#define	SEGLVL		0x3000000	/* access level */
#define	SEGEXE		0x4000000	/* execute permission */
#define	SEGWRT		0x8000000	/* write permission */
#define	SEGRD		0x10000000	/* read permission */
#define	SEGMOD		0x20000000	/* segment modified */
#define	SEGPRES		0x40000000	/* segment present & valid */
#define	SEGREF		0x80000000	/* segment referenced */

#define	SEGASL		4		/* bits to shift SEGMASK to get clicks */
#define	SEGLSL		17		/* bits to shift SEGLEN to get clicks */
#define	SEGFULL		32		/* number of clicks in a full segment */
#define	SEGBAD		0		/* value of hste indicating invalid seg */

	/* system segment flags */
#define	RO	(SEGPRES|SEGRD|SEGEXE)
#define	RW	(SEGPRES|SEGRD|SEGWRT|SEGEXE)

	/* Caution: these bit assignments assume that the user prototype
		    seg regs are not actually used as the h/ware seg regs */
#define	TX	SEGREF
#define	ABS	SEGMOD

#else

/*
 * Segmentation hardware definitions
 *		PE 7/32, 8/32, 3220
 */

struct seg {
	int	seg_hste;
};

struct seg * uisa;		/* first user segmentation register */
struct seg * kisa;		/* first kernel segmentation register */

struct seg	useg;		/* u segment register */

struct seg	uisa0[];	/* user segment table */

#define	NSEGS	16			/* # of segmentation regs */
/*#define	NUSEGS	16 moved to param.h */	/* number of user segments */
#define	SEGASL		8		/* bits to shift SEGMASK to get clicks */
#define	SEGLSL		20		/* bits to shift SEGLEN to get clicks */
#define	SEGFULL		256		/* number of clicks in a full segment */
#define	SEGBAD		0		/* value of hste indicating invalid seg */

#define SEGMASK		0xfff00		/* segment start address */
#define	SEGEP		0x80		/* execute protect */
#define SEGIP		0x40		/* write-interrupt protect */
#define SEGWP		0x20		/* write protect */
#define SEGPRES		0x10		/* present */

#define	RO	(SEGWP|SEGPRES)		/* access abilities */
#define	RW	SEGPRES
#define	TX	0x01		/* Software: text segment */
#define	ABS	0x02		/* Software: absolute address */


#endif
