/*
 *		Qume daemon
 */

#include <stdio.h>
#include <sgtty.h>

/* File names */
char lpd[]	"/usr/lpd";
char lock[]	"/usr/lpd/qlock";
char printer[]	"/dev/qume";
char afile[]	"/usr/adm/qume";

/*
 * control sequence to set unix default tabs on qume
 */
char stabs[] {
	"\0332\033(08,16,24,32,40,48,56,64,72,80,88,96,A4,B2,C0,C8,D6,E4,F2."
};
/* Buffers */
FILE	*cmdbuf;	/* for reading command file */
int prbuf[128];		/* for copying file to printer */
char lbuf[64];		/* for assembling lines from command file */
char dbuf[17];		/* for reading directory */
long tbuf;		/* for date & time */

/* Tty modes for printer */
struct sgttyb ttymode = {
	B1200, B1200,		/* ispeed, ospeed */
	0, 0,			/* erase, kill */
	XTABS | CRMOD		/* flags */
};

/* Accounting data */
struct {
	char	user[8];
	long	date;
	int	npages;
	int	nlines;
	int	nchars;
} ac;
int afd;

/* Signal routine to interrupt printer */

int	interrupted;

prstop()
{
	signal(5, prstop);
	interrupted = 1;
}

main()
{
	register flag;

	/* Ignore quit, interrupt, hangup */
	signal(1, 1);
	signal(2, 1);
	signal(3, 1);

	/* Use lock to prevent multiple active daemons */
	close(1);
	if (creat(lock, 0) != 1)
		exit(0);
	/* Fork and exit, thus spawning the daemon */
	if (fork())
		exit(0);

	/* Write daemon's process-id to lock file for prstop command */
	printf("%o\n", getpid());
	fflush(stdout);

	/* Use hangup signal to interrupt printout */
	signal(5, prstop);

	/* Before opening the printer, make sure there's something to print */
	close(0);
	close(1);
	if (open(lpd, 0) != 0)
		dexit();
	flag = 0;
	while (read(0, dbuf, 16) == 16)
		if ((dbuf[0] | dbuf[1]) != 0
		    && dbuf[2] == 'q' && dbuf[3] == 'f')
			flag++;
	if (!flag)
		dexit();

	/* Open the printer, and set proper tty modes */
	if (open(printer, 1) != 1)
		dexit();
	ioctl(1, TIOCSETN, &ttymode);
	/* set hardware tabs */
	write(1, stabs, sizeof stabs);

	/* Open accounting file */
	if (afd = open(afile, 1))
		lseek(afd, 0, 2);

	/* Search lpd directory for work to do */
	if (chdir(lpd) < 0)
		dexit();
	lseek(0, 0, 0);
	while (read(0, dbuf, 16) == 16) {
		if ((dbuf[0] | dbuf[1]) == 0
		    || dbuf[2] != 'q' || dbuf[3] != 'f')
			continue;

		/* Process one command file */
		spool(&dbuf[2]);
		unlink(&dbuf[2]);

		/* Reread directory in case it changed while we were spooling */
		lseek(0, 0, 0);
	}

	/* Feed paper partly out of printer */
	printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
	fflush(stdout);

	dexit();
}

/*
 * Remove lock and terminate
 */
dexit()
{
	unlink(lock);
	exit(0);
}

/*
 * Read and obey a file of spooling commands
 */
spool(dfname)
char *dfname;
{
	register in, len, c;
	register char *p, *q;

	if ((cmdbuf = fopen(dfname, "r")) == NULL)
		return;
	for (p = &ac; p < (char *)&ac + sizeof ac; p++)
		*p = 0;
	time(&tbuf);
	ac.date = tbuf;

	for(;;) {
		switch (c = getc(cmdbuf)) {
	
		/* EOF or unknown command */
		default:
			fclose(cmdbuf);
			if (afd)
				write(afd, &ac, sizeof ac);
			if ((ttymode.sg_flags&CRMOD) == 0)  {
				ttymode.sg_flags |= CRMOD;
				ioctl(1, TIOCSETN, &ttymode);
			}
			return;
	
		/* Unsupported commands */
		case 'S':
		case 'M':
			getline(lbuf);
			continue;
	
		/* Nroff mode -- no CRMOD */
		case 'N':
			getline(lbuf);
			ttymode.sg_flags &= ~CRMOD;
			ioctl(1, TIOCSETN, &ttymode);
			continue;

		/* header page */
		case 'L':
			lbuf[0] = lbuf[1] = ' ';
			getline(&lbuf[2]);
			q = &lbuf[2];
			for (p = ac.user; p < &ac.user[8] && *q; p++)
				*p = *q++;
			header();
			continue;

		/* Copy file in binary ('F' means prepend a form feed */
		case 'F':
		case 'B':
			getline(lt%   #!P @t%$    X  P @@X P @D   <!P @t%  X P @LX P @PX     H!P @t%  X P @XX P @\X     T!$ P @t% 
X'  P  P   X  P @d   `!$ P @t%  X P @lX P @pX     h!P @t%      /usr/lpd    /usr/lpd/lock   /dev/lp /usr/adm/lpd       B   F   L   M   S   U      h  h            ========== University of Wollongong ============================================ Computing Science Laboratory ==========


 


===============================================   ===============================================
  You can't print an _a._o_u_t file, stupid!
                            %o
 %s%.24s%s           


    

 


                    
          

									






                  
  	
 
       
    	  
  

  
  


       



   ,   ;   g   j   p   q   y                     0                                                                                                 , 0         M   :  /EST EDT Day Mon 00 00:00:00 1900
 SunMonTueWedThuFriSat JanFebMarAprMayJunJulAugSepOctNovDec    0123456789ABCDEF       C   D   E   F   L   O   S   X   c   d   e   f   l   o   