h30927
s 00145/00000/00000
d D 1.1 82/08/03 08:42:27 cecily 1 0
e
u
U
t
T
I 1
/*
 *   mount table access routines
 */

#include	<stdio.h>
#define		MS		256
#define		NL		'\n'
#define		NMOUNT		32
#define		FNS		128
#define		SEP(r)		(*r == ':'  ||  *r == NL  ||  *r == NULL)
#define		SKIP(r)		if (SEP(r))  r++;
#define		COPY(r, s)	while (!SEP(r))  *s++ = *r++;  *s = NULL;

/*
 *   format is:-
 *
 *	device:directory:spare:flags
 */


static	char	mtabline[MS];
static	FILE	*in;
static	FILE	*out;
static	char	tbuf[NMOUNT][FNS];
static	char	*devs[NMOUNT];
static	char	*mtab	=	"/etc/mtab";



/*
 *   initialize device table
 */
static	mtabinit()
{
	register int	index;

	for (index=0; index<NMOUNT; index++)
		devs[index] = &tbuf[index][0];

	return;
}


/*
 *   get 1 entry from mount table, return it's index,
 *   or -1 for end-of-file, -2 for format error.
 */
getmtab(sp, dp, cp, fp)
register char *sp, *dp;
register char *cp, *fp;
{
	static	 int	index	=	0;
	register char	*p;

	if (in == NULL)  {
		in = fopen(mtab, "r");
		if (in == NULL)
			return(-3);

		mtabinit();
		}

	if (fgets(mtabline, MS, in) == NULL)  {
		fclose(in);
		return(-1);
		}

	p = &mtabline[0];
	COPY(p, sp)
	SKIP(p)
	COPY(p, dp)
	SKIP(p)
	COPY(p, cp)
	SKIP(p)
	COPY(p, fp)

	if (*p != NL)
		return(-2);

	return(index++);
}


/*
 *   write entry on mtab - re-creates mtab
 *   the update must be total!
 */
putmtab(sp, dp, cp, fp)
register char *sp, *dp;
register char *cp, *fp;
{
	static	 int	index	=	0;

	if (out == NULL)  {
		out = fopen(mtab, "w");
		if (out == NULL)  {
			fprintf(stderr, "putmtab: can't create %s\n", mtab);
			exit(3);
			}

		chmod(mtab, 0664);
		}

	fprintf(out, "%s:%s:%s:%s\n", sp, dp, cp, fp);
	fflush(out);
	return(index++);
}


/*
 *   get a list of the mounted devices
 */
char	**getmdevs()
{
	register int	index;
	auto	 char	sp[FNS];
	auto	 char	dp[FNS];
	auto	 char	cp[FNS];
	auto	 char	fp[FNS];

	index = 0;
	while (getmtab(sp, dp, cp, fp) >= 0)  {
		if (index >= NMOUNT)  {
			fprintf(stderr, "getmdevs: too many devices\n");
			exit(3);
			}

		strcpy(devs[index], &sp[0]);
		index++;
		}

	devs[index] = NULL;
	return(&devs[0]);
}


/*
 *   empty out mtab
 */
emptymtab()
{
	if (creat(mtab, 0664) < 0)
		return(-3);
	return(0);
}
E 1
