#include "../h/param.h"
#include "../h/systm.h"
#include "../h/buf.h"
#include "../h/tty.h"
#include "../h/conf.h"
#include "../h/proc.h"
#include "../h/text.h"
#include "../h/file.h"
#include "../h/inode.h"
#include "../h/acct.h"
#include "../h/dskmap.h"
#include "../h/ccb.h"

int	nodev(), nulldev();
int	dskstrategy();
struct buf	dsktab;
int	mtopen(), mtclose(), mtstrategy();
struct buf	mtab;
int	msmstrategy();
struct buf	msmtab;

struct bdevsw	bdevsw[] = {
	nulldev, nulldev, dskstrategy, &dsktab,	/* dsk = 0 */
	mtopen, mtclose, mtstrategy, &mtab,	/* mt = 1 */
	nulldev, nulldev, msmstrategy, &msmtab,	/* msm = 2 */
	nodev, nodev, nodev, 0,	/* d40 = 3 */
	0
};

int	vduopen(), vduclose(), vduread(), vduwrite(), vduioctl(), vdustop();
struct tty	vdu[26];
int	mmread(), mmwrite();
int	dskread(), dskwrite();
int	syopen(), syread(), sywrite(), sysioctl();
int	mtopen(), mtclose(), mtread(), mtwrite(), mtioctl();
int	lpopen(), lpclose(), lpwrite(), lpioctl();
int	msmread(), msmwrite();
int	dsaopen(), dsaclose(), dsaread(), dsawrite(), dsaioctl(), dsastop();
struct tty	dsa[2];

struct cdevsw	cdevsw[] = {
	vduopen, vduclose, vduread, vduwrite, vduioctl, vdustop, vdu,	/* vdu = 0 */
	nulldev, nulldev, mmread, mmwrite, nodev, nulldev, 0,	/* mem = 1 */
	nulldev, nulldev, dskread, dskwrite, nodev, nulldev, 0,	/* dsk = 2 */
	syopen, nulldev, syread, sywrite, sysioctl, nulldev, 0,	/* tty = 3 */
	mtopen, mtclose, mtread, mtwrite, mtioctl, nulldev, 0,	/* mt = 4 */
	nodev, nodev, nodev, nodev, nodev, nodev, 0,	/* cli = 5 */
	lpopen, lpclose, nodev, lpwrite, lpioctl, nulldev, 0,	/* lp = 6 */
	nulldev, nulldev, msmread, msmwrite, nodev, nulldev, 0,	/* msm = 7 */
	dsaopen, dsaclose, dsaread, dsawrite, dsaioctl, dsastop, dsa,	/* dsa = 8 */
	nodev, nodev, nodev, nodev, nodev, nodev, 0,	/* mx = 9 */
	nodev, nodev, nodev, nodev, nodev, nodev, 0,	/* d40 = 10 */
	0
};

int	ttyopen(), ttread(), ttwrite(), ttyinput(), ttyrend(), ttstart();

struct linesw	linesw[] = {
	ttyopen, nulldev, ttread, ttwrite, nodev,
		ttyinput, ttyrend, nulldev, ttstart, nulldev,	/* tty = 0 */
	0
};

int	nldisp = 1;
int	mpxchan();
int	(*ldmpx)() = mpxchan;
dev_t	rootdev = makedev(2, 0);
dev_t	swapdev = makedev(2, 1);
dev_t	pipedev = makedev(2, 0);
dev_t	consdev = makedev(0, 0);
daddr_t	swplo	= 100;
int	nswap	= 9500;
caddr_t	memtop	= 983040;

int	mtdump();
int	(*dumpsw)() = mtdump;

struct	buf	buf[NBUF];
struct	file	file[NFILE];
struct	inode	inode[NINODE];
struct	proc	proc[NPROC];
struct	text	text[NTEXT];
struct	buf	bfreelist;
struct	acct	acctbuf;
struct	inode	*acctp;
int	nvdu = 26;
char	vduaddr[] = {
	0x10, 0x12, 0x20, 0x22, 0x24, 0x26, 0x28, 0x2A,
	0x2C, 0x2E, 0x30, 0x32, 0x34, 0x36, 0x38, 0x3A,
	0x3C, 0x3E, 0x40, 0x42, 0x44, 0x46, 0x48, 0x4A,
	0x4C, 0x4E,
};
struct ccb *vduccb = &ccb[0];
char	vdurate[][4] = {
	B150, B600, B4800, B9600,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
	B300, B1200, B7200, B19200,
};
int	ndsk = 4;
char	dskaddr[] = {
	0xC6, 0xC7, 0xD6, 0xD7,
};
int	dskcntl = 0xB6;
int	dskselch = 0xF1;
int	dsksize = 1;
int	nmt = 2;
char	mtaddr[] = {
	0x85, 0xC5,
};
int	mtselch = 0xF1;
char	lpaddr[] = {
	0x62,
};
int	nmsm = 1;
char	msmaddr[] = {
	0xEC,
};
int	msmcntl = 0xEB;
int	msmselch = 0xF0;
int	msmsize = 0;
int	msmmap[] = {
	       0,	    9600,
	    9600,	    9600,
	   19200,	    9600,
	   28800,	   51200,
	   80000,	   51200,
	       0,	       0,
	       0,	       0,
	       0,	  131520,
};
int	ndsa = 2;
char	dsaaddr[] = {
	0xB8, 0xBA,
};
struct ccb *dsaccb = &ccb[26];
char	clockaddr[] = {
	0x6C,
};

char	devmap[] = {

	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,  8,  8,  9,  9,
	10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17,
	18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  1,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  2,  3,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

char	devint[] = {

	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 8, 12,  8, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 8, 12,  8, 12,  8, 12,  8, 12,  8, 12,  8, 12,  8, 12,  8, 12,
	 8, 12,  8, 12,  8, 12,  8, 12,  8, 12,  8, 12,  8, 12,  8, 12,
	 8, 12,  8, 12,  8, 12,  8, 12,  8, 12,  8, 12,  8, 12,  8, 12,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0, 28,  0,  0,  0,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0, 20,  0, 40, 44, 40, 44,  0,  0,  0,  0,
	 0,  0,  0,  0,  0, 24, 16, 16,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0, 16, 16,  0,  0,  0,  0,  0,  0,  0,  0,
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 36, 32,  0,  0,  0,
	 4,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};
int	nulldev(), selchint(), vdurint(), vduxint(), dskintr(), cntlintr();
int	mtintr(), lpint(), msmintr(), msmcintr(), dsarint(), dsaxint();
int	clock();

int	(*handler[])() = {
	nulldev,
	selchint,
	vdurint,
	vduxint,
	dskintr,
	cntlintr,
	mtintr,
	lpint,
	msmintr,
	msmcintr,
	dsarint,
	dsaxint,
	clock,
};
