#include <sys/local.h>
#include <sys/param.h>
#include <sys/ino.h>
#include <sys/inode.h>
#include <sys/filsys.h>
#include "saio.h"

#define STACKSIZE       (8*1024)        /* Minimum size for stack */


copyunix(io, bootaddr)
register io;
register char *bootaddr;
{
	register char   *addr, *top;
	unsigned        txtsiz,datsiz,bsssiz,stksiz;
	int             magic;

	lseek(io, (off_t)0, 0);
	magic = getw(io);
	txtsiz = getw(io);
	datsiz = getw(io);
	bsssiz = getw(io);
	getw(io); getw(io);
	stksiz = getw(io);
	getw(io);
	if (stksiz < STACKSIZE)
		stksiz = STACKSIZE;

	switch (magic) {
/***
	case 0411:
		setseg(0);
		lseek(io, (long)(020+txtsiz), 0);

		for(addr=0; addr!=datsiz; addr+=2)  {
			mtpi(getw(io),addr);
		}

		clrseg(addr,bsssiz);

		phys = (long)datsiz + (long)bsssiz + 63L;
		phys =/ 64;
		setseg((int)phys);

		lseek(io, 020L, 0);

		for(addr=0; addr!=txtsiz; addr+=2) {
			mtpi(getw(io),addr);
		}
		return;
***/
	case 0407:
		top = bootaddr + txtsiz + datsiz;
		for (addr = bootaddr; addr != top; addr++)
			*addr = getc(io);
		return(addr + bsssiz + stksiz);
	default:
		printf("Can't load %o files\n", magic);
		return(0);
	}
}
