/*
 *              vr [ N ]
 *
 * Filter to convert "fixed-length record" input to UNIX text format:
 *      lines of N bytes (default 80) are read, trailing blanks trimmed,
 *      and newline appended.
 */

#include <stdio.h>
char buf[512];
main(argc, argv)
char **argv;
{
	register len, col;
	register c;

	if (argc > 1)
		len = atoi(argv[1]);
	else
		len = 80;

	col = 0;
	while ((c = getchar()) != EOF) {
		buf[col] = c;
		if (++col >= len) {
			while (--col >= 0 && buf[col] == ' ')
				;
			buf[++col] = '\0';
			puts(buf);
			col = 0;
		}
	}
}
